/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-12-01 07:08:48 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `ndu6_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_duplicator_activity_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `sub_type` varchar(100) NOT NULL,
  `severity` int(8) NOT NULL,
  `title` text NOT NULL,
  `data` longtext NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `sub_type_idx` (`sub_type`),
  KEY `severity_idx` (`severity`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_duplicator_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `archive_name` varchar(350) NOT NULL DEFAULT '',
  `status` int(11) NOT NULL,
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE','TEMPORARY') NOT NULL DEFAULT '',
  `package` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`(191)),
  KEY `archive_name` (`archive_name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_duplicator_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `value_1` varchar(255) NOT NULL DEFAULT '',
  `value_2` varchar(255) NOT NULL DEFAULT '',
  `value_3` varchar(255) NOT NULL DEFAULT '',
  `value_4` varchar(255) NOT NULL DEFAULT '',
  `value_5` varchar(255) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`(191)),
  KEY `value_2` (`value_2`(191)),
  KEY `value_3` (`value_3`(191)),
  KEY `value_4` (`value_4`(191)),
  KEY `value_5` (`value_5`(191))
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_gf_draft_submissions` (
  `uuid` char(32) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `form_id` mediumint(10) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` varchar(45) NOT NULL,
  `source_url` longtext NOT NULL,
  `submission` longtext NOT NULL,
  PRIMARY KEY (`uuid`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_gf_entry` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `post_id` bigint(10) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_starred` tinyint(10) NOT NULL DEFAULT 0,
  `is_read` tinyint(10) NOT NULL DEFAULT 0,
  `ip` varchar(45) NOT NULL,
  `source_url` varchar(200) NOT NULL DEFAULT '',
  `user_agent` varchar(250) NOT NULL DEFAULT '',
  `currency` varchar(5) DEFAULT NULL,
  `payment_status` varchar(15) DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_amount` decimal(19,2) DEFAULT NULL,
  `payment_method` varchar(30) DEFAULT NULL,
  `transaction_id` varchar(50) DEFAULT NULL,
  `is_fulfilled` tinyint(10) DEFAULT NULL,
  `created_by` bigint(10) unsigned DEFAULT NULL,
  `transaction_type` tinyint(10) DEFAULT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'active',
  `source_id` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `form_id_status` (`form_id`,`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_gf_entry_meta` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL DEFAULT 0,
  `entry_id` bigint(10) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  `item_index` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `entry_id` (`entry_id`),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_gf_entry_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` int(10) unsigned NOT NULL,
  `user_name` varchar(250) DEFAULT NULL,
  `user_id` bigint(10) DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `value` longtext DEFAULT NULL,
  `note_type` varchar(50) DEFAULT NULL,
  `sub_type` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `entry_id` (`entry_id`),
  KEY `entry_user_key` (`entry_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_gf_form` (
  `id` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_active` tinyint(10) NOT NULL DEFAULT 1,
  `is_trash` tinyint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_gf_form_meta` (
  `form_id` mediumint(10) unsigned NOT NULL,
  `display_meta` longtext DEFAULT NULL,
  `entries_grid_meta` longtext DEFAULT NULL,
  `confirmations` longtext DEFAULT NULL,
  `notifications` longtext DEFAULT NULL,
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_gf_form_revisions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `display_meta` longtext DEFAULT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_gf_form_view` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` char(15) DEFAULT NULL,
  `count` mediumint(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_jet_post_types` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `slug` text DEFAULT NULL,
  `status` text DEFAULT NULL,
  `labels` longtext DEFAULT NULL,
  `args` longtext DEFAULT NULL,
  `meta_fields` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_jet_smart_filters_indexer` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `item_id` bigint(20) unsigned DEFAULT NULL,
  `item_query` varchar(50) DEFAULT NULL,
  `item_key` varchar(50) DEFAULT NULL,
  `item_value` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_jet_taxonomies` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `slug` text DEFAULT NULL,
  `object_type` text DEFAULT NULL,
  `status` text DEFAULT NULL,
  `labels` longtext DEFAULT NULL,
  `args` longtext DEFAULT NULL,
  `meta_fields` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=632 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=108 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_rank_math_internal_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `target_post_id` (`target_post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_rank_math_internal_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT 0,
  `external_link_count` int(10) unsigned DEFAULT 0,
  `incoming_link_count` int(10) unsigned DEFAULT 0,
  PRIMARY KEY (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_snippets` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` tinytext NOT NULL,
  `description` text NOT NULL,
  `code` longtext NOT NULL,
  `tags` longtext NOT NULL,
  `scope` varchar(15) NOT NULL DEFAULT 'global',
  `condition_id` bigint(20) NOT NULL DEFAULT 0,
  `priority` smallint(6) NOT NULL DEFAULT 10,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT current_timestamp(),
  `revision` bigint(20) NOT NULL DEFAULT 1,
  `cloud_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `scope` (`scope`),
  KEY `active` (`active`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_wpr_above_the_fold` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `lcp` longtext DEFAULT '',
  `viewport` longtext DEFAULT '',
  `error_message` longtext DEFAULT NULL,
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_wpr_lazy_render_content` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `below_the_fold` longtext DEFAULT '',
  `error_message` longtext DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_wpr_performance_monitoring` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `title` text DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `job_id` varchar(255) NOT NULL DEFAULT '',
  `queue_name` varchar(255) NOT NULL DEFAULT '',
  `retries` tinyint(1) NOT NULL DEFAULT 1,
  `status` varchar(255) DEFAULT NULL,
  `data` longtext NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `submitted_at` timestamp NULL DEFAULT NULL,
  `next_retry_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `score` tinyint(3) DEFAULT 0,
  `report_url` varchar(255) DEFAULT '',
  `is_blurred` tinyint(1) NOT NULL DEFAULT 0,
  `error_code` varchar(32) DEFAULT NULL,
  `error_message` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191)),
  KEY `error_code_index` (`error_code`),
  KEY `is_blurred` (`is_blurred`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_wpr_preconnect_external_domains` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `domains` longtext DEFAULT '',
  `error_message` longtext DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_wpr_preload_fonts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `fonts` longtext DEFAULT '',
  `error_message` longtext DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_wpr_rocket_cache` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_locked` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ndu6_wpr_rucss_used_css` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `css` longtext DEFAULT NULL,
  `hash` varchar(32) DEFAULT '',
  `error_code` varchar(32) DEFAULT NULL,
  `error_message` longtext DEFAULT NULL,
  `unprocessedcss` longtext DEFAULT NULL,
  `retries` tinyint(1) NOT NULL DEFAULT 1,
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `job_id` varchar(255) NOT NULL DEFAULT '',
  `queue_name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `submitted_at` timestamp NULL DEFAULT NULL,
  `next_retry_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191)),
  KEY `error_code_index` (`error_code`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `ndu6_users` VALUES 
("1","sajad","$wp$2y$10$4PpawKbcOeAQTSwXWcbpQOZXGbOGUUPznzS6RYqI3GTeQEgTA707a","admin","joodakiweb@gmail.com","https://toplor.ir/","2025-05-02 09:55:02","","0","admin");

INSERT IGNORE INTO `ndu6_usermeta` VALUES 
("1","1","nickname","admin"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","ndu6_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","ndu6_user_level","10"),
("14","1","dismissed_wp_pointers",""),
("15","1","show_welcome_panel","0"),
("17","1","ndu6_dashboard_quick_press_last_post_id","6"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:11:\"5.218.148.0\";}"),
("20","1","_hello_elementor_install_notice","1"),
("21","1","elementor_introduction","a:1:{s:25:\"black_friday_pointer_2025\";b:1;}"),
("22","1","closedpostboxes_dashboard","a:0:{}"),
("23","1","metaboxhidden_dashboard","a:4:{i:0;s:20:\"e-dashboard-overview\";i:1;s:19:\"dashboard_right_now\";i:2;s:21:\"dashboard_quick_press\";i:3;s:17:\"dashboard_primary\";}"),
("24","1","meta-box-order_dashboard","a:4:{s:6:\"normal\";s:62:\"e-dashboard-overview,dashboard_site_health,dashboard_right_now\";s:4:\"side\";s:58:\"dashboard_quick_press,dashboard_activity,dashboard_primary\";s:7:\"column3\";s:0:\"\";s:7:\"column4\";s:0:\"\";}"),
("25","1","manageedit-postcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("26","1","manageedit-postcolumnshidden_default","1"),
("27","1","manageedit-pagecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("28","1","manageedit-pagecolumnshidden_default","1"),
("29","1","manageedit-e-floating-buttonscolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("30","1","manageedit-e-floating-buttonscolumnshidden_default","1"),
("31","1","manageedit-jet-enginecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("32","1","manageedit-jet-enginecolumnshidden_default","1"),
("33","1","last_update","1764511567"),
("34","1","ndu6_user-settings","libraryContent=browse"),
("35","1","ndu6_user-settings-time","1764498303"),
("36","1","plugin_image_optimization_first_time","2025-11-30 13:56:12"),
("37","1","elementor_admin_notices","a:1:{s:25:\"plugin_image_optimization\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:0:{}}}"),
("38","1","session_tokens","a:1:{s:64:\"406eb991066bc9fa8420ba43d803d90c9346ec34be5655a304347dd2294ffcab\";a:4:{s:10:\"expiration\";i:1764744795;s:2:\"ip\";s:13:\"37.153.189.84\";s:2:\"ua\";s:125:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36 OPR/124.0.0.0\";s:5:\"login\";i:1764571995;}}"),
("39","1","rocket_boxes","a:1:{i:1;s:34:\"rocket_warning_plugin_modification\";}");

INSERT IGNORE INTO `ndu6_actionscheduler_actions` VALUES 
("13","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-30 10:11:47","2025-11-30 13:41:47","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764497507;s:18:\"\0*\0first_timestamp\";i:1764497507;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764497507;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-11-30 10:11:48","2025-11-30 13:41:48","1",NULL),
("14","action_scheduler/migration_hook","complete","2025-11-30 10:12:48","2025-11-30 13:42:48","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1764497568;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1764497568;}","2","1","2025-11-30 10:13:04","2025-11-30 13:43:04","4",NULL),
("15","rank_math/analytics/data_fetch","complete","2025-12-01 06:40:00","2025-12-01 10:10:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764571200;s:18:\"\0*\0first_timestamp\";i:1764571200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764571200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-12-01 06:52:53","2025-12-01 10:22:53","36",NULL),
("16","action_scheduler_run_recurring_actions_schedule_hook","pending","2025-12-01 10:11:48","2025-12-01 13:41:48","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764583908;s:18:\"\0*\0first_timestamp\";i:1764497507;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764583908;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("17","rank_math/analytics/data_fetch","pending","2025-12-02 06:52:53","2025-12-02 10:22:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764658373;s:18:\"\0*\0first_timestamp\";i:1764571200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764658373;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("18","rocket_preload_job_load_initial_sitemap","complete","2025-12-01 07:04:39","2025-12-01 07:04:39","10","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","4","1","2025-12-01 07:04:52","2025-12-01 10:34:52","47",NULL),
("19","rocket_insights_credit_reset","complete","2025-12-01 07:04:47","2025-12-01 10:34:47","1","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764572687;s:18:\"\0*\0first_timestamp\";i:1764572687;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764572687;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}","5","1","2025-12-01 07:04:52","2025-12-01 10:34:52","47",NULL),
("20","rocket_insights_credit_reset","pending","2025-12-31 07:04:52","2025-12-31 10:34:52","1","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767164692;s:18:\"\0*\0first_timestamp\";i:1764572687;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767164692;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}","5","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("21","rocket_preload_job_preload_url","complete","2025-12-01 07:04:52","2025-12-01 07:04:52","10","[\"https:\\/\\/www.toplor.ir\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","4","1","2025-12-01 07:04:54","2025-12-01 10:34:54","48",NULL),
("22","rocket_preload_job_parse_sitemap","complete","2025-12-01 07:04:52","2025-12-01 07:04:52","10","[\"https:\\/\\/www.toplor.ir\\/sitemap_index.xml\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","4","1","2025-12-01 07:04:54","2025-12-01 10:34:54","48",NULL),
("23","rocket_preload_job_check_finished","complete","2025-12-01 07:05:52","2025-12-01 10:35:52","10","[1764572692]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1764572752;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1764572752;}","4","1","2025-12-01 07:05:54","2025-12-01 10:35:54","51",NULL),
("24","rocket_preload_job_check_finished","complete","2025-12-01 07:06:54","2025-12-01 10:36:54","10","[1764572754]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1764572814;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1764572814;}","4","1","2025-12-01 07:07:05","2025-12-01 10:37:05","56",NULL),
("25","rocket_preload_job_preload_url","complete","2025-12-01 07:05:54","2025-12-01 07:05:54","10","[\"https:\\/\\/www.toplor.ir\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","4","1","2025-12-01 07:06:17","2025-12-01 10:36:17","53",NULL);

INSERT IGNORE INTO `ndu6_actionscheduler_claims` VALUES 
("46","2025-12-01 07:04:42"),
("50","2025-12-01 07:05:53"),
("55","2025-12-01 07:07:05"),
("58","2025-12-01 07:08:20"),
("60","2025-12-01 07:08:41");

INSERT IGNORE INTO `ndu6_actionscheduler_groups` VALUES 
("1","ActionScheduler"),
("2","action-scheduler-migration"),
("3","rank-math"),
("4","rocket-preload"),
("5","rocket-insights");

INSERT IGNORE INTO `ndu6_actionscheduler_logs` VALUES 
("1","13","action created","2025-11-30 10:11:47","2025-11-30 13:41:47"),
("2","14","action created","2025-11-30 10:11:48","2025-11-30 13:41:48"),
("3","15","action created","2025-11-30 10:11:48","2025-11-30 13:41:48"),
("4","13","action started via Async Request","2025-11-30 10:11:48","2025-11-30 13:41:48"),
("5","13","action complete via Async Request","2025-11-30 10:11:48","2025-11-30 13:41:48"),
("6","16","action created","2025-11-30 10:11:48","2025-11-30 13:41:48"),
("7","14","action started via WP Cron","2025-11-30 10:13:04","2025-11-30 13:43:04"),
("8","14","action complete via WP Cron","2025-11-30 10:13:04","2025-11-30 13:43:04"),
("9","15","action started via WP Cron","2025-12-01 06:52:53","2025-12-01 10:22:53"),
("10","15","action complete via WP Cron","2025-12-01 06:52:53","2025-12-01 10:22:53"),
("11","17","action created","2025-12-01 06:52:53","2025-12-01 10:22:53"),
("12","18","action created","2025-12-01 07:04:39","2025-12-01 10:34:39"),
("13","19","action created","2025-12-01 07:04:47","2025-12-01 10:34:47"),
("14","19","action started via WP Cron","2025-12-01 07:04:52","2025-12-01 10:34:52"),
("15","19","action complete via WP Cron","2025-12-01 07:04:52","2025-12-01 10:34:52"),
("16","20","action created","2025-12-01 07:04:52","2025-12-01 10:34:52"),
("17","18","action started via WP Cron","2025-12-01 07:04:52","2025-12-01 10:34:52"),
("18","21","action created","2025-12-01 07:04:52","2025-12-01 10:34:52"),
("19","22","action created","2025-12-01 07:04:52","2025-12-01 10:34:52"),
("20","23","action created","2025-12-01 07:04:52","2025-12-01 10:34:52"),
("21","18","action complete via WP Cron","2025-12-01 07:04:52","2025-12-01 10:34:52"),
("22","21","action started via WP Cron","2025-12-01 07:04:52","2025-12-01 10:34:52"),
("23","21","action complete via WP Cron","2025-12-01 07:04:54","2025-12-01 10:34:54"),
("24","22","action started via WP Cron","2025-12-01 07:04:54","2025-12-01 10:34:54"),
("25","22","action complete via WP Cron","2025-12-01 07:04:54","2025-12-01 10:34:54"),
("26","23","action started via WP Cron","2025-12-01 07:05:54","2025-12-01 10:35:54"),
("27","24","action created","2025-12-01 07:05:54","2025-12-01 10:35:54"),
("28","23","action complete via WP Cron","2025-12-01 07:05:54","2025-12-01 10:35:54"),
("29","25","action created","2025-12-01 07:05:54","2025-12-01 10:35:54"),
("30","25","action started via Async Request","2025-12-01 07:06:15","2025-12-01 10:36:15"),
("31","25","action complete via Async Request","2025-12-01 07:06:17","2025-12-01 10:36:17"),
("32","24","action started via WP Cron","2025-12-01 07:07:05","2025-12-01 10:37:05"),
("33","24","action complete via WP Cron","2025-12-01 07:07:05","2025-12-01 10:37:05");

INSERT IGNORE INTO `ndu6_duplicator_activity_logs` VALUES 
("1","websites_scan","scan_start","10","اسکن","{\n    \"packageId\": 1,\n    \"packageName\": \"20251130_d8a7d986d8acd985d986d8a8d987d8aad8b1db8\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 0,\n    \"dirCount\": 0,\n    \"size\": 0,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 0,\n    \"dbSize\": 0,\n    \"dbRowCount\": 0\n}","0","4.5.24","2025-11-30 10:45:21","2025-11-30 10:45:21"),
("2","websites_scan","scan_end","10","اسکن تکمیل شد","{\n    \"packageId\": 1,\n    \"packageName\": \"20251130_d8a7d986d8acd985d986d8a8d987d8aad8b1db8\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 14584,\n    \"dirCount\": 3109,\n    \"size\": 266637476,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 37,\n    \"dbSize\": 1419109,\n    \"dbRowCount\": 471\n}","1","4.5.24","2025-11-30 10:45:23","2025-11-30 10:45:23"),
("3","backup_create","start","10","Backup creation: 20251130_d8a7d986d8acd985d986d8a8d987d8aad8b1db8","{\n    \"packageId\": 2,\n    \"packageName\": \"20251130_d8a7d986d8acd985d986d8a8d987d8aad8b1db8\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251130_d8a7d986d8acd985d986d8a8d987d8aad8b1db8_5f48689952f4d1c65409_20251130104520\",\n    \"logFileName\": \"20251130_d8a7d986d8acd985d986d8a8d987d8aad8b1db8_5f48689952f4d1c65409_20251130104520_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 14584,\n    \"dirCount\": 3109,\n    \"size\": 266637476,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"\\u0622\\u0631\\u0634\\u06cc\\u0648 \\u0632\\u06cc\\u067e\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"\\u062f\\u0633\\u062a\\u06cc\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 37,\n    \"dbSizeDisplay\": \"1.35MB\",\n    \"execution_start_time\": 1764499534.9439731\n}","0","4.5.24","2025-11-30 10:45:34","2025-11-30 10:45:34"),
("4","backup_create","db_dump","10","Backup creation: 20251130_d8a7d986d8acd985d986d8a8d987d8aad8b1db8 - Database Dump","{\n    \"packageId\": 2,\n    \"packageName\": \"20251130_d8a7d986d8acd985d986d8a8d987d8aad8b1db8\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251130_d8a7d986d8acd985d986d8a8d987d8aad8b1db8_5f48689952f4d1c65409_20251130104520\",\n    \"logFileName\": \"20251130_d8a7d986d8acd985d986d8a8d987d8aad8b1db8_5f48689952f4d1c65409_20251130104520_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 14584,\n    \"dirCount\": 3109,\n    \"size\": 266637476,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"\\u0622\\u0631\\u0634\\u06cc\\u0648 \\u0632\\u06cc\\u067e\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"\\u062f\\u0633\\u062a\\u06cc\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 37,\n    \"dbSizeDisplay\": \"1.35MB\",\n    \"execution_start_time\": 1764499534.9439731\n}","3","4.5.24","2025-11-30 10:45:34","2025-11-30 10:45:34"),
("5","websites_scan","scan_start","10","اسکن","{\n    \"packageId\": 3,\n    \"packageName\": \"20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 0,\n    \"dirCount\": 0,\n    \"size\": 0,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 0,\n    \"dbSize\": 0,\n    \"dbRowCount\": 0\n}","0","4.5.24","2025-12-01 07:08:23","2025-12-01 07:08:23"),
("6","websites_scan","scan_end","10","اسکن تکمیل شد","{\n    \"packageId\": 3,\n    \"packageName\": \"20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 15840,\n    \"dirCount\": 3496,\n    \"size\": 276342202,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 44,\n    \"dbSize\": 1825921,\n    \"dbRowCount\": 568\n}","5","4.5.24","2025-12-01 07:08:26","2025-12-01 07:08:26"),
("7","backup_create","start","10","Backup creation: 20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8","{\n    \"packageId\": 4,\n    \"packageName\": \"20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8_31ce3918ba3b74874519_20251201070822\",\n    \"logFileName\": \"20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8_31ce3918ba3b74874519_20251201070822_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 15840,\n    \"dirCount\": 3496,\n    \"size\": 276342202,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"\\u0622\\u0631\\u0634\\u06cc\\u0648 \\u0632\\u06cc\\u067e\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"\\u062f\\u0633\\u062a\\u06cc\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 44,\n    \"dbSizeDisplay\": \"1.74MB\",\n    \"execution_start_time\": 1764572927.243336\n}","0","4.5.24","2025-12-01 07:08:47","2025-12-01 07:08:47"),
("8","backup_create","db_dump","10","Backup creation: 20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8 - Database Dump","{\n    \"packageId\": 4,\n    \"packageName\": \"20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8_31ce3918ba3b74874519_20251201070822\",\n    \"logFileName\": \"20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8_31ce3918ba3b74874519_20251201070822_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 15840,\n    \"dirCount\": 3496,\n    \"size\": 276342202,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"\\u0622\\u0631\\u0634\\u06cc\\u0648 \\u0632\\u06cc\\u067e\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"\\u062f\\u0633\\u062a\\u06cc\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 44,\n    \"dbSizeDisplay\": \"1.74MB\",\n    \"execution_start_time\": 1764572927.243336\n}","7","4.5.24","2025-12-01 07:08:47","2025-12-01 07:08:47");

INSERT IGNORE INTO `ndu6_duplicator_backups` VALUES 
("2","Standard","20251130_d8a7d986d8acd985d986d8a8d987d8aad8b1db8","5f48689952f4d1c65409_20251130104520","20251130_d8a7d986d8acd985d986d8a8d987d8aad8b1db8_5f48689952f4d1c65409_20251130104520_archive.zip","100","MANUAL,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","{\n    \"ID\": 2,\n    \"VersionWP\": \"6.8.3\",\n    \"VersionDB\": \"10.6.23\",\n    \"VersionPHP\": \"8.1.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20251130_d8a7d986d8acd985d986d8a8d987d8aad8b1db8\",\n    \"hash\": \"5f48689952f4d1c65409_20251130104520\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.toplor.ir\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20251130_d8a7d986d8acd985d986d8a8d987d8aad8b1db8_5f48689952f4d1c65409_20251130104520_scan.json\",\n    \"timer_start\": 1764499534.9439731,\n    \"Runtime\": \"14.386 \\u062b\\u0627\\u0646\\u06cc\\u0647.\",\n    \"ExeSize\": \"127.71KB\",\n    \"ZipSize\": \"88.76MB\",\n    \"Brand\": \"\\u067e\\u06cc\\u0634\\u200c\\u0641\\u0631\\u0636\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/.opcache\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/.tmb\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/bps-backup\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/cache\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/old-cache\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/updraft\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/wfcache\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/.htaccess\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/.user.ini\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/php.ini\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/web.config\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-config.php\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20251130_d8a7d986d8acd985d986d8a8d987d8aad8b1db8_5f48689952f4d1c65409_20251130104520_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/\",\n        \"Size\": 93074917,\n        \"Dirs\": [],\n        \"DirCount\": 3109,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 14584,\n        \"file_count\": 17693,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20251130_d8a7d986d8acd985d986d8a8d987d8aad8b1db8_5f48689952f4d1c65409_20251130104520_installer.php\",\n        \"Size\": 130770,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"I+kX3DuUlg04T7\\/GKrOtS8q7El8Sz2tcDfwdjWDRTx2\\/HZ7gqZOj9Ek6tLnMgrz0MjLS4XxfZmMgujpVNEOGGQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"MyISAM\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": true,\n            \"name\": \"toplorir_gMwkSka\",\n            \"tablesBaseCount\": 37,\n            \"tablesFinalCount\": 37,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 471,\n            \"tablesSizeOnDisk\": 1419109,\n            \"tablesList\": {\n                \"ndu6_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 20964\n                },\n                \"ndu6_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 3086\n                },\n                \"ndu6_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 9308\n                },\n                \"ndu6_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 4544\n                },\n                \"ndu6_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 10344\n                },\n                \"ndu6_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 7656\n                },\n                \"ndu6_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 4,\n                    \"size\": 11896\n                },\n                \"ndu6_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 2,\n                    \"size\": 38060\n                },\n                \"ndu6_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 40216\n                },\n                \"ndu6_e_events\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 4172\n                },\n                \"ndu6_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ndu6_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"ndu6_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"ndu6_gf_draft_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_gf_entry\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_gf_entry_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ndu6_gf_entry_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_gf_form\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_gf_form_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_gf_form_revisions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_gf_form_view\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_jet_post_types\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_jet_smart_filters_indexer\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_jet_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_options\": {\n                    \"inaccurateRows\": \"302\",\n                    \"insertedRows\": 303,\n                    \"size\": 1133580\n                },\n                \"ndu6_postmeta\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 23088\n                },\n                \"ndu6_posts\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 34760\n                },\n                \"ndu6_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_snippets\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 5320\n                },\n                \"ndu6_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ndu6_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 13456\n                },\n                \"ndu6_term_relationships\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 3135\n                },\n                \"ndu6_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 4184\n                },\n                \"ndu6_usermeta\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 36,\n                    \"size\": 13312\n                },\n                \"ndu6_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 8332\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.6.23\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 1312372,\n        \"File\": \"20251130_d8a7d986d8acd985d986d8a8d987d8aad8b1db8_5f48689952f4d1c65409_20251130104520_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/backups-dup-pro\\/tmp\\/20251130_d8a7d986d8acd985d986d8a8d987d8aad8b1db8_5f48689952f4d1c65409_20251130104520_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 100,\n    \"progressPercent\": 100,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": {\n        \"hash\": \"5f48689-30104520\",\n        \"date\": \"20251130104520\",\n        \"mapping\": {\n            \"orig_files\": \"orig_files\",\n            \"archive_config\": \"archive.txt\",\n            \"scan\": \"scan.json\",\n            \"file_list\": \"scanned-files.txt\",\n            \"dir_list\": \"scanned-dirs.txt\",\n            \"file_index\": \"index.txt\",\n            \"manual_extract\": \"manual-extract\",\n            \"db_dump\": \"db_dumps\\/20251130104520-dump.sql\",\n            \"inst_chunk_data\": \"installer-chunk-data.json\",\n            \"inst_notices\": \"installer-notices.json\",\n            \"inst_db_data\": \"installer-db-data.json\",\n            \"inst_db_seek_log\": \"installer-db-seek-tell-log.txt\",\n            \"inst_extraction_data\": \"installer-extraction.json\",\n            \"inst_s3_data\": \"installer-s3data.json\",\n            \"inst_php_error_log\": \"php_error.log\",\n            \"params\": \"params.json\"\n        }\n    },\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1764499549,\n            \"stopped_timestamp\": 1764499550,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 3,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24\",\n    \"created\": \"2025-11-30 10:45:20\",\n    \"updated\": \"2025-11-30 10:45:50\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 1,\n    \"mainActivityLogId\": 3\n}","4.5.24","2025-11-30 10:45:20","2025-11-30 10:45:50"),
("3","Standard","20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8","31ce3918ba3b74874519_20251201070822","20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8_31ce3918ba3b74874519_20251201070822_archive.zip","5","MANUAL,ZIP_ARCHIVE,TEMPORARY","{\n    \"ID\": 3,\n    \"VersionWP\": \"6.8.3\",\n    \"VersionDB\": \"10.6.23\",\n    \"VersionPHP\": \"8.1.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8\",\n    \"hash\": \"31ce3918ba3b74874519_20251201070822\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.toplor.ir\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8_31ce3918ba3b74874519_20251201070822_scan.json\",\n    \"timer_start\": -1,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"\\u067e\\u06cc\\u0634\\u200c\\u0641\\u0631\\u0636\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/.opcache\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/.tmb\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/bps-backup\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/cache\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/old-cache\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/updraft\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/wfcache\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/.htaccess\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/.user.ini\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/php.ini\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/web.config\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-config.php\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8_31ce3918ba3b74874519_20251201070822_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/\",\n        \"Size\": 276342202,\n        \"Dirs\": [],\n        \"DirCount\": 3496,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 15840,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 187617736,\n                        \"bytes\": \"178.93MB\",\n                        \"nodes\": 15394,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 215936777,\n                        \"bytes\": \"205.93MB\",\n                        \"nodes\": 16240,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-snapshots\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/.opcache\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/.tmb\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/old-cache\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/updraft\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/wfcache\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/cache\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/.htaccess\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/.user.ini\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/php.ini\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/web.config\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/debug.log\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"text\": \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html <span class=\\\"size\\\" >263.54MB<\\/span> <span class=\\\"nodes\\\" >19336<\\/span>\",\n                \"fullPath\": \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\",\n                \"type\": \"folder\",\n                \"state\": {\n                    \"opened\": true,\n                    \"disabled\": false,\n                    \"selected\": false,\n                    \"checked\": false,\n                    \"checkbox_disabled\": true\n                },\n                \"children\": [\n                    {\n                        \"text\": \"wp-content <span class=\\\"size\\\" >205.93MB<\\/span> <span class=\\\"nodes\\\" >16240<\\/span>\",\n                        \"fullPath\": \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\",\n                        \"type\": \"folder\",\n                        \"state\": {\n                            \"opened\": true,\n                            \"disabled\": false,\n                            \"selected\": false,\n                            \"checked\": false,\n                            \"checkbox_disabled\": false\n                        },\n                        \"children\": [\n                            {\n                                \"text\": \"plugins <span class=\\\"size\\\" >178.93MB<\\/span> <span class=\\\"nodes\\\" >15394<\\/span>\",\n                                \"fullPath\": \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/plugins\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": false,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": true,\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            }\n                        ],\n                        \"li_attr\": {\n                            \"data-full-loaded\": false,\n                            \"class\": \" warning-node\"\n                        },\n                        \"a_attr\": []\n                    }\n                ],\n                \"li_attr\": {\n                    \"data-full-loaded\": false,\n                    \"class\": \" root-node core-node warning-childs\"\n                },\n                \"a_attr\": {\n                    \"title\": \"\\u062f\\u0627\\u06cc\\u0631\\u06a9\\u062a\\u0648\\u0631\\u06cc\\u200c\\u0647\\u0627\\u06cc \\u0627\\u0635\\u0644\\u06cc \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633 \\u0646\\u0628\\u0627\\u06cc\\u062f \\u0641\\u06cc\\u0644\\u062a\\u0631 \\u0634\\u0648\\u0646\\u062f. \\u0647\\u0646\\u06af\\u0627\\u0645 \\u062d\\u0630\\u0641 \\u0641\\u0627\\u06cc\\u0644 \\u0647\\u0627 \\u0627\\u062d\\u062a\\u06cc\\u0627\\u0637 \\u06a9\\u0646\\u06cc\\u062f.\"\n                }\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8_31ce3918ba3b74874519_20251201070822_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"9hX5mbPx8cR7tSuWgzmPrYSUE2KgfnmPoQKbGjqA1CN\\/eeqSBTYZTNIXrYd6A0LFngYt9vHXOUKdAxt5W+l5Kw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"localhost\",\n        \"OptsDBName\": \"toplor-sajefdb\",\n        \"OptsDBUser\": \"sajefkaka\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"MyISAM\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": true,\n            \"name\": \"toplorir_gMwkSka\",\n            \"tablesBaseCount\": 44,\n            \"tablesFinalCount\": 44,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 568,\n            \"tablesSizeOnDisk\": 1825921,\n            \"tablesList\": {\n                \"ndu6_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 0,\n                    \"size\": 23468\n                },\n                \"ndu6_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 3142\n                },\n                \"ndu6_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 9364\n                },\n                \"ndu6_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 0,\n                    \"size\": 5952\n                },\n                \"ndu6_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ndu6_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 15964\n                },\n                \"ndu6_duplicator_backups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 70944\n                },\n                \"ndu6_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 40288\n                },\n                \"ndu6_e_events\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 0,\n                    \"size\": 4172\n                },\n                \"ndu6_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ndu6_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"ndu6_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"ndu6_gf_draft_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_gf_entry\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_gf_entry_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ndu6_gf_entry_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_gf_form\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_gf_form_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_gf_form_revisions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_gf_form_view\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_jet_post_types\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_jet_smart_filters_indexer\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_jet_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_options\": {\n                    \"inaccurateRows\": \"353\",\n                    \"insertedRows\": 0,\n                    \"size\": 1481324\n                },\n                \"ndu6_postmeta\": {\n                    \"inaccurateRows\": \"59\",\n                    \"insertedRows\": 0,\n                    \"size\": 22360\n                },\n                \"ndu6_posts\": {\n                    \"inaccurateRows\": \"29\",\n                    \"insertedRows\": 0,\n                    \"size\": 17932\n                },\n                \"ndu6_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_snippets\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 5320\n                },\n                \"ndu6_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ndu6_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 13456\n                },\n                \"ndu6_term_relationships\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 3135\n                },\n                \"ndu6_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 4176\n                },\n                \"ndu6_usermeta\": {\n                    \"inaccurateRows\": \"37\",\n                    \"insertedRows\": 0,\n                    \"size\": 13392\n                },\n                \"ndu6_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 8332\n                },\n                \"ndu6_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ndu6_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ndu6_wpr_performance_monitoring\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16568\n                },\n                \"ndu6_wpr_preconnect_external_domains\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ndu6_wpr_preload_fonts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ndu6_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 11336\n                },\n                \"ndu6_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.6.23\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8_31ce3918ba3b74874519_20251201070822_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 5,\n    \"progressPercent\": 5,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24\",\n    \"created\": \"2025-12-01 07:08:22\",\n    \"updated\": \"2025-12-01 07:08:26\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\",\n        \"TEMPORARY\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 5,\n    \"mainActivityLogId\": 0\n}","4.5.24","2025-12-01 07:08:22","2025-12-01 07:08:26"),
("4","Standard","20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8","31ce3918ba3b74874519_20251201070822","20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8_31ce3918ba3b74874519_20251201070822_archive.zip","20","MANUAL,ZIP_ARCHIVE","{\n    \"ID\": 4,\n    \"VersionWP\": \"6.8.3\",\n    \"VersionDB\": \"10.6.23\",\n    \"VersionPHP\": \"8.1.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8\",\n    \"hash\": \"31ce3918ba3b74874519_20251201070822\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.toplor.ir\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8_31ce3918ba3b74874519_20251201070822_scan.json\",\n    \"timer_start\": 1764572927.243336,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"\\u067e\\u06cc\\u0634\\u200c\\u0641\\u0631\\u0636\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/.opcache\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/.tmb\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/bps-backup\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/cache\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/old-cache\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/updraft\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/wfcache\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/.htaccess\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/.user.ini\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/php.ini\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/web.config\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-config.php\",\n            \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8_31ce3918ba3b74874519_20251201070822_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/\",\n        \"Size\": 276342202,\n        \"Dirs\": [],\n        \"DirCount\": 3496,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 15840,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 187617736,\n                        \"bytes\": \"178.93MB\",\n                        \"nodes\": 15394,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 215936777,\n                        \"bytes\": \"205.93MB\",\n                        \"nodes\": 16240,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-snapshots\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/.opcache\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/.tmb\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/old-cache\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/updraft\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/wfcache\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/cache\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/.htaccess\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/.user.ini\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/php.ini\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/web.config\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/debug.log\",\n                    \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"treeList\": []\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8_31ce3918ba3b74874519_20251201070822_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"9uUoMRKNE4LU9F6jkWZRv7uAaG7pH49W\\/fHYiY73uJg4vcnkpjDglJZuKJb1Ia1z3weiLJzKqmB0gteAY2f6zw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"localhost\",\n        \"OptsDBName\": \"toplor-sajefdb\",\n        \"OptsDBUser\": \"sajefkaka\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"MyISAM\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": true,\n            \"name\": \"toplorir_gMwkSka\",\n            \"tablesBaseCount\": 44,\n            \"tablesFinalCount\": 44,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 568,\n            \"tablesSizeOnDisk\": 1825921,\n            \"tablesList\": {\n                \"ndu6_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 0,\n                    \"size\": 23468\n                },\n                \"ndu6_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 3142\n                },\n                \"ndu6_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 9364\n                },\n                \"ndu6_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 0,\n                    \"size\": 5952\n                },\n                \"ndu6_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ndu6_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 15964\n                },\n                \"ndu6_duplicator_backups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 70944\n                },\n                \"ndu6_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 40288\n                },\n                \"ndu6_e_events\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 0,\n                    \"size\": 4172\n                },\n                \"ndu6_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ndu6_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"ndu6_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"ndu6_gf_draft_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_gf_entry\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_gf_entry_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ndu6_gf_entry_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_gf_form\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_gf_form_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_gf_form_revisions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_gf_form_view\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_jet_post_types\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_jet_smart_filters_indexer\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_jet_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_options\": {\n                    \"inaccurateRows\": \"353\",\n                    \"insertedRows\": 0,\n                    \"size\": 1481324\n                },\n                \"ndu6_postmeta\": {\n                    \"inaccurateRows\": \"59\",\n                    \"insertedRows\": 0,\n                    \"size\": 22360\n                },\n                \"ndu6_posts\": {\n                    \"inaccurateRows\": \"29\",\n                    \"insertedRows\": 0,\n                    \"size\": 17932\n                },\n                \"ndu6_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ndu6_snippets\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 5320\n                },\n                \"ndu6_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ndu6_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 13456\n                },\n                \"ndu6_term_relationships\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 3135\n                },\n                \"ndu6_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 4176\n                },\n                \"ndu6_usermeta\": {\n                    \"inaccurateRows\": \"37\",\n                    \"insertedRows\": 0,\n                    \"size\": 13392\n                },\n                \"ndu6_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 8332\n                },\n                \"ndu6_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ndu6_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ndu6_wpr_performance_monitoring\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16568\n                },\n                \"ndu6_wpr_preconnect_external_domains\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ndu6_wpr_preload_fonts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ndu6_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 11336\n                },\n                \"ndu6_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.6.23\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8_31ce3918ba3b74874519_20251201070822_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/toplorir\\/domains\\/toplor.ir\\/public_html\\/wp-content\\/backups-dup-pro\\/tmp\\/20251201_d8a7d986d8acd985d986d8a8d987d8aad8b1db8d8a7d986d8acd985d986d8a8d987d8aad8b1db8_31ce3918ba3b74874519_20251201070822_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 20,\n    \"progressPercent\": 20,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 1764572928,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"ndu6_users\",\n            \"ndu6_usermeta\",\n            \"ndu6_actionscheduler_actions\",\n            \"ndu6_actionscheduler_claims\",\n            \"ndu6_actionscheduler_groups\",\n            \"ndu6_actionscheduler_logs\",\n            \"ndu6_commentmeta\",\n            \"ndu6_comments\",\n            \"ndu6_duplicator_activity_logs\",\n            \"ndu6_duplicator_backups\",\n            \"ndu6_duplicator_entities\",\n            \"ndu6_e_events\",\n            \"ndu6_e_submissions\",\n            \"ndu6_e_submissions_actions_log\",\n            \"ndu6_e_submissions_values\",\n            \"ndu6_gf_draft_submissions\",\n            \"ndu6_gf_entry\",\n            \"ndu6_gf_entry_meta\",\n            \"ndu6_gf_entry_notes\",\n            \"ndu6_gf_form\",\n            \"ndu6_gf_form_meta\",\n            \"ndu6_gf_form_revisions\",\n            \"ndu6_gf_form_view\",\n            \"ndu6_jet_post_types\",\n            \"ndu6_jet_smart_filters_indexer\",\n            \"ndu6_jet_taxonomies\",\n            \"ndu6_links\",\n            \"ndu6_options\",\n            \"ndu6_postmeta\",\n            \"ndu6_posts\",\n            \"ndu6_rank_math_internal_links\",\n            \"ndu6_rank_math_internal_meta\",\n            \"ndu6_snippets\",\n            \"ndu6_termmeta\",\n            \"ndu6_terms\",\n            \"ndu6_term_relationships\",\n            \"ndu6_term_taxonomy\",\n            \"ndu6_wpr_above_the_fold\",\n            \"ndu6_wpr_lazy_render_content\",\n            \"ndu6_wpr_performance_monitoring\",\n            \"ndu6_wpr_preconnect_external_domains\",\n            \"ndu6_wpr_preload_fonts\",\n            \"ndu6_wpr_rocket_cache\",\n            \"ndu6_wpr_rucss_used_css\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1764572927.2677319,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 573,\n            \"tables\": {\n                \"ndu6_users\": {\n                    \"start\": \"1\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_duplicator_activity_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_e_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_e_submissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_e_submissions_actions_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_e_submissions_values\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_gf_draft_submissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_gf_entry\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_gf_entry_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_gf_entry_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_gf_form\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_gf_form_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_gf_form_revisions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_gf_form_view\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_jet_post_types\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_jet_smart_filters_indexer\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_jet_taxonomies\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_rank_math_internal_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_rank_math_internal_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_snippets\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_wpr_above_the_fold\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_wpr_lazy_render_content\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_wpr_performance_monitoring\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_wpr_preconnect_external_domains\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_wpr_preload_fonts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_wpr_rocket_cache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ndu6_wpr_rucss_used_css\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24\",\n    \"created\": \"2025-12-01 07:08:22\",\n    \"updated\": \"2025-12-01 07:08:48\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 5,\n    \"mainActivityLogId\": 7\n}","4.5.24","2025-12-01 07:08:22","2025-12-01 07:08:48");

INSERT IGNORE INTO `ndu6_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","","","","","","{\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [\n        \"info@toplor.ir\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"max_package_transfer_time_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"info@toplor.ir\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"ajax_protocol\": \"https\",\n    \"custom_ajax_url\": \"https:\\/\\/www.toplor.ir\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"purgeBackupRecords\": 0,\n    \"manual_mode_storage_ids\": [\n        3\n    ],\n    \"license_key_visible\": 1,\n    \"last_system_check_timestamp\": 0,\n    \"initial_activation_timestamp\": 1764497784,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 1,\n    \"version\": \"4.5.24\",\n    \"created\": \"2025-11-30 10:16:23\",\n    \"updated\": \"2025-12-01 07:08:22\"\n}","4.5.24","2025-11-30 10:16:23","2025-12-01 07:08:22"),
("2","Dynamic_Entity","","","","","","{\n    \"data\": \"boHh\\/t+LIm9idP3Ylfujb+ITkugNhFB8b8eAHKStMD0G0YUZ3s33xzYAU2Ks5L0SfveDc7EvQpGCR5826OfkufVGm4xOMonJ\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 2,\n    \"version\": \"4.5.24\",\n    \"created\": \"2025-11-30 10:16:23\",\n    \"updated\": \"2025-12-01 06:53:16\",\n    \"dataIsEncrypted\": true\n}","4.5.24","2025-11-30 10:16:23","2025-12-01 06:53:16"),
("3","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"Ovn0uLt0KYfY\\/Gq4cJCL4G0Rjoia+dMW4ldPdTkhkBVsJF0EiMmT1X6c2SysxEFu73\\/txfN2IOa52Hd54PR0iOvrtcyNkn7+ueLvJqKwh7KaDb5IwxptpUzc0ORyEwxb9cD0jRLrG\\/b\\/sU\\/h\\/UeItToKQr0N\\/MsK8Rhf0Gl3b4YWvMWRSfHEQqZ26HO2E7EM7u+RN8URsjJbbzFe41nWK0Vi4p+ddiYRSiQ\\/ZqcQQy0lOkYt8VK8VAsLo20sT9b4LkvtT+k5hD1DsL8EiAPn3g==\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 3,\n    \"version\": \"4.5.24\",\n    \"created\": \"2025-11-30 10:16:23\",\n    \"updated\": \"2025-12-01 06:53:16\"\n}","4.5.24","2025-11-30 10:16:23","2025-12-01 06:53:16"),
("4","EmailSummary","","","","","","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"failedUploads\": [],\n    \"cancelledUploads\": [],\n    \"successfulUploads\": [],\n    \"scheduleIds\": [],\n    \"storageIds\": [],\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 4,\n    \"version\": \"4.5.24\",\n    \"created\": \"\",\n    \"updated\": \"2025-12-01 06:53:16\"\n}","4.5.24","2025-11-30 10:16:23","2025-12-01 06:53:16"),
("5","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"iXidZg6CWzRCVILqcdnb02\\/N4ZvKRmur\\/UGlTBoT5N1GLg\\/EYpm3dm4qGhNATK6pcvWLEA0kRxvBJNcNJ6pZ3Q==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 5,\n    \"version\": \"4.5.24\",\n    \"created\": \"2025-11-30 10:16:23\",\n    \"updated\": \"2025-11-30 10:16:23\"\n}","4.5.24","2025-11-30 10:16:23","2025-11-30 10:16:23"),
("6","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"[Manual Mode]\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%%sitetitle%\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"2bqfoOiNQ6tRFSunQapdQmHDfC8qKAyZYP35o\\/+epFqR4YRWHAfH1joNA2CF6SxFn\\/inu0TEciUKWVeRjQ2p0g==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"localhost\",\n    \"installer_opts_db_name\": \"toplor-sajefdb\",\n    \"installer_opts_db_user\": \"sajefkaka\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -1,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 6,\n    \"version\": \"4.5.24\",\n    \"created\": \"2025-11-30 10:16:23\",\n    \"updated\": \"2025-12-01 07:08:22\"\n}","4.5.24","2025-11-30 10:16:23","2025-12-01 07:08:22"),
("7","LicenseDataEntity","","","","","","{\n    \"licenseKey\": \"HO8MK+CKXMAkNTC0g2X3hVxpArjaJRNn+inwBN3b\\/jAET26mNsktqllaKuDzgwJJD\\/Sq6vJKd+O7YtlNPD\\/0UQ==\",\n    \"status\": \"oYhi3QqwDq2KOjb+NEHjxUIHC3ihFgzEVHCChAcPhwU5LmFrPYfXPucR0kDRHv8PjNuyDEXpfftvPDxR97L6EoTX2i82fj0Y\",\n    \"type\": \"zVxKx9lLbyp1H4Rjus917O6yKGGoxhvjoWUB8x9P1jHZVKoe3ROGla7+quFgMATFkBb5matnhbvxYYtiVYqm3Wu8hjBOCrc7\",\n    \"data\": \"wvBguOOCkH3zGYDXMkqAs3ktobZ+K\\/h9Z1PtdeCdzt2FILCV4LGfwgFpgC44QYbSodd9F\\/CTsse\\/dctjZgoyXef1doUl1wpCgmUZjzlvAPsoIfRed3zUA3H2uuIu1ZnX7aFIuHGmmw9UfUtCCdKO6WXA8s7Y8M1O1PxyoOLgIe+ud4SqHG\\/mOr0a+0dKV+oZ4nPCSzHOoFRYJ+y0G\\/Fi6RmYcyQxbLdyy\\/VUnAnm4pyNj3cJX5enLCCJ6BlOczavucmP298IU9KXxh2nS3pU0Apu6cK1laccafp+Eek5b7VnLjyYzBqD0lGqpKGuAIOqUEAb0dK3wQCwfZ1kR7uRQW+EEYlE5fdg3iEWSaqOx0cHrEaJo8ZeezvtRSOVuRDqaHNLlWnTfjHF\\/4gcW8ZQo9n+SpvsuGL\\/\",\n    \"lastRemoteUpdate\": \"\",\n    \"lastFailureTime\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 7,\n    \"version\": \"4.5.24\",\n    \"created\": \"2025-11-30 10:16:23\",\n    \"updated\": \"2025-12-01 07:08:48\"\n}","4.5.24","2025-11-30 10:16:23","2025-12-01 07:08:48"),
("8","DUP_PRO_System_Global_Entity","","","","","","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1764572926,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 8,\n    \"version\": \"4.5.24\",\n    \"created\": \"2025-11-30 10:16:25\",\n    \"updated\": \"2025-12-01 07:08:46\"\n}","4.5.24","2025-11-30 10:16:25","2025-12-01 07:08:46");

INSERT IGNORE INTO `ndu6_e_events` VALUES 
("1","{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2025-11-30T02:06:59.106+08:00\"}","2025-11-30 02:06:59"),
("2","{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2025-11-30T02:06:59.098+08:00\"}","2025-11-30 02:06:59"),
("3","{\"event\":\"skip\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\"}\",\"ts\":\"2025-11-30T02:07:01.248+08:00\"}","2025-11-30 02:07:01"),
("4","{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"chooseFeatures\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2025-11-30T02:07:01.260+08:00\"}","2025-11-30 02:07:01"),
("5","{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"chooseFeatures\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2025-11-30T02:07:01.275+08:00\"}","2025-11-30 02:07:01"),
("6","{\"event\":\"close modal\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"chooseFeatures\\\"}\",\"ts\":\"2025-11-30T02:07:03.265+08:00\"}","2025-11-30 02:07:03");

INSERT IGNORE INTO `ndu6_options` VALUES 
("1","cron","a:30:{i:1764572931;a:1:{s:30:\"rocket_preload_process_pending\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:30:\"rocket_preload_process_pending\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1764572981;a:3:{s:24:\"rocket_saas_pending_jobs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:24:\"rocket_saas_pending_jobs\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}s:32:\"action_scheduler_run_queue_rucss\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}s:26:\"rocket_saas_on_submit_jobs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:26:\"rocket_saas_on_submit_jobs\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1764572987;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1764573281;a:1:{s:36:\"rocket_preload_clean_rows_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1764573383;a:1:{s:32:\"duplicator_backup_storages_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:41:\"duplicator_backup_storages_check_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1764575705;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1764576291;a:1:{s:23:\"rocket_purge_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:34:\"rocket_expired_cache_cron_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1764579871;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"c7c97442c7bbde2137452591b932e68d\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:49;}}}}i:1764582905;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764582978;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764582980;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764583616;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764583653;a:1:{s:36:\"puc_cron_check_updates-elementor-pro\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764583749;a:1:{s:28:\"zhaket_guard_daily_validator\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764584183;a:1:{s:31:\"duplicator_activity_log_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"duplicator_daily_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764585000;a:1:{s:33:\"duplicator_pro_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1764585835;a:2:{s:17:\"gravityforms_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:27:\"gf_register_daily_validator\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764586502;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764588302;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764590102;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764615951;a:1:{s:37:\"rocket_preload_revert_old_failed_rows\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:29:\"rocket_revert_old_failed_rows\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764631864;a:1:{s:35:\"rank_math/content-ai/update_prompts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764633600;a:2:{s:35:\"rank_math/redirection/clean_trashed\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"rank_math/links/internal_links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764659081;a:2:{s:25:\"zhk_guard_daily_validator\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:32:\"rocket_performance_hints_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764831881;a:1:{s:30:\"rocket_remove_saas_failed_jobs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:30:\"rocket_remove_saas_failed_jobs\";s:4:\"args\";a:0:{}s:8:\"interval\";i:259200;}}}i:1764928606;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765014905;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765177481;a:2:{s:27:\"rocket_update_dynamic_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:33:\"rocket_saas_clean_rows_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765276130;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","on"),
("2","siteurl","https://www.toplor.ir/","on"),
("3","home","https://www.toplor.ir/","on"),
("4","blogname","انجمن بهترین تعمیر کاران لرستان","on"),
("5","blogdescription","","on"),
("6","users_can_register","0","on"),
("7","admin_email","info@toplor.ir","on"),
("8","start_of_week","6","on"),
("9","use_balanceTags","0","on"),
("10","use_smilies","1","on"),
("11","require_name_email","1","on"),
("12","comments_notify","1","on"),
("13","posts_per_rss","10","on"),
("14","rss_use_excerpt","0","on"),
("15","mailserver_url","mail.example.com","on"),
("16","mailserver_login","login@example.com","on"),
("17","mailserver_pass","","on"),
("18","mailserver_port","110","on"),
("19","default_category","1","on"),
("20","default_comment_status","open","on"),
("21","default_ping_status","open","on"),
("22","default_pingback_flag","1","on"),
("23","posts_per_page","10","on"),
("24","date_format","F j, Y","on"),
("25","time_format","g:i a","on"),
("26","links_updated_date_format","F j, Y g:i a","on"),
("27","comment_moderation","0","on"),
("28","moderation_notify","1","on"),
("29","permalink_structure","/%postname%/","on"),
("30","rewrite_rules","a:126:{s:11:\"jsf/(.*)/?$\";s:25:\"index.php?jsf=$matches[1]\";s:52:\"([0-9]{4})/([0-9]{2})/([0-9]{2})/([^/]+)/jsf/(.*)/?$\";s:96:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&jsf=$matches[5]\";s:41:\"([0-9]{4})/([0-9]{2})/([^/]+)/jsf/(.*)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&name=$matches[3]&jsf=$matches[4]\";s:29:\"archives/([0-9]+)/jsf/(.*)/?$\";s:39:\"index.php?p=$matches[1]&jsf=$matches[2]\";s:20:\"([0-9]+)/jsf/(.*)/?$\";s:39:\"index.php?p=$matches[1]&jsf=$matches[2]\";s:19:\"(.?.+?)/jsf/(.*)/?$\";s:46:\"index.php?pagename=$matches[1]&jsf=$matches[2]\";s:19:\"([^/]+)/jsf/(.*)/?$\";s:42:\"index.php?name=$matches[1]&jsf=$matches[2]\";s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:25:\"index.php?xsl=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/schema-preview/?$\";s:57:\"index.php?category=$matches[1]&schema-preview=$matches[3]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/([^/]+)/schema-preview(/(.*))?/?$\";s:67:\"index.php?e-floating-buttons=$matches[1]&schema-preview=$matches[3]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:25:\"schema-preview(/(.*))?/?$\";s:37:\"index.php?&schema-preview=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:33:\"(.?.+?)/schema-preview(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&schema-preview=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:33:\"([^/]+)/schema-preview(/(.*))?/?$\";s:53:\"index.php?name=$matches[1]&schema-preview=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","on"),
("31","hack_file","0","on"),
("32","blog_charset","UTF-8","on"),
("33","moderation_keys","","off"),
("34","active_plugins","a:12:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";i:1;s:35:\"code-snippets-pro/code-snippets.php\";i:2;s:33:\"duplicator-pro/duplicator-pro.php\";i:3;s:31:\"elementor-pro/elementor-pro.php\";i:4;s:23:\"elementor/elementor.php\";i:5;s:35:\"extra-file-type/extra-file-type.php\";i:6;s:29:\"gravityforms/gravityforms.php\";i:7;s:25:\"jet-engine/jet-engine.php\";i:8;s:39:\"jet-smart-filters/jet-smart-filters.php\";i:9;s:38:\"seo-by-rank-math-pro/rank-math-pro.php\";i:10;s:30:\"seo-by-rank-math/rank-math.php\";i:11;s:23:\"wp-rocket/wp-rocket.php\";}","on"),
("35","category_base","","on"),
("36","ping_sites","https://rpc.pingomatic.com/","on"),
("37","comment_max_links","2","on"),
("38","gmt_offset","","on"),
("39","default_email_category","1","on"),
("40","recently_edited","","off"),
("41","template","hello-elementor","on"),
("42","stylesheet","hello-elementor","on"),
("43","comment_registration","0","on"),
("44","html_type","text/html","on"),
("45","use_trackback","0","on"),
("46","default_role","subscriber","on"),
("47","db_version","60421","on"),
("48","uploads_use_yearmonth_folders","1","on"),
("49","upload_path","","on"),
("50","blog_public","1","on"),
("51","default_link_category","2","on"),
("52","show_on_front","posts","on"),
("53","tag_base","","on"),
("54","show_avatars","1","on"),
("55","avatar_rating","G","on"),
("56","upload_url_path","","on"),
("57","thumbnail_size_w","150","on"),
("58","thumbnail_size_h","150","on"),
("59","thumbnail_crop","1","on"),
("60","medium_size_w","300","on"),
("61","medium_size_h","300","on"),
("62","avatar_default","mystery","on"),
("63","large_size_w","1024","on"),
("64","large_size_h","1024","on"),
("65","image_default_link_type","none","on"),
("66","image_default_size","","on"),
("67","image_default_align","","on"),
("68","close_comments_for_old_posts","0","on"),
("69","close_comments_days_old","14","on"),
("70","thread_comments","1","on"),
("71","thread_comments_depth","5","on"),
("72","page_comments","0","on"),
("73","comments_per_page","50","on"),
("74","default_comments_page","newest","on"),
("75","comment_order","asc","on"),
("76","sticky_posts","a:0:{}","on"),
("77","widget_categories","a:0:{}","on"),
("78","widget_text","a:0:{}","on"),
("79","widget_rss","a:0:{}","on"),
("80","uninstall_plugins","a:1:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}","off"),
("81","timezone_string","Asia/Tehran","on"),
("82","page_for_posts","0","on"),
("83","page_on_front","0","on"),
("84","default_post_format","0","on"),
("85","link_manager_enabled","0","on"),
("86","finished_splitting_shared_terms","1","on"),
("87","site_icon","0","on"),
("88","medium_large_size_w","768","on"),
("89","medium_large_size_h","0","on"),
("90","wp_page_for_privacy_policy","3","on"),
("91","show_comments_cookies_opt_in","1","on"),
("92","admin_email_lifespan","1780049002","on"),
("93","disallowed_keys","","off"),
("94","comment_previously_approved","1","on"),
("95","auto_plugin_theme_update_emails","a:0:{}","off"),
("96","auto_update_core_dev","enabled","on"),
("97","auto_update_core_minor","enabled","on"),
("98","auto_update_core_major","enabled","on"),
("99","wp_force_deactivated_plugins","a:0:{}","on"),
("100","wp_attachment_pages_enabled","0","on"),
("101","initial_db_version","58975","on"),
("102","ndu6_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:97:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:23:\"rank_math_edit_htaccess\";b:1;s:16:\"rank_math_titles\";b:1;s:17:\"rank_math_general\";b:1;s:17:\"rank_math_sitemap\";b:1;s:21:\"rank_math_404_monitor\";b:1;s:22:\"rank_math_link_builder\";b:1;s:22:\"rank_math_redirections\";b:1;s:22:\"rank_math_role_manager\";b:1;s:19:\"rank_math_analytics\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:25:\"rank_math_onpage_advanced\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;s:20:\"rank_math_content_ai\";b:1;s:19:\"rank_math_admin_bar\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:14:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","on"),
("103","fresh_site","1","off"),
("104","WPLANG","fa_IR","auto"),
("105","user_count","1","off"),
("106","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","auto"),
("107","sidebars_widgets","a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}","auto"),
("108","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("109","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("110","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("111","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("112","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("113","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("114","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("115","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("116","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("117","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("118","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("119","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("120","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("121","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("122","_transient_wp_core_block_css_files","a:2:{s:7:\"version\";s:5:\"6.8.3\";s:5:\"files\";a:536:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:26:\"post-content/style-rtl.css\";i:309;s:30:\"post-content/style-rtl.min.css\";i:310;s:22:\"post-content/style.css\";i:311;s:26:\"post-content/style.min.css\";i:312;s:23:\"post-date/style-rtl.css\";i:313;s:27:\"post-date/style-rtl.min.css\";i:314;s:19:\"post-date/style.css\";i:315;s:23:\"post-date/style.min.css\";i:316;s:27:\"post-excerpt/editor-rtl.css\";i:317;s:31:\"post-excerpt/editor-rtl.min.css\";i:318;s:23:\"post-excerpt/editor.css\";i:319;s:27:\"post-excerpt/editor.min.css\";i:320;s:26:\"post-excerpt/style-rtl.css\";i:321;s:30:\"post-excerpt/style-rtl.min.css\";i:322;s:22:\"post-excerpt/style.css\";i:323;s:26:\"post-excerpt/style.min.css\";i:324;s:34:\"post-featured-image/editor-rtl.css\";i:325;s:38:\"post-featured-image/editor-rtl.min.css\";i:326;s:30:\"post-featured-image/editor.css\";i:327;s:34:\"post-featured-image/editor.min.css\";i:328;s:33:\"post-featured-image/style-rtl.css\";i:329;s:37:\"post-featured-image/style-rtl.min.css\";i:330;s:29:\"post-featured-image/style.css\";i:331;s:33:\"post-featured-image/style.min.css\";i:332;s:34:\"post-navigation-link/style-rtl.css\";i:333;s:38:\"post-navigation-link/style-rtl.min.css\";i:334;s:30:\"post-navigation-link/style.css\";i:335;s:34:\"post-navigation-link/style.min.css\";i:336;s:27:\"post-template/style-rtl.css\";i:337;s:31:\"post-template/style-rtl.min.css\";i:338;s:23:\"post-template/style.css\";i:339;s:27:\"post-template/style.min.css\";i:340;s:24:\"post-terms/style-rtl.css\";i:341;s:28:\"post-terms/style-rtl.min.css\";i:342;s:20:\"post-terms/style.css\";i:343;s:24:\"post-terms/style.min.css\";i:344;s:24:\"post-title/style-rtl.css\";i:345;s:28:\"post-title/style-rtl.min.css\";i:346;s:20:\"post-title/style.css\";i:347;s:24:\"post-title/style.min.css\";i:348;s:26:\"preformatted/style-rtl.css\";i:349;s:30:\"preformatted/style-rtl.min.css\";i:350;s:22:\"preformatted/style.css\";i:351;s:26:\"preformatted/style.min.css\";i:352;s:24:\"pullquote/editor-rtl.css\";i:353;s:28:\"pullquote/editor-rtl.min.css\";i:354;s:20:\"pullquote/editor.css\";i:355;s:24:\"pullquote/editor.min.css\";i:356;s:23:\"pullquote/style-rtl.css\";i:357;s:27:\"pullquote/style-rtl.min.css\";i:358;s:19:\"pullquote/style.css\";i:359;s:23:\"pullquote/style.min.css\";i:360;s:23:\"pullquote/theme-rtl.css\";i:361;s:27:\"pullquote/theme-rtl.min.css\";i:362;s:19:\"pullquote/theme.css\";i:363;s:23:\"pullquote/theme.min.css\";i:364;s:39:\"query-pagination-numbers/editor-rtl.css\";i:365;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:366;s:35:\"query-pagination-numbers/editor.css\";i:367;s:39:\"query-pagination-numbers/editor.min.css\";i:368;s:31:\"query-pagination/editor-rtl.css\";i:369;s:35:\"query-pagination/editor-rtl.min.css\";i:370;s:27:\"query-pagination/editor.css\";i:371;s:31:\"query-pagination/editor.min.css\";i:372;s:30:\"query-pagination/style-rtl.css\";i:373;s:34:\"query-pagination/style-rtl.min.css\";i:374;s:26:\"query-pagination/style.css\";i:375;s:30:\"query-pagination/style.min.css\";i:376;s:25:\"query-title/style-rtl.css\";i:377;s:29:\"query-title/style-rtl.min.css\";i:378;s:21:\"query-title/style.css\";i:379;s:25:\"query-title/style.min.css\";i:380;s:25:\"query-total/style-rtl.css\";i:381;s:29:\"query-total/style-rtl.min.css\";i:382;s:21:\"query-total/style.css\";i:383;s:25:\"query-total/style.min.css\";i:384;s:20:\"query/editor-rtl.css\";i:385;s:24:\"query/editor-rtl.min.css\";i:386;s:16:\"query/editor.css\";i:387;s:20:\"query/editor.min.css\";i:388;s:19:\"quote/style-rtl.css\";i:389;s:23:\"quote/style-rtl.min.css\";i:390;s:15:\"quote/style.css\";i:391;s:19:\"quote/style.min.css\";i:392;s:19:\"quote/theme-rtl.css\";i:393;s:23:\"quote/theme-rtl.min.css\";i:394;s:15:\"quote/theme.css\";i:395;s:19:\"quote/theme.min.css\";i:396;s:23:\"read-more/style-rtl.css\";i:397;s:27:\"read-more/style-rtl.min.css\";i:398;s:19:\"read-more/style.css\";i:399;s:23:\"read-more/style.min.css\";i:400;s:18:\"rss/editor-rtl.css\";i:401;s:22:\"rss/editor-rtl.min.css\";i:402;s:14:\"rss/editor.css\";i:403;s:18:\"rss/editor.min.css\";i:404;s:17:\"rss/style-rtl.css\";i:405;s:21:\"rss/style-rtl.min.css\";i:406;s:13:\"rss/style.css\";i:407;s:17:\"rss/style.min.css\";i:408;s:21:\"search/editor-rtl.css\";i:409;s:25:\"search/editor-rtl.min.css\";i:410;s:17:\"search/editor.css\";i:411;s:21:\"search/editor.min.css\";i:412;s:20:\"search/style-rtl.css\";i:413;s:24:\"search/style-rtl.min.css\";i:414;s:16:\"search/style.css\";i:415;s:20:\"search/style.min.css\";i:416;s:20:\"search/theme-rtl.css\";i:417;s:24:\"search/theme-rtl.min.css\";i:418;s:16:\"search/theme.css\";i:419;s:20:\"search/theme.min.css\";i:420;s:24:\"separator/editor-rtl.css\";i:421;s:28:\"separator/editor-rtl.min.css\";i:422;s:20:\"separator/editor.css\";i:423;s:24:\"separator/editor.min.css\";i:424;s:23:\"separator/style-rtl.css\";i:425;s:27:\"separator/style-rtl.min.css\";i:426;s:19:\"separator/style.css\";i:427;s:23:\"separator/style.min.css\";i:428;s:23:\"separator/theme-rtl.css\";i:429;s:27:\"separator/theme-rtl.min.css\";i:430;s:19:\"separator/theme.css\";i:431;s:23:\"separator/theme.min.css\";i:432;s:24:\"shortcode/editor-rtl.css\";i:433;s:28:\"shortcode/editor-rtl.min.css\";i:434;s:20:\"shortcode/editor.css\";i:435;s:24:\"shortcode/editor.min.css\";i:436;s:24:\"site-logo/editor-rtl.css\";i:437;s:28:\"site-logo/editor-rtl.min.css\";i:438;s:20:\"site-logo/editor.css\";i:439;s:24:\"site-logo/editor.min.css\";i:440;s:23:\"site-logo/style-rtl.css\";i:441;s:27:\"site-logo/style-rtl.min.css\";i:442;s:19:\"site-logo/style.css\";i:443;s:23:\"site-logo/style.min.css\";i:444;s:27:\"site-tagline/editor-rtl.css\";i:445;s:31:\"site-tagline/editor-rtl.min.css\";i:446;s:23:\"site-tagline/editor.css\";i:447;s:27:\"site-tagline/editor.min.css\";i:448;s:26:\"site-tagline/style-rtl.css\";i:449;s:30:\"site-tagline/style-rtl.min.css\";i:450;s:22:\"site-tagline/style.css\";i:451;s:26:\"site-tagline/style.min.css\";i:452;s:25:\"site-title/editor-rtl.css\";i:453;s:29:\"site-title/editor-rtl.min.css\";i:454;s:21:\"site-title/editor.css\";i:455;s:25:\"site-title/editor.min.css\";i:456;s:24:\"site-title/style-rtl.css\";i:457;s:28:\"site-title/style-rtl.min.css\";i:458;s:20:\"site-title/style.css\";i:459;s:24:\"site-title/style.min.css\";i:460;s:26:\"social-link/editor-rtl.css\";i:461;s:30:\"social-link/editor-rtl.min.css\";i:462;s:22:\"social-link/editor.css\";i:463;s:26:\"social-link/editor.min.css\";i:464;s:27:\"social-links/editor-rtl.css\";i:465;s:31:\"social-links/editor-rtl.min.css\";i:466;s:23:\"social-links/editor.css\";i:467;s:27:\"social-links/editor.min.css\";i:468;s:26:\"social-links/style-rtl.css\";i:469;s:30:\"social-links/style-rtl.min.css\";i:470;s:22:\"social-links/style.css\";i:471;s:26:\"social-links/style.min.css\";i:472;s:21:\"spacer/editor-rtl.css\";i:473;s:25:\"spacer/editor-rtl.min.css\";i:474;s:17:\"spacer/editor.css\";i:475;s:21:\"spacer/editor.min.css\";i:476;s:20:\"spacer/style-rtl.css\";i:477;s:24:\"spacer/style-rtl.min.css\";i:478;s:16:\"spacer/style.css\";i:479;s:20:\"spacer/style.min.css\";i:480;s:20:\"table/editor-rtl.css\";i:481;s:24:\"table/editor-rtl.min.css\";i:482;s:16:\"table/editor.css\";i:483;s:20:\"table/editor.min.css\";i:484;s:19:\"table/style-rtl.css\";i:485;s:23:\"table/style-rtl.min.css\";i:486;s:15:\"table/style.css\";i:487;s:19:\"table/style.min.css\";i:488;s:19:\"table/theme-rtl.css\";i:489;s:23:\"table/theme-rtl.min.css\";i:490;s:15:\"table/theme.css\";i:491;s:19:\"table/theme.min.css\";i:492;s:24:\"tag-cloud/editor-rtl.css\";i:493;s:28:\"tag-cloud/editor-rtl.min.css\";i:494;s:20:\"tag-cloud/editor.css\";i:495;s:24:\"tag-cloud/editor.min.css\";i:496;s:23:\"tag-cloud/style-rtl.css\";i:497;s:27:\"tag-cloud/style-rtl.min.css\";i:498;s:19:\"tag-cloud/style.css\";i:499;s:23:\"tag-cloud/style.min.css\";i:500;s:28:\"template-part/editor-rtl.css\";i:501;s:32:\"template-part/editor-rtl.min.css\";i:502;s:24:\"template-part/editor.css\";i:503;s:28:\"template-part/editor.min.css\";i:504;s:27:\"template-part/theme-rtl.css\";i:505;s:31:\"template-part/theme-rtl.min.css\";i:506;s:23:\"template-part/theme.css\";i:507;s:27:\"template-part/theme.min.css\";i:508;s:30:\"term-description/style-rtl.css\";i:509;s:34:\"term-description/style-rtl.min.css\";i:510;s:26:\"term-description/style.css\";i:511;s:30:\"term-description/style.min.css\";i:512;s:27:\"text-columns/editor-rtl.css\";i:513;s:31:\"text-columns/editor-rtl.min.css\";i:514;s:23:\"text-columns/editor.css\";i:515;s:27:\"text-columns/editor.min.css\";i:516;s:26:\"text-columns/style-rtl.css\";i:517;s:30:\"text-columns/style-rtl.min.css\";i:518;s:22:\"text-columns/style.css\";i:519;s:26:\"text-columns/style.min.css\";i:520;s:19:\"verse/style-rtl.css\";i:521;s:23:\"verse/style-rtl.min.css\";i:522;s:15:\"verse/style.css\";i:523;s:19:\"verse/style.min.css\";i:524;s:20:\"video/editor-rtl.css\";i:525;s:24:\"video/editor-rtl.min.css\";i:526;s:16:\"video/editor.css\";i:527;s:20:\"video/editor.min.css\";i:528;s:19:\"video/style-rtl.css\";i:529;s:23:\"video/style-rtl.min.css\";i:530;s:15:\"video/style.css\";i:531;s:19:\"video/style.min.css\";i:532;s:19:\"video/theme-rtl.css\";i:533;s:23:\"video/theme-rtl.min.css\";i:534;s:15:\"video/theme.css\";i:535;s:19:\"video/theme.min.css\";}}","on"),
("126","nonce_key","*1d ?h:;E.6wsOWgV! [JI$wxtgF064RmO:(YubS};A]MCV!0#s2dKRHKn~}5]}_","off"),
("127","nonce_salt","VdQ{Adb!-pOAazlxd@SLn,Quqxhmh`V//zys.#cv&nx|z*I]dv#[EW%XT3&0yRa9","off"),
("130","secure_auth_key","pEu[Ux/8*+,u4TLX2+TnG@-NDXn<e5wg7,urmVfNr77dvL+IKUm3M/a96Ob3 0wo","off"),
("131","secure_auth_salt","7kQPaf$yA *?-$D.#C={2u;BH=#!(S5RgH.tq(8Y@pVD0=Ve:VZfXPJ-eVN[*i8f","off"),
("132","logged_in_key","FXJ*+q`$e]JVU2>}E|o8WHGo]K(!8];%DrxHG1] qxp J=T/`iW&<Eb`a.N8UeSr","off"),
("133","logged_in_salt","%($rN0|PI|-D4/9H@xM$=|~6b5{/&8z1Q0Zon:u5DdXG@o|&]dQF#hH8/wukj-S`","off"),
("156","_site_transient_wp_plugin_dependencies_plugin_data","a:1:{s:9:\"elementor\";a:35:{s:4:\"name\";s:84:\"وب‌سایت ساز المنتور &#8211; فراتر از یک صفحه‌ساز\";s:4:\"slug\";s:9:\"elementor\";s:7:\"version\";s:6:\"3.33.2\";s:6:\"author\";s:64:\"<a href=\"https://profiles.wordpress.org/elemntor/\">Elementor</a>\";s:14:\"author_profile\";s:40:\"https://profiles.wordpress.org/elemntor/\";s:12:\"contributors\";a:1:{s:8:\"elemntor\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/elemntor/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/7d70f15d78757f876d1847a8f87dd93e1d9c168264b4aeeaf72058656690d05b?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:9:\"Elementor\";}}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.8.3\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:90;s:7:\"ratings\";a:5:{i:5;i:6075;i:4;i:218;i:3;i:108;i:2;i:106;i:1;i:633;}s:11:\"num_ratings\";i:7140;s:11:\"support_url\";s:47:\"https://wordpress.org/support/plugin/elementor/\";s:15:\"support_threads\";i:93;s:24:\"support_threads_resolved\";i:85;s:15:\"active_installs\";i:10000000;s:12:\"last_updated\";s:21:\"2025-11-23 1:13pm GMT\";s:5:\"added\";s:10:\"2016-05-30\";s:8:\"homepage\";s:87:\"https://elementor.com/?utm_source=wp-plugins&utm_campaign=plugin-uri&utm_medium=wp-dash\";s:8:\"sections\";a:6:{s:11:\"description\";s:26297:\"<p><iframe loading=\"lazy\" title=\"Elementor - The Leading Platform for Web Creators\" width=\"750\" height=\"422\" src=\"https://www.youtube.com/embed/le72grP_Q6k?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe></p>\n<h4>THE #1 NO CODE DRAG &amp; DROP WORDPRESS WEBSITE BUILDER POWERING OVER 18M WEBSITES WORLDWIDE, NOW WITH AI.</h4>\n<p>Elementor, the leading WordPress website creation platform, empowers you to build professional, pixel-perfect websites seamlessly.</p>\n<p>Unlock all features with <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-pro-features/\" rel=\"nofollow ugc\">Elementor Pro</a>.</p>\n<p>Need fast and secure cloud hosting for your Elementor site? Try out <strong><a href=\"https://elemn.to/repo-hosting\" rel=\"nofollow ugc\">Elementor Hosting</a></strong> Powered by Google Cloud &amp; Cloudflare. 4.9/5 TrustPilot score.</p>\n<h3>🌟 Create Professional Stunning Websites</h3>\n<ul>\n<li><strong><a href=\"https://go.elementor.com/feature-page-editor/\" rel=\"nofollow ugc\">Intuitive Drag &amp; Drop Builder</a></strong>: Build any website with our no-code, drag-and-drop Editor. Achieve design precision with full control over layout and style.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-feature-page/\" rel=\"nofollow ugc\">Pixel-Perfect Design Tools</a></strong>: Upload SVGs, apply masks, gradients, box shadows, headline effects, shape dividers, and use built-in CSS controls for advanced customization.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-library-full-website-kit/\" rel=\"nofollow ugc\">Template Library</a></strong>: Apply complete website kits for instant setups, or choose from a vast library of single pages, blocks, and pop-up templates.</li>\n<li><strong><a href=\"https://go.elementor.com/feature-page-editor/\" rel=\"nofollow ugc\">Advanced Widgets</a></strong>: Access over 40 FREE widgets, including heading, image, text editor, video, button, gallery, carousels, and more.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-ai/\" rel=\"nofollow ugc\">AI Capabilities</a></strong>: Revolutionize your design and content creation process with native AI integration. Instantly create sections, text, code, and images.</li>\n</ul>\n<h4>🗝️ Key features:</h4>\n<ul>\n<li><strong><a href=\"https://go.elementor.com/feature-page-global-settings/\" rel=\"nofollow ugc\">Design System</a></strong>: Use Elementor&#8217;s Design System for consistent colors, typography, and design elements, ensuring a cohesive, professional look.</li>\n<li><strong><a href=\"https://go.elementor.com/feature-page-responsive-design/\" rel=\"nofollow ugc\">Responsive Design</a></strong>: Optimize your design for every device with custom breakpoints, ensuring a seamless desktop, tablet, and mobile experience.</li>\n<li><strong>Mask Shapes</strong>: Turning any element, like an image or video, into whatever shape you desire to create standout designs.</li>\n<li><strong>CSS Transform</strong>: Use CSS Transform to rotate, scale, and skew elements, adding dynamic styling to your site.</li>\n<li><strong>Entrance Animations</strong>: Add entrance animations to elements to create engaging and interactive user experiences.</li>\n<li><strong><a href=\"https://elementor.com/features/#SaveBackup\" rel=\"nofollow ugc\">Revision History</a></strong>: Elementor&#8217;s Revision History feature enables users to track and revert to previous versions of their designs, providing peace of mind and flexibility during the creative process.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-developers-developers-website/\" rel=\"nofollow ugc\">Developer-Friendly</a></strong>: Equipped with extensive documentation, API, developer tools, and custom code areas, Elementor offers a conducive environment for developers to extend its capabilities and create custom solutions.</li>\n<li><strong>Floating Buttons</strong>: Enhance user interaction with customizable, floating action buttons that stay in view as users scroll.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-industry-leading-theme-builder/\" rel=\"nofollow ugc\">Theme Builder</a> [Pro]</strong>: Design every part of your site—headers, footers, posts, and archives—for complete control over appearance.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-popup-builder/\" rel=\"nofollow ugc\">Popup Builder</a> [Pro]</strong>: Create eye-catching popups with Elementor&#8217;s Popup Builder, equipped with advanced targeting and triggering options to optimize user engagement and conversions.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-professional-form-builder-and-submission-log/\" rel=\"nofollow ugc\">Forms</a> [Pro]</strong>: Design and integrate custom forms, utilizing advanced features and integrations to capture and manage submissions effectively.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-woocommerce-builder/\" rel=\"nofollow ugc\">WooCommerce Builder</a> [Pro]</strong>: Integrate Elementor with WooCommerce to design custom product pages, shop layouts, archives, carts, checkout pages, my account, and more, enhancing your store&#8217;s visual appeal and functionality.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-dynamic-content/\" rel=\"nofollow ugc\">Dynamic Content</a> [Pro]</strong>: Leverage dynamic content capabilities to create personalized and interactive web experiences by connecting your designs to various data sources.</li>\n<li><strong><a href=\"https://go.elementor.com/features-page-notes/\" rel=\"nofollow ugc\">Notes</a> [Pro]</strong>: Enhance team collaboration by using Elementor&#8217;s Notes feature to leave feedback and comments directly on the design interface.</li>\n<li><strong>Custom Code [Pro]</strong>: Insert custom code to extend the functionality of your site, offering flexibility for advanced customizations.</li>\n<li><strong>Custom CSS [Pro]</strong>: Apply Custom CSS to fine-tune the styling of elements, ensuring precise control over the design aspects.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-motion-effects/\" rel=\"nofollow ugc\">Motion Effects</a> [Pro]</strong>: Add advanced motion effects to elements for a more dynamic and engaging user experience.</li>\n<li><strong>Custom Fonts &amp; Icons [Pro]</strong>: Upload and use custom fonts and icons to match your brand&#8217;s identity.</li>\n</ul>\n<h4>😍 Elementor FREE widgets</h4>\n<p>Unlock the potential of Elementor with our comprehensive suite of free widgets and tools, designed to empower your website creation process and elevate your design capabilities:</p>\n<ul>\n<li><strong>عنوان</strong>. عنوان‌های چشم نواز را اضافه کنید.</li>\n<li><strong>Image</strong>. Control the size, opacity and more.</li>\n<li><strong>Text Editor</strong>. Just like the WordPress editor.</li>\n<li><strong>Video</strong>. Add YouTube, Vimeo, Dailymotion or self-hosted videos.</li>\n<li><strong>Button</strong>. Create interactive buttons.</li>\n<li><strong>Link in Bio</strong>. Build link in bio components to promote your business / services.</li>\n<li><strong>Image Box</strong>. A box with image, headline and text.</li>\n<li><strong>Testimonials</strong>. Customer testimonials.</li>\n<li><strong>نماد</strong>. یک یا چند نماد از بیش از ۶۰۰ نماد را در دسترس قرار دهید.</li>\n<li><strong>Icon Box</strong>. An icon, headline, and text with one widget.</li>\n<li><strong>Social Icons</strong>. Link to your social pages with the Facebook/X (formerly Twitter) icons.</li>\n<li><strong>Image Gallery</strong>. Display your images in a grid.</li>\n<li><strong>Image Carousel</strong>. Create rotating carousels or sliders for chosen images.</li>\n<li><strong>فهرست نماد</strong>. از هر نمادی برای ایجاد یک لیست گلوله استفاده کنید.</li>\n<li><strong>Counter</strong>. Show numbers in an escalating manner.</li>\n<li><strong>نوار پیشرفت</strong>. شامل یک نوار پیشرفت در حال افزایش است.</li>\n<li><strong>Nested Tabs</strong>. Display content in vertical or horizontal tabs.</li>\n<li><strong>Nested Accordion</strong>. Display any type of content in collapsible sections.</li>\n<li><strong>جمع‌کننده</strong>. از جمع‌کننده برای پنهان کردن یا نمایش محتوا، مانند پرسش‌های متداول، استفاده کنید.</li>\n<li><strong>Rating</strong>. Display how many stars (or another icon) other visitors gave.</li>\n<li><strong>هشدار</strong>. یک جعبه هشدار رنگی برای جلب توجه بازدیدکنندگان قرار دهید.</li>\n<li><strong>HTML</strong>. کد را در برگه وارد کنید.</li>\n<li><strong>Shortcode</strong>. Insert shortcodes from any plugin into the page.</li>\n<li><strong>لنگر فهرست</strong>. هر منو را به این لنگر پیوند دهید.</li>\n<li><strong>Read More</strong>. Set the Read More cut-off for the excerpt in archive pages.</li>\n<li><strong>Sidebar</strong>. Add sidebars onto the page.</li>\n<li><strong>نقشه‌های گوگل</strong>. نقشه‌ها را در برگه جاسازی کنید.</li>\n<li><strong>SoundCloud</strong>. Add SoundCloud audio bits.</li>\n<li><strong>تقسیم‌کننده</strong>. مطالب را با یک تقسیم‌کننده طراحی شده جدا کنید.</li>\n<li><strong>فاصله‌گذار</strong>. فاصله بین عناصر اضافه کنید..</li>\n<li><strong>Text Path</strong>. Attach your text to a path.</li>\n<li><strong>و شمارش&#8230;</strong></li>\n</ul>\n<h3>🚀 Enhance Your Website</h3>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-performance-performance-page/\" rel=\"nofollow ugc\">High-Performing Websites</a></strong>: Website performance impacts your visitor’s experience and search result ranking. Elementor, in partnership with Google Chrome, continuously enhances performance without compromising design.</p>\n<p><strong>Key features include:</strong></p>\n<ul>\n<li><strong>Reduced DOM Output</strong>: Streamlined HTML structure for faster rendering.</li>\n<li><strong>Improved Media File Loading</strong>: Optimized loading of images, videos, and other media assets.</li>\n<li><strong>Reduced CSS and JS Files</strong>: Minimized and concatenated stylesheets and scripts for quicker loading times.</li>\n<li><strong>Lazy Loading</strong>: Deferred loading of non-critical resources to improve initial page load speed.</li>\n<li><strong>Faster Font Loading</strong>: Efficient delivery of web fonts to enhance text rendering speed.</li>\n<li><strong>Optimized Front-End Asset Loading</strong>: Efficient loading of assets like JavaScript and CSS to minimize render-blocking.</li>\n<li><strong>Element Caching</strong>: Cache frequently accessed design elements to reduce server response time and enhance overall performance.</li>\n</ul>\n<h3>🔥 Elementor Pro Features</h3>\n<p>Create unparalleled websites while saving time, money and resources with <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-elementor-pro/\" rel=\"nofollow ugc\">Elementor Pro</a>’s full website builder. Get access to 100+ professional widgets, features, and tools.</p>\n<p><strong>Pro Design Widgets:</strong></p>\n<ol>\n<li><strong>Posts</strong>: Display your blog posts with customizable layouts and styles.</li>\n<li><strong>Share Buttons</strong>: Allow visitors to easily share your content on various social media platforms.</li>\n<li><strong>Portfolio</strong>: Showcase your work or projects with stunning portfolio layouts.</li>\n<li><strong>Slides</strong>: Create dynamic slideshows with custom animations and transitions.</li>\n<li><strong>Form</strong>: Design and customize advanced forms for user interaction and data collection.</li>\n<li><strong>Login</strong>: Add a login form or user registration module to your website.</li>\n<li><strong>Nav Menu</strong>: Customize and style your website&#8217;s navigation menu for better user experience.</li>\n<li><strong>Animated Headline</strong>: Create attention-grabbing headlines with animated effects.</li>\n<li><strong>Price Table</strong>: Display pricing plans or packages in a structured and visually appealing format.</li>\n<li><strong>Price List</strong>: Showcase a list of prices or services with customizable styling options.</li>\n<li><strong>Gallery</strong>: Create beautiful image galleries with various layout options and lightbox support.</li>\n<li><strong>Flip Box</strong>: Add interactive flip animations to highlight content or features.</li>\n<li><strong>Call to Action</strong>: Encourage user interaction and conversions with compelling call-to-action sections.</li>\n<li><strong>Media Carousel</strong>: Showcase a carousel of media files such as images or videos.</li>\n<li><strong>Testimonial Carousel</strong>: Display client testimonials in a carousel format for social proof.</li>\n<li><strong>Nested Carousel</strong>: Create nested carousels for more complex content organization.</li>\n<li><strong>Loop Carousel</strong>: Display content in a looped carousel for continuous viewing.</li>\n<li><strong>Table Of Content</strong>: Generate a table of contents for longer articles or guides to improve navigation.</li>\n<li><strong>Countdown</strong>: Add countdown timers to create urgency for promotions or events.</li>\n<li><strong>Facebook Page</strong>: Embed your Facebook page feed or content onto your website.</li>\n<li><strong>Blockquote</strong>: Highlight quotes or testimonials with stylish formatting options.</li>\n<li><strong>Template</strong>: Save and reuse design templates for consistent branding and layout.</li>\n<li><strong>Reviews</strong>: Showcase customer reviews and ratings to build trust and credibility.</li>\n<li><strong>Facebook Button</strong>: Add buttons to promote interactions with your Facebook page or content.</li>\n<li><strong>Facebook Embed</strong>: Embed Facebook posts or content onto your website.</li>\n<li><strong>Facebook Comments</strong>: Enable Facebook comments on your website&#8217;s pages or posts.</li>\n<li><strong>PayPal Button</strong>: Integrate PayPal buttons for easy online payments.</li>\n<li><strong>Stripe Button</strong>: Integrate Stripe payment buttons to facilitate secure online transactions.</li>\n<li><strong>Lottie Widget</strong>: Add Lottie animations to enhance visual appeal and engagement.</li>\n<li><strong>Code Highlight</strong>: Display code snippets with syntax highlighting for better readability.</li>\n<li><strong>Video Playlist</strong>: Create and customize playlists for video content on your website.</li>\n<li><strong>مگا منو</strong>: منوهای پیشرفته را برای پیمایش بهتر و نمایش محتوای پیچیده سفارشی کنید.</li>\n<li><strong>Off Canvas</strong>: Create off-canvas areas that slide in to show extra info or menus without cluttering the main layout.</li>\n</ol>\n<p><strong>Pro Theme Widgets:</strong></p>\n<p>Build and customize all the key parts of your website including headers, footers, 404 page, global archives, and more</p>\n<ol>\n<li><strong>Post Title</strong>: Customize the title of individual blog posts or pages.</li>\n<li><strong>Post Excerpt</strong>: Display a brief summary or teaser of your blog posts.</li>\n<li><strong>Post Content</strong>: Customize the main content area of your blog posts or pages.</li>\n<li><strong>Featured Image</strong>: Set and customize featured images for blog posts or pages.</li>\n<li><strong>Author Box</strong>: Display author information and bios on blog posts.</li>\n<li><strong>Post Comments</strong>: Customize the appearance and functionality of comments sections on your website.</li>\n<li><strong>Post Navigation</strong>: Add navigation links to adjacent posts for easy browsing.</li>\n<li><strong>Post Info</strong>: Display additional information about blog posts, such as author and date.</li>\n<li><strong>Site Logo</strong>: Upload and customize your website&#8217;s logo for branding purposes.</li>\n<li><strong>Site Title</strong>: Customize the title of your website.</li>\n<li><strong>Page Title</strong>: Customize the title of individual pages.</li>\n<li><strong>Search Bar</strong>: Add a search bar to allow users to search your website&#8217;s content.</li>\n<li><strong>Breadcrumbs</strong>: Display hierarchical navigation paths for better user navigation.</li>\n<li><strong>Sitemap</strong>: Generate a sitemap for better search engine indexing and user navigation.</li>\n<li><strong>Loop Grid</strong>: Design and customize grid layouts for blog post archives or product listings.</li>\n</ol>\n<p><strong>Pro WooCommerce Widgets:</strong></p>\n<p>Design and customize a complete online shopping experience across your entire website.</p>\n<ol>\n<li><strong>Product</strong>: Display individual products with customizable layouts and styles.</li>\n<li><strong>Breadcrumbs</strong>: Display hierarchical navigation paths for better user navigation within your store.</li>\n<li><strong>Product Title</strong>: Customize the title of individual products.</li>\n<li><strong>Product Images</strong>: Set and customize images for product listings.</li>\n<li><strong>Product Price</strong>: Display the price of individual products.</li>\n<li><strong>Add To Cart</strong>: Add customizable add to cart buttons for easy purchasing.</li>\n<li><strong>Product Rating</strong>: Display ratings and reviews for products.</li>\n<li><strong>Product Stock</strong>: Display stock availability for products.</li>\n<li><strong>Product Meta</strong>: Display additional information about products, such as SKU and categories.</li>\n<li><strong>Product Content</strong>: Customize the main content area of product descriptions.</li>\n<li><strong>Short Description</strong>: Display brief summaries or teasers of products.</li>\n<li><strong>Product Data Tabs</strong>: Organize product information into tabbed sections for better organization.</li>\n<li><strong>Additional Information</strong>: Display additional details about products, such as dimensions and weight.</li>\n<li><strong>Product Related</strong>: Showcase related products to encourage additional purchases.</li>\n<li><strong>Upsells</strong>: Promote upsell products to increase average order value.</li>\n<li><strong>Products</strong>: Display a grid or list of products with customizable settings.</li>\n<li><strong>Custom Add To Cart</strong>: Customize the add to cart button for specific products.</li>\n<li><strong>WooCommerce Pages</strong>: Design and customize WooCommerce-specific pages, such as the cart and checkout pages.</li>\n<li><strong>Product Categories</strong>: Display product categories for easy navigation within your store.</li>\n<li><strong>Menu Cart</strong>: Display a cart icon in your navigation menu for easy access to the shopping cart.</li>\n<li><strong>Cart</strong>: Customize the appearance and functionality of the shopping cart page.</li>\n<li><strong>Checkout</strong>: Customize the appearance and functionality of the checkout page.</li>\n<li><strong>My Account</strong>: Customize the appearance and functionality of the customer account area.</li>\n<li><strong>Purchase Summary</strong>: Display a summary of purchases during the checkout process.</li>\n<li><strong>WooCommerce Notices</strong>: Customize the appearance and functionality of WooCommerce notices, such as order confirmation messages.</li>\n</ol>\n<p>Build professional websites with <strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-elementor-pro/\" rel=\"nofollow ugc\">Elementor Pro</a></strong>!</p>\n<h4>🔒 SECURITY AND COMPLIANCE</h4>\n<p>Elementor places a paramount focus on security, evident through our acquisition of industry certifications such as ISO/IEC 27001, ISO/IEC 27017, ISO/IEC 27018, ISO/IEC 27701, and SOC 2 Type II. These certifications underscore our commitment to implementing robust security measures, and highlight our dedication to adhering to recognized industry standards.</p>\n<p>We encourage ethical security research through our <a href=\"https://go.elementor.com/wp-repo-description-tab-bug-crowd-bug-bounty-program/\" rel=\"nofollow ugc\">Bug Bounty program</a>. We collaborate with leading bug bounty services to provide opportunities for researchers to report vulnerabilities in our services. Our bounty programs include a triage team available 24/7/365.</p>\n<p>For more information: <a href=\"https://go.elementor.com/trust-center/\" rel=\"nofollow ugc\">Trust Center</a>.</p>\n<h4>♿ Accessibility Best Practices</h4>\n<p>Elementor offers accessibility tools and enhancements to help you provide a better experience for all users. Including HTML 5 semantic, full keyboard navigation menu, ongoing improvement of features, widget, and more.</p>\n<h4>🌐 Translated to 63+ languages, includes RTL support</h4>\n<p>Elementor supports multiple languages, typographies, and RTL, with editor translations in <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate/\" rel=\"nofollow ugc\">over 63 languages</a>.</p>\n<p>It’s also compatible with WPML, Polylang, TranslatePress, Weglot, and more. To contribute, add a new language via translate.wordpress.org. See our guide on <a href=\"https://go.elementor.com/wp-repo-description-tab-help-center-translate/\" rel=\"nofollow ugc\">how to translate and localize the plugin</a>.</p>\n<h4>⏩ Use of 3rd Party Services</h4>\n<p>To improve the user experience, Elementor may use the following 3rd party services if the required feature is enabled:</p>\n<ul>\n<li>Google Fonts – are loaded to add additional fonts to your website. Google’s <a href=\"https://policies.google.com/terms\" rel=\"nofollow ugc\">TOS</a> and <a href=\"https://policies.google.com/privacy\" rel=\"nofollow ugc\">Privacy Policy</a></li>\n<li>Some Elementor features require loading assets from Elementor.com. These assets are not used for tracking unless explicitly mentioned, requiring your approval and manual opt-in. Learn more in our <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-plugin-terms/\" rel=\"nofollow ugc\">TOS</a> and <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-plugin-privacy/\" rel=\"nofollow ugc\">Privacy Policy</a>.</li>\n</ul>\n<h4>📧 Related Products by Elementor</h4>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-io/\" rel=\"nofollow ugc\">Image Optimizer</a></strong>: Superior image compression for faster, high-quality website performance.</p>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-sm/\" rel=\"nofollow ugc\">Site Mailer</a></strong>: Reliable email management without SMTP plugins, keeping your communications streamlined and efficient.</p>\n<h4>📣 See What Our Users Have to Say</h4>\n<blockquote>\n<p>“Elementor is hands down the best page builder out there” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/elementor-is-hands-down-the-best-page-builder-out-there/\" rel=\"ugc\">Graphicvision1</a></em></p>\n<p>“An incredibly user-friendly plugin” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/a-wonderful-experience/\" rel=\"ugc\">Hyeyoga</a></em></p>\n<p>“Easily, my most used WP plugin” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/easily-my-most-used-wp-plugin/\" rel=\"ugc\">Xander Venske</a></em></p>\n<p>“I upgraded to the Pro version and just love this plugin!” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/love-elementor-17/\" rel=\"ugc\">Andybarn56</a></em></p>\n<p>“Excellent product with great tech support” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/excellent-product-with-great-tech-support/\" rel=\"ugc\">Martywilsonnj</a></em></p>\n</blockquote>\n<p><em><a href=\"https://wordpress.org/support/plugin/elementor/reviews/?filter=5\" rel=\"ugc\">More testimonials</a></em></p>\n<h4>🌍 به یک جامعه جهانی بپیوندید.</h4>\n<p>به جامعه جهانی‌ای بپیوندید که به یکدیگر کمک می‌کند تا به اهداف خود دست یابند.</p>\n<ul>\n<li><a href=\"https://elemn.to/discord\" rel=\"nofollow ugc\">Discord Community</a> – Topic and language-specific channels, plus Ella, an amazing AI helper, ready to assist you.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-facebook-group/\" rel=\"nofollow ugc\">Facebook Community</a> &#8211; Over 150K+ members, offering support, advice, feedback, and tutorials.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-github-repo/\" rel=\"nofollow ugc\">GitHub Community</a> &#8211; Get information about releases, request features, or report a bug.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-addons-dozens-of-elementor-addons/\" rel=\"nofollow ugc\">Elementor Addons, Themes, and Kits</a> Themes and Kits – created specifically for Elementor.</li>\n<li>Learn valuable insights and techniques from our <a href=\"https://go.elementor.com/wp-repo-description-tab-youtube-channel/\" rel=\"nofollow ugc\">YouTube Channel</a>.</li>\n<li>Access our <a href=\"https://go.elementor.com/wp-repo-description-tab-academy-elementor-academy/\" rel=\"nofollow ugc\">Academy</a> and <a href=\"https://go.elementor.com/wp-repo-description-tab-help-center-help-center/\" rel=\"nofollow ugc\">Help Center</a> &#8211; Find guides, tutorials, and resources to answer your questions and boost creativity.</li>\n<li>Show your support by <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-review/\" rel=\"nofollow ugc\">rating us on WordPress</a>. Your feedback fuels our growth! 🤗</li>\n<li>If you have questions or need support, visit the <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-forum/\" rel=\"nofollow ugc\">Plugin&#8217;s Forum</a>. Elementor Pro users can get 24/7 premium support,  &hellip;</li>\n</ul>\n\";s:12:\"installation\";s:1959:\"<h4>حداقل نیازمندی‌ها</h4>\n<ul>\n<li>WordPress 6.5 or greater</li>\n<li>PHP نسخه ۷.۴ یا بالاتر</li>\n<li>MySQL نسخه 5.0 یا بالاتر</li>\n</ul>\n<h4>الزامات توصیه شده</h4>\n<ul>\n<li>PHP نسخه 8.1 یا بالاتر</li>\n<li>MySQL نسخه 5.6 یا بالاتر</li>\n<li>محدودیت حافظه وردپرس ۶۴ مگابایت یا بیشتر (۱۲۸ مگابایت یا بالاتر ترجیح داده می‌شود)</li>\n</ul>\n<p><iframe loading=\"lazy\" title=\"Installing Elementor on WordPress\" width=\"750\" height=\"422\" src=\"https://www.youtube.com/embed/9EZ159ryFNs?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe></p>\n<h4>فرایند نصب</h4>\n<ol>\n<li>با استفاده از نصب‌کننده افزونه داخلی وردپرس نصب کنید، یا فایل فشرده را استخراج کنید و محتویات را در <code>wp-content/plugins/</code> پوشه نصب وردپرس خود رها کنید.</li>\n<li>افزونه را از طریق فهرست &#8216;افزونه‌ها&#8217; در وردپرس فعال کنید.</li>\n<li>برو به برگه‌ها &gt; افزودن جدید</li>\n<li>دکمه &#8216;ویرایش با المنتور&#8217; را فشار دهید.</li>\n<li>اکنون می‌توانید ابزارک‌ها را از پانل سمت چپ به قسمت محتوا بکشید و رها کنید، همچنین بخش‌ها و ستون‌های جدیدی را که ساختار صفحه را تشکیل می‌دهند اضافه کنید.</li>\n</ol>\n<p>برای مستندات و آموزش‌ها به <a href=\"https://elementor.com/help/?utm_source=wp-repo&amp;utm_medium=link&amp;utm_campaign=readme\" rel=\"nofollow ugc\">پایگاه دانش</a> ما مراجعه کنید.</p>\n\";s:3:\"faq\";s:7130:\"\n<dt id=\'how%20do%20i%20install%20elementor%3F\'>\nچگونه المنتور را نصب کنم؟\n</h4>\n<p>\n<p>برای نصب نسخه رایگان المنتور مراحل زیر را دنبال کنید:<br />\nاز داشبورد وردپرس شما -&gt; به افزونه‌ها بروید -&gt; روی «افزودن جدید» کلیک کنید -&gt; در قسمت جستجو المنتور را وارد کنید و سازنده وب‌سایت المنتور را انتخاب کنید.<br />\nنصب -&gt; پس از نصب روی فعال کردن کلیک کنید.</p>\n</p>\n<dt id=\'does%20elementor%20work%20with%20all%20the%20themes%3F\'>\nآیا المنتور با تمام پوسته‌ها کار می‌کند؟\n</h4>\n<p>\n<p>المنتور با تمام پوسته‌هایی را که به استانداردهای کدنویسی وردپرس تعیین شده توسط Codex آن احترام میگذارد، کار می‌کند. پیشنهاد می‌شود از <a href=\"https://go.elementor.com/wp-repo-description-tab-hello-theme-hello-theme/\" rel=\"nofollow ugc\">پوسته سلام</a> المنتور استفاده کنید، یک بوم خالی سبک وزن ، برای لذت بردن از انعطاف‌پذیری کامل هنگام استفاده از المنتور و بهینه سازی تجربه خود.</p>\n</p>\n<dt id=\'is%20elementor%20compatible%20with%20gutenberg%3F\'>\nآیا المنتور با گوتنبرگ سازگار است؟\n</h4>\n<p>\n<p>المنتور و گوتنبرگ به طور یکپارچه با هم کار می کنند. به عنوان یک کاربر، می توانید به راحتی تصمیم بگیرید که در هر نقطه از ویرایش سایت خود از کدام ویرایشگر استفاده کنید.</p>\n</p>\n<dt id=\'can%20i%20create%20an%20online%20store%3F\'>\nآیا می‌توانم یک فروشگاه اینترنتی ایجاد کنم؟\n</h4>\n<p>\n<p>بله، با سازنده ووکامرس المنتور پرو می توانید هر صفحه از فروشگاه خود را سفارشی کنید تا یک تجربه مشتری شگفت انگیز ایجاد کنید که باعث فروش می شود.</p>\n</p>\n<dt id=\'does%20it%20work%20with%20other%20wordpress%20plugins%3F\'>\nآیا با سایر افزونه‌های وردپرس کار می‌کند؟\n</h4>\n<p>\n<p>تقریباً با همه افزونه ها کار می کند. اگر با مشکل ناسازگاری مواجه شدید، لطفاً آن را به ما و افزونه‌ای که با المنتور مغایرت دارد گزارش دهید.</p>\n</p>\n<dt id=\'do%20i%20need%20to%20know%20how%20to%20code%3F\'>\nآیا باید بدانم چگونه کدنویسی کنم؟\n</h4>\n<p>\n<p>No! Elementor provides you with all the widgets and features that you need to build a professional website without using code.</p>\n</p>\n<dt id=\'do%20i%20need%20to%20know%20how%20to%20design%3F\'>\nDo I need to know how to design?\n</h4>\n<p>\n<p>No, you can choose between professionally designed kits and templates that fit toevery industry and have all you need to create your own professional website.</p>\n</p>\n<dt id=\'will%20elementor%20slow%20down%20my%20website%3F\'>\nWill Elementor slow down my website?\n</h4>\n<p>\n<p>از آنجایی که المنتور سرعت و عملکرد را در اولویت قرار می دهد، با هر نسخه جدید المنتور از عملکرد بهتر و سریع تری لذت می برید. هنگام آزمایش طرح‌بندی صفحه مشابه در نسخه‌های قدیمی‌تر، می‌توانید بهبود عملکرد قابل توجهی را مشاهده کنید، از امتیاز 82 در Google PageSpeed Insight در نسخه 3.1 به امتیاز 95 i در نسخه 3.5.</p>\n</p>\n<dt id=\'is%20my%20site%20secure%20with%20elementor%3F\'>\nآیا سایت من با المنتور امن است؟\n</h4>\n<p>\n<p>امنیت وب سایت شما برای ما بسیار مهم است و ما اقدامات پیشگیرانه ای را برای اطمینان از ایمن بودن وب سایت شما انجام می دهیم. المنتور دارای گواهینامه ISO 27001 است و دارای یک تیم اختصاصی از متخصصان امنیتی است که بهترین شیوه های صنعت را برای حداکثر امنیت و انطباق، 24/7 پیاده سازی می کنند.</p>\n<p>همچنین یک برنامه امنیتی مدیریت شده جایزه اشکال وجود دارد که با فعال کردن 24/7/365 شناسایی آسیب‌پذیری crowdsourced از قدرت جامعه استفاده می‌کند.</p>\n</p>\n<dt id=\'can%20i%20buy%20templates%20separately%3F\'>\nآیا می‌توانم قالب‌ها را جداگانه بخرم؟\n</h4>\n<p>\n<p>البته می‌توانید از هر قالبی که از المنتور پشتیبانی می‌کند، استفاده کنید.</p>\n</p>\n<dt id=\'is%20elementor%20compatible%20with%20post%20and%20custom%20post%20types%3F\'>\nآیا المنتور با انواع پست و پست سفارشی سازگار است؟\n</h4>\n<p>\n<p>البته! می‌توانید تعیین کنید کدام نوع پست المنتور را در صفحه تنظیمات فعال می‌کند.</p>\n</p>\n<dt id=\'what%20is%20the%20difference%20between%20elementor%27s%20free%20plugin%20and%20elementor%20pro\'>\nتفاوت بین افزونه رایگان المنتور و المنتور پرو چیست\n</h4>\n<p>\n<p>نسخه رایگان المنتور به شما امکان می دهد درگ انقلابی ما را کاوش کنید. ویرایشگر زنده، ویجت ها و قالب های اولیه را رها کنید.المنتور پرو (Essential، Advanced، Expert، Studio و Agency) شما را با ابزارهای حرفه ای تری توانمند می کند که گردش کار شما را سرعت می بخشد، به شما امکان دسترسی به پشتیبانی از نیروی انسانی را می دهد، به شما کمک می کند محتوای پیشرفته تری بسازید، و بازدیدکنندگان را تبدیل کنید. مقایسه کامل را اینجا ببینید.</p>\n</p>\n<dt id=\'how%20can%20i%20become%20a%20contributor\'>\nچگونه می‌توانم مشارکت کننده شوم\n</h4>\n<p>\n<p>اگر می‌خواهید کمک کنید، به <a href=\"https://github.com/elementor/elementor\" rel=\"nofollow ugc\">مخزن Elementor GitHub</a> ما بروید و ببینید کجا می‌توانید کمک کنید.<br />\nهمچنین می‌توانید از طریق <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate/\" rel=\"nofollow ugc\">translate.wordpress.org</a> یک زبان جدید اضافه کنید. ما یک راهنمای کوتاه ایجاد کرده‌ایم که <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate-faq/\" rel=\"nofollow ugc\">نحوه ترجمه و بومی‌سازی افزونه را توضیح می‌دهد</a>.</p>\n</p>\n\n\";s:9:\"changelog\";s:1845:\"<h4>3.33.2 &#8211; 2025-11-23</h4>\n<ul>\n<li>Security Fix: Improved code security enforcement in repeater widgets</li>\n<li>Security Fix: Improved code security enforcement in Star Rating widget</li>\n<li>Fix: Editor not loading with errors in the console in certain scenarios – Editor V4</li>\n</ul>\n<h4>3.33.1 &#8211; 2025-11-17</h4>\n<ul>\n<li>Security Fix: Improved code security enforcement in Floating Elements</li>\n</ul>\n<h4>3.33.0 &#8211; 2025-11-10</h4>\n<ul>\n<li>New: Introducing Variables Manager to manage design variables like colors, fonts, and sizes from a centralized panel &#8211; Editor V4</li>\n<li>New: Introducing Blend Mode control to create layered visual effects by defining how elements blend with backgrounds &#8211; Editor V4</li>\n<li>New: Introducing Background Clipping control to define where an element&#8217;s background is rendered across the element&#8217;s layout &#8211; Editor V4</li>\n<li>Tweak: Updated Editor Top Bar layout and button placement for improved navigation</li>\n<li>Tweak: Adjusted default cache behavior to inactive and updated FAQ Schema notice in Accordion widget</li>\n<li>Tweak: Improved error handling in Import and Export customization flow</li>\n<li>Tweak: Applied CSS logical properties support in Star Rating widget</li>\n<li>Tweak: Enhanced accessibility in Star Rating widget</li>\n<li>Tweak: Updated minimum supported versions for Chrome, Firefox, and Safari</li>\n<li>Fix: Child pages and menu items not importing correctly in Website Templates</li>\n<li>Fix: Deprecated <code>utf8_encode()</code> and <code>utf8_decode()</code> functions replaced for PHP 8.2 compatibility (<a href=\"https://github.com/elementor/elementor/issues/27499\" rel=\"nofollow ugc\">#27499</a>)</li>\n</ul>\n<p><a href=\"https://go.elementor.com/full-changelog/\" rel=\"nofollow ugc\">See changelog for all versions.</a></p>\n\";s:11:\"screenshots\";s:3148:\"<ol><li><a href=\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\" alt=\"&lt;strong&gt;Visual Drag and Drop Editor&lt;/strong&gt; - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.\"></a><p><strong>Visual Drag and Drop Editor</strong> - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\" alt=\"&lt;strong&gt;Full Design System&lt;/strong&gt; - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.\"></a><p><strong>Full Design System</strong> - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\" alt=\"&lt;strong&gt;Responsive Design&lt;/strong&gt; Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.\"></a><p><strong>Responsive Design</strong> Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\" alt=\"&lt;strong&gt;Kits and Templates&lt;/strong&gt; - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.\"></a><p><strong>Kits and Templates</strong> - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\" alt=\"&lt;strong&gt;Nested Elements&lt;/strong&gt; Leverage Elementor&#039;s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.\"></a><p><strong>Nested Elements</strong> Leverage Elementor\'s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\" alt=\"&lt;strong&gt;Motion Effects&lt;/strong&gt; - Add entrance animations and transitions to any element in your website to captivate visitors.\"></a><p><strong>Motion Effects</strong> - Add entrance animations and transitions to any element in your website to captivate visitors.</p></li></ol>\";s:7:\"reviews\";s:20823:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Une valeur sûre</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/magicphotoevents/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/9ea3ffc47183d9a9b7ad38f8ccfbe4fe6727cfb93d9ed170d125b535ea6a1965?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/9ea3ffc47183d9a9b7ad38f8ccfbe4fe6727cfb93d9ed170d125b535ea6a1965?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/magicphotoevents/\" class=\"reviewer-name\">magicphotoevents</a> در <span class=\"review-date\">نوامبر 30, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Elementor est un véritable atout pour wordpress !</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Tuyệt vời</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/vuhienctld/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/e1efa552412525312ade86f45c3b1dc9d5ba24e36538fe8d48c63059c93bf503?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/e1efa552412525312ade86f45c3b1dc9d5ba24e36538fe8d48c63059c93bf503?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/vuhienctld/\" class=\"reviewer-name\">vuhienctld</a> در <span class=\"review-date\">نوامبر 28, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Đây được xem là plugin xây dựng website đẹp và đơn giản. Giúp tối ưu tốt tốc độ load website. Tôi hài lòng cao nhất với plugin này</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Hands down the best editor</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/whiteelephantagency/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/d77da09e583e1566e62273a5270a884532349a7304b61f04956dfd6b4a919f5d?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/d77da09e583e1566e62273a5270a884532349a7304b61f04956dfd6b4a919f5d?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/whiteelephantagency/\" class=\"reviewer-name\">whiteelephantagency</a> در <span class=\"review-date\">نوامبر 26, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Is there a better alternative? I highly doubt it at this point. I\'ve installed Elementor on close to 100 websites now and rarely, emphasis on rarely, have we ever run into issues around build or features. You can pretty much design anything you want or get extremely close to your mockups. I say this as we\'ve worked on small business sites to startups and big corporations. </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Not intuitive</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/icedriver/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/86d96bab72d2542f5754065f094263dd6a9381b991e8519b7c89cfb02fc91e85?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/86d96bab72d2542f5754065f094263dd6a9381b991e8519b7c89cfb02fc91e85?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/icedriver/\" class=\"reviewer-name\">icedriver</a> در <span class=\"review-date\">نوامبر 26, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I inherited a site that was built with Elementor. The setup is not clear, the tools are mixed up and I can\'t get to previous menus. Instructions are convoluted and basically I need to watch many videos by people to figure out basic things - like \"how do I change the text in this menu\". </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">What a nightmare! STAY AWAY!!! Customer service does not exist!!!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/simjm/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/2f228d4b3706a609043654b6818c35af3e9b78b1de84679edb6cef71805df4b2?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/2f228d4b3706a609043654b6818c35af3e9b78b1de84679edb6cef71805df4b2?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/simjm/\" class=\"reviewer-name\">simjm</a> در <span class=\"review-date\">نوامبر 25, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Over the last several weeks, my experience with Elementor and Elementor Pro has deteriorated to a level that I can only describe as unacceptable for any paid software platform — let alone one that markets itself as a premium, reliable website-building solution. I am writing this detailed escalation because your support team has repeatedly failed to read, understand, or resolve the core issue: <strong>your system is incorrectly marking my active Elementor Pro license as “inactive,” preventing me from using the product I paid for.</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Let me start with the basics. Two months ago, I purchased a full year of Elementor Pro. That means I have <strong>ten months remaining</strong> on a valid, fully paid subscription. Yet despite this, your platform is blocking my ability to activate the plugin on a newly built staging environment. I performed the deactivation exactly as instructed on the previous installation, downloaded a fresh copy of the Elementor Pro ZIP file directly from my account dashboard, and installed it cleanly. There is no caching conflict, no duplicate installation, no domain mismatch — nothing on my side preventing activation.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>And yet, your system repeatedly tells me the license is “inactive.”</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>This alone is a serious problem. But what makes it significantly worse is the quality of the support I’ve received since raising this issue. Your team continues to respond with scripted messages as if they haven’t even read what I wrote. I’ve been told — incorrectly — that I do not have an active license, or that I may be “misunderstanding” the problem. You have asked questions I already answered. You have requested information I already submitted. And you continue to email administrative addresses I explicitly told you not to use, even after I clearly requested communication through my personal email.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>At this point, I am left wondering: <strong>Is anyone actually reading these messages?</strong><br />Because nothing in your responses suggests that a real human has taken thirty seconds to understand the situation.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Beyond the licensing issue itself, the timing makes this even more infuriating. Over the past month, I have dealt with catastrophic failures triggered by Elementor, Elementor Pro, Astra, Astra Pro, and third-party plugin conflicts. I have experienced fatal errors, broken templates, layout issues, width constraints that made no sense, and ultimately a complete collapse of my website — all during a period when I was actively trying to produce content and rebuild my platform. This forced me into a full migration to a new hosting environment, where I am now working from a clean staging build.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The last thing I should be dealing with, after all that, is your own licensing system refusing to recognize a paid subscription.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Let me be clear: <strong>I want what I paid for. Nothing more, nothing less.</strong><br />I paid for Elementor Pro. I should be able to use Elementor Pro. This is not optional. This is not a trivial request. This is the bare minimum expectation for a paid software product.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>At this point, I am requesting:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><!-- wp:list-item -->\n<li>A <strong>manual reset</strong> of my Elementor Pro license on your end.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Removal of any stuck, ghosted, or “phantom” activations.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Correction of your system so it correctly acknowledges the ten months of coverage remaining.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>A response from someone who has actually read this message and understands the issue — not another boilerplate reply.</li>\n<!-- /wp:list-item --></ol>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>I expect this to be resolved promptly. If not, I will escalate further through billing channels, publish a full account of this experience, and ensure others understand the risks of relying on your product. I am done wasting time repeating the same information to a support team that refuses to engage with a basic licensing problem affecting a paying customer.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>— <strong>John</strong></p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Elementor = headache</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/lemurnick/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/7737048386dbd1390172d41a715190e1c49b4fbec9835a2e208e736ce6c77422?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/7737048386dbd1390172d41a715190e1c49b4fbec9835a2e208e736ce6c77422?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/lemurnick/\" class=\"reviewer-name\">lemurnick</a> در <span class=\"review-date\">نوامبر 21, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Elementor Website Builder is more than just a page builder. First and foremost, it\'s a pain in the ass with constant issues with the editor and updates. Curse the day I decided to use it. I won\'t have those kinds of issues again! </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Not as good as it use to be</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/kkardi/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/0d2f3fa31213f1ff96eb7bda589bbeb5d078f24f7c5045c1a5d89f49a3e7d8ba?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/0d2f3fa31213f1ff96eb7bda589bbeb5d078f24f7c5045c1a5d89f49a3e7d8ba?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/kkardi/\" class=\"reviewer-name\">kkardi</a> در <span class=\"review-date\">نوامبر 20, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>You can find better website builders at better value. Costumer service sucks and they really rely  on the community to do it for them. The Ai website builder doesn\'t load onto your website regardless if you do it manually or through elementor. <br /><br /></p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Easy to Understand for begginers</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/skillcore/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/68633c5b2abcbaddd06153902230b2539cf0dfccee62a00567d14718c6bf8747?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/68633c5b2abcbaddd06153902230b2539cf0dfccee62a00567d14718c6bf8747?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/skillcore/\" class=\"reviewer-name\">Skillcore Learning <small>(skillcore)</small></a> در <span class=\"review-date\">نوامبر 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>When i started working on wordpress, it took some time to understand from where we have to start. But after using the elementor i created my own website skillcore.co.in for those who wants to develop their skills and add some new skills in their personal and professional life. Elementor should add some new features or give some more features in free version for new user also.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Operator Friendly</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/mikegates1954/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/0eb731693d913b3bde1ce0fc08acc2603818852a6f7283cffe69431e106c863b?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/0eb731693d913b3bde1ce0fc08acc2603818852a6f7283cffe69431e106c863b?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/mikegates1954/\" class=\"reviewer-name\">mikegates1954</a> در <span class=\"review-date\">نوامبر 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Found Elementor very easy to operate, although always finding new capabilities. When I started this venture 6 years ago, I knew very little how to operate Elementor. I am self-taught. I love this program. I recommend this to all that I chat to about my web page.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Admin side popups</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/fwuk/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/6e624dd9d5cfd73a73b52f449c853decbd6791ce87ff9834ceb6516c9ba6c3cd?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/6e624dd9d5cfd73a73b52f449c853decbd6791ce87ff9834ceb6516c9ba6c3cd?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/fwuk/\" class=\"reviewer-name\">fwuk</a> در <span class=\"review-date\">نوامبر 13, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Use it on every website I build. Getting better every update.</p>\n<!-- /wp:paragraph --></div>\n</div>\n\";}s:17:\"short_description\";s:339:\"صفحه ساز المنتور همه چیز را در خود جای داده : صفحه سازی با قابلیت کشیدن و رها کردن عناصر ، طراحی پیکسلی عالی ، ویرایشگر رسپانسیو برای نسخه تلفن همراه و چیزهای زیاد دیگر. همین الان شروع کنید!\";s:13:\"download_link\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.2.zip\";s:14:\"upgrade_notice\";a:0:{}s:11:\"screenshots\";a:6:{i:1;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\";s:7:\"caption\";s:144:\"<strong>Visual Drag and Drop Editor</strong> - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.\";}i:2;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\";s:7:\"caption\";s:185:\"<strong>Full Design System</strong> - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.\";}i:3;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\";s:7:\"caption\";s:170:\"<strong>Responsive Design</strong> Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.\";}i:4;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\";s:7:\"caption\";s:193:\"<strong>Kits and Templates</strong> - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.\";}i:5;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\";s:7:\"caption\";s:190:\"<strong>Nested Elements</strong> Leverage Elementor\'s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.\";}i:6;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\";s:7:\"caption\";s:127:\"<strong>Motion Effects</strong> - Add entrance animations and transitions to any element in your website to captivate visitors.\";}}s:4:\"tags\";a:5:{s:13:\"drag-and-drop\";s:13:\"drag-and-drop\";s:6:\"editor\";s:6:\"editor\";s:9:\"elementor\";s:9:\"elementor\";s:12:\"landing-page\";s:12:\"landing page\";s:12:\"page-builder\";s:12:\"page builder\";}s:8:\"versions\";a:377:{s:5:\"3.0.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.0.zip\";s:5:\"3.0.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.1.zip\";s:6:\"3.0.10\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.10.zip\";s:6:\"3.0.11\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.11.zip\";s:6:\"3.0.12\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.12.zip\";s:6:\"3.0.13\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.13.zip\";s:6:\"3.0.14\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.14.zip\";s:6:\"3.0.15\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.15.zip\";s:6:\"3.0.16\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.16.zip\";s:5:\"3.0.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.2.zip\";s:5:\"3.0.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.3.zip\";s:5:\"3.0.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.4.zip\";s:5:\"3.0.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.5.zip\";s:5:\"3.0.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.6.zip\";s:5:\"3.0.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.7.zip\";s:5:\"3.0.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.8.zip\";s:7:\"3.0.8.1\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.0.8.1.zip\";s:5:\"3.0.9\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.9.zip\";s:5:\"3.1.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.0.zip\";s:11:\"3.1.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta1.zip\";s:11:\"3.1.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta2.zip\";s:11:\"3.1.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta3.zip\";s:11:\"3.1.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta4.zip\";s:10:\"3.1.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev1.zip\";s:10:\"3.1.0-dev2\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev2.zip\";s:10:\"3.1.0-dev3\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev3.zip\";s:5:\"3.1.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.1.zip\";s:5:\"3.1.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.2.zip\";s:5:\"3.1.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.3.zip\";s:5:\"3.1.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.4.zip\";s:6:\"3.10.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.0.zip\";s:11:\"3.10.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.10.0-dev1.zip\";s:6:\"3.10.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.1.zip\";s:6:\"3.10.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.2.zip\";s:6:\"3.11.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.0.zip\";s:12:\"3.11.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta1.zip\";s:12:\"3.11.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta2.zip\";s:12:\"3.11.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta3.zip\";s:11:\"3.11.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev1.zip\";s:11:\"3.11.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev2.zip\";s:11:\"3.11.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev3.zip\";s:6:\"3.11.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.1.zip\";s:6:\"3.11.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.2.zip\";s:6:\"3.11.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.3.zip\";s:6:\"3.11.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.4.zip\";s:6:\"3.11.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.5.zip\";s:6:\"3.12.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.0.zip\";s:6:\"3.12.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.1.zip\";s:6:\"3.12.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.2.zip\";s:6:\"3.13.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.0.zip\";s:12:\"3.13.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta1.zip\";s:12:\"3.13.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta2.zip\";s:12:\"3.13.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta3.zip\";s:11:\"3.13.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-dev3.zip\";s:11:\"3.13.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-dev4.zip\";s:6:\"3.13.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.1.zip\";s:6:\"3.13.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.2.zip\";s:6:\"3.13.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.3.zip\";s:6:\"3.13.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.4.zip\";s:6:\"3.14.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.14.0.zip\";s:12:\"3.14.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta1.zip\";s:12:\"3.14.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta2.zip\";s:12:\"3.14.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta3.zip\";s:12:\"3.14.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta4.zip\";s:12:\"3.14.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta5.zip\";s:6:\"3.14.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.14.1.zip\";s:6:\"3.15.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.0.zip\";s:6:\"3.15.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.1.zip\";s:6:\"3.15.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.2.zip\";s:6:\"3.15.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.3.zip\";s:6:\"3.16.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.0.zip\";s:12:\"3.16.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-beta3.zip\";s:12:\"3.16.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-beta4.zip\";s:11:\"3.16.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-dev1.zip\";s:11:\"3.16.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-dev2.zip\";s:6:\"3.16.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.1.zip\";s:6:\"3.16.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.2.zip\";s:6:\"3.16.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.3.zip\";s:6:\"3.16.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.4.zip\";s:6:\"3.16.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.5.zip\";s:6:\"3.16.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.6.zip\";s:6:\"3.17.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.0.zip\";s:11:\"3.17.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev2.zip\";s:11:\"3.17.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev3.zip\";s:11:\"3.17.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev4.zip\";s:6:\"3.17.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.1.zip\";s:6:\"3.17.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.2.zip\";s:6:\"3.17.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.3.zip\";s:6:\"3.18.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.0.zip\";s:12:\"3.18.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta1.zip\";s:12:\"3.18.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta2.zip\";s:12:\"3.18.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta3.zip\";s:12:\"3.18.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta4.zip\";s:11:\"3.18.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-dev1.zip\";s:6:\"3.18.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.1.zip\";s:6:\"3.18.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.2.zip\";s:6:\"3.18.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.3.zip\";s:6:\"3.19.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.0.zip\";s:12:\"3.19.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta1.zip\";s:12:\"3.19.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta2.zip\";s:12:\"3.19.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta3.zip\";s:12:\"3.19.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta4.zip\";s:12:\"3.19.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta5.zip\";s:12:\"3.19.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta6.zip\";s:11:\"3.19.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev1.zip\";s:11:\"3.19.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev2.zip\";s:11:\"3.19.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev3.zip\";s:11:\"3.19.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev4.zip\";s:11:\"3.19.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev5.zip\";s:11:\"3.19.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev6.zip\";s:6:\"3.19.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.1.zip\";s:6:\"3.19.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.2.zip\";s:6:\"3.19.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.3.zip\";s:6:\"3.19.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.4.zip\";s:5:\"3.2.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.0.zip\";s:5:\"3.2.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.1.zip\";s:5:\"3.2.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.2.zip\";s:5:\"3.2.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.3.zip\";s:5:\"3.2.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.4.zip\";s:5:\"3.2.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.5.zip\";s:6:\"3.20.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.0.zip\";s:12:\"3.20.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta1.zip\";s:12:\"3.20.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta2.zip\";s:12:\"3.20.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta3.zip\";s:12:\"3.20.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta4.zip\";s:11:\"3.20.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev1.zip\";s:11:\"3.20.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev2.zip\";s:11:\"3.20.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev3.zip\";s:11:\"3.20.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev4.zip\";s:6:\"3.20.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.1.zip\";s:6:\"3.20.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.2.zip\";s:6:\"3.20.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.3.zip\";s:6:\"3.20.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.4.zip\";s:6:\"3.21.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.0.zip\";s:12:\"3.21.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta1.zip\";s:12:\"3.21.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta2.zip\";s:12:\"3.21.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta3.zip\";s:11:\"3.21.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev1.zip\";s:11:\"3.21.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev2.zip\";s:11:\"3.21.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev3.zip\";s:6:\"3.21.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.1.zip\";s:6:\"3.21.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.2.zip\";s:6:\"3.21.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.3.zip\";s:6:\"3.21.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.4.zip\";s:6:\"3.21.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.5.zip\";s:6:\"3.21.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.6.zip\";s:6:\"3.21.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.7.zip\";s:6:\"3.21.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.8.zip\";s:6:\"3.22.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.0.zip\";s:12:\"3.22.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta1.zip\";s:12:\"3.22.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta2.zip\";s:12:\"3.22.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta3.zip\";s:12:\"3.22.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta4.zip\";s:12:\"3.22.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta5.zip\";s:12:\"3.22.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta6.zip\";s:11:\"3.22.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev1.zip\";s:11:\"3.22.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev2.zip\";s:11:\"3.22.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev3.zip\";s:11:\"3.22.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev4.zip\";s:11:\"3.22.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev5.zip\";s:11:\"3.22.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev6.zip\";s:6:\"3.22.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.1.zip\";s:6:\"3.22.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.2.zip\";s:6:\"3.22.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.3.zip\";s:6:\"3.23.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.0.zip\";s:12:\"3.23.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta1.zip\";s:12:\"3.23.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta2.zip\";s:12:\"3.23.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta3.zip\";s:12:\"3.23.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta4.zip\";s:12:\"3.23.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta5.zip\";s:12:\"3.23.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta6.zip\";s:11:\"3.23.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev1.zip\";s:11:\"3.23.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev2.zip\";s:11:\"3.23.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev3.zip\";s:11:\"3.23.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev4.zip\";s:11:\"3.23.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev5.zip\";s:11:\"3.23.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev6.zip\";s:6:\"3.23.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.1.zip\";s:6:\"3.23.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.2.zip\";s:6:\"3.23.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.3.zip\";s:6:\"3.23.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.4.zip\";s:6:\"3.24.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.0.zip\";s:12:\"3.24.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta1.zip\";s:12:\"3.24.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta2.zip\";s:12:\"3.24.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta3.zip\";s:11:\"3.24.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev1.zip\";s:11:\"3.24.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev2.zip\";s:11:\"3.24.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev3.zip\";s:6:\"3.24.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.1.zip\";s:6:\"3.24.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.2.zip\";s:6:\"3.24.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.3.zip\";s:6:\"3.24.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.4.zip\";s:6:\"3.24.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.5.zip\";s:6:\"3.24.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.6.zip\";s:6:\"3.24.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.7.zip\";s:6:\"3.24.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.8.zip\";s:6:\"3.25.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.0.zip\";s:12:\"3.25.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta1.zip\";s:12:\"3.25.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta2.zip\";s:12:\"3.25.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta3.zip\";s:11:\"3.25.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev1.zip\";s:11:\"3.25.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev2.zip\";s:11:\"3.25.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev3.zip\";s:6:\"3.25.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.1.zip\";s:7:\"3.25.10\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.25.10.zip\";s:7:\"3.25.11\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.25.11.zip\";s:6:\"3.25.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.2.zip\";s:6:\"3.25.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.3.zip\";s:6:\"3.25.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.4.zip\";s:6:\"3.25.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.5.zip\";s:6:\"3.25.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.6.zip\";s:6:\"3.25.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.7.zip\";s:6:\"3.25.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.8.zip\";s:6:\"3.25.9\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.9.zip\";s:6:\"3.26.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.0.zip\";s:12:\"3.26.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta1.zip\";s:12:\"3.26.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta2.zip\";s:12:\"3.26.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta3.zip\";s:12:\"3.26.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta4.zip\";s:12:\"3.26.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta5.zip\";s:11:\"3.26.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev1.zip\";s:11:\"3.26.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev2.zip\";s:11:\"3.26.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev3.zip\";s:11:\"3.26.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev4.zip\";s:11:\"3.26.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev5.zip\";s:6:\"3.26.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.1.zip\";s:6:\"3.26.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.2.zip\";s:6:\"3.26.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.3.zip\";s:6:\"3.26.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.4.zip\";s:6:\"3.26.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.5.zip\";s:6:\"3.27.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.0.zip\";s:12:\"3.27.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-beta1.zip\";s:12:\"3.27.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-beta2.zip\";s:11:\"3.27.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-dev1.zip\";s:11:\"3.27.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-dev2.zip\";s:6:\"3.27.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.1.zip\";s:6:\"3.27.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.2.zip\";s:6:\"3.27.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.3.zip\";s:6:\"3.27.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.4.zip\";s:6:\"3.27.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.5.zip\";s:6:\"3.27.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.6.zip\";s:6:\"3.27.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.7.zip\";s:6:\"3.28.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.0.zip\";s:12:\"3.28.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta1.zip\";s:12:\"3.28.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta2.zip\";s:12:\"3.28.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta3.zip\";s:11:\"3.28.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev1.zip\";s:11:\"3.28.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev2.zip\";s:11:\"3.28.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev3.zip\";s:6:\"3.28.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.1.zip\";s:6:\"3.28.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.2.zip\";s:6:\"3.28.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.3.zip\";s:6:\"3.28.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.4.zip\";s:6:\"3.29.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.0.zip\";s:12:\"3.29.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta1.zip\";s:12:\"3.29.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta2.zip\";s:12:\"3.29.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta3.zip\";s:12:\"3.29.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta4.zip\";s:11:\"3.29.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev1.zip\";s:11:\"3.29.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev2.zip\";s:11:\"3.29.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev3.zip\";s:11:\"3.29.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev4.zip\";s:6:\"3.29.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.1.zip\";s:6:\"3.29.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.2.zip\";s:5:\"3.3.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.3.0.zip\";s:5:\"3.3.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.3.1.zip\";s:6:\"3.30.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.0.zip\";s:12:\"3.30.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta1.zip\";s:12:\"3.30.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta2.zip\";s:12:\"3.30.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta3.zip\";s:11:\"3.30.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev1.zip\";s:11:\"3.30.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev2.zip\";s:11:\"3.30.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev3.zip\";s:6:\"3.30.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.1.zip\";s:6:\"3.30.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.2.zip\";s:6:\"3.30.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.3.zip\";s:6:\"3.30.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.4.zip\";s:6:\"3.31.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.0.zip\";s:12:\"3.31.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-beta1.zip\";s:12:\"3.31.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-beta2.zip\";s:11:\"3.31.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-dev1.zip\";s:11:\"3.31.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-dev2.zip\";s:6:\"3.31.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.1.zip\";s:6:\"3.31.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.2.zip\";s:6:\"3.31.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.3.zip\";s:6:\"3.31.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.4.zip\";s:6:\"3.31.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.5.zip\";s:6:\"3.32.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.0.zip\";s:12:\"3.32.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta1.zip\";s:12:\"3.32.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta2.zip\";s:12:\"3.32.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta3.zip\";s:11:\"3.32.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev1.zip\";s:11:\"3.32.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev2.zip\";s:11:\"3.32.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev3.zip\";s:6:\"3.32.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.1.zip\";s:6:\"3.32.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.2.zip\";s:6:\"3.32.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.3.zip\";s:6:\"3.32.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.4.zip\";s:6:\"3.32.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.5.zip\";s:6:\"3.33.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.0.zip\";s:12:\"3.33.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta1.zip\";s:12:\"3.33.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta2.zip\";s:12:\"3.33.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta3.zip\";s:12:\"3.33.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta4.zip\";s:11:\"3.33.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev1.zip\";s:11:\"3.33.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev2.zip\";s:11:\"3.33.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev3.zip\";s:11:\"3.33.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev4.zip\";s:6:\"3.33.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.1.zip\";s:6:\"3.33.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.2.zip\";s:5:\"3.4.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.0.zip\";s:10:\"3.4.0-dev7\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev7.zip\";s:10:\"3.4.0-dev8\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev8.zip\";s:10:\"3.4.0-dev9\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev9.zip\";s:5:\"3.4.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.1.zip\";s:5:\"3.4.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.2.zip\";s:5:\"3.4.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.3.zip\";s:5:\"3.4.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.4.zip\";s:5:\"3.4.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.5.zip\";s:5:\"3.4.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.6.zip\";s:5:\"3.4.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.7.zip\";s:5:\"3.4.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.8.zip\";s:5:\"3.5.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.0.zip\";s:11:\"3.5.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta1.zip\";s:11:\"3.5.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta2.zip\";s:11:\"3.5.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta3.zip\";s:11:\"3.5.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta4.zip\";s:11:\"3.5.0-beta5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta5.zip\";s:11:\"3.5.0-beta7\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta7.zip\";s:11:\"3.5.0-beta8\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta8.zip\";s:10:\"3.5.0-dev8\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-dev8.zip\";s:10:\"3.5.0-dev9\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-dev9.zip\";s:5:\"3.5.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.1.zip\";s:5:\"3.5.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.2.zip\";s:5:\"3.5.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.3.zip\";s:5:\"3.5.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.4.zip\";s:5:\"3.5.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.5.zip\";s:5:\"3.5.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.6.zip\";s:5:\"3.6.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:11:\"3.6.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta1.zip\";s:11:\"3.6.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta2.zip\";s:11:\"3.6.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta3.zip\";s:11:\"3.6.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta4.zip\";s:11:\"3.6.0-beta5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta5.zip\";s:10:\"3.6.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-dev1.zip\";s:11:\"3.6.0-dev10\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-dev10.zip\";s:5:\"3.6.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.1.zip\";s:5:\"3.6.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.2.zip\";s:5:\"3.6.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.3.zip\";s:5:\"3.6.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.4.zip\";s:5:\"3.6.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.5.zip\";s:5:\"3.6.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.6.zip\";s:5:\"3.6.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.7.zip\";s:5:\"3.6.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.8.zip\";s:5:\"3.7.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.0.zip\";s:11:\"3.7.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta1.zip\";s:11:\"3.7.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta2.zip\";s:11:\"3.7.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta3.zip\";s:11:\"3.7.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta4.zip\";s:10:\"3.7.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-dev1.zip\";s:5:\"3.7.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.1.zip\";s:5:\"3.7.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.2.zip\";s:5:\"3.7.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.3.zip\";s:5:\"3.7.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.4.zip\";s:5:\"3.7.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.5.zip\";s:5:\"3.7.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.6.zip\";s:5:\"3.7.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.7.zip\";s:5:\"3.7.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.8.zip\";s:5:\"3.8.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.8.0.zip\";s:11:\"3.8.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta1.zip\";s:11:\"3.8.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta2.zip\";s:11:\"3.8.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta3.zip\";s:5:\"3.8.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.8.1.zip\";s:5:\"3.9.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.0.zip\";s:5:\"3.9.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.1.zip\";s:5:\"3.9.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.2.zip\";s:5:\"trunk\";s:52:\"https://downloads.wordpress.org/plugin/elementor.zip\";}s:14:\"business_model\";s:10:\"commercial\";s:14:\"repository_url\";s:0:\"\";s:22:\"commercial_support_url\";s:94:\"https://elementor.com/support/?utm_source=wp-repo&utm_medium=link&utm_campaign=premium-support\";s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133\";s:4:\"high\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133\";}s:5:\"icons\";a:2:{s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597\";s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597\";}s:12:\"preview_link\";s:0:\"\";s:4:\"Name\";s:84:\"وب‌سایت ساز المنتور &#8211; فراتر از یک صفحه‌ساز\";}}","off");

INSERT IGNORE INTO `ndu6_options` VALUES 
("157","recently_activated","a:0:{}","off"),
("163","new_admin_email","info@toplor.ir","auto"),
("174","theme_mods_twentytwentyfive","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1764497103;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","off"),
("175","recovery_keys","a:0:{}","off"),
("176","_transient_wp_styles_for_blocks","a:2:{s:4:\"hash\";s:32:\"e4db2e247eccf33a2af3e11c37e80bd8\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:12:\"core/columns\";s:0:\"\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}","on"),
("178","finished_updating_comment_type","1","auto"),
("183","db_upgraded","","on"),
("196","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:14:\"info@toplor.ir\";s:7:\"version\";s:5:\"6.8.3\";s:9:\"timestamp\";i:1764496976;}","off"),
("197","_site_transient_timeout_php_check_7b9fb72b3bf6b27c046e3a9832dfe8e2","1765101777","off"),
("198","_site_transient_php_check_7b9fb72b3bf6b27c046e3a9832dfe8e2","a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:0;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}","off"),
("199","_transient_health-check-site-status-result","{\"good\":17,\"recommended\":5,\"critical\":1}","on"),
("200","_site_transient_timeout_browser_e4c4b51bcc4533fdf2a13cb61b1f671a","1765101803","off"),
("201","_site_transient_browser_e4c4b51bcc4533fdf2a13cb61b1f671a","a:10:{s:4:\"name\";s:5:\"Opera\";s:7:\"version\";s:9:\"124.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:22:\"https://www.opera.com/\";s:7:\"img_src\";s:42:\"http://s.w.org/images/browsers/opera.png?1\";s:11:\"img_src_ssl\";s:43:\"https://s.w.org/images/browsers/opera.png?1\";s:15:\"current_version\";s:5:\"12.18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","off"),
("202","can_compress_scripts","1","on"),
("203","_site_transient_timeout_community-events-93de2e68806202d55ef3f6cfbfa3b17b","1764540205","off"),
("204","_site_transient_community-events-93de2e68806202d55ef3f6cfbfa3b17b","a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:11:\"5.218.148.0\";}s:6:\"events\";a:0:{}}","off"),
("205","_transient_timeout_feed_9ba2df8849616f02166b8f7242d75067","1764540205","off"),
("206","_transient_feed_9ba2df8849616f02166b8f7242d75067","a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"بلاگ – WordPress.org فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fa.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Feb 2025 10:36:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fa-IR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=7.0-alpha-61315\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"بلاگ – WordPress.org فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fa.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"خطرات استفاده از محصولات نال و کرک شده\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:230:\"https://fa.wordpress.org/2025/02/12/%d8%ae%d8%b7%d8%b1%d8%a7%d8%aa-%d8%a7%d8%b3%d8%aa%d9%81%d8%a7%d8%af%d9%87-%d8%a7%d8%b2-%d9%85%d8%ad%d8%b5%d9%88%d9%84%d8%a7%d8%aa-%d9%86%d8%a7%d9%84-%d9%88-%da%a9%d8%b1%da%a9-%d8%b4%d8%af%d9%87/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:239:\"https://fa.wordpress.org/2025/02/12/%d8%ae%d8%b7%d8%b1%d8%a7%d8%aa-%d8%a7%d8%b3%d8%aa%d9%81%d8%a7%d8%af%d9%87-%d8%a7%d8%b2-%d9%85%d8%ad%d8%b5%d9%88%d9%84%d8%a7%d8%aa-%d9%86%d8%a7%d9%84-%d9%88-%da%a9%d8%b1%da%a9-%d8%b4%d8%af%d9%87/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Feb 2025 09:39:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fa.wordpress.org/?p=1120\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:515:\"استفاده از محصولات نال (Null) یا کرک شده در حوزه وردپرس و دیگر نرم‌افزارها ممکن است برای برخی افراد به دلیل رایگان بودن و یا قیمت کمتر از نسخه اصلی آن‌ها جذاب باشد، اما این کار با مشکلات و خطرات بزرگی همراه است.&#160;در ادامه به دلایل اصلی اجتناب از محصولات نال می‌پردازیم. 1. احترام به [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Farhad Sakhaei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:13685:\"\n<p>استفاده از محصولات نال (Null) یا کرک شده در حوزه وردپرس و دیگر نرم‌افزارها ممکن است برای برخی افراد به دلیل رایگان بودن و یا قیمت کمتر از نسخه اصلی آن‌ها جذاب باشد، اما این کار با مشکلات و خطرات بزرگی همراه است.&nbsp;در ادامه به دلایل اصلی اجتناب از محصولات نال می‌پردازیم.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h4 class=\"wp-block-heading\"><strong>1. احترام به قانون کپی‌رایت</strong></h4>\n\n\n\n<p>هر نرم‌افزاری که توسط توسعه‌دهندگان یا تیم‌های برنامه‌نویسی تولید می‌شود، نتیجه‌ زحمت، زمان و هزینه‌ زیادی است. اکثر این نرم‌افزارها نسخه‌های رایگان یا آزمایشی نیز ارائه می‌دهند تا کاربران بتوانند قبل از خرید، آن‌ها را امتحان کنند.<br>استفاده از نسخه‌های نال شده این محصولات، نه تنها نقض قانون کپی‌رایت، بلکه یک عمل غیر اخلاقی محسوب می‌شود. این کار نه تنها زحمات توسعه‌دهنده را بی‌ارزش می‌کند، بلکه توسعه و نوآوری در نرم‌افزارها را نیز کاهش می‌دهد.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h4 class=\"wp-block-heading\"><strong>2. خطرات امنیتی</strong></h4>\n\n\n\n<p>استفاده از محصولات نال می‌تواند امنیت شما و وب‌سایتتان را به شدت به خطر بیندازد.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>محصول نال چیست؟</strong><strong><br></strong>محصولات نال در واقع نسخه‌های غیرقانونی نرم‌افزارهایی هستند که سیستم لایسنس آن‌ها دور زده شده است. این نسخه‌ها اغلب توسط افرادی عرضه می‌شوند که اهداف نامعلومی دارند، از جمله تزریق کدهای مخرب.</li>\n\n\n\n<li><strong>عدم دریافت به‌روزرسانی‌ها</strong><strong><br></strong>یکی از بزرگ‌ترین مزایای محصولات اصلی، ارائه به‌روزرسانی‌های منظم برای رفع باگ‌ها و ارتقای امنیت است. کاربران محصولات نال، این آپدیت‌ها را دریافت نمی‌کنند و در نتیجه، سایت آن‌ها در برابر حملات سایبری آسیب‌پذیر می‌شود.</li>\n\n\n\n<li><strong>عدم پشتیبانی</strong><strong><br></strong>محصولات پرمیوم معمولاً با پشتیبانی کامل توسعه‌دهندگان همراه هستند. کاربران محصولات نال به این پشتیبانی دسترسی ندارند و در صورت بروز مشکل، باید خودشان آن را حل کنند.</li>\n\n\n\n<li><strong>کدهای مخرب</strong><strong><br></strong>محصولات نال اغلب شامل کدهای مخربی هستند که می‌توانند اطلاعات حساس شما مانند رمزهای عبور، اطلاعات بانکی و حتی اطلاعات مشتریان شما را به سرقت ببرند. این مسئله به ویژه برای سایت‌های فروشگاهی و کسب‌وکارهای آنلاین بسیار خطرناک است.</li>\n\n\n\n<li><strong>سو استفاده از منابع سرور</strong><strong><br></strong>استفاده از محصولات نال در برخی موارد منجر به سوء استفاده هکرها از منابع سرور، ارسال ایمیل‌های تبلیغاتی، دریافت دسترسی و تلاش برای نفوذ به سرور و هک کردن آن می‌شود که می‌تواند نتایج مخرب و مشکل زایی برای سرور و یا آدرس IP آن و حتی سایت‌های مشترک دیگر میزبانی‌شده بر روی آن داشته باشد.</li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h4 class=\"wp-block-heading\"><strong>3. تاثیرات منفی بر سئو</strong></h4>\n\n\n\n<p>استفاده از محصولات نال ممکن است باعث ایجاد لینک‌های اسپم، پاپ‌آپ‌های تبلیغاتی و حتی تغییرات مخفی در کد سایت شود. این موارد ممکن است باعث کاهش رتبه سایت شما در موتورهای جستجو شده و اعتماد کاربران را نیز از بین ببرد.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h4 class=\"wp-block-heading\"><strong>4. انگیزه‌های ارائه‌دهندگان محصولات نال</strong></h4>\n\n\n\n<p>افرادی که محصولات نال را ارائه می‌دهند، معمولاً به دنبال منافع شخصی هستند. برخی از انگیزه‌های آن‌ها عبارتند از:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>تزریق تبلیغات و لینک‌های اسپم به سایت شما.</li>\n\n\n\n<li>سرقت اطلاعات شخصی مانند نام کاربری، رمز عبور، ایمیل و اطلاعات مالی.</li>\n\n\n\n<li>آلوده کردن فایل‌ها و سرورهای شما به بدافزارها.</li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h3 class=\"wp-block-heading\"><strong>چگونه بفهمیم یک محصول نال است؟</strong></h3>\n\n\n\n<p>تشخیص محصولات نال برای افرادی که با ویژگی‌های نسخه‌های اورجینال آشنا نیستند، ممکن است دشوار باشد. اما با چند نکته ساده می‌توان از خرید این محصولات جلوگیری کرد:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><strong>فروشگاه عرضه‌کننده محصول:</strong><strong><br></strong>هر محصول تجاری، تنها در فروشگاه رسمی تولیدکننده آن به فروش می‌رسد. اگر یک فروشگاه دیگر، از جمله فروشگاه‌های ایرانی، محصولاتی مانند قالب وودمارت (WoodMart)، افزونه المنتور (Elementor) یا سایر افزونه‌ها و قالب‌های پرمیوم را با عنوان نگارش اصل و اورجینال ارائه کند، در حال فروش نسخه نال محصول است. توجه داشته باشید هیچ وب‌سایتی از این امر مستثنی نیست.</li>\n\n\n\n<li><strong>قیمت غیرمعقول:</strong><strong><br></strong>محصولات نال معمولاً با قیمتی بسیار کمتر از نسخه اورجینال به فروش می‌رسند. اگر یک قالب یا افزونه با قیمت بسیار پایین‌تر از سایت اصلی عرضه شود، احتمال نال بودن آن بسیار زیاد است.</li>\n\n\n\n<li><strong>عدم ارائه لایسنس معتبر:</strong><strong><br></strong>محصولات اصلی همراه با یک لایسنس معتبر عرضه می‌شوند که امکان فعال‌سازی و دریافت به‌روزرسانی‌ها را فراهم می‌کند. اگر محصولی فاقد لایسنس معتبر باشد یا لایسنس غیرقابل تأیید ارائه دهد، احتمالاً نال شده است.</li>\n\n\n\n<li><strong>بررسی نظرات کاربران و اعتبار فروشنده:</strong><strong><br></strong>پیش از خرید، نظرات کاربران را بررسی کنید و از معتبر بودن فروشگاه اطمینان حاصل کنید. فروشگاه‌های معتبر اطلاعات واضحی درباره محصولات ارائه می‌دهند و به سوالات کاربران پاسخ شفاف می‌دهند.</li>\n\n\n\n<li><strong>محصولات نگارش اصلی کد شده نمی‌باشند</strong><strong><br></strong>باید توجه داشته باشید که وردپرس بر اساس GPL و کد باز (Open Source) منتشر شده است. این به این معنی است که تمامی افزونه‌ها و پوسته‌های مرتبط با آن، باید به صورت کد باز منتشر شوند، حتی هر افزونه و یا پوسته‌ای که نگارش Premium یا Pro باشد باید به صورت Open Source به کاربران ارائه شوند، حال آنکه متاسفانه بسیاری از فروشگاه‌های ایرانی، نسخه‌های Premium و Pro را که کد باز هستند، کدگذاری کرده و با دخل تصرف بیشتر و یا اضافه کردن سیستم‌های لایسنس پیچیده‌تر، سعی در فروش بیشتر و در نتیجه پیچیده‌تر کردن محصول نهایی می‌کنند که این کار در نهایت منجر به سنگین‌تر شدن سایت و زمان بارگذاری بیشتر سایت و مشکلات دیگر می‌شود.</li>\n</ol>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h3 class=\"wp-block-heading\"><strong>چطور محصولات اورجینال بخریم؟</strong></h3>\n\n\n\n<p>با توجه به مشکلات خرید دلاری برای کاربران ایرانی، می‌توانید از روش‌های زیر استفاده کنید:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><strong>سایت‌های واسطه:</strong><strong><br></strong>برخی از سایت‌های معتبر واسطه ایرانی امکان خرید دلاری را برای شما فراهم می‌کنند. این سایت‌ها با دریافت مبلغ ریالی، محصول مورد نظر شما را از سایت اصلی خریداری کرده و اطلاعات لایسنس را در اختیار شما قرار می‌دهند. قبل از استفاده از خدمات این سایت‌ها، اعتبار آن‌ها را بررسی کنید.</li>\n\n\n\n<li><strong>دوستان یا آشنایان دارای حساب بین‌المللی:</strong><strong><br></strong>اگر دوستان یا آشنایانی دارید که دسترسی به کارت‌های بین‌المللی مانند مسترکارت یا ویزا کارت دارند، می‌توانید از آن‌ها برای خرید محصولات کمک بگیرید.</li>\n\n\n\n<li><strong>پیشنهاد دیگر: استفاده از تخفیف‌ها و باندل‌ها</strong><strong><br></strong>بسیاری از توسعه‌دهندگان محصولات وردپرس، در بازه‌های زمانی خاص مانند جمعه سیاه (Black Friday) یا مناسبت‌های دیگر، تخفیف‌های چشمگیری ارائه می‌دهند. با کمی برنامه‌ریزی می‌توانید محصولات اورجینال را با هزینه کمتری خریداری کنید.</li>\n</ol>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h3 class=\"wp-block-heading\"><strong>جمع‌بندی:</strong></h3>\n\n\n\n<p>خرید محصولات اصلی، علاوه بر حمایت از توسعه‌دهندگان، به شما این امکان را می‌دهد که از امکانات زیر بهره‌مند شوید:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>پشتیبانی مداوم:</strong> حل مشکلات و پاسخ به سوالات شما.</li>\n\n\n\n<li><strong>دریافت به‌روزرسانی‌ها:</strong> محافظت سایت در برابر آسیب‌پذیری‌ها.</li>\n\n\n\n<li><strong>دسترسی به امکانات کامل و مستندات:</strong> بهره‌گیری از تمامی قابلیت‌های محصول به صورت بهینه.</li>\n</ul>\n\n\n\n<p>با خرید نسخه‌های اورجینال، هم امنیت و عملکرد سایت خود را تضمین می‌کنید و هم به توسعه تکنولوژی‌های بهتر کمک می‌کنید.</p>\n\n\n\n<p>استفاده از محصولات نال نه تنها غیراخلاقی و غیرقانونی است، بلکه می‌تواند خطرات جدی برای امنیت، عملکرد و اعتبار سایت شما ایجاد کند. به جای انتخاب این محصولات، از نسخه‌های رایگان یا لایسنس‌دار استفاده کنید. این کار نه تنها باعث حمایت از توسعه‌دهندگان می‌شود، بلکه امنیت و کیفیت سایت شما را تضمین می‌کند.</p>\n\n\n\n<p>اگر هزینه یک محصول برایتان بالا است، به دنبال جایگزین‌های رایگان یا تخفیف‌های فصلی باشید، اما هرگز امنیت و اعتبار خود را فدای استفاده از محصولات نال نکنید.</p>\n\n\n\n<p><strong>نوشته شده توسط:</strong> <a href=\"https://profiles.wordpress.org/asadiy4n/\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/asadiy4n/\">حسین اسدیان</a> و <a href=\"https://fa.wordpress.org/team/2024/02/17/%d9%85%d8%b9%d8%b1%d9%81%db%8c-%d8%aa%db%8c%d9%85-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/\" data-type=\"link\" data-id=\"https://fa.wordpress.org/team/2024/02/17/%d9%85%d8%b9%d8%b1%d9%81%db%8c-%d8%aa%db%8c%d9%85-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/\">تیم وردپرس فارسی</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:235:\"https://fa.wordpress.org/2025/02/12/%d8%ae%d8%b7%d8%b1%d8%a7%d8%aa-%d8%a7%d8%b3%d8%aa%d9%81%d8%a7%d8%af%d9%87-%d8%a7%d8%b2-%d9%85%d8%ad%d8%b5%d9%88%d9%84%d8%a7%d8%aa-%d9%86%d8%a7%d9%84-%d9%88-%da%a9%d8%b1%da%a9-%d8%b4%d8%af%d9%87/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1120\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۷\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"https://fa.wordpress.org/2024/11/17/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%86%da%af%d8%a7%d8%b1%d8%b4-%db%b7-%db%b6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 17 Nov 2024 20:15:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fa.wordpress.org/?p=1103\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:527:\"به وردپرس ۶.۷ خوش آمدید! وردپرس ۶.۷ با تم مدرن Twenty Twenty-Five معرفی می‌شود که انعطاف‌پذیری طراحی بی‌نظیری را برای هر وبلاگ در هر مقیاسی ارائه می‌دهد. کنترل تایپوگرافی سایت خود را مانند هرگز قبل با ویژگی‌های جدید مدیریت فونت به دست بگیرید. ویژگی جدید Zoom Out به شما این امکان را می‌دهد که سایت [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11038:\"\n<h2 class=\"wp-block-heading has-huge-font-size\"><strong>به وردپرس ۶.۷ خوش آمدید!</strong></h2>\n\n\n\n<p>وردپرس ۶.۷ با تم مدرن Twenty Twenty-Five معرفی می‌شود که انعطاف‌پذیری طراحی بی‌نظیری را برای هر وبلاگ در هر مقیاسی ارائه می‌دهد. کنترل تایپوگرافی سایت خود را مانند هرگز قبل با ویژگی‌های جدید مدیریت فونت به دست بگیرید. ویژگی جدید Zoom Out به شما این امکان را می‌دهد که سایت خود را با یک نمای کلان طراحی کنید و از جزئیات فاصله بگیرید تا تصویر کلی را به زندگی بیاورید</p>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>معرفی پوسته Twenty Twenty-Five<br>امکان بی‌پایان بدون پیچیدگی</strong></h4>\n\n\n\n<p>پوسته Twenty Twenty-Five یک پوسته انعطاف‌پذیر و متمرکز بر طراحی را ارائه می‌دهد که به شما این امکان را می‌دهد تا سایت‌های خیره‌کننده‌ای را به سادگی بسازید. زیبایی‌شناسی خود را با مجموعه‌ای از گزینه‌های سبک، الگوهای بلوک و پالت‌های رنگی سفارشی کنید. این پوسته که به اصول اساسی خود پایبند است، واقعاً می‌تواند با شما رشد کند</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img decoding=\"async\" src=\"https://i0.wp.com/s.w.org/images/core/6.7/feature-tt5-2.webp\" alt=\"\" style=\"aspect-ratio:4/3;object-fit:cover;width:474px;height:auto\" /></figure>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>تصویر کلی را با ویژگی Zoom Out ببینید<br>محتوای خود را از یک دیدگاه جدید کاوش کنید</strong></h4>\n\n\n\n<p>محتوای خود را به‌طور کامل و به شیوه‌ای بی‌سابقه ویرایش و مرتب کنید. نمای وسیع‌تری از سایت شما این امکان را می‌دهد که الگوها را به دلخواه خود اضافه، ویرایش، جابجا یا حذف کنید. معمار درون خود را در آغوش بگیرید</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img decoding=\"async\" src=\"https://i0.wp.com/s.w.org/images/core/6.7/feature-zoom-2.webp?ssl=1\" alt=\"\" style=\"aspect-ratio:4/3;object-fit:cover;width:474px\" /></figure>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>بلوک‌ها و فیلدهای سفارشی را بدون دردسر (یا کدنویسی) متصل کنید<br>راهی ساده برای ایجاد محتوای پویا</strong></h4>\n\n\n\n<p>این ویژگی یک رابط کاربری جدید برای اتصال بلوک‌ها به فیلدهای سفارشی معرفی می‌کند و کنترل محتوای پویا را به‌طور مستقیم در ویرایشگر قرار می‌دهد. بلوک‌ها را تنها با چند کلیک به فیلدها متصل کنید و انعطاف‌پذیری و کارایی را در هنگام ساخت افزایش دهید. مشتریان شما، شما را دوست خواهند داشت—انگار که قبلاً دوست نداشتند!</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img decoding=\"async\" src=\"https://i0.wp.com/s.w.org/images/core/6.7/feature-block-bindings-2.webp?ssl=1\" alt=\"\" style=\"aspect-ratio:4/3;object-fit:cover;width:474px\" /></figure>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>معمار درون فونت‌شناس خود را در آغوش بگیرید<br>بخش جدید سبک، امکانات جدید</strong></h4>\n\n\n\n<p>با افزودن جدید به رابط Styles، اندازه‌های پیش‌فرض فونت را ایجاد، ویرایش، حذف و اعمال کنید. می‌توانید تنظیمات پیش‌فرض پوسته را نادیده بگیرید یا اندازه فونت سفارشی خود را ایجاد کنید که شامل تایپوگرافی سیال برای مقیاس‌بندی پاسخگو باشد. به جزئیات بپردازید!</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img decoding=\"async\" src=\"https://i0.wp.com/s.w.org/images/core/6.7/feature-font-presets-2.png?ssl=1\" alt=\"\" style=\"aspect-ratio:4/3;object-fit:cover;width:474px\" /></figure>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>عملکرد</strong></h4>\n\n\n\n<p>وردپرس ۶.۷ به‌روزرسانی‌های مهمی در زمینه عملکرد ارائه می‌دهد، از جمله بارگذاری سریع‌تر الگوها، پیش‌نمایش‌های بهینه‌شده در مؤلفه‌های نمای داده، بهبود پشتیبانی از PHP 8+ و حذف کدهای منسوخ، اندازه‌های خودکار برای تصاویر بارگذاری شده به‌صورت تنبل و پردازش کارآمدتر برچسب‌ها در API HTML.</p>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>دسترس‌پذیری</strong></h4>\n\n\n\n<p>بیش از ۶۵ اصلاح و بهبود در زمینه دسترس‌پذیری بر جنبه‌های بنیادی تجربه وردپرس تمرکز دارد، از بهبود مؤلفه‌های رابط کاربری و ناوبری با کیبورد در ویرایشگر، تا عنوان دسترس‌پذیر در صفحه‌های ورود به وردپرس و برچسب‌گذاری واضح‌تر در سرتاسر.</p>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-heic-1.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>پشتیبانی از تصاویر HEIC</strong><br>پشتیبانی از تصاویر HEIC مدیریت رسانه را بهبود می‌بخشد و امکان استفاده از تصاویر با کیفیت بالا و فضای بهینه را در تمام بلوک‌ها فراهم می‌کند</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-streamlined-query-loops.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>بلوک Query Loop بهینه‌شده</strong><br>بهبودهای انجام‌شده در بلوک Query Loop قابلیت استفاده را افزایش می‌دهد و با خودکارسازی تنظیمات پیش‌فرض و تجمیع گزینه‌های کلیدی، سفارشی‌سازی را آسان‌تر می‌کند</figcaption></figure>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-preview-dropdown.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>گسترش منوی کشویی پیش‌نمایش</strong><br>بهبودهای انجام‌شده در گزینه‌های پیش‌نمایش به افزونه‌ها و پوسته‌ها این امکان را می‌دهد که موارد سفارشی را به منوی کشویی اضافه کنند و نحوه پیش‌نمایش محتوا را غنی‌تر کنند</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-site-background.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>سفارشی‌سازی پس‌زمینه سایت</strong><br>ابزارهای بهبود یافته پس‌زمینه، سفارشی‌سازی بلوک‌ها را افزایش می‌دهند و امکان تنظیمات جهانی را فراهم می‌کنند، که به حفظ انسجام در سرتاسر سایت کمک کرده و تلاش‌های طراحی را ساده‌تر می‌سازد.</figcaption></figure>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-template-registration.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>API ثبت الگو</strong><br>این API جدید ثبت الگوهای سفارشی را برای افزونه‌ها ساده‌تر می‌کند و امکان نادیده‌گیری پوسته و ایجاد الگوهای سفارشی برای دسته‌بندی‌ها را برای انعطاف‌پذیری بیشتر فراهم می‌آورد</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-refined-pages.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>نمای بهبود یافته صفحات در ویرایشگر سایت</strong><br>ویرایش را با نمای صفحات بهبود یافته که گزینه‌های فیلتر سفارشی را ارائه می‌دهند، ساده‌تر کنید. با تغییر نمایش فیلترها، به نمای‌های بهینه‌شده‌ای مانند منتشر شده و پیش‌نویس‌ها بدون شلوغی دسترسی پیدا کنید.</figcaption></figure>\n</div>\n</div>\n\n\n\n<p>برای مشاهدهٔ جامع تمام ویژگی‌ها و بهبودهای جدید در وردپرس ۶.۷، آن را به‌روز و امتحان کنید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1103\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۶\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"https://fa.wordpress.org/2024/07/16/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%86%da%af%d8%a7%d8%b1%d8%b4-%db%b6-%db%b6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Jul 2024 08:08:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fa.wordpress.org/?p=1080\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:646:\"وردپرس فارسی نگارش ۶.۶ منتشر شد، موارد کلیدی این نگارش عبارتند از: پالت‌های رنگ و مجموعه‌های فونت انتخاب‌های طراحی بیشتری را به پوسته‌های بلوکی اضافه کنید.سازندگان پوستهٔ بلوکی می‌توانند مجموعه‌های نامحدود و منحصر بفرد رنگ یا فونت ایجاد کنند تا انتخاب‌های طراحی خاص‌تری را در همان پوسته ارائه دهند. این مجموعه‌ها امکانات طراحی محدودشده‌تری را [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5177:\"\n<p>وردپرس فارسی نگارش ۶.۶ منتشر شد، موارد کلیدی این نگارش عبارتند از:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>پالت‌های رنگ و مجموعه‌های فونت</li>\n\n\n\n<li>پیش‌نمایش سریع برای برگه‌ها</li>\n\n\n\n<li>بازگرداندن به‌روزرسانی‌های خودکار افزونه</li>\n\n\n\n<li>باز‌نویسی‌ها</li>\n</ul>\n\n\n\n<p></p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2024/10/6-6-highlight-grid.png\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"567\" src=\"https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-1024x567.png\" alt=\"\" class=\"wp-image-1081\" srcset=\"https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-1024x567.png 1024w, https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-300x166.png 300w, https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-768x426.png 768w, https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-1536x851.png 1536w, https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-2048x1135.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">پالت‌های رنگ و مجموعه‌های فونت</h2>\n\n\n\n<p><strong>انتخاب‌های طراحی بیشتری را به پوسته‌های بلوکی اضافه کنید.</strong><br>سازندگان پوستهٔ بلوکی می‌توانند مجموعه‌های نامحدود و منحصر بفرد رنگ یا فونت ایجاد کنند تا انتخاب‌های طراحی خاص‌تری را در همان پوسته ارائه دهند. این مجموعه‌ها امکانات طراحی محدودشده‌تری را ارائه می‌کنند و امکان سفارشی‌سازی را بدون تغییر استایل گسترده‌تر سایت، فراتر از تنظیمات رنگ یا تایپوگرافی فراهم می‌کنند.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">پیش‌نمایش سریع برای برگه‌ها</h2>\n\n\n\n<p><strong>گردش کاری خود را با چیدمان جدیدی که برای برگه‌ها ایجاد شده‌است، ساده کنید.&nbsp;</strong><br>تمام برگه‌هایتان و پیش‌نمایش هر برگهٔ انتخابی را قبل از ویرایش از طریق یک چیدمان جدید پهلو به پهلو در ویرایشگر سایت مشاهده کنید.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">بازگرداندن به‌روزرسانی‌های خودکار افزونه</h2>\n\n\n\n<p><strong>افزونه‌های خود را با خیال راحت بصورت خودکار به‌روزرسانی کنید.</strong><br>از سهولت به‌روزرسانی خودکار افزونه‌ها با ایمنی بازگرداندن در صورت بروز مشکل، لذت ببرید و امنیت سایتتان را بهبود ببخشید و در عین حال مدت از کار افتادن احتمالی سایت را به حداقل برسانید.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">باز‌نویسی‌ها</h2>\n\n\n\n<p><strong>افزودن قابلیت سفارشی‌سازی محتوا در الگوهای همگام‌سازی شده.</strong><br>اجازه می‌دهد که قطعات خاصی از محتوا در هر نمونه از یک الگوی همگام‌سازی‌شده را سفارشی و در عین حال سبکی ثابت را برای همه نمونه‌ها حفظ کنید و به‌روزرسانی‌های آینده را ساده‌تر می‌کند. در حال حاضر، می‌توانید برای بلوک‌های عنوان، پاراگراف، دکمه و تصویر، از باز‌نویسی‌ها استفاده کنید.</p>\n\n\n\n<p></p>\n\n\n\n<p>ه‌ترین نگارش <a href=\"https://make.wordpress.org/core/2024/06/25/wordpress-6-6-field-guide/\">راهنمای زمینهٔ وردپرس</a> را بررسی نمایید. سرشار از یادداشت‌های دقیق توسعه‌دهنده است که به شما کمک می‌کند با وردپرس بسازید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p>برای اطلاعات بیشتر دربارهٔ پیشرفت‌ها و مشکلات حل شده، اطلاعات نصب، یادداشت‌های توسعه‌دهنده و منابع، همکاری‌کنندگان در انتشار، و فهرست تغییرات پرونده در این نسخه <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-6/\">یادداشت‌های انتشار وردپرس ۶.۲ را بخوانید</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1080\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۵\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"https://fa.wordpress.org/2024/04/02/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%86%da%af%d8%a7%d8%b1%d8%b4-%db%b6-%db%b5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Apr 2024 07:56:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fa.wordpress.org/?p=1076\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:536:\"وردپرس فارسی نگارش ۶.۵ منتشر شد، موارد کلیدی این نگارش عبارتند از: با کتابخانه فونت آشنا شوید بدون کدنویسی یا مراحل اضافی، کنترل یک قطعه ضروری از طراحی سایت خود – تایپوگرافی – را حفظ کنید. فونت‌های محلی و گوگل را به راحتی برای هر تم بلوکی نصب، حذف و فعال کنید. گنجاندن مجموعه‌های تایپوگرافی [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7323:\"\n<p>وردپرس فارسی نگارش ۶.۵ منتشر شد، موارد کلیدی این نگارش عبارتند از:<br></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>کتابخانه فونت جدید</li>\n\n\n\n<li>پس زمینه و ابزار سایه پیشرفته</li>\n\n\n\n<li>جزئیات بیشتری در اصلاحات استایل</li>\n\n\n\n<li>کنترل بهتر لینک</li>\n\n\n\n<li>نماهای داده جدید</li>\n\n\n\n<li>به‌روزرسانی عملکرد</li>\n\n\n\n<li>بهبود دسترسی</li>\n\n\n\n<li></li>\n</ul>\n\n\n\n<p></p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2024/10/6-5-highlight-grid.png\"><img decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-1024x576.png\" alt=\"\" class=\"wp-image-1077\" srcset=\"https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-1024x576.png 1024w, https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-300x169.png 300w, https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-768x432.png 768w, https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-1536x864.png 1536w, https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-2048x1153.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">با کتابخانه فونت آشنا شوید</h2>\n\n\n\n<p>بدون کدنویسی یا مراحل اضافی، کنترل یک قطعه ضروری از طراحی سایت خود – تایپوگرافی – را حفظ کنید.</p>\n\n\n\n<p>فونت‌های محلی و گوگل را به راحتی برای هر تم بلوکی نصب، حذف و فعال کنید. گنجاندن مجموعه‌های تایپوگرافی سفارشی به سازندگان سایت و ناشران، حق انتخاب بیشتری می‌دهد.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">پس زمینه و ابزار سایه پیشرفته</h2>\n\n\n\n<p>با استفاده از ابزارهای طراحی به‌روز، راه‌های بیشتری برای افزودن جذابیت بصری به چیدمان‌ها بیابید. تنظیمات اندازه، تکرار و نقطه کانونی را روی تصاویر پس زمینه خود کنترل کنید تا آن‌ها را با هم ترکیب و یا برجسته کنید. با افزودن پشتیبانی از سایه‌ها به بلوک‌های بیشتر، در طرح‌هایتان عمق بصری ایجاد و یا کمی هویت به آن‌ها تزریق کنید.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">جزئیات بیشتری را از اصلاحات استایل خود دریافت کنید</h2>\n\n\n\n<p>پروژه‌های خلاقانه را با داشتن تصویر کامل‌تری از آنچه انجام شده است — و آنچه می‌توانید به آن برگردید، انجام بدهید. جزئیاتی مانند نشان‌های زمانی، خلاصه‌ی سریع و فهرست صفحه‌بندی‌شده‌ی همه ویرایش‌ها را دریافت کنید. برای مشاهده تغییرات، خارج از آنچه روی آن کار می‌کنید، به ویرایش‌های موجود در کتابچه سبک نگاه کنید. اکنون رونوشت‌ها برای الگوها و اجزای قالب نیز در دسترس است.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">کنترل بهتر لینک</h2>\n\n\n\n<p>پیوندها را به راحتی با تجربه پیوندسازی قابل درک‌تر ایجاد و مدیریت کنید، با یک رابط کاربری ساده و میانبرهایی برای کپی کردن پیوندها.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">نماهای داده جدید را کاوش کنید</h2>\n\n\n\n<p>هر بخش از سایت شما با کتابخانه‌ای از اطلاعات و داده‌ها همراه است — اکنون، می‌توانید آنچه را که نیاز دارید به سرعت پیدا کنید و آن را هر طور که دوست دارید سازماندهی کنید. نماهای داده برای صفحات، قالب‌ها، الگوها و بخش‌های قالب به شما امکان می‌دهد داده‌ها را در یک نمای جدول یا شبکه‌ای مشاهده کنید، با گزینه‌هایی برای تغییر زمینه‌ها و ایجاد تغییرات دسته‌جمعی.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">به‌روزرسانی عملکرد</h2>\n\n\n\n<p>این نگارش شامل بیش از ۱۱۰ به روز‌رسانی عملکرد، با افزایش چشمگیر سرعت و کارایی در ویرایشگر پست و ویرایشگر سایت است. بارگیری بیش از دو برابر سریعتر از نگارش ۶٫۴ است، با سرعت پردازش ورودی تا پنج برابر سریعتر از نگارش قبلی. زمان بارگذاری سایت‌های ترجمه شده تا ۲۵٪ در این نگارش بهبود یافته‌ است.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">بهبود دسترسی</h2>\n\n\n\n<p>این نگارش شامل بیش از ۶۵ بهبود دسترسی‌پذیری در سراسر پلتفرم است که آن را بیش از همیشه در دسترس قرار می‌دهد. این شامل یک اصلاح مهم است که دسترسی به منوهای فرعی مدیریت را برای کاربران صفحه‌خوان و دیگرانی که با صفحه‌کلید پیمایش می‌کنند، رفع انسداد می‌کند. این نگارش همچنین اصلاحاتی را برای کنتراست رنگ در حالت‌های تمرکز مدیر، موقعیت‌یابی عناصر و فوکوس مکان‌نما و موارد بسیار دیگر، اضافه می‌کند که به بهبود تجربه وردپرس برای همه کمک می‌کند.</p>\n\n\n\n<p></p>\n\n\n\n<p>تازه‌ترین نگارش <a href=\"https://make.wordpress.org/core/2024/03/15/wordpress-6-5-field-guide/\">راهنمای زمینهٔ وردپرس</a> را بررسی نمایید. سرشار از یادداشت‌های دقیق توسعه‌دهنده است که به شما کمک می‌کند با وردپرس بسازید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p>برای اطلاعات بیشتر دربارهٔ پیشرفت‌ها و مشکلات حل شده، اطلاعات نصب، یادداشت‌های توسعه‌دهنده و منابع، همکاری‌کنندگان در انتشار، و فهرست تغییرات پرونده در این نسخه <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-5/\">یادداشت‌های انتشار وردپرس ۶.۲ را بخوانید</a>.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1076\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۴\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"https://fa.wordpress.org/2023/11/07/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-6-4-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Nov 2023 11:20:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=905\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:600:\"این نسخه جدید از وردپرس، یک قالب پیش‌فرض جدید و چندین ارتقاء جهت تقویت هر مرحله از سفر خلاقانه‌تان را معرفی می‌کند. محتوای خود را به‌صورت بی‌درنگ با بهبودهای بیشتر در نوشتن ایجاد کنید. با ابزارهای بهبود یافته، راه‌های بیشتری برای زنده‌سازی دیدگاه‌های خود بیابید و ویرایش سایت را با ابزارهای پیشرفته ساده‌تر کنید. انعطاف [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Farhad Sakhaei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1955:\"\n<p>این نسخه جدید از وردپرس، یک قالب پیش‌فرض جدید و چندین ارتقاء جهت تقویت هر مرحله از سفر خلاقانه‌تان را معرفی می‌کند. محتوای خود را به‌صورت بی‌درنگ با بهبودهای بیشتر در نوشتن ایجاد کنید. با ابزارهای بهبود یافته، راه‌های بیشتری برای زنده‌سازی دیدگاه‌های خود بیابید و ویرایش سایت را با ابزارهای پیشرفته ساده‌تر کنید. انعطاف بی‌نظیر ساختار با بلوک‌ها را کشف کنید و به ایده‌های خود اجازه بدهید که پرواز کنند.</p>\n\n\n\n<p>بسیاری از ویژگی‌ها و بهبودهای وردپرس 6.4 در دسته &#8220;کوچک اما قدرتمند&#8221; قرار دارند. همراه با زیبایی چند منظوره قالب Twenty Twenty-Four (دو هزار و بیست و چهار)، این به‌روزرسانی‌ها به خالقان محتوا و توسعه‌دهندگان سایت کمک می‌کنند تا زمان و تلاش خود را صرفه‌جویی کنند و در عین حال تجربه وردپرس با ارزش و کم دردسر را که جهان انتظار دارده است، ارائه دهند.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full\"><a href=\"https://fa.wordpress.org/files/2024/02/tt41.png\"><img decoding=\"async\" width=\"1024\" height=\"666\" src=\"https://fa.wordpress.org/files/2024/02/tt41.png\" alt=\"وردپرس 6.4\" class=\"wp-image-906\" srcset=\"https://fa.wordpress.org/files/2024/02/tt41.png 1024w, https://fa.wordpress.org/files/2024/02/tt41-300x195.png 300w, https://fa.wordpress.org/files/2024/02/tt41-768x500.png 768w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a><figcaption class=\"wp-element-caption\">وردپرس 6.4</figcaption></figure>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"905\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۳\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://fa.wordpress.org/2023/08/20/wordpress-6-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 20 Aug 2023 20:15:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=858\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:513:\"با وردپرس 6.3 شما می‌توانید وب سایت‌های زیبا و جذاب‌تر از همیشه ایجاد کنید. چه بخواهید یک سایت کامل بدون کدنویسی بسازید یا یک توسعه دهنده باشید که به دنبال سفارشی کردن تمام جزئیات است، وردپرس 6.3 چیزی برای جلب توجه شما دارد. با باز کردن بسته بندی و کاوش در این آخرین نسخه، عملکردها [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2248:\"\n<p>با وردپرس 6.3 شما می‌توانید وب سایت‌های زیبا و جذاب‌تر از همیشه ایجاد کنید. چه بخواهید یک سایت کامل بدون کدنویسی بسازید یا یک توسعه دهنده باشید که به دنبال سفارشی کردن تمام جزئیات است، وردپرس 6.3 چیزی برای جلب توجه شما دارد. با باز کردن بسته بندی و کاوش در این آخرین نسخه، عملکردها و پیمایش به روز شده ای را خواهید دید که به شما کمک می کند با تلاش کمتر کار کنید و ایجاد کنید، ابزارهایی طراحی کنید که کنترل بیشتری بر طرح بندی به شما می‌دهد، و عملکردهای افزوده شده‌ای را که تجربه ساخت سایت را غنی می کند. وردپرس 6.3 فصل مهمی را در تکامل وردپرس به عنوان ابزاری برای بیان مشخص می‌کند. این نقطه اوج سال‌ها کار صدها مشارکت‌کننده است که تجربه ویرایش قوی‌تر و منسجم‌تری را برای ساخت وب‌سایت‌هایی با بلوک به ارمغان می‌آورد. این به تلاش برای قابل دسترس ساختن انتشار وب برای همه ادامه می دهد &#8211; بنابراین فقط یک شروع جدید است!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/08/site-editor-2.png?resize=1024%2C666&amp;ssl=1\" alt=\"\" /></figure>\n\n\n\n<p>وردپرس جدید را از لینک زیر دریافت نمایید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"858\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۲\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:162:\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Apr 2023 07:13:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=760\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:580:\"وردپرس ۶.۲ شامل بیش از ۲۹۲ بهبود و ۳۹۴ رفع مشکل است. این برگه آخرین امکانات برجسته را از زمان انتشار وردپرس ۶.۱ در نوامبر ۲۰۲۲ نشان می‌دهد. تازه‌ترین نگارش راهنمای زمینهٔ وردپرس را بررسی نمایید. سرشار از یادداشت‌های دقیق توسعه‌دهنده است که به شما کمک می‌کند با وردپرس بسازید. برای اطلاعات بیشتر دربارهٔ پیشرفت‌ها [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10296:\"\n<p>وردپرس ۶.۲ شامل بیش از ۲۹۲ بهبود و ۳۹۴ رفع مشکل است. این برگه آخرین امکانات برجسته را از زمان انتشار وردپرس ۶.۱ در نوامبر ۲۰۲۲ نشان می‌دهد.</p>\n\n\n\n<div class=\"wp-block-jetpack-tiled-gallery alignfull is-style-rectangular\"><div class=\"tiled-gallery__gallery\"><div class=\"tiled-gallery__row\"><div class=\"tiled-gallery__col\" style=\"flex-basis:66.70764%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-site-editor.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-site-editor.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-site-editor.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"763\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-site-editor/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-site-editor.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-site-editor.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:33.29236%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-navigation.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-navigation.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-navigation.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"764\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-navigation/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-navigation.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-navigation.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-block-inserter.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-block-inserter.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-block-inserter.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"765\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-block-inserter/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-block-inserter.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-block-inserter.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div></div><div class=\"tiled-gallery__row\"><div class=\"tiled-gallery__col\" style=\"flex-basis:33.33333%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-split-controls-fixed.png\"><img decoding=\"async\" srcset=\"https://i1.wp.com/fa.wordpress.org/files/2023/04/about-split-controls-fixed.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i1.wp.com/fa.wordpress.org/files/2023/04/about-split-controls-fixed.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"766\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-split-controls-fixed/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-split-controls-fixed.png\" data-width=\"872\" src=\"https://i1.wp.com/fa.wordpress.org/files/2023/04/about-split-controls-fixed.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:33.33333%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-openverse.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-openverse.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-openverse.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"767\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-openverse/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-openverse.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-openverse.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:33.33333%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-headers.png\"><img decoding=\"async\" srcset=\"https://i1.wp.com/fa.wordpress.org/files/2023/04/about-headers.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i1.wp.com/fa.wordpress.org/files/2023/04/about-headers.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"768\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-headers/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-headers.png\" data-width=\"872\" src=\"https://i1.wp.com/fa.wordpress.org/files/2023/04/about-headers.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div></div><div class=\"tiled-gallery__row\"><div class=\"tiled-gallery__col\" style=\"flex-basis:25.00000%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-out-of-beta.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-out-of-beta.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-out-of-beta.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"769\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-out-of-beta/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-out-of-beta.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-out-of-beta.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:25.00000%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-distraction-free.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-distraction-free.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-distraction-free.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"770\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-distraction-free/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-distraction-free.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-distraction-free.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:25.00000%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-custom-css.png\"><img decoding=\"async\" srcset=\"https://i2.wp.com/fa.wordpress.org/files/2023/04/about-custom-css.png?strip=info&#038;w=560&#038;ssl=1 560w\" alt=\"\" data-height=\"560\" data-id=\"771\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-custom-css/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-custom-css.png\" data-width=\"560\" src=\"https://i2.wp.com/fa.wordpress.org/files/2023/04/about-custom-css.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:25.00000%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-copy-paste.png\"><img decoding=\"async\" srcset=\"https://i2.wp.com/fa.wordpress.org/files/2023/04/about-copy-paste.png?strip=info&#038;w=560&#038;ssl=1 560w\" alt=\"\" data-height=\"560\" data-id=\"772\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-copy-paste/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-copy-paste.png\" data-width=\"560\" src=\"https://i2.wp.com/fa.wordpress.org/files/2023/04/about-copy-paste.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div></div></div></div>\n\n\n\n<p></p>\n\n\n\n<p>تازه‌ترین نگارش <a href=\"https://make.wordpress.org/core/2023/03/09/wordpress-6-2-field-guide/\">راهنمای زمینهٔ وردپرس</a> را بررسی نمایید. سرشار از یادداشت‌های دقیق توسعه‌دهنده است که به شما کمک می‌کند با وردپرس بسازید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p>برای اطلاعات بیشتر دربارهٔ پیشرفت‌ها و مشکلات حل شده، اطلاعات نصب، یادداشت‌های توسعه‌دهنده و منابع، همکاری‌کنندگان در انتشار، و فهرست تغییرات پرونده در این نسخه <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-2/\">یادداشت‌های انتشار وردپرس ۶.۲ را بخوانید</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"760\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"وردپرس فارسی نگارش ۵٫۸\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:167:\"https://fa.wordpress.org/2020/12/09/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b5%d9%ab%db%b8-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Dec 2020 14:35:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=662\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:611:\"&#8212; سه نیروی اساسی مدیریت ابزارک‌ها با بلوک‌ها بعد از ماه‌ها کار سخت، بلوک‌های پر قدرت ویرایشگر ابزارک‌های بلوکی و سفارشی‌ساز آمده‌اند. هم‌اکنون شما می‌توانید بلوک‌ها را از هر دو طریق ناحیه‌های ابزارک سایتتان و پیش‌نمایش زنده سفارشی‌ساز اضافه کنید. این امکانات جدیدی را برای ایجاد محتوا ایجاد می کند: از طرح بندی کوچک بدون [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:16226:\"\n<p class=\"has-text-align-center has-white-color has-text-color\">&#8212;</p>\n\n\n\n<h2 class=\"has-text-align-center has-large-font-size wp-block-heading\"> سه نیروی اساسی </h2>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\" style=\"grid-template-columns:60% auto\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"768\" src=\"https://fa.wordpress.org/files/2021/07/about-widgets-blocks-1024x768.png\" alt=\"\" class=\"wp-image-698 size-full\" srcset=\"https://fa.wordpress.org/files/2021/07/about-widgets-blocks-1024x768.png 1024w, https://fa.wordpress.org/files/2021/07/about-widgets-blocks-300x225.png 300w, https://fa.wordpress.org/files/2021/07/about-widgets-blocks-768x576.png 768w, https://fa.wordpress.org/files/2021/07/about-widgets-blocks-440x330.png 440w, https://fa.wordpress.org/files/2021/07/about-widgets-blocks.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">مدیریت ابزارک‌ها با بلوک‌ها</h3>\n\n\n\n<p>بعد از ماه‌ها کار سخت، بلوک‌های پر قدرت ویرایشگر ابزارک‌های بلوکی و سفارشی‌ساز آمده‌اند. هم‌اکنون شما می‌توانید بلوک‌ها را از هر دو طریق ناحیه‌های ابزارک سایتتان و پیش‌نمایش زنده سفارشی‌ساز اضافه کنید. این امکانات جدیدی را برای ایجاد محتوا ایجاد می کند: از طرح بندی کوچک بدون کد گرفته تا کتابخانه گسترده بلوک‌های اصلی و شخص ثالث. برای توسعه‌دهندگانمان، شما می‌توانید جزئیات بیشتر را در <a href=\"https://make.wordpress.org/core/2021/06/29/block-based-widgets-editor-in-wordpress-5-8/\">یادداشت توسعه ابزارک‌ها</a> پیدا کنید.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile\" style=\"grid-template-columns:auto 60%\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"811\" src=\"https://fa.wordpress.org/files/2021/07/about-query-loop-1024x811.png\" alt=\"\" class=\"wp-image-697 size-full\" srcset=\"https://fa.wordpress.org/files/2021/07/about-query-loop-1024x811.png 1024w, https://fa.wordpress.org/files/2021/07/about-query-loop-300x238.png 300w, https://fa.wordpress.org/files/2021/07/about-query-loop-768x608.png 768w, https://fa.wordpress.org/files/2021/07/about-query-loop.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">نمایش نوشته‌ها با بلوک‌ها و الگوهای جدید</h3>\n\n\n\n<p>بلوک چرخه درخواست امکان نمایش نوشته‌ها را براساس پارامترهای تعیین‌شده فراهم می‌کند؛ نظیر یک چرخه PHP بدون کدنویسی. به آسانی نوشته‌های یک دسته خاص را نمایش دهید یا کارهایی نظیر ایجاد یک برگه نمونه کار یا یک برگه کامل از دستورات آشپزی مورد علاقه شما انجام دهید. به بلوک آخرین نوشته‌ها به عنوان یک بلوک بسیار پیچیده و قوی فکر کنید! به علاوه، پیشنهادات الگو باعث می‌شود تا ایجاد لیستی از نوشته‌ها با طراحی مورد نظرتان آسان‌تر از گذشته قابل انجام باشد.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\" style=\"grid-template-columns:60% auto\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"666\" src=\"https://fa.wordpress.org/files/2020/12/about-template-1024x666.png\" alt=\"\" class=\"wp-image-699 size-full\" srcset=\"https://fa.wordpress.org/files/2020/12/about-template-1024x666.png 1024w, https://fa.wordpress.org/files/2020/12/about-template-300x195.png 300w, https://fa.wordpress.org/files/2020/12/about-template-768x499.png 768w, https://fa.wordpress.org/files/2020/12/about-template.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">ویرایش قالب اطراف نوشته‌ها</h3>\n\n\n\n<p>شما می‌توانید از ویرایشگر بلوک آشنا برای ویرایش قالب‌هایی که محتوای شما را در اختیار دارند استفاده کنید—به سادگی یک بلوک پوسته یا یک پوسته را که این ویژگی را انتخاب کرده است فعال کنید. از ویرایش نوشته‌ها به ویرایش برگه‌های خود بروید و دوباره بازگردید، همه اینها در حالی‌است که از ویرایشگر بلوک آشنا استفاده می‌کنید. بیش از ۲۰ بلوک جدید سارگاز با پوسته‌ها در دسترس است. در مورد این قابلیت و اینکه چطور می‌توان آن را تجربه کرد در یادداشت‌های انتشار بخوانید.</p>\n</div></div>\n\n\n\n<p> </p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"has-text-align-center has-large-font-size wp-block-heading\">سه همیار گردش کار</h2>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile\" style=\"grid-template-columns:auto 60%\"><figure class=\"wp-block-media-text__media\"><a href=\"https://fa.wordpress.org/files/2020/12/about-list-view.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"803\" src=\"https://fa.wordpress.org/files/2020/12/about-list-view-1024x803.png\" alt=\"\" class=\"wp-image-700 size-full\" srcset=\"https://fa.wordpress.org/files/2020/12/about-list-view-1024x803.png 1024w, https://fa.wordpress.org/files/2020/12/about-list-view-300x235.png 300w, https://fa.wordpress.org/files/2020/12/about-list-view-768x602.png 768w, https://fa.wordpress.org/files/2020/12/about-list-view.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">نمای کلی ساختار برگه</h3>\n\n\n\n<p>گاهی شما نیاز به یک برگه فرود ساده نیاز داری ، اما گاهی نیاز به یک چیز قوی‌تر دارید. با اضافه شدن بلوک‌ها‌ی بیشتر، ادغام الوگها، و آسان شده ایجاد محتوا، راه‌حل‌های جدیدی لازم است تا بتوان محتوای پیچیده را به راحتی جستجو کرد. مشاهده فهرستی بهترین راه برای پرش بین لایه‌های محتوا و بلوک‌های تو در تو است. از آنجا که مشاهده فهرستی به شما یک نمای کلی از تمام بلوک‌های محتوای شما می‌دهد، اکنون می‌توانید به سرعت و دقیق به بلوک مورد نیاز خود بروید. آماده تمرکز کامل بر روی محتوای خود هستید؟ این را متناسب با گردش کار خود روشن یا خاموش کنید.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\" style=\"grid-template-columns:60% auto\"><figure class=\"wp-block-media-text__media\"><a href=\"https://fa.wordpress.org/files/2020/12/about-pattern-suggestions.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"555\" src=\"https://fa.wordpress.org/files/2020/12/about-pattern-suggestions-1024x555.png\" alt=\"\" class=\"wp-image-701 size-full\" srcset=\"https://fa.wordpress.org/files/2020/12/about-pattern-suggestions-1024x555.png 1024w, https://fa.wordpress.org/files/2020/12/about-pattern-suggestions-300x163.png 300w, https://fa.wordpress.org/files/2020/12/about-pattern-suggestions-768x416.png 768w, https://fa.wordpress.org/files/2020/12/about-pattern-suggestions.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">الگوهای پیشنهادی برای بلوک‌ها</h3>\n\n\n\n<p>شروع در این نسخه ابزار دگرگونی الگو که الگوهای بلوک را بر اساس بلوکی که استفاده می‌کنید پیشنهاد می‌دهد. هم‌اکنون، می‌توانید این را در بلوک کوئری و بلوک آیکون شبکه‌های اجتماعی استفاده نمایید. با اضافه شدن الگوهای بیشتر، شما می‌توانید از نحوه سبک دادن به سایت خود بدون اینکه هرگز از ویرایشگر خارج شوید الهام بگیرید!</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile\" style=\"grid-template-columns:auto 60%\"><figure class=\"wp-block-media-text__media\"><a href=\"https://fa.wordpress.org/files/2020/12/about-duotone.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"837\" src=\"https://fa.wordpress.org/files/2020/12/about-duotone-1024x837.png\" alt=\"\" class=\"wp-image-702 size-full\" srcset=\"https://fa.wordpress.org/files/2020/12/about-duotone-1024x837.png 1024w, https://fa.wordpress.org/files/2020/12/about-duotone-300x245.png 300w, https://fa.wordpress.org/files/2020/12/about-duotone-768x628.png 768w, https://fa.wordpress.org/files/2020/12/about-duotone.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">سبک‌دهی و رنگ‌آمیزی تصاویر</h3>\n\n\n\n<p>با جلوه دوتون عکس‌ها و بلوک‌های پوشش را رنگی کنید! دوتون می‌تواند رنگ‌های زیادی را به طرح و سبک عکس‌های شما (یا ویدئوهایی در بلوک پوشش) برای ادغام خوب در پوسته‌های شما اضافه کند. شما می‌توانید جلوه دوتون را به عنوان یک فیلتر سیاه و سفید تصور کنید، اما به جای اینکه سایه‌ها سیاه و سفید و هایلایت باشند، رنگ‌های خود را برای سایه‌ها و هایلایت‌ها انتخاب می‌کنید. چیزهای بیشتری برای آموختن کارکرد آن در مستندات وجود دارد.</p>\n</div></div>\n\n\n\n<p></p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"has-text-align-center has-large-font-size wp-block-heading\">برای توسعه‌دهندگان که بررسی کنند</h2>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://fa.wordpress.org/files/2020/12/about-theme-json.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1020\" height=\"610\" src=\"https://fa.wordpress.org/files/2020/12/about-theme-json.png\" alt=\"\" class=\"wp-image-703\" srcset=\"https://fa.wordpress.org/files/2020/12/about-theme-json.png 1020w, https://fa.wordpress.org/files/2020/12/about-theme-json-300x179.png 300w, https://fa.wordpress.org/files/2020/12/about-theme-json-768x459.png 768w\" sizes=\"auto, (max-width: 1020px) 100vw, 1020px\" /></a></figure>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:25%\"></div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:50%\">\n<h3 class=\"wp-block-heading\">Theme.json</h3>\n\n\n\n<p>معرفی APIهای تنظیمات عمومی و سبک‌های عمومی: تنظیمات ویرایشگر، ابزارهای شخصی‌سازی در دسترس، و سبک‌های بلوک‌ها را با استفاده از پرونده theme.json در پوسته فعال کنترل کنید. این پرونده پیکربندی قابلیت‌ها و مجموعه سبک‌های پیش‌فرض برای سایت و بلوک‌ها را فعال یا غیرفعال می‌کند. اگر شما پوسته می‌سازید، شما می‌توانید این ویژگی جدید مفید را آزمایش کنید. برای اینکه بدانید هم‌اکنون چه چیزی در دسترس است و چگونه کار می‌کند، <a href=\"https://make.wordpress.org/core/2021/06/25/introducing-theme-json-in-wordpress-5-8/\">این توضیحات فنی را بخوانید</a>.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:25%\"></div>\n</div>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">کنار گذاشتن پشتیبانی از اینترنت اکسپلورر ۱۱</h3>\n\n\n\n<p>در این انتشار، پشتیبانی از اینترنت اکسپلورر ۱۱ کنار گذاشته شده است. این یعنی شما ممکن است نیاز به مدیریت مشکلاتی روی وبگاه‌تان داشته باشید که در آینده رفع نخواهند شد. اگر در حال حاضر از اینترنت اکسپلورر ۱۱ استفاده می‌کنید، اکیدا پیشنهاد می‌کنیم که <a href=\"https://browsehappy.com/\">به مرورگر مدرن‌تری نقل مکان کنید</a>.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">افزودن پشتیبانی از WebP</h3>\n\n\n\n<p>WebP یک قالب ذخیره تصویر مدرن است که امکان فشرده‌سازی بی‌اتلاف و یا بااتلاف بهبودیافته را برای تصاویر در فضای وب فراهم می‌کند. تصاویر WebP به طور میانگین حدود ۳۰٪ کم‌حجم‌تر از معادل‌های‌شان در قالب‌های JPEG و PNG هستند که این یعنی وب‌گاه‌ها سریع‌تر شده و پهنای باند کم‌تری مصرف می‌کنند.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">افزودن پشتیبانی بلوک اضافی</h3>\n\n\n\n<p>به عنوان قابلیتی بسط داده شده بر روی پشتیبانی بلوک پیاده‌سازی شده در وردپرس <a href=\"https://make.wordpress.org/core/2020/11/18/block-supports-in-wordpress-5-6/\">۵٫۶</a> و <a href=\"https://make.wordpress.org/core/2021/02/24/changes-to-block-editor-components-and-blocks/\">۵٬۷</a>، وردپرس ۵٫۸ چندین پرچم و گزینه پشتیبانی بلوک جدید را برای سفارشی‌سازی بلوک‌های ثبت شده معرفی می‌کند. اطلاعات بیشتر در <a href=\"https://make.wordpress.org/core/2021/06/25/block-supports-api-updates-for-wordpress-5-8/\">یادداشت توسعه پشتیبانی بلوک</a> در دسترس است.</p>\n</div>\n</div>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\">بخش راهنما را برای توضیحات بیشتر بررسی نمایید.</h3>\n\n\n\n<p>آخرین نگارش از راهنمای میدانی وردپرس را بررسی کنید. این یادداشت‌های توسعه‌دهنده برای هر تغییری که شاید بخواهید از آنها آگاه باشید را برجسته می‌کند. <a href=\"https://make.wordpress.org/core/2021/07/03/wordpress-5-8-field-guide/\">راهنمای میدانی وردپرس .۵.۸</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"662\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"وردپرس فارسی نگارش ۵٫۵\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://fa.wordpress.org/2020/08/11/wp-persian-55/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2020 20:42:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=641\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:570:\"در وردپرس ۵٫۵، سایت شما در سه بخش اصلی قدرت جدیدی گرفته است: سرعت، جستجو و امنیت. سرعت عکس‌ها لِیزی-لود شده‌اند، و سرعت بارگذاری نوشته‌ها و برگه‌ها سریعتر شدند. تصاویر تأثیر زیادی بر محتوایتان می‌گذارند، اما گاهی اوقات می‌توانند باعث کند شدن سایت شما شوند. در وردپرس ۵.۵، عکس‌ها تا زمانی‌ که با اسکرول قابل [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8171:\"\n<p>در وردپرس ۵٫۵، سایت شما در سه بخش اصلی قدرت جدیدی گرفته است: سرعت، جستجو و امنیت.</p>\n\n\n\n<h2 class=\"wp-block-heading\">سرعت</h2>\n\n\n\n<p><strong>عکس‌ها لِیزی-لود شده‌اند، و سرعت بارگذاری</strong> <strong>نوشته‌ها و برگه‌ها سریعتر شدند.</strong></p>\n\n\n\n<p>تصاویر تأثیر زیادی بر محتوایتان می‌گذارند، اما گاهی اوقات می‌توانند باعث کند شدن سایت شما شوند.</p>\n\n\n\n<p>در وردپرس ۵.۵، عکس‌ها تا زمانی‌ که با اسکرول قابل مشاهده می‌شوند، برای بارگذاری صبر می‌کنند. واژه تکنیکال آن &#8216;lazy loading&#8217; است.</p>\n\n\n\n<p>روی موبایل، لِیزی-لود می‌تواند مرورگرها را از دریافت پرونده‌های درنظرگرفته‌شده برای سایر دستگاه‌ها باز دارد. آن می‌تواند باعث صرفه‌جویی خوانندگان شما در داده شود — و کمک کند عمر باتری حفظ شود.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">جستجو</h2>\n\n\n\n<p><strong>به نقشهٔ سایت جدید سلام کنید.</strong></p>\n\n\n\n<p>سایت‌های وردپرس با موتورهای جستجو به خوبی کار می‌کنند.</p>\n\n\n\n<p>اکنون، به طور پیش‌فرض، وردپرس ۵.۵ دارای یک نقشهٔ سایت XML است که به موتورهای جستجو کمک می‌کند تا از همان دقایقی آغاز کار، مهم‌ترین برگه‌های شما را کشف کنند.</p>\n\n\n\n<p>بنابراین تعداد بیشتری از افراد سایت شما را زودتر پیدا می‌کنند و به شما فرصت بیشتری می‌دهند تا مشارکت داشته باشند، آنها را حفظ نمایید و به مشترکین، مشتریان یا هر آن‌چه که با تعریف موفقیت شما مناسب باشد، تبدیل نمایید.</p>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<div class=\"wp-block-group has-background\" style=\"background-color:#ebcd3d\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<h2 class=\"has-background wp-block-heading\" style=\"background-color:#ebcd3d\">امنیت</h2>\n\n\n\n<p><strong>به‌روزرسانی‌های خودکار برای افزونه‌ها و پوسته‌ها</strong></p>\n\n\n\n<p>اکنون می‌توانید افزونه‌ها و پوسته‌ها را تنظیم نمایید تا به صورت خودکار در مدیریت وردپرس به‌روزرسانی شوند — یا نه! —. بنابراین همیشه می‌دانید سایت شما آخرین کد موجود را اجرا می‌نماید.</p>\n\n\n\n<p>همچنین می‌توانید برای هر افزونه یا پوسته‌ای که نصب نموده‌اید، به‌روزرسانی‌های خودکار را روشن یا خاموش نمایید — همه در همان صفحه‌هایی که همیشه از آن‌ها استفاده شده است.</p>\n\n\n\n<p><strong>به‌روزرسانی با بارگذاری پروندهٔ ZIP</strong> <strong>شده</strong></p>\n\n\n\n<p>اگر به‌روزرسانی افزونه‌ها و پوسته‌هایتان به صورت دستی انجام می‌شود، اکنون این کار نیز ساده‌تر است — فقط یک پروندهٔ ZIP را بارگذاری نمایید.</p>\n</div></div>\n</div></div>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-group has-background\" style=\"background-color:#f3ecda\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<h2 class=\"wp-block-heading\">نکات برجسته از بلوک ویرایشگر</h2>\n\n\n\n<p>یک بار دیگر، تازه‌ترین نگارش وردپرس فهرست طولانی از ویژگی‌های جدید هیجان‌انگیز را برای ویرایشگر بلوک منتشر نمود. برای نمونه:</p>\n\n\n\n<h4 class=\"wp-block-heading\">الگوهای بلوک</h4>\n\n\n\n<p>الگوهای بلوک جدید ایجاد طرح‌های زیبا، پیچیده را با کمک ترکیبی از متن و رسانه که می‌توانید آنها را مخلوط و متناسب با داستانتان کنید، ساده و سرگرم‌کننده می‌کند.</p>\n\n\n\n<p>شما همچنین می‌توانید الگوهای بلوک را در طیف گسترده‌ای از افزونه‌ها و پوسته‌ها، با تعداد زیادی که بیشتر از همیشه اضافه شده، پیدا کنید. هر یک از آنها را از یک کشویی انتخاب کنید — فقط کلیک کنید و بروید!</p>\n\n\n\n<h4 class=\"wp-block-heading\">ویرایش تصویر توکار</h4>\n\n\n\n<p>تصاویرتان را به درستی از بلوک تصویر برش داده‌، بچرخانید، و زوم نمایید. اگر زمان زیادی را صرف تصاویر می‌نمایید، این می‌تواند در وقت شما ساعت‌ها صرفه‌جویی نماید.</p>\n\n\n\n<h4 class=\"wp-block-heading\">پوشه بلوک جدید</h4>\n\n\n\n<p>حالا این ساده‌تر از هر زمانی است که بلوک موردنیازتان را پیدا کنید. پوشه بلوک جدید برای ویرایشگر بلوک ساخته شده، پس شما می‌توانید نوع‌های بلوک جدیدی برای سایتتان بدون خروج از ویرایشگر نصب کنید.</p>\n\n\n\n<h4 class=\"wp-block-heading\">و خیلی بیشتر.</h4>\n\n\n\n<p>هایلایت‌های بالا بخش کوچکی از امکانات ویرایشگر بلوک جدید است که شما نصب کردید. ویرایشگر بلوک را باز کنید و لذت ببرید!</p>\n</div></div>\n</div></div>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">دسترس‌پذیری</h2>\n\n\n\n<p>هر نگارش پیشرفت‌هایی را به تجربهٔ دستر‌س‌پذیری انتشار می‌افزاید، و این دربارهٔ وردپرس ۵.۵ نیز صدق می‌کند.</p>\n\n\n\n<p>هم‌اکنون می‌توانید پیوندها را در صفحه رسانه و کادر مودال با یک دکمه، بجای تلاش برای هایلایت کردن یک خط از متن کپی کنید.</p>\n\n\n\n<p>همچنین شما می‌توانید جعبه‌های متا را با صفحه کلید حرکت دهید، و عکس‌ها را در وردپرس با دستگاه کمک‌کننده خود ویرایش کنید، همان‌گونه که این می‌تواند دستورالعمل‌های موجود را در ویرایشگر تصویر بخواند.</p>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-buttons aligncenter is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p class=\"has-text-align-center has-text-color\" style=\"color:#ffffff\">&#8230;..</p>\n\n\n\n<h5 class=\"wp-block-heading\">بخش راهنما را برای توضیحات بیشتر بررسی نمایید.</h5>\n\n\n\n<p>چیزهای بیشتری برای دوست‌داران در وردپرس ۵.۵ وجود دارد. برای کاوش بیشتر و آموختن اینکه چطور این تغییرات سایت‌های شما، پوسته‌ها، افزونه‌ها و موارد دیگر را جلا می‌دهند، <a href=\"https://make.wordpress.org/core/wordpress-5-5-field-guide/\">راهنمای زمینه وردپرس ۵.۵</a> را بررسی نمایید.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"641\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"وردپرس فارسی نگارش ۵٫۴\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://fa.wordpress.org/2020/04/01/wp-persian-54/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Apr 2020 20:16:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=603\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:614:\"وردپرس فارسی ۵٫۴ منتشر شد. مهمترین قابلیت‌های جدید این نگارش را بصورت خلاصه بررسی می‌کنیم: چند بلوک جدید به این نگارش اضافه شده که امکانات جذابی را برای استفاده فراهم کرده‌ کرده‌اند. بلوک آیکون‌های شبکه‌های اجتماعی و بلوک دکمه‌ها و یک بلوک برای ناوبری اضافه شده است. همچنین بهبودهایی در بلوک‌های متنی/رسانه‌ای انجام گرفته. &#8230;.. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6203:\"\n<p>وردپرس فارسی ۵٫۴ منتشر شد. مهمترین قابلیت‌های جدید این نگارش را بصورت خلاصه بررسی می‌کنیم:</p>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right has-background is-stacked-on-mobile\" style=\"background-color:#f3f4f5\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"500\" height=\"500\" src=\"https://fa.wordpress.org/files/2020/04/blocks-5-5.png\" alt=\"\" class=\"wp-image-605\" srcset=\"https://fa.wordpress.org/files/2020/04/blocks-5-5.png 500w, https://fa.wordpress.org/files/2020/04/blocks-5-5-300x300.png 300w, https://fa.wordpress.org/files/2020/04/blocks-5-5-150x150.png 150w\" sizes=\"auto, (max-width: 500px) 100vw, 500px\" /></figure><div class=\"wp-block-media-text__content\">\n<p style=\"font-size:15px\" class=\"has-text-align-right\">چند بلوک جدید به این نگارش اضافه شده که امکانات جذابی را برای استفاده فراهم کرده‌ کرده‌اند.</p>\n\n\n\n<p style=\"font-size:15px\" class=\"has-text-align-right\">بلوک آیکون‌های شبکه‌های اجتماعی و بلوک دکمه‌ها و یک بلوک برای ناوبری اضافه شده است. همچنین بهبودهایی در بلوک‌های متنی/رسانه‌ای انجام گرفته.</p>\n</div></div>\n\n\n\n<p style=\"color:#ffffff\" class=\"has-text-color has-text-align-center\">&#8230;..</p>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"500\" height=\"500\" src=\"https://fa.wordpress.org/files/2020/04/ui-5-5.png\" alt=\"\" class=\"wp-image-614\" srcset=\"https://fa.wordpress.org/files/2020/04/ui-5-5.png 500w, https://fa.wordpress.org/files/2020/04/ui-5-5-300x300.png 300w, https://fa.wordpress.org/files/2020/04/ui-5-5-150x150.png 150w\" sizes=\"auto, (max-width: 500px) 100vw, 500px\" /></figure><div class=\"wp-block-media-text__content\">\n<p style=\"font-size:15px\" class=\"has-text-align-right\">در این نگارش رابط کاربری ساده‌تر، راهبری واضح‌تر و تب‌زدن ساده‌تر شده است.</p>\n\n\n\n<p style=\"font-size:15px\" class=\"has-text-align-right\">سرعت بارگذاری ۱۴% سریعتر و زمان نوشتن هم ۵۱% سریعتر شده است!</p>\n\n\n\n<p style=\"font-size:15px\" class=\"has-text-align-right\">در این نگارش، در بخش نوشتن، ویرایشگر بصورت پیش‌فرض تمام صفحه شده است.</p>\n</div></div>\n\n\n\n<p style=\"color:#ffffff\" class=\"has-text-color has-text-align-center\">&#8230;..</p>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right has-background is-stacked-on-mobile\" style=\"background-color:#f3f4f5\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"500\" height=\"500\" src=\"https://fa.wordpress.org/files/2020/04/privacy-5-5.png\" alt=\"\" class=\"wp-image-607\" srcset=\"https://fa.wordpress.org/files/2020/04/privacy-5-5.png 500w, https://fa.wordpress.org/files/2020/04/privacy-5-5-300x300.png 300w, https://fa.wordpress.org/files/2020/04/privacy-5-5-150x150.png 150w\" sizes=\"auto, (max-width: 500px) 100vw, 500px\" /></figure><div class=\"wp-block-media-text__content\">\n<p style=\"font-size:15px\" class=\"has-text-align-right\">در این نگارش همچنان بخش حفظ حریم خصوصی بهبودهای فنی و ظاهری داشته است.</p>\n\n\n\n<p style=\"font-size:15px\" class=\"has-text-align-right\">هم‌اکنون برون‌بری داده‌های شخصی شامل اطلاعات نشست کاربران و داده‌های موقیعت مکانی کاربران به اضافهٔ جدول محتوا در دسترس است.</p>\n</div></div>\n\n\n\n<p style=\"color:#ffffff\" class=\"has-text-color has-text-align-center\">&#8230;..</p>\n\n\n\n<p><strong>برای توسعه دهندگان:</strong></p>\n\n\n\n<p style=\"font-size:15px\">&#8211; زمینه‌های دلخواه به گزینه‌های فهرست افزوده شدند، بدون افزونه و بدون نوشتن واکرهای سفارشی میتوانید آنها را استفاده نمایید.</p>\n\n\n\n<p style=\"font-size:15px\">&#8211; در بلوک‌ها، هم‌اکنون می‌توانید ظاهر بلوک‌ها را به شیوه‌ای که می‌خواهید تغییر دهید.</p>\n\n\n\n<p style=\"font-size:15px\">&#8211; اگر افزونه‌ای دارید، هم‌اکنون می‌توانید بلوک‌هایتان را در دسته‌های مختلف ثبت نمایید — این یک راهکار عالی برای بیشتر دیده شدن برند شما است.</p>\n\n\n\n<p style=\"font-size:15px\">&#8211; به کاربران اجازه دهید با دو API تازه کارهای بیشتری انجام دهند: متغییرهای بلوک و گرادیانت.</p>\n\n\n\n<p style=\"font-size:15px\">&#8211; همچنین در جاسازها، هم‌اکنون ویرایشگر بلوک، TikTok را پشتیبانی می‌کند— و CollegeHumor حذف شد.</p>\n\n\n\n<p></p>\n\n\n\n<p style=\"color:#ffffff\" class=\"has-text-color has-text-align-center\">&#8230;..</p>\n\n\n\n<div class=\"wp-block-buttons aligncenter is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-color has-background has-vivid-cyan-blue-background-color\" href=\"https://fa.wordpress.org/download/\" style=\"color:#ffffff;border-radius:8px\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p style=\"color:#ffffff\" class=\"has-text-color has-text-align-center\">&#8230;..</p>\n\n\n\n<p>چیزهای بیشتری برای دوست‌داران در وردپرس ۵٫۴ وجود دارد. برای کاوش بیشتر و آموختن اینکه چطور این تغییرات سایت‌های شما، پوسته‌ها، افزونه‌ها و موارد دیگر را زیبایی و بهبود می‌دهند، <a href=\"https://make.wordpress.org/core/2020/03/03/wordpress-5-4-field-guide/\">راهنمای زمینه وردپرس ۵.۴</a> را بررسی نمایید.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"603\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://fa.wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"13096050\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sun, 30 Nov 2025 10:03:25 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Thu, 13 Nov 2025 13:56:10 GMT\";s:4:\"link\";s:61:\"<https://fa.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";i:1764496951;s:21:\"cache_expiration_time\";i:1764540205;s:23:\"__cache_expiration_time\";i:1764540205;}","off"),
("207","_transient_timeout_feed_mod_9ba2df8849616f02166b8f7242d75067","1764540205","off"),
("208","_transient_feed_mod_9ba2df8849616f02166b8f7242d75067","1764497005","off"),
("209","_transient_timeout_feed_813f86eb29c12d6094f1acd1445797e5","1764540206","off"),
("210","_transient_feed_813f86eb29c12d6094f1acd1445797e5","a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"تیم وردپرس فارسی – WordPress.org فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://fa.wordpress.org/team\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 15 Feb 2025 19:56:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fa-IR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=7.0-alpha-61315\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"تیم وردپرس فارسی – WordPress.org فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://fa.wordpress.org/team\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"آموزش مشارکت در ترجمه وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://fa.wordpress.org/team/2025/02/14/how-to-contribute-translation/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://fa.wordpress.org/team/2025/02/14/how-to-contribute-translation/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Feb 2025 03:50:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"مطالب\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=222\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:650:\"مقدمه‌ای بر ترجمه وردپرس فارسی وردپرس به‌عنوان یک سیستم مدیریت محتوای متن‌باز، توسط میلیون‌ها نفر در سراسر جهان استفاده می‌شود. این سیستم با پشتیبانی از افزونه‌ها، پوسته‌ها، و ابزارهای متنوع، به کاربران این امکان را می‌دهد تا وب‌سایت‌های خود را به شکلی کاملاً شخصی‌سازی‌شده مدیریت نمایند. با وجود این امکانات، وردپرس برای کاربران غیربومی تنها [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:37076:\"<h2 class=\"wp-block-heading has-medium-font-size\"><strong>مقدمه‌ای بر ترجمه وردپرس فارسی</strong></h2>\n\n\n\n<p>وردپرس به‌عنوان یک سیستم مدیریت محتوای متن‌باز، توسط میلیون‌ها نفر در سراسر جهان استفاده می‌شود. این سیستم با پشتیبانی از افزونه‌ها، پوسته‌ها، و ابزارهای متنوع، به کاربران این امکان را می‌دهد تا وب‌سایت‌های خود را به شکلی کاملاً شخصی‌سازی‌شده مدیریت نمایند. با وجود این امکانات، وردپرس برای کاربران غیربومی تنها در صورتی مفید خواهد بود که به زبان مادری آن‌ها ترجمه شود.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><a href=\"https://fa.wordpress.org/team/files/2025/02/wp-translate.jpg\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://fa.wordpress.org/team/files/2025/02/wp-translate-1024x576.jpg\" alt=\"\" class=\"wp-image-315\" style=\"width:684px;height:auto\" srcset=\"https://fa.wordpress.org/team/files/2025/02/wp-translate-1024x576.jpg 1024w, https://fa.wordpress.org/team/files/2025/02/wp-translate-300x169.jpg 300w, https://fa.wordpress.org/team/files/2025/02/wp-translate-768x432.jpg 768w, https://fa.wordpress.org/team/files/2025/02/wp-translate.jpg 1280w\" sizes=\"(max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<p>ترجمه وردپرس فراتر از برگردان متن‌های ساده است؛ این فرآیند شامل تطبیق مفاهیم و عملکردهای وردپرس با فرهنگ، زبان و نیازهای کاربران محلی می‌باشد. در نتیجه، تجربه کاربری بهتری برای کاربران فارسی‌زبان فراهم می‌شود.</p>\n\n\n\n<p>جامعه وردپرس به‌طور داوطلبانه و با تکیه بر همکاری‌های جهانی، فرآیند ترجمه را انجام می‌دهد. این مشارکت هم به بهبود کیفیت ترجمه‌ها کمک می‌کند و هم دسترسی کاربران به وردپرس را تسهیل می‌نماید. برای پیوستن به این جامعه مترجمان، تنها کافی است علاقه‌مند به زبان فارسی و وردپرس باشید.</p>\n\n\n\n<p>در این نوشته به آموزش ترجمه وردپرس فارسی، افزونه‌ها و پوسته‌های آن می‌پردازیم.</p>\n\n\n\n<h2 class=\"wp-block-heading has-medium-font-size\"><strong>چرا ترجمه وردپرس فارسی اهمیت دارد؟</strong></h2>\n\n\n\n<p>وردپرس به‌عنوان یکی از محبوب‌ترین سیستم‌های مدیریت محتوا در جهان، به میلیون‌ها کاربر در سراسر دنیا امکان ساخت وب‌سایت‌ها را می‌دهد. یکی از عوامل موفقیت وردپرس، <strong>انعطاف‌پذیری و جامعه گسترده‌ای</strong> است که به طور مستمر در بهبود آن مشارکت می‌نمایند.</p>\n\n\n\n<p>در این میان، ترجمه وردپرس به زبان‌های مختلف نقش کلیدی در دسترسی بهتر کاربران به این ابزار قدرتمند ایفا می‌کند. وردپرس فارسی نیز با ارائه رابط کاربری و مستندات به زبان فارسی، تجربه کاربران ایرانی را بهبود می‌بخشد. اما این دستاورد تنها به کمک <strong>مشارکت داوطلبانه جامعه مترجمان</strong> امکان‌پذیر است.</p>\n\n\n\n<p>این مقاله به شما کمک می‌کند تا با فرآیند ترجمه وردپرس فارسی آشنا شوید و بتوانید به راحتی به این پروژه جهانی بپیوندید. با مشارکت در ترجمه، نه تنها مهارت‌های خود را تقویت می‌نمایید، بلکه در ساخت ابزارهای دیجیتال برای دیگر فارسی‌زبانان نیز نقش موثری خواهید داشت.</p>\n\n\n\n<span id=\"more-222\"></span>\n\n\n\n<h2 class=\"wp-block-heading has-medium-font-size\"><strong>نحوه ثبت‌نام و ورود به سیستم ترجمه وردپرس</strong></h2>\n\n\n\n<p>برای مشارکت در ترجمه وردپرس فارسی، اولین گام ثبت‌نام و ورود به سیستم ترجمه وردپرس است. این سیستم به شما امکان می‌دهد تا به صورت آنلاین ترجمه‌ها را مشاهده، ویرایش و پیشنهادهای خود را ارسال نمایید. در ادامه، مراحل ثبت‌نام و ورود را بررسی می‌کنیم:</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۱. ایجاد حساب کاربری در WordPress.org</strong></p>\n\n\n\n<p>برای مشارکت در ترجمه وردپرس، نیاز به یک حساب کاربری در وب‌سایت <a href=\"https://wordpress.org/\">WordPress.org</a> دارید. اگر هنوز حساب کاربری ندارید، مراحل زیر را دنبال نمایید:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>به صفحه <a href=\"https://login.wordpress.org/register?locale=fa_IR\">ثبت‌نام</a> بروید.</li>\n\n\n\n<li>نام کاربری و آدرس ایمیل خود را وارد نمایید.</li>\n\n\n\n<li>ایمیلی حاوی پیوند تأیید دریافت خواهید کرد. روی آن کلیک نمایید و رمز عبور خود را تنظیم کنید.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image alignleft size-full is-resized\"><a href=\"https://fa.wordpress.org/team/files/2024/12/image-1.png\"><img decoding=\"async\" width=\"589\" height=\"877\" src=\"https://fa.wordpress.org/team/files/2024/12/image-1.png\" alt=\"\" class=\"wp-image-242\" style=\"width:333px;height:auto\" srcset=\"https://fa.wordpress.org/team/files/2024/12/image-1.png 589w, https://fa.wordpress.org/team/files/2024/12/image-1-201x300.png 201w\" sizes=\"(max-width: 589px) 100vw, 589px\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-full is-resized\"><a href=\"https://fa.wordpress.org/team/files/2024/12/image.png\"><img decoding=\"async\" width=\"528\" height=\"815\" src=\"https://fa.wordpress.org/team/files/2024/12/image.png\" alt=\"\" class=\"wp-image-240\" style=\"width:321px;height:auto\" srcset=\"https://fa.wordpress.org/team/files/2024/12/image.png 528w, https://fa.wordpress.org/team/files/2024/12/image-194x300.png 194w\" sizes=\"(max-width: 528px) 100vw, 528px\"></a></figure>\n\n\n\n<p class=\"has-small-font-size\"></p>\n\n\n\n<p><strong>نکته مهم در مورد ثبت نام:</strong></p>\n\n\n\n<p class=\"has-light-grey-2-background-color has-background\">وردپرس در سیاست‌های ضد هرزنامه خود ثبت نام را برای همه کاربرهای جدید بسته است، به همین دلیل ایمیل تاییدیه بعد از انجام کار بالا برای شما ارسال نخواهد شد، اگر از قبل در وردپرس حساب کاربری ندارید و نیاز به حساب جدید دارید، بعد از انجام کار بالا باید یک ایمیل با ایمیل ثبت‌نامی به آدرس <a href=\"mailto:forum-password-resets@wordpress.org\" target=\"_blank\" rel=\"noreferrer noopener\">forum-password-resets@wordpress.org</a> ارسال کنید و در متن ایمیل (به انگلیسی) توضیح بدید که برای چی نیاز دارید که حساب کاربری جدید بسازید. بعد از مکاتبه با وردپرس و طی کردن این مرحله حساب شما فعال خواهد شد.</p>\n\n\n\n<div style=\"height:27px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۲. ورود به سیستم ترجمه</strong></p>\n\n\n\n<p>پس از ایجاد حساب کاربری، می‌توانید به سیستم ترجمه وردپرس دسترسی پیدا نمایید:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>به صفحه <a href=\"https://translate.wordpress.org/locale/fa/\">ورود وردپرس</a> بروید. با استفاده از اطلاعات حساب کاربری خود، وارد سیستم شوید.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full is-resized\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-1.png\"><img loading=\"lazy\" decoding=\"async\" width=\"548\" height=\"799\" src=\"https://fa.wordpress.org/team/files/2025/02/image-1.png\" alt=\"\" class=\"wp-image-260\" style=\"width:366px;height:auto\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-1.png 548w, https://fa.wordpress.org/team/files/2025/02/image-1-206x300.png 206w\" sizes=\"auto, (max-width: 548px) 100vw, 548px\"></a></figure>\n\n\n\n<p></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>پس از ورود، می‌توانید پروژه‌های ترجمه فعال را مشاهده و پروژه مورد نظر خود را انتخاب نمایید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۳. شروع به مشارکت در ترجمه</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>پس از ورود به سیستم، به بخش <a href=\"https://translate.wordpress.org/locale/fa/\">زبان فارسی</a> بروید.</li>\n\n\n\n<li>یک پروژه، افزونه یا پوسته را انتخاب نمایید.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"362\" src=\"https://fa.wordpress.org/team/files/2025/02/image-1024x362.png\" alt=\"\" class=\"wp-image-258\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-1024x362.png 1024w, https://fa.wordpress.org/team/files/2025/02/image-300x106.png 300w, https://fa.wordpress.org/team/files/2025/02/image-768x271.png 768w, https://fa.wordpress.org/team/files/2025/02/image-1536x543.png 1536w, https://fa.wordpress.org/team/files/2025/02/image.png 1868w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<ul class=\"wp-block-list\">\n<li>بعد از ورود به پروژه بخش‌ها و رشته‌های قابل ترجمه مشخص است. زیر پروژه <strong>Stable (latest release)</strong> در این بخش دارای اولویت بالاتری برای ترجمه است و از اینجا شروع می‌کنیم.<br></li>\n</ul>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-2.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"154\" src=\"https://fa.wordpress.org/team/files/2025/02/image-2-1024x154.png\" alt=\"\" class=\"wp-image-265\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-2-1024x154.png 1024w, https://fa.wordpress.org/team/files/2025/02/image-2-300x45.png 300w, https://fa.wordpress.org/team/files/2025/02/image-2-768x116.png 768w, https://fa.wordpress.org/team/files/2025/02/image-2-1536x231.png 1536w, https://fa.wordpress.org/team/files/2025/02/image-2.png 1866w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<ul class=\"wp-block-list\">\n<li>با باز کردن هر رشته می‌توانید پیشنهادهای ترجمه خود را ارسال نمایید یا ترجمه‌های موجود را بازبینی و اصلاح نمایید.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-3.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"585\" src=\"https://fa.wordpress.org/team/files/2025/02/image-3-1024x585.png\" alt=\"\" class=\"wp-image-267\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-3-1024x585.png 1024w, https://fa.wordpress.org/team/files/2025/02/image-3-300x171.png 300w, https://fa.wordpress.org/team/files/2025/02/image-3-768x439.png 768w, https://fa.wordpress.org/team/files/2025/02/image-3.png 1122w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<p class=\"has-normal-font-size\"><strong>نکته:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>پس از ارسال ترجمه، مدیران پروژه یا مترجمان ارشد ترجمه‌های شما را بررسی و تأیید می‌نمایند. با افزایش مشارکت و دقت در ترجمه‌ها، می‌توانید به یکی از اعضای فعال جامعه مترجمان وردپرس تبدیل شوید.</li>\n\n\n\n<li><strong>بخش‌های مختلف وردپرس از نظر حساسیت ترجمه اولویت‌بندی دارند.</strong> اگر تازه‌کار هستید، بهتر است ابتدا ترجمه افزونه‌ها را انجام دهید. ترجمه هسته وردپرس بیشترین حساسیت را دارد و نیازمند دقت، تجربه و آشنایی بیشتر با استانداردهای ترجمه است.</li>\n</ul>\n\n\n\n<p></p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>نکات ترجمه صحیح در وردپرس و تایید شدن آن‌ها</strong></h2>\n\n\n\n<p>ترجمه وردپرس نه‌تنها به برگرداندن متن‌ها از زبان اصلی به فارسی محدود می‌شود، بلکه شامل ارائه ترجمه‌هایی است که مفهوم، کاربردپذیری، و تجربه کاربری مناسبی داشته باشند. در ادامه، نکات عملی برای داشتن ترجمه‌های صحیح و مؤثر ارائه شده است که رعایت آن‌ها واجب و ضروری است:</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۱. استفاده و پیروی از واژه‌نامه وردپرس (WordPress Glossary)</strong></p>\n\n\n\n<p>واژه‌نامه ترجمه وردپرس (Glossary) یک ابزار کلیدی برای مترجمان است. با استفاده از این واژه‌نامه می‌توانید:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>از معادل‌های رسمی و استاندارد استفاده نمایید.</li>\n\n\n\n<li>یکپارچگی ترجمه‌ها را تضمین کنید.</li>\n</ul>\n\n\n\n<p>واژه‌نامه وردپرس شامل اصطلاحات رایج و استانداردهایی است که در ترجمه‌ها استفاده می‌شوند. این ابزار کمک می‌نماید تا ترجمه‌ها یکپارچگی بیشتری داشته باشند.<br>برای مشاهده واژه‌نامه، می‌توانید به بخش “<a href=\"https://translate.wordpress.org/locale/fa/default/glossary/\">WordPress Translation Glossary</a>” مراجعه نمایید.</p>\n\n\n\n<p>این واژه‌نامه به صورت تصویر زیر شمارو هنگام ترجمه همراهی و کمک می‌کند.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-4.png\"><img loading=\"lazy\" decoding=\"async\" width=\"511\" height=\"414\" src=\"https://fa.wordpress.org/team/files/2025/02/image-4.png\" alt=\"\" class=\"wp-image-271\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-4.png 511w, https://fa.wordpress.org/team/files/2025/02/image-4-300x243.png 300w\" sizes=\"auto, (max-width: 511px) 100vw, 511px\"></a></figure>\n\n\n\n<p class=\"has-normal-font-size\"></p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۲. مفهوم را به جای متن ترجمه نمایید</strong></p>\n\n\n\n<p>در ترجمه، به اصل متن پایبند باشید اما تمرکز شما باید بر انتقال صحیح مفهوم باشد، بسیاری از اصطلاحات وردپرس نیاز به تطبیق با فرهنگ و زبان فارسی دارند. متن را به دلخواه تغییر ندهید و سلیقه خود را در ترجمه لحاظ نکنید.<br><strong>مثال:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>به جای ترجمه کلمه‌به‌کلمه “Custom Post Type”، می‌توانید از عبارت “نوع نوشته سفارشی” استفاده نمایید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۳. به سازگاری و یکنواختی پایبند باشید</strong></p>\n\n\n\n<p>برای ایجاد تجربه کاربری بهتر، لازم است در تمام ترجمه‌ها از واژه‌ها و عبارات یکسان استفاده نمایید. استفاده از واژه‌نامه وردپرس و بررسی ترجمه‌های تأییدشده دیگر می‌تواند کمک زیادی کند.</p>\n\n\n\n<p></p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۴. به اصول نگارشی فارسی توجه نمایید</strong></p>\n\n\n\n<p>رعایت اصول نگارشی، مانند استفاده از نیم‌فاصله، نشانه‌گذاری مناسب، و دستور زبان فارسی، تأثیر زیادی بر کیفیت ترجمه خواهد داشت.<br><strong>مثال:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>به جای “این ابزار می تواند” از “این ابزار می‌تواند” استفاده نمایید.</li>\n\n\n\n<li>در ترجمه حتماً از نیم‌فاصله در جای درست استفاده نمایید. کلماتی مانند “پوسته‌ ها” و “بلوک‌ ها” که بدون نیم‌فاصله نوشته شوند، تأیید نخواهند شد.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۵. از صفحه‌کلید فارسی و استاندارد استفاده نمایید.</strong><br>وجود کاراکترهای غیراستاندارد مانند “ي” و “ك” در ترجمه باعث رد شدن آن خواهد شد.</p>\n\n\n\n<p>از “هٔ” (ی کوچک) به‌درستی استفاده نمایید. در کلماتی مانند “صفحهٔ قبلی” حتماً از “ٔ” استفاده شود. این کاراکتر با “ه همزه‌دار” یا “همزه” متفاوت است و در صفحه‌کلید استاندارد با کلید Shift + N نوشته می‌شود.</p>\n\n\n\n<p>در انجام ترجمه با موبایل حتما دقت کنید که صفحه‌کلید شما فارسی باشد. (در سیستم عامل ios معمولا صفحه‌کلید عربی است)</p>\n\n\n\n<p></p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۶. سازگاری با متن اصلی را حفظ نمایید</strong></p>\n\n\n\n<p>ترجمه باید با متن اصلی از نظر ساختار و مفهوم همخوانی داشته باشد. به ویژه در مواردی که رشته‌های ترجمه متغیر یا کد دارند، باید آن‌ها را دقیقاً به همان شکل در ترجمه حفظ نمایید.<br><strong>مثال:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>“Welcome, %s!” به شکل “خوش آمدید، %s!” ترجمه شود.</li>\n\n\n\n<li><strong>علائم خاص مانند (%s) را دقیقاً مطابق با متن اصلی ترجمه نمایید.</strong> تمامی علائم و کاراکترهای ویژه باید دقیقاً همان‌طور که در متن اصلی آمده‌اند، در ترجمه نیز قرار گیرند.</li>\n\n\n\n<li>به‌عنوان‌مثال، نباید علامت “%” را به “٪” تغییر دهید. همچنین علائمی مانند کاما (،)، درصد (%)، هش (#)، و (&amp;) و تگ‌های HTML باید بدون تغییر باقی بمانند.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۷. از ترجمه ماشینی استفاده نکنید</strong></p>\n\n\n\n<p>ابزارهای ترجمه ماشینی می‌توانند به سرعت کار شما کمک کنند، اما همواره باید بازبینی و اصلاح شوند. این ابزارها معمولاً مفهوم یا سبک متن را به درستی درک نمی‌کنند. ترجمه‌های مستقیم ماشینی تایید نمی‌شوند.</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۸. به بخش پیشنهادها توجه نمایید</strong></p>\n\n\n\n<p>به بخش پیشنهادها توجه نمایید، اما به آن کاملاً اعتماد نکنید. این بخش بر اساس حافظه ترجمه، پیشنهادهایی ارائه می‌دهد. اگر در حال ترجمه افزونه هستید، ممکن است این پیشنهادات کمک‌کننده باشند، اما برای ترجمه خود وردپرس باید دقت نمایید که پیشنهاد ارائه‌شده از هسته وردپرس باشد.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-5.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"593\" src=\"https://fa.wordpress.org/team/files/2025/02/image-5-1024x593.png\" alt=\"\" class=\"wp-image-272\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-5-1024x593.png 1024w, https://fa.wordpress.org/team/files/2025/02/image-5-300x174.png 300w, https://fa.wordpress.org/team/files/2025/02/image-5-768x445.png 768w, https://fa.wordpress.org/team/files/2025/02/image-5.png 1152w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۹. از بازبینی نهایی غافل نشوید</strong></p>\n\n\n\n<p>قبل از ارسال ترجمه، حتماً آن را بازبینی نمایید تا از صحت ترجمه، اصول نگارشی و روان بودن متن مطمئن شوید.</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۱۰. با جامعه مترجمان همکاری نمایید</strong></p>\n\n\n\n<p>یکی از مزایای ترجمه وردپرس، همکاری با جامعه‌ای از مترجمان است. از بازخوردهای دیگر مترجمان استفاده نمایید و در صورت شک، از آن‌ها سؤال کنید.</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://t.me/wpdevelopers\">عضویت در گروه تلگرام مترجمان</a></div>\n</div>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۱۱. آزمایش و بررسی ترجمه در عمل</strong></p>\n\n\n\n<p>ترجمه‌ها را روی محیط وردپرس آزمایش کنید تا از مناسب بودن آن‌ها در محیط کاربری مطمئن شوید. این کار به شما کمک می‌کند تا خطاها و مشکلات احتمالی را پیش از تأیید نهایی برطرف نمایید. ابزارهایی مانند <a>Loco Translate</a> یا بخش <a href=\"https://translate.wordpress.org/locale/fa/default/wp-plugins/\">ویرایش زنده</a> GlotPress در بخش افزونه‌ها به شما این امکان را می‌دهند.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-6.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"360\" src=\"https://fa.wordpress.org/team/files/2025/02/image-6-1024x360.png\" alt=\"\" class=\"wp-image-279\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-6-1024x360.png 1024w, https://fa.wordpress.org/team/files/2025/02/image-6-300x105.png 300w, https://fa.wordpress.org/team/files/2025/02/image-6-768x270.png 768w, https://fa.wordpress.org/team/files/2025/02/image-6-1536x540.png 1536w, https://fa.wordpress.org/team/files/2025/02/image-6.png 1900w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<p>با رعایت این نکات، می‌توانید ترجمه‌های باکیفیتی ارائه دهید که تجربه کاربران فارسی‌زبان وردپرس را بهبود بخشد و به گسترش این پلتفرم کمک نماید.</p>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\">چالش‌های رایج در ترجمه وردپرس و راه‌حل‌ها</h3>\n\n\n\n<p>در فرآیند ترجمه وردپرس، ممکن است با چالش‌هایی روبه‌رو شوید که کیفیت و سرعت ترجمه را تحت تأثیر قرار دهند. شناخت این چالش‌ها و راه‌حل‌های مناسب، به شما کمک می‌نماید تا فرآیند ترجمه را بهینه‌تر انجام دهید. در ادامه، به برخی از رایج‌ترین چالش‌ها و راهکارهای پیشنهادی پرداخته‌ایم:</p>\n\n\n\n<p class=\"has-charcoal-0-color has-text-color has-link-color has-normal-font-size wp-elements-79296ebdfacd39b15d4f8cd584f1f73f\"><strong>۱. ابهام در پذیرش ترجمه‌ها و تایید نشدن آن‌ها</strong></p>\n\n\n\n<p>گاهی پیشنهادهای ترجمه شما مدت زیادی منتظر تأیید می‌مانند.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>با مدیران ترجمه پروژه از طریق گروه تلگرام در ارتباط باشید و از آن‌ها برای بازبینی درخواست نمایید.</li>\n\n\n\n<li>وضعیت‌های ترجمه خود را بررسی نمایید.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-7.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"131\" src=\"https://fa.wordpress.org/team/files/2025/02/image-7-1024x131.png\" alt=\"\" class=\"wp-image-280\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-7-1024x131.png 1024w, https://fa.wordpress.org/team/files/2025/02/image-7-300x38.png 300w, https://fa.wordpress.org/team/files/2025/02/image-7-768x98.png 768w, https://fa.wordpress.org/team/files/2025/02/image-7.png 1318w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<p>ممکن است ترجمه شما توسط مدیران در بخش Fuzzy یا Changes requested قرار گرفته باشد. این حالت یعنی ترجمه شما ایرادی داشته و تایید نشده است و ویرایشگر مربوطه آن را برای تغییر و اصلاح به خود شما ارجاع داده است. پیشنهاد ترجمه اصلاح شده شما بعد از ارسال مجدد بررسی می‌شود.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>به قسمت بحث‌ها (Disscussion) توجه کنید.</strong></li>\n</ul>\n\n\n\n<p>در بخش Disscussion که در سمت راست ترجمه هر رشته در دسترس است ممکن است دیدگاهی از طرف مدیر یا ویرایشگر آن پروژه برای شما ارسال شده باشد. در این بخش می‌توانید به تبادل نظر و گفتگو بپردازید.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full is-resized\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-8.png\"><img loading=\"lazy\" decoding=\"async\" width=\"753\" height=\"526\" src=\"https://fa.wordpress.org/team/files/2025/02/image-8.png\" alt=\"\" class=\"wp-image-288\" style=\"width:593px;height:auto\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-8.png 753w, https://fa.wordpress.org/team/files/2025/02/image-8-300x210.png 300w\" sizes=\"auto, (max-width: 753px) 100vw, 753px\"></a></figure>\n\n\n\n<ul class=\"wp-block-list\">\n<li>اگر مشارکت شما ادامه‌دار و مؤثر باشد، می‌توانید به عضویت تیم مترجمان ارشد درآیید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۲. عبارات فنی و نامفهوم</strong></p>\n\n\n\n<p>عبارات فنی یا کدها در متن اصلی ممکن است باعث سردرگمی شوند، به‌ویژه اگر با اصطلاحات برنامه‌نویسی آشنایی کافی نداشته باشید.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>از واژه‌نامه‌ وردپرس استفاده نمایید.</li>\n\n\n\n<li>اگر عبارت کاملاً نامفهوم است، با جامعه مترجمان مشورت کنید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۳. رعایت استانداردهای نگارشی</strong></p>\n\n\n\n<p>رعایت نیم‌فاصله، نقطه‌گذاری و سایر استانداردهای نگارشی ممکن است در طول ترجمه فراموش شود.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>از ابزارهای ویرایش متن با قابلیت بررسی نگارشی (مانند ویراستیار) استفاده نمایید.</li>\n\n\n\n<li>پیش از ارسال، متن ترجمه‌شده را بازبینی نمایید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۴. واژه‌های بدون معادل فارسی مناسب</strong></p>\n\n\n\n<p>برخی از واژه‌ها، مانند اصطلاحات تخصصی یا مفاهیم نوین، معادل دقیقی در فارسی ندارند.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>از معادل‌های جاافتاده در واژه‌نامه وردپرس استفاده نمایید.</li>\n\n\n\n<li>اگر معادل مناسبی وجود ندارد، توضیح ساده و روانی ارائه دهید که برای کاربران قابل درک باشد.</li>\n\n\n\n<li>با مدیران ترجمه در میان بگذارید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۵. طولانی بودن برخی رشته‌ها</strong></p>\n\n\n\n<p>رشته‌هایی که بیش از حد طولانی هستند ممکن است خوانایی را کاهش دهند.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>ترجمه را به بخش‌های کوتاه‌تر تقسیم کنید تا خوانایی افزایش یابد.</li>\n\n\n\n<li>از جملات روان و ساده استفاده نمایید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۶. تداخل با ترجمه‌های دیگر</strong></p>\n\n\n\n<p>ممکن است چند نفر روی یک پروژه کار کنند و ترجمه‌ها با یکدیگر ناسازگار باشند.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>از ابتدا واژه‌نامه‌ها و استانداردهای پروژه را مرور کنید.</li>\n\n\n\n<li>همکاری و تعامل با دیگر مترجمان را جدی بگیرید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۷. مدیریت زمان و حجم کار</strong></p>\n\n\n\n<p>پروژه‌های بزرگ مانند ترجمه هسته وردپرس یا افزونه‌های معروف ممکن است زمان زیادی ببرند.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>ابتدا روی رشته‌های مهم‌تر و پرکاربردتر تمرکز نمایید.</li>\n\n\n\n<li>فقط رشته‌های کوتاه و تک کلمه‌ای رو ترجمه نکنید.</li>\n\n\n\n<li>مشارکت را به‌صورت تیمی انجام دهید تا بار کار تقسیم شود.</li>\n</ul>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>نکات نهایی ترجمه وردپرس فارسی</strong></h3>\n\n\n\n<p><strong>۱. پایبندی به زبان فارسی</strong></p>\n\n\n\n<p>تحت هیچ شرایطی در ترجمه از کلمات انگلیسی یا فینگلیش استفاده نکنید. فارسی نوشتن کلمه انگلیسی (مثال: پست‌تایپ) مجاز نیست.</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۲. ساده‌نویسی و روان‌نویسی</strong></p>\n\n\n\n<p>از کلمات پیچیده و جملات طولانی پرهیز نمایید. سادگی و روانی ترجمه، تجربه کاربری بهتری برای مخاطبان فراهم می‌کند.</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۳. تنظیم طول متن‌ها</strong></p>\n\n\n\n<p>ترجمه‌ها باید از نظر طول با متن اصلی هماهنگ باشند. این موضوع به‌ویژه در مواردی که فضا محدود است، مانند دکمه‌ها یا منوها، اهمیت دارد.</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۴. همکاری با دیگر مترجمان</strong></p>\n\n\n\n<p>با دیگر مترجمان در پروژه‌ها همکاری نمایید و از بازخورد آن‌ها برای بهبود کار خود استفاده کنید. همچنین می‌توانید ترجمه‌های پیشنهادی آن‌ها را مطالعه و ایده بگیرید.</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۵. استفاده از قابلیت‌های GlotPress</strong></p>\n\n\n\n<p>در پلتفرم ترجمه وردپرس (GlotPress)، قابلیت‌هایی وجود دارد که می‌توانند کار شما را آسان‌تر نمایند:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>فیلتر رشته‌ها</strong>: برای تمرکز روی ترجمه‌های ناقص یا رشته‌های خاص.</li>\n\n\n\n<li><strong>حالت جستجو</strong>: برای یافتن کلمات یا عبارات خاص در تمام پروژه.</li>\n</ul>\n\n\n\n<p><strong>۶. ابزارهای کمکی آنلاین</strong></p>\n\n\n\n<p>برای بهبود کیفیت ترجمه، می‌توانید از ابزارهای آنلاین مانند Google Translate، DeepL یا <a href=\"https://targoman.ir/\">ترگمان</a> استفاده نمایید. این ابزارها به‌ویژه در ارائه ترجمه اولیه رشته‌های طولانی مفید هستند، اما باید توجه داشته باشید که ترجمه‌ها نیاز به بازبینی و اصلاح و جایگزینی با واژه‌نامه را دارند تا با استانداردهای وردپرس مطابقت داشته باشند.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>پایان: گامی در جهت بهبود وردپرس فارسی</strong></h3>\n\n\n\n<p>مشارکت در ترجمه وردپرس فارسی نه تنها فرصتی برای یادگیری و ارتقای مهارت‌های زبانی و فنی شماست، بلکه اقدامی ارزشمند برای بهبود تجربه کاربری میلیون‌ها کاربر فارسی‌زبان به‌شمار می‌رود. ترجمه باکیفیت و استاندارد، استفاده از وردپرس را ساده‌تر و لذت‌بخش‌تر می‌نماید و جامعه‌ای قوی‌تر و پویا‌تر ایجاد می‌کند.</p>\n\n\n\n<p>در این مقاله، با مراحل مختلف مشارکت در ترجمه، ابزارهای مورد نیاز، چالش‌ها و راهکارها آشنا شدید. هر یک از شما می‌توانید با اختصاص زمان و استفاده از راهنمایی‌های ارائه‌شده، تأثیری مثبت و ماندگار در این پروژه جهانی داشته باشید.</p>\n\n\n\n<p>اگر شما هم به وردپرس علاقه دارید، اکنون زمان مناسبی برای شروع مشارکت است. با ثبت‌نام در بخش ترجمه و همکاری با دیگر اعضای جامعه مترجمان، به یکی از ستون‌های اصلی در توسعه و پیشرفت وردپرس فارسی تبدیل شوید.</p>\n\n\n\n<p>با همکاری، تعهد و تلاش جمعی، می‌توانیم وردپرس فارسی را به سطحی جدید برسانیم و به کاربران بیشتری کمک کنیم تا از این ابزار قدرتمند به ساده‌ترین و بهترین شکل ممکن بهره‌مند شوند.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>این نوشته به مرور به‌روز خواهد شد و موارد و نکات جدیدتر به آن اضافه خواهد شد.</p>\n\n\n\n<p><strong>در صورت داشتن سؤال یا نیاز به راهنمایی، از بخش دیدگاه‌ها استفاده نمایید و پرسش خود را در اینجا مطرح کنید تا راهنمایی لازم دریافت نمایید.</strong></p>\n</blockquote>\n\n\n<div class=\"wp-block-post-author has-large-font-size\"><div class=\"wp-block-post-author__avatar\"><img alt=\"\" src=\"https://secure.gravatar.com/avatar/205c7baf65283c61a8c0a6b6559680fda83297a11c809ec031f5200073e65e0d?s=96&amp;d=mm&amp;r=g\" srcset=\"https://secure.gravatar.com/avatar/205c7baf65283c61a8c0a6b6559680fda83297a11c809ec031f5200073e65e0d?s=192&amp;d=mm&amp;r=g 2x\" class=\"avatar avatar-96 photo\" height=\"96\" width=\"96\"></div><div class=\"wp-block-post-author__content\"><p class=\"wp-block-post-author__byline\">نوشته شده توسط سعید فرد از وردپرس فارسی</p><p class=\"wp-block-post-author__name\"><a href=\"https://profiles.wordpress.org/saeedfard/\" target=\"_self\">Saeed Fard</a></p></div></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://fa.wordpress.org/team/2025/02/14/how-to-contribute-translation/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"222\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"پیوستن به گروه مترجمین و توسعه دهندگان وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:240:\"https://fa.wordpress.org/team/2024/04/21/%d9%be%db%8c%d9%88%d8%b3%d8%aa%d9%86-%d8%a8%d9%87-%da%af%d8%b1%d9%88%d9%87-%d9%85%d8%aa%d8%b1%d8%ac%d9%85%db%8c%d9%86-%d9%88-%d8%aa%d9%88%d8%b3%d8%b9%d9%87-%d8%af%d9%87%d9%86%d8%af%da%af%d8%a7%d9%86/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:249:\"https://fa.wordpress.org/team/2024/04/21/%d9%be%db%8c%d9%88%d8%b3%d8%aa%d9%86-%d8%a8%d9%87-%da%af%d8%b1%d9%88%d9%87-%d9%85%d8%aa%d8%b1%d8%ac%d9%85%db%8c%d9%86-%d9%88-%d8%aa%d9%88%d8%b3%d8%b9%d9%87-%d8%af%d9%87%d9%86%d8%af%da%af%d8%a7%d9%86/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 21 Apr 2024 16:51:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"مطالب\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=201\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:605:\"با درود،با توجه به محدودیت‌هایی که در Slack برای کاربران ایرانی وجود دارد، تیم وردپرس فارسی، از تلگرام برای هماهنگی و ارتباط تیم استفاده می‌کند. لذا از تمامی مترجمین و توسعه دهندگان فارسی، درخواست می‌شود تا در گروه تلگرامی “توسعه دهندگان وردپرس فارسی” به آدرس زیر: https://t.me/wpdevelopers و همچنین کانال مربوطه به آدرس: https://t.me/fa_wordpress عضو [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Farhad Sakhaei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:22925:\"<p>با درود،<br>با توجه به محدودیت‌هایی که در Slack برای کاربران ایرانی وجود دارد، تیم وردپرس فارسی، از تلگرام برای هماهنگی و ارتباط تیم استفاده می‌کند. لذا از تمامی مترجمین و توسعه دهندگان فارسی، درخواست می‌شود تا در گروه تلگرامی “توسعه دهندگان وردپرس فارسی” به آدرس زیر:</p>\n\n\n\n<p class=\"has-text-align-center\"><a href=\"https://t.me/wpdevelopers\">https://t.me/wpdevelopers</a></p>\n\n\n\n<p>و همچنین کانال مربوطه به آدرس:</p>\n\n\n\n<p class=\"has-text-align-center\"><a href=\"https://t.me/fa_wordpress\">https://t.me/fa_wordpress</a></p>\n\n\n\n<p>عضو شوند تا هماهنگی‌های لازم برای ترجمه‌ها و توسعه‌ها، صورت پذیرد. ضمنا جهت ارتباط بهتر و پیگیری‌های مورد نیاز، لطفا در زیرگروه “معرفی مترجمین”، <strong>ایمیل مربوط به حساب کاربری وردپرس</strong> خود و <strong>شناسه تلگرام</strong> خود را اعلام نمایید تا ارتباط بهتر و سریعتری برای موارد مورد نیاز صورت پذیرد.</p>\n\n\n\n<p>با سپاس</p>\n\n\n\n<p dir=\"ltr\"><a href=\"https://profiles.wordpress.org/farhad0/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>farhad0</a> <a href=\"https://profiles.wordpress.org/man4toman/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>man4toman</a> <a href=\"https://profiles.wordpress.org/saeedfard/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>SaeedFard</a> <a href=\"https://profiles.wordpress.org/sushyant/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sushyant</a> <a href=\"https://profiles.wordpress.org/asadiy4n/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>asadiy4n</a> <a href=\"https://profiles.wordpress.org/cg-team/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>CG-TEAM</a> <a href=\"https://profiles.wordpress.org/1farakav/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>1farakav</a> <a href=\"https://profiles.wordpress.org/ach1992/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ach1992</a> <a href=\"https://profiles.wordpress.org/aminfa/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>aminfa</a> <a href=\"https://profiles.wordpress.org/hadi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>hadi</a>.omid <a href=\"https://profiles.wordpress.org/yazdaniwp/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>yazdaniwp</a> <a href=\"https://profiles.wordpress.org/aminomidi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>aminomidi</a> <a href=\"https://profiles.wordpress.org/360messenger/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>360messenger</a> <a href=\"https://profiles.wordpress.org/addeveloper/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>addeveloper</a> <a href=\"https://profiles.wordpress.org/affiliatenetworks/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>affiliatenetworks</a> <a href=\"https://profiles.wordpress.org/ahangarha/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ahangarha</a> <a href=\"https://profiles.wordpress.org/aliarjini/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>aliarjini</a> <a href=\"https://profiles.wordpress.org/aliasghar1112/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>aliasghar1112</a> <a href=\"https://profiles.wordpress.org/aligholami/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>aligholami</a> <a href=\"https://profiles.wordpress.org/alirashidnahal/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>alirashidnahal</a> <a href=\"https://profiles.wordpress.org/alixo/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>alixo</a> <a href=\"https://profiles.wordpress.org/alizadegan/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>alizadegan</a> <a href=\"https://profiles.wordpress.org/amatris/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>amatris</a> <a href=\"https://profiles.wordpress.org/ameskaran/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ameskaran</a> <a href=\"https://profiles.wordpress.org/amirarshia/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>amirarshia</a> <a href=\"https://profiles.wordpress.org/amirhosseinhpv/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>amirhosseinhpv</a> <a href=\"https://profiles.wordpress.org/amirhpcom/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>amirhpcom</a> <a href=\"https://profiles.wordpress.org/antialiasfactory/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>antialiasfactory</a> <a href=\"https://profiles.wordpress.org/ardalan13/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ardalan13</a> <a href=\"https://profiles.wordpress.org/ariankeshavarz/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ariankeshavarz</a> <a href=\"https://profiles.wordpress.org/armansiahloo/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>armansiahloo</a> <a href=\"https://profiles.wordpress.org/armenab1/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>armenab1</a> <a href=\"https://profiles.wordpress.org/arshen/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Arshen</a> <a href=\"https://profiles.wordpress.org/arvancloud/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>arvancloud</a> <a href=\"https://profiles.wordpress.org/as911/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>as911</a> <a href=\"https://profiles.wordpress.org/asterids/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>asterids</a> <a href=\"https://profiles.wordpress.org/aydin714/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>aydin714</a> <a href=\"https://profiles.wordpress.org/basemax/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>basemax</a> <a href=\"https://profiles.wordpress.org/bbkysf/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>bbkysf</a> <a href=\"https://profiles.wordpress.org/blackswanlab/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>blackswanlab</a> <a href=\"https://profiles.wordpress.org/bmoudi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>bmoudi</a> <a href=\"https://profiles.wordpress.org/chilisearch/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>chilisearch</a> <a href=\"https://profiles.wordpress.org/dedidata/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>dedidata</a> <a href=\"https://profiles.wordpress.org/digikotcom/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>digikotcom</a> <a href=\"https://profiles.wordpress.org/djamir121/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>djamir121</a> <a href=\"https://profiles.wordpress.org/domiinodev/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>domiinodev</a> <a href=\"https://profiles.wordpress.org/ebrahimzadeh/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ebrahimzadeh</a> <a href=\"https://profiles.wordpress.org/ee_persian/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ee_persian</a> <a href=\"https://profiles.wordpress.org/elementorir/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>elementorir</a> <a href=\"https://profiles.wordpress.org/ercmanager1/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ercmanager1</a> <a href=\"https://profiles.wordpress.org/esmailfadaei/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>esmailfadaei</a> <a href=\"https://profiles.wordpress.org/farokhheidari/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>farokhheidari</a> <a href=\"https://profiles.wordpress.org/farshadhz/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>farshadhz</a> <a href=\"https://profiles.wordpress.org/feredi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>feredi</a> <a href=\"https://profiles.wordpress.org/foadadeli/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>foadadeli</a> <a href=\"https://profiles.wordpress.org/gamefa/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>gamefa</a> <a href=\"https://profiles.wordpress.org/ghasemi71ir/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ghasemi71ir</a> <a href=\"https://profiles.wordpress.org/ghtali/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ghtali</a> <a href=\"https://profiles.wordpress.org/glboy/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>glboy</a> <a href=\"https://profiles.wordpress.org/goudarz/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Goudarz</a> <a href=\"https://profiles.wordpress.org/h71/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>h71</a> <a href=\"https://profiles.wordpress.org/ham3da/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ham3da</a> <a href=\"https://profiles.wordpress.org/hanieh729/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>hanieh729</a> <a href=\"https://profiles.wordpress.org/hassantafreshi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>hassantafreshi</a> <a href=\"https://profiles.wordpress.org/hitsteps/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>hitsteps</a> <a href=\"https://profiles.wordpress.org/hosseinsadeghi69/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>hosseinsadeghi69</a> <a href=\"https://profiles.wordpress.org/hsnshfn/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>hsnshfn</a> <a href=\"https://profiles.wordpress.org/imikiani/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>imikiani</a> <a href=\"https://profiles.wordpress.org/infomtaghavi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>infomtaghavi</a> <a href=\"https://profiles.wordpress.org/irangold/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>irangold</a> <a href=\"https://profiles.wordpress.org/irdb/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>irdb</a> <a href=\"https://profiles.wordpress.org/johnbozorgi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>johnbozorgi</a> <a href=\"https://profiles.wordpress.org/kafrashi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>kafrashi</a> <a href=\"https://profiles.wordpress.org/kamalireal/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>kamalireal</a> <a href=\"https://profiles.wordpress.org/kamrankhorsandi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>kamrankhorsandi</a> <a href=\"https://profiles.wordpress.org/kashani/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>kashani</a> <a href=\"https://profiles.wordpress.org/khorshidlab/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>khorshidlab</a> <a href=\"https://profiles.wordpress.org/longman2020/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>longman2020</a> <a href=\"https://profiles.wordpress.org/lord_viper/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>lord_viper</a> <a href=\"https://profiles.wordpress.org/lusha/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>lusha</a> <a href=\"https://profiles.wordpress.org/m0911/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>m0911</a> <a href=\"https://profiles.wordpress.org/mahdi6489/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mahdi6489</a> <a href=\"https://profiles.wordpress.org/mahdiebrahimii/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mahdiebrahimii</a> <a href=\"https://profiles.wordpress.org/mahdiyerezaie/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mahdiyerezaie</a> <a href=\"https://profiles.wordpress.org/mahdyarme/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mahdyarme</a> <a href=\"https://profiles.wordpress.org/mainseo/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mainseo</a> @manzoorwani.jk <a href=\"https://profiles.wordpress.org/mashhadcode/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mashhadcode</a> <a href=\"https://profiles.wordpress.org/masoudnkh/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>masoudnkh</a> <a href=\"https://profiles.wordpress.org/matinbeigi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>matinbeigi</a> <a href=\"https://profiles.wordpress.org/mazraee/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mazraee</a> <a href=\"https://profiles.wordpress.org/mehdibolourian/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mehdibolourian</a> <a href=\"https://profiles.wordpress.org/mehr/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Mehr</a>.Ban <a href=\"https://profiles.wordpress.org/mehrshad81/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mehrshad81</a> <a href=\"https://profiles.wordpress.org/mehrshaddarzi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mehrshaddarzi</a> <a href=\"https://profiles.wordpress.org/mhmanavi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mhmanavi</a> <a href=\"https://profiles.wordpress.org/michaelpk/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>michaelpk</a> <a href=\"https://profiles.wordpress.org/mihanwp/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mihanwp</a> <a href=\"https://profiles.wordpress.org/milad47/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Milad47</a> <a href=\"https://profiles.wordpress.org/mo0orteza/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Mo0orTeZa</a> <a href=\"https://profiles.wordpress.org/moccc/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>moccc</a> <a href=\"https://profiles.wordpress.org/mohadeseghasemi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mohadeseghasemi</a> <a href=\"https://profiles.wordpress.org/mohammad9574/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mohammad9574</a> <a href=\"https://profiles.wordpress.org/mohammadhero/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mohammadhero</a> <a href=\"https://profiles.wordpress.org/mohsengham/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mohsengham</a> <a href=\"https://profiles.wordpress.org/mohsenpazhoohiyani/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mohsenpazhoohiyani</a> <a href=\"https://profiles.wordpress.org/mojtaba-taheri/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mojtaba-taheri</a> <a href=\"https://profiles.wordpress.org/mojtabad/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mojtabad</a> <a href=\"https://profiles.wordpress.org/moreconvert/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>moreconvert</a> <a href=\"https://profiles.wordpress.org/mostafa/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mostafa</a>.s1990 <a href=\"https://profiles.wordpress.org/mostafarouz/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mostafarouz</a> <a href=\"https://profiles.wordpress.org/motefaghehi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>motefaghehi</a> <a href=\"https://profiles.wordpress.org/motlaqcode/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>motlaqcode</a> <a href=\"https://profiles.wordpress.org/mralidoosti/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mralidoosti</a> <a href=\"https://profiles.wordpress.org/msn6060/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>msn6060</a> <a href=\"https://profiles.wordpress.org/msninsider/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>msninsider</a> <a href=\"https://profiles.wordpress.org/narimonfund/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>narimonfund</a> <a href=\"https://profiles.wordpress.org/native0098/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>native0098</a> <a href=\"https://profiles.wordpress.org/navidos/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>navidos</a> <a href=\"https://profiles.wordpress.org/niloomand/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>niloomand</a> <a href=\"https://profiles.wordpress.org/nima78600/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>nima78600</a> <a href=\"https://profiles.wordpress.org/nirweb/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>nirweb</a> <a href=\"https://profiles.wordpress.org/novinhub/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>novinhub</a> <a href=\"https://profiles.wordpress.org/otoraby/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>otoraby</a> <a href=\"https://profiles.wordpress.org/parnibraan/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>parnibraan</a> <a href=\"https://profiles.wordpress.org/parselearn/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>parselearn</a> <a href=\"https://profiles.wordpress.org/parsmizban/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>parsmizban</a> <a href=\"https://profiles.wordpress.org/pash2048/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>pash2048</a> <a href=\"https://profiles.wordpress.org/payzito/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>payzito</a> @pctricks.ir <a href=\"https://profiles.wordpress.org/pedramrahimi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>pedramrahimi</a> <a href=\"https://profiles.wordpress.org/pegahnorozi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>pegahnorozi</a> <a href=\"https://profiles.wordpress.org/peprodev/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>peprodev</a> <a href=\"https://profiles.wordpress.org/persianscript/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Persianscript</a> <a href=\"https://profiles.wordpress.org/piman/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>piman</a> <a href=\"https://profiles.wordpress.org/pingmeter/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>pingmeter</a> <a href=\"https://profiles.wordpress.org/poolito/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>poolito</a> <a href=\"https://profiles.wordpress.org/porsline/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>porsline</a> <a href=\"https://profiles.wordpress.org/poshtibancom/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>poshtibancom</a> <a href=\"https://profiles.wordpress.org/qodeinteractive/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>qodeinteractive</a> <a href=\"https://profiles.wordpress.org/qwerty13/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>qwerty13</a> <a href=\"https://profiles.wordpress.org/rahmatmajidi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rahmatmajidi</a> <a href=\"https://profiles.wordpress.org/rajaeinet/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rajaeinet</a> <a href=\"https://profiles.wordpress.org/rarathemesupport/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rarathemesupport</a> <a href=\"https://profiles.wordpress.org/sadeghpm/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sadeghpm</a> <a href=\"https://profiles.wordpress.org/saeed_same/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>saeed_same</a> <a href=\"https://profiles.wordpress.org/safelayout/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>safelayout</a> <a href=\"https://profiles.wordpress.org/sahabi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sahabi</a> <a href=\"https://profiles.wordpress.org/sajjadtalebi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sajjadtalebi</a> <a href=\"https://profiles.wordpress.org/salamzadeh/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Salamzadeh</a> <a href=\"https://profiles.wordpress.org/salarlotfi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>salarlotfi</a> <a href=\"https://profiles.wordpress.org/salemi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>salemi</a> <a href=\"https://profiles.wordpress.org/salman1990/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>salman1990</a> <a href=\"https://profiles.wordpress.org/samanehmirrajabi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>samanehmirrajabi</a> <a href=\"https://profiles.wordpress.org/samtemehr/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>samtemehr</a> <a href=\"https://profiles.wordpress.org/saniamohammadi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>saniamohammadi</a> <a href=\"https://profiles.wordpress.org/sareham238/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sareham238</a> <a href=\"https://profiles.wordpress.org/sazmankav/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sazmankav</a> <a href=\"https://profiles.wordpress.org/seramo/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>seramo</a> <a href=\"https://profiles.wordpress.org/shayanfp/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>shayanfp</a> <a href=\"https://profiles.wordpress.org/shokrino/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>shokrino</a> <a href=\"https://profiles.wordpress.org/silvercover/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>silvercover</a> <a href=\"https://profiles.wordpress.org/sinashams/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sinashams</a> <a href=\"https://profiles.wordpress.org/smm1378/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>smm1378</a> <a href=\"https://profiles.wordpress.org/smrm/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>smrm</a> <a href=\"https://profiles.wordpress.org/soheilmir/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>soheilmir</a> <a href=\"https://profiles.wordpress.org/sunyniazi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sunyniazi</a> <a href=\"https://profiles.wordpress.org/tadeha/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>tadeha</a> <a href=\"https://profiles.wordpress.org/translationsbysemperplugins/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>translationsbysemperplugins</a> <a href=\"https://profiles.wordpress.org/tsina/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>tsina</a> <a href=\"https://profiles.wordpress.org/untashgaal/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>untashgaal</a> <a href=\"https://profiles.wordpress.org/vadatiertebat/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>vadatiertebat</a> <a href=\"https://profiles.wordpress.org/weloper/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>weloper</a> <a href=\"https://profiles.wordpress.org/worldless/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>worldless</a> <a href=\"https://profiles.wordpress.org/wpvar/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>wpvar</a> <a href=\"https://profiles.wordpress.org/yashar_hv/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>yashar_hv</a> <a href=\"https://profiles.wordpress.org/yasser1992/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>yasser1992</a> <a href=\"https://profiles.wordpress.org/ynproduct/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ynproduct</a> <a href=\"https://profiles.wordpress.org/zareidev/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>zareidev</a> <a href=\"https://profiles.wordpress.org/zeroone2021/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>zeroone2021</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:245:\"https://fa.wordpress.org/team/2024/04/21/%d9%be%db%8c%d9%88%d8%b3%d8%aa%d9%86-%d8%a8%d9%87-%da%af%d8%b1%d9%88%d9%87-%d9%85%d8%aa%d8%b1%d8%ac%d9%85%db%8c%d9%86-%d9%88-%d8%aa%d9%88%d8%b3%d8%b9%d9%87-%d8%af%d9%87%d9%86%d8%af%da%af%d8%a7%d9%86/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"201\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"معرفی تیم وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:159:\"https://fa.wordpress.org/team/2024/02/17/%d9%85%d8%b9%d8%b1%d9%81%db%8c-%d8%aa%db%8c%d9%85-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:167:\"https://fa.wordpress.org/team/2024/02/17/%d9%85%d8%b9%d8%b1%d9%81%db%8c-%d8%aa%db%8c%d9%85-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 17 Feb 2024 13:06:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"مطالب\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=145\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:509:\"تیم وردپرس فارسی یک تشکیل کاملا مستقل است که وابسته به هیچگونه سازمان و یا شرکتی نمی باشد، پروژه وردپرس فارسی به هیچ شخص و یا گروه خاصی تعلق ندارد و توسط تیم وردپرس فارسی که به صورت داوطلبانه فعالیت می کنند، اداره می شود. این بخش از سایت وردپرس، مخصوص تیم وردپرس فارسی می‌باشد. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Farhad Sakhaei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:75228:\"<p>تیم وردپرس فارسی یک تشکیل کاملا مستقل است که وابسته به هیچگونه سازمان و یا شرکتی نمی باشد، پروژه وردپرس فارسی به هیچ شخص و یا گروه خاصی تعلق ندارد و توسط تیم وردپرس فارسی که به صورت داوطلبانه فعالیت می کنند، اداره می شود. این بخش از سایت وردپرس، مخصوص تیم وردپرس فارسی می‌باشد. شما می‌توانید اخبار و رویدادهای مربوط به تیم وردپرس فارسی را در اینجا دنبال کنید و در صورت تمایل در ترجمه وردپرس مشارکت کنید.</p>\n\n\n\n<h2 class=\"wp-block-heading\">اعضای تیم وردپرس فارسی</h2>\n\n\n\n<h3 class=\"wp-block-heading has-text-align-center\">مدیران بخش فارسی وردپرس</h3>\n\n\n\n<div class=\"wp-block-group is-content-justification-space-between is-layout-flex wp-container-core-group-is-layout-9366075c wp-block-group-is-layout-flex\">\n<div class=\"wp-block-group is-vertical is-content-justification-center is-nowrap is-layout-flex wp-container-core-group-is-layout-671c4991 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://profiles.wordpress.org/farhad0\" target=\"_blank\" rel=\"noreferrer noopener\"><img decoding=\"async\" src=\"https://secure.gravatar.com/avatar/0ebc32f2dc5921020c3b62738f4fa058?s=160&amp;d=mm&amp;r=g\" alt=\"\"></a></figure>\n\n\n\n<p class=\"has-medium-font-size\"><strong><a href=\"https://profiles.wordpress.org/farhad0\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/farhad0\">فرهاد سخایی</a></strong></p>\n</div>\n\n\n\n<div class=\"wp-block-group is-vertical is-content-justification-center is-nowrap is-layout-flex wp-container-core-group-is-layout-671c4991 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://profiles.wordpress.org/man4toman\" target=\"_blank\" rel=\"noreferrer noopener\"><img decoding=\"async\" src=\"https://secure.gravatar.com/avatar/0223bc303222e11c85b7e780e929bafa?s=160&amp;d=mm&amp;r=g\" alt=\"\"></a></figure>\n\n\n\n<p class=\"has-medium-font-size\"><strong><a href=\"https://profiles.wordpress.org/man4toman\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/man4toman\" target=\"_blank\" rel=\"noreferrer noopener\">مرتضی گرانسایه</a></strong></p>\n</div>\n\n\n\n<div class=\"wp-block-group is-vertical is-content-justification-center is-nowrap is-layout-flex wp-container-core-group-is-layout-d7b04dc7 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://profiles.wordpress.org/saeedfard\" target=\"_blank\" rel=\"noreferrer noopener\"><img decoding=\"async\" src=\"https://secure.gravatar.com/avatar/218e2e8376f15e9d72de62b7a3c28fd4?s=160&amp;d=mm&amp;r=g\" alt=\"\"></a></figure>\n\n\n\n<p class=\"has-text-align-center has-medium-font-size\"><strong><a href=\"https://profiles.wordpress.org/saeedfard\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/saeedfard\" target=\"_blank\" rel=\"noreferrer noopener\">سعید فرد</a></strong></p>\n</div>\n\n\n\n<div class=\"wp-block-group is-vertical is-content-justification-center is-nowrap is-layout-flex wp-container-core-group-is-layout-d7b04dc7 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://profiles.wordpress.org/sushyant\" target=\"_blank\" rel=\"noreferrer noopener\"><img decoding=\"async\" src=\"https://secure.gravatar.com/avatar/6a35a072c0766d41217d17317f3ea057?s=160&amp;d=mm&amp;r=g\" alt=\"\"></a></figure>\n\n\n\n<p class=\"has-medium-font-size\"><strong><a href=\"https://profiles.wordpress.org/sushyant\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/sushyant\" target=\"_blank\" rel=\"noreferrer noopener\">سوشیانت زوار زاده</a></strong></p>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">ویراستاران ترجمه پروژه‌های وردپرس</h2>\n\n\n\n<div style=\"clear:both;overflow: hidden\">\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/1farakav/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2ac90d3243016ceb85b794693cb21517?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>1farakav</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/360messenger/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/15e0ea462c4401f4f72ecac44e3d748c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>360messenger</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ach1992/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/210dd07c37484e1ee09f39e0dbe5a98e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ACh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/addeveloper/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/cdfb2b2f869b117b3c7a717f1a0f5199?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ADDeveloper</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/affiliatenetworks/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e7f2577d1c64018b09ee9113cd006c8c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>affiliatenetworks</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ahangarha/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/a7f24279a1c7eb9edfcd4bbfa6405844?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ahangarha</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/translationsbysemperplugins/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/613ec4dc7a0323e1e04e0484b532e570?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>AIOSEO Translations</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/alizadegan/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/b596479b88c6b78ca32bc068be75bbf7?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Ali Alizadegan</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/aliarjini/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/cf8c1b74d58c3b8ea98b3262e0ae7ebe?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ali arjini</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/alixo/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d60e3dc2dee03a210fe16337c2021c1c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Ali Esmaeili</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/aligholami/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/32919c054088aa3dff571ab81c3f5d76?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Ali Gholami</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/alirashidnahal/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d2cc791ce1a9291e06775a1b24c3197e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Ali Rashidnahal</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/as911/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/28dc5ad2aa7ccc44413057b033a536d4?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Alireza Sedghi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/amatris/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/24758bce866aeb6316f1256e3a1244e2?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>amatris</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ameskaran/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/9cb2521ac836b8c7f042396f1f39a914?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ameskaran</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/aminfa/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/91a34f1a502004701d8ad2c1e715f3a6?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>amin askari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sazmankav/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/bcb756ce8bff9ae05111fc4dc73b8eaa?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Amin Mahjoor</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/aminomidi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3959eb01b3eca2ac83ec36cbf9f0e9a5?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Amin Omidi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/amirarshia/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/347edea6a33c515fdf20f24240307c20?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>amirarshia</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/djamir121/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e8eb5ca949a93d2606dc215593e0b2f3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>AMIR Heydari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/amirhpcom/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/a4b904ff316d7c98496108e651441624?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Amirhossein Hosseinpour</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/amirhosseinhpv/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2f6329ce417480573782224099734deb?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>amirhp-com</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/native0098/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/89f22ae87a917b049b02728446c52372?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ARash Ghanei</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ardalan13/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/760d071079d3ab12e22c545501811838?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Ardalan Davoudi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/aliasghar1112/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3ffb886ffd1fe939559438c733b3a453?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>arian</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ariankeshavarz/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/91d82f7845cd8c3cf4354b8362a669f4?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Arian Keshavarz</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/armansiahloo/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/1e3fd783b8d49b7f08c8e153548f5673?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>arman siahloo</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/arvancloud/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/08b43a96759f4737ef6d334030e7b873?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ArvanCloud</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/asadiy4n/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d81955a0f2c8d1b676735b19840fe957?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Asadiyan</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/asterids/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/99ad47b6ac94e4d14028d774771f68bc?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>asterids</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/aydin714/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/8c78459453fee125531ec04d413c7c26?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>aydin714</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/bbkysf/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3276f73903245fe62deffb331ee11de5?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Babak Yousefzadeh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/bmoudi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fcc97bddef8d4e7b89a1911c06d75697?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Bijan Moudi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/blackswanlab/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/1fd03d88ea9dc937939fd0d655df155b?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>BlackSwan</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/chilisearch/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/cc10b45b85557af4b3b5c6022c4f4a05?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Chili Search</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/dedidata/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f69a56c77882b62840c5f2a40cd1b087?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>DediData</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/digikotcom/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/381714b60533b546fa0b824717122524?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>digikot.com</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/domiinodev/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ec7ccdac8fceb213e8e367ea310acc3d?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Domino dev</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/parnibraan/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c121b76ce158eb2a7b88d7535d50e69e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ehsaan</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ercmanager1/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/64cb2605e604942bc16980498672f36e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ercmanager1</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ee_persian/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/319abf373a18f8bb53935a50ea681fdc?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>esmail ebrahimi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/esmailfadaei/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/db9d5507ce8b01a54c1b2c48593c16d7?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>esmailfadaei</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/feredi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3f7819027cef1619a8ab2fa678042736?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Farhad Fariborzi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/farokhheidari/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/9da3725eed363a40e6c1a9e4ce59a818?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>farokhheidari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/farshadhz/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/bae20c1e448d7ed3205e061f2b6571e5?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>farshadhz</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/arshen/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/5ad52ff159fc7d8fc5fe85288cb82319?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Foad Tahmasebi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ghtali/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/81ea8ef483e5fc8d53184fbfbe8c4f8e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ghtali</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/goudarz/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/5f663c942d32cc77e51b7ae94a199023?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Goudarz Jafari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/hadiomid/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f8ecf070e8d4649c5f03c36a66171eb9?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>hadi.omid</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/silvercover/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3ced7aa268d0a80d29cee2731a5f589a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hamed Takmil</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/yazdaniwp/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f62756a112ab1b86500c54beaea6dfbd?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hamid Reza Yazdani</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/hanieh729/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2cec9118b4afb3d5005c6ba298a5a8cb?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hanieh Ramzanpour</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/hsnshfn/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/8ae345e1d37b9c3c8eb9470f28929a75?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hassan Shafiian</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/hassantafreshi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/99a72de762392a5a5efbf36a4367f793?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>hassantafreshi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/hitsteps/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d1adb81e2590e1f3fa943e6865dbf459?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hitsteps</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/h71/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/8415a8ca663844689b6b0e5f49108e3d?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hossein</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/hosseinsadeghi69/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ec5e64b66b43016fa7b635e026569986?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hossein Sadeghi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/glboy/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/39910273e5a04bb79c64aa0c261d09dc?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>idehweb</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/imikiani/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/17575b917994c7f0273929220bb7f92f?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Iman Kiani</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/infomtaghavi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/796b1ab5fe2646f3ea525b01adbd5599?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>infomtaghavi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/irangold/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/901682cf57b32039d9559850f0871070?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>irangold</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/irdb/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e0ab2d106c7cae38d826b9ccd0b427e8?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>irdb</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ham3da/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f2d495a9435381aada34ba96535f1337?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Javad Ehteshami</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/pash2048/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/0bf24dc164ac15d58404ce6ccdf0e41c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>javad jazandari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/johnbozorgi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/cb66664459d45128adcff3ae34c99f4b?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>John Bozorgi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/kafrashi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/897230e3d4bc2af09e8cfc169fbc9ec4?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>kafrashi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/kamrankhorsandi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c134f741d1a58ce5713dca362c454b27?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Kamran Khorsandi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/gamefa/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/4a5f0fbba8fbc26592b2ec5a84b62f4c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>kasra naraghi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/khorshidlab/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d1005c02764ed93db28fc02af34cf9cc?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Khorshid</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/longman2020/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c3867746448950074bf44902501e851e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>longman2020</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/lusha/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/eb729c02496909a29b353fa110ff3abb?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>lumarsha</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mazraee/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ad7313e9868d0d311cbcd8df3a712fe3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>M. Mazraee</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mahdiebrahimii/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fe5eecdeba173ac42d31c888bff1b2a0?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mahdi Ebrahimi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mahdiyerezaie/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ccef3bc24c6020bad21752125d53bdd3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>mahdiyerezaie</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mahdyarme/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d0bf590292d00fefbc17b24e7388ea88?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mahdyar Hasanpour</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mainseo/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/1ad550fce817bb096a7fe0eedefd0a41?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>mainseo</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/manzoorwanijk/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ff0fc68d4d69124a38b4aed217a74ff5?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Manzoor Wani (a11n)</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mashhadcode/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/9b1414b9617f8e7345a01d10073030b9?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>mashhadcode</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/masoudnkh/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ba3555901bd8c8f5a160af53e67b8ab8?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Masoud NKH</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/matinbeigi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c9c10181d66be41f25c2fbe17658011e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Matin Beigi (Rick Sanchez)</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/basemax/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3cfbe47b6fb1f7c03467b2be20a1904f?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Max Base</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/antialiasfactory/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/1120e8649e76041919b334447228ffd7?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Maziar Firuzmand</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/m0911/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/73faf14ee55c29babb265e20ac22beff?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mehdi Abdollahi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mehdibolourian/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f64880371f196af7f5d3490954f5d08d?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mehdi Bolourian</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/msn6060/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f82de68ee8cac799acd5b841e5dbf026?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mehdi Soltani</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mehrban/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/301e39948cca7b82c50222dce2f6464c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mehr@Ban</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mehrshaddarzi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d88c9733e7ed1deda936e848ee629e63?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mehrshad Darzi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mehrshad81/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2fada5712ee0951795edd9b43eef90a3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mehrshad MTI</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/weloper/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/298fae8b228d3d680c5b6b37b1caddb3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mersad GHasemi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mhmanavi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c1ce302525f2e6e3f63d1535d86b178a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>mhmanavi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/michaelpk/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/82343eb50a4d3334144ed232ad8dfacf?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>michaelpk</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mihanwp/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/14144c1a63d0d1cf77ce4629ed77559c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>MihanWP</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/lord_viper/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fed8d40c5a576989ab0536611af3aea2?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mobin Ghasempoor</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/moccc/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/a175d00ddc61fdf6b7193fc7a8a82ab4?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>moccc</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mohadeseghasemi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/647aa1d91813a72b594705fdc93ee3fe?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mohadese Ghasemi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mohammad9574/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/1b213544ccfcc3eae61e4640eaa4733a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mohammad Ahmadi Akbari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ghasemi71ir/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/7173544c295e4da83c06463894924e24?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mohammad Ghasemi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mohammadhero/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d3cc70e26610175df37e29ad3058476b?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mohammad Hero</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/kamalireal/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/7d12ca5dd6b28c06fb3e6d9bab35d98c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>MohammadReza Kamali</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mohsenpazhoohiyani/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d1ec0de464dfa603266aafb57893190a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Moh Sen</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mohsengham/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/64d4e212c9263a72b2fcadbe3951342f?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mohsen Ghiasi Ravari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mojtaba-taheri/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/dadbd3df6db151c924279a85333be5d3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mojtaba</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mojtabad/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/bad8c41e73e002d4a356b6f45ea5cbea?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mojtaba Darvishi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/moreconvert/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/4aec5812e3db8673416ae1130567d24a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>moreconvert</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mo0orteza/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ff676fc8aefcaba0a322e26cf9b6e33c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Morteza Gholami</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mostafarouz/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/61cd3a411bf24f29129cc5f6671ca54a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>mostafarouz</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/pctricksir/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f3de891086460ebc9d49285dd875d392?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mostafa Shiraali</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mostafas1990/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e3631726d155eac3e02f76ce86675b5e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mostafa Soufi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/motefaghehi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ab18b632dcc092fa8f9186aeda372ca6?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Motefaghehi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/motlaqcode/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/1b483f0e8a37f692326fa773f13fdc67?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>motlaq.code</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mralidoosti/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/a3fb02547f4c5c7b52a0e8f62808e5f2?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mr.Alidoosti</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/msninsider/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/cbde60e0b6889dce753b42c8902ef5c0?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>msninsider</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/narimonfund/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/5285b112df84b46bdbb74863578eb613?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>narimonfund</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/navidos/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/7dcc163b0e899db1292b87e75f40bda4?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Navid</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/kashani/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/b36d7087386d76b7a19108b02f98f106?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Navid Kashani</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/milad47/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/37274b79cf0175321cb7643fbee5df94?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Nejad (drdgtal.ir)</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/niloomand/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/0cd10486b080d82bfe48daa6230dd935?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Niloufar Firouzmand</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/nima78600/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d748601773ad0279e56aa3c4019115b6?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Nima</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/nirweb/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c7415431eace690f62db1308c0ad64d9?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>NirWp Team</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/novinhub/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/322d3edcc25fe18b82e463a283cef232?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>novinhub</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/rajaeinet/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fd7b9df37ca332d1442a0ce3967a7c44?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Omid Rajaei</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/otoraby/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/60ae94ff71f9b47157b12f662edf29c7?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>otoraby</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/parselearn/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fdaf2d63dcac607c3369add863f92d49?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Parsa</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/rahmatmajidi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3fec48b6acbb1532a33452201fe96f1b?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>parsamajidi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/saeed_same/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/696fc497c9a2c917559f87d052bc3567?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br></a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/parsmizban/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f9456e0a85245eddae6ead8ff0fd73ec?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Pars Mizban</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/payzito/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2a81c9c4689f2161249bd7a7af97fcd2?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Payzito</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/pegahnorozi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3516a004a13a9aabf580b1af90709f38?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>pegahnorozi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/peprodev/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ab681a56b7c8835bd5e9115cd2168967?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Pepro Dev. Group</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/persianscript/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ef45e608481190c18b2af07af5723f9b?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>PersianScript</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/piman/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/6d47c40bb24abd6a4635f8a938833595?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Peyman Naeimi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/pingmeter/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fef2f4fcb95ba6066ef881890471b601?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Pingmeter</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/poolito/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f492c9b739e0f81689cdac49f18045d4?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Poolito</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/porsline/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/aa21f1b133d19e3ec284b54f6f66e8d1?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>porsline</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/poshtibancom/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/efe7c8e18dc355f38c206462e2a8fd89?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Poshtiban</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/qodeinteractive/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/b3112ae650270b077c3757e194e07b12?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Qode</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/rarathemesupport/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fd7624354ed1954db2857defe5d41717?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Rara Themes Support</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/vadatiertebat/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e19ecf951917ba4664ad0dcb920a86f7?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Rasool Vahdati</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sadeghpm/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c63f816d8d209d003b333883a5116d0a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>sadeghpm</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/safelayout/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/0d8556a5f60d79d46e4a0d99ec3bb01e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>safelayout</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sahabi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/713bcf163578d7beaf4fc5633068ee2e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>sahabi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sajjadtalebi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/41fdeae6932388edea980feab1ea8878?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>sajjad talebi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/salarlotfi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/19796781761750c8f461faa560255f72?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>salar lotfi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/samanehmirrajabi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3c249b6aea6b218f100a646dd4236322?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Samaneh Mirrajabi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/samtemehr/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fb8da7c62925a0f0747d979f5416c005?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>samtemehr</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/saniamohammadi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/4b1289fe9c88fa85980f32b1da0ffa32?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Sania Mohammadi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sareham238/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/dfda29e07b9ef724e74a5489462acc1d?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>sareham238</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/salamzadeh/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/981c633c2e04866c36713f4c771ead61?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Sasan Salamzadeh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ebrahimzadeh/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/6a6a7c553627a2f0b1f229ef896f9593?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Sekineh Ebrahimzadeh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/seramo/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/59a56d919279eb8c099e9ecfde2ac1b1?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>seramo</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/shayanfp/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e2bd4472eb102fb2523f618f354d20bb?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Shayan Farhang Pazhooh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/shokrino/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2c5113e52a9ead1d847a053680b929f5?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Shokrino Team</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/salemi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/9d8d335ac6f18b9d70529ec181e07825?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Siavash</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sinashams/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/5bc3dc3c1c481092e57d5ee7aaad8d4c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Sina Shamsizadeh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/smm1378/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d11d16690e254682f881b95a8906e9b6?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>smm1378</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/smrm/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/917f43c1bc06d82d93b33c6feb567ee3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>smrmkh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/soheilmir/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/dd162394cad442a9d41f6e61e9699fcc?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>soheilmir</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sunyniazi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/9118863f478aacf17e28c9c8eaaac868?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>sunyniazi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/tadeha/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d9d8d1fe52190dd5533faa32084601ba?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>tadeha</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/tsina/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/5175589803cc8209f9d14ff51f21ba6f?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>tsina</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/untashgaal/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c80bf7c5fe758586a0dd3c57abfa18f8?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Untashgaal</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/worldless/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/647edccfb36251fa1088ac69ddf24e3d?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>worldless</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/wpvar/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2e7c768382cbc3d2f0a927caea2b8b83?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>wpvar</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/yasser1992/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/7ff577dff2645a4cbd9aaad68cb71b4e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Yaser Shahi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/yashar_hv/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/69e51bde3535a671976159ba988d1fc1?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Yashar</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ynproduct/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/72bcce1fa00e869b00a3ccabff95c6e0?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ynproduct</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/cg-team/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/b7b3d45881027c27ef020c17b8750480?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Yousefzadeh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/zareidev/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fcbc5c441416e2c6ea8f9c9b23001a4d?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>zarei_dev</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/armenab1/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/9c8a84d3ceae3eaa3a7c8b0ad998109b?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Արմեն</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/elementorir/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d0e9b9be12b8164adb0adf91a980236f?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>المنتور فارسی</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mahdi6489/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d35bb6a22a417637fc73beeb92600be1?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>تندر وردپرس</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/zeroone2021/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/75478f3f1929f976951d668ee1e364a3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>دنیای صفر و یک دیجیتالی</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/salman1990/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f05fafc0856c43643dd36628b34b9944?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>سلمان محمدی</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/qwerty13/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e802e5ac490da7d1029b7029265249ef?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>مرتضی رستگار</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/pedramrahimi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/b545db4131a739d2348816b3c6ee12ae?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>پدرام رحیمی</a>\n</div>\n<div class=\"clear:both;content: \'\';display: flex-row;\"></div>\n\n\n\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center\"><strong><a href=\"https://make.wordpress.org/polyglots/teams/?locale=fa_IR\" data-type=\"link\" data-id=\"https://make.wordpress.org/polyglots/teams/?locale=fa_IR\" target=\"_blank\" rel=\"noreferrer noopener\">مشاهده لیست کامل توسعه دهندگان بخش فارسی</a></strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">استفاده کنندگان زبان فارسی وردپرس</h2>\n\n\n\n<p>تا سال 2024، 44.26٪ از کل وبسایت های اینترنت از وردپرس استفاده می‌کنند. این مقدار برابر با چیزی حدود ۸۱۰ میلیون وب‌سایت می‌شود و این شماره به سرعت در حال افزایش است. بیش از ۵۰۰ وب‌سایت هر روز با وردپرس ساخته می‌شود. از میان این وب سایت‌ها چیزی حدود ۸۱ میلیون وب سایت، به زبان فارسی می‌باشند (یک دهم درصد)</p>\n\n\n\n<h2 class=\"wp-block-heading\">تاریخچه فعالیت تیم وردپرس فارسی</h2>\n\n\n\n<p>فعالیت تیم وردپرس فارسی تقریبا از ابتدای بوجود آمدن وردپرس شکل گرفت و در فروردین ۱۳۸۶ انتشار افزونه تاریخ شمسی برای وردپرس توسط آقای <a href=\"https://profiles.wordpress.org/mani_monaj\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/mani_monaj\">مانی منجّمی</a>، سرعت بومی‌سازی وردپرس را دو چندان کرد. فعالیت‌های این دوستان و همچنین کاربر <a href=\"https://profiles.wordpress.org/gonahkar\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/gonahkar\">Gonahkar</a> باعث افزایش چشمگیر محبوبیت وردپرس، در میان کاربران وب فارسی زبان شد.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:164:\"https://fa.wordpress.org/team/2024/02/17/%d9%85%d8%b9%d8%b1%d9%81%db%8c-%d8%aa%db%8c%d9%85-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"145\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"واژه‌نامه رسمی وردپرس فارسی منتشر شد\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:227:\"https://fa.wordpress.org/team/2024/02/09/%d9%88%d8%a7%da%98%d9%87%d9%86%d8%a7%d9%85%d9%87-%d8%b1%d8%b3%d9%85%db%8c-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:236:\"https://fa.wordpress.org/team/2024/02/09/%d9%88%d8%a7%da%98%d9%87%d9%86%d8%a7%d9%85%d9%87-%d8%b1%d8%b3%d9%85%db%8c-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Feb 2024 21:23:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"مطالب\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://fa.wordpress.org/team/?p=98\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:609:\"واژه‌نامه وردپرس فارسی بر اساس واژه‌های پرتکرار در هسته وردپرس و بخش مدیریت آن ایجاد شده است. شما مترجم عزیز می‌توانید در هنگام ترجمه وردپرس در بخش ترجمه آنلاین وردپرس فارسی، از پیشنهادات ترجمه‌ای که بر اساس این واژه‌نامه به شما داده می‌شود استفاده نمایید و ترجمه خود را ساده‌تر و روان‌تر انجام دهید. این واژه‌نامه شامل بیش [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Farhad Sakhaei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2087:\"<p><a href=\"https://translate.wordpress.org/locale/fa/default/glossary/\">واژه‌نامه وردپرس فارسی</a> بر اساس واژه‌های پرتکرار در هسته وردپرس و بخش مدیریت آن ایجاد شده است. شما مترجم عزیز می‌توانید در هنگام ترجمه وردپرس در بخش <a rel=\"noreferrer noopener\" href=\"https://translate.wordpress.org/locale/fa/\" target=\"_blank\">ترجمه آنلاین وردپرس فارسی</a>، از پیشنهادات ترجمه‌ای که بر اساس این واژه‌نامه به شما داده می‌شود استفاده نمایید و ترجمه خود را ساده‌تر و روان‌تر انجام دهید.</p>\n\n\n\n<p>این واژه‌نامه شامل بیش از ۱۲۰۰ واژه و عبارت می‌باشد و به دلیل تعداد زیاد کلمات و عبارت‌های درج شده در آن، ممکن است نیاز به بهبود بیشتر نیز داشته باشد. لذا در صورتی که مایل به بهبود این واژه‌نامه هستید می‌توانید پیشنهادات خود را در مورد بهبود ترجمه واژه‌ها به صورت دیدگاه (Comment) بر روی <a href=\"https://docs.google.com/spreadsheets/d/1SrhQknH-gipzFXI6TCu1KEXUF9QivkCo3jp6yJy3CRE/edit?usp=sharing\" target=\"_blank\" rel=\"noreferrer noopener\">منبع Google Sheet این واژه‌نامه</a> ارائه نمایید. ضمنا در صورتی که نیاز به بحث و گفتگو در مورد واژه‌ای دارید، می‌توانید به بخش <a href=\"https://t.me/wpdevelopers\" target=\"_blank\" rel=\"noreferrer noopener\">گفتگوهای مربوط به تیم وردپرس فارسی</a> مراجعه و اقدام به عضویت و ورود نمایید. گردآوری این واژه‌نامه با تلاش <a href=\"https://make.wordpress.org/polyglots/teams/?locale=fa_IR\" target=\"_blank\" rel=\"noreferrer noopener\">تیم وردپرس فارسی</a> انجام شده است.<br></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:232:\"https://fa.wordpress.org/team/2024/02/09/%d9%88%d8%a7%da%98%d9%87%d9%86%d8%a7%d9%85%d9%87-%d8%b1%d8%b3%d9%85%db%8c-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"98\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"برگزاری تولد وردپرس در میتاپ بندرعباس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:239:\"https://fa.wordpress.org/team/2023/05/24/%d8%a8%d8%b1%da%af%d8%b2%d8%a7%d8%b1%db%8c-%d8%aa%d9%88%d9%84%d8%af-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%af%d8%b1-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%a8%d9%86%d8%af%d8%b1%d8%b9%d8%a8%d8%a7%d8%b3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:247:\"https://fa.wordpress.org/team/2023/05/24/%d8%a8%d8%b1%da%af%d8%b2%d8%a7%d8%b1%db%8c-%d8%aa%d9%88%d9%84%d8%af-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%af%d8%b1-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%a8%d9%86%d8%af%d8%b1%d8%b9%d8%a8%d8%a7%d8%b3/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 May 2023 06:17:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=102\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:469:\"به همین جهت ما نیز در جامعه وردپرس ایران در این روز دور هم جمع شده و در رویداد تولد ۲۰ سالگی وردپرس دیدار تازه می‌کنیم. از شما علاقمندان به دنیای وردپرس و متن باز دعوت میکنیم که این روز رو در کنار ما باشید. تاریخ برگزاری رویداد: شنبه 6 خرداد، ساعت 18:00 الی 20:15 [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3337:\"<figure class=\"wp-block-image size-full\"><a href=\"https://fa.wordpress.org/files/2023/05/poster-wordpress-2-1024x1024-1.jpg\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2023/05/poster-wordpress-2-1024x1024-1.jpg\" alt=\"\" class=\"wp-image-817\"></a></figure>\n\n\n\n<p>به همین جهت ما نیز در جامعه وردپرس ایران در این روز دور هم جمع شده و در رویداد تولد ۲۰ سالگی وردپرس دیدار تازه می‌کنیم.</p>\n\n\n\n<p>از شما علاقمندان به دنیای وردپرس و متن باز دعوت میکنیم که این روز رو در کنار ما باشید.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\">\n\n\n\n<p>تاریخ برگزاری رویداد: <strong>شنبه 6 خرداد، ساعت 18:00 الی 20:15</strong></p>\n\n\n\n<p>محل برگزاری: <strong>بندرعباس، خیابان آیت الله غفاری شمالی، ساختمان پارک علم و فناوری هرمزگان، سالن کنفرانس</strong></p>\n\n\n\n<p>ظرفیت: <strong>50 نفر</strong></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\">\n\n\n\n<h2 class=\"wp-block-heading\">ثبت نام در میتاپ</h2>\n\n\n\n<p>شرکت در این رویداد رایگان است اما حتما برای حضور باید در آن ثبت نام کنید.<br>برای ثبت نام در میتاپ وردپرس بندرعباس به این لینک Attend کرده</p>\n\n\n\n<p><a href=\"https://www.meetup.com/bandarabbas-wordpress-meetup/events/293634850/\">https://www.meetup.com/bandarabbas-wordpress-meetup/</a></p>\n\n\n\n<p>به دلیل محدودیت ظرفیت در این رویداد در صورت ثبت نام و کنسل شدن حضورتون حتما به برگزار کنندگان رویداد اطلاع‌رسانی کنید.</p>\n\n\n\n<p>جهت اطلاع‌رسانی در مورد رویداد در شبکه‌های اجتماعی میتاپ وردپرس عضو شوید.</p>\n\n\n\n<p><a href=\"https://t.me/irwpmeetup\" target=\"_blank\" rel=\"noreferrer noopener\">https://t.me/irwpmeetup</a><br><a href=\"https://instagram.com/irwpmeetup\" target=\"_blank\" rel=\"noreferrer noopener\">https://instagram.com/irwpmeetup</a><br><a href=\"https://wpmeetup.ir/\" target=\"_blank\" rel=\"noreferrer noopener\">https://wpmeetup.ir/</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\">\n\n\n\n<h2 class=\"wp-block-heading\">برنامه رویداد</h2>\n\n\n\n<figure class=\"wp-block-table is-style-stripes\"><table><tbody><tr><td><strong>برنامه</strong></td><td><strong>ساعت</strong></td></tr><tr><td>معرفی و خوش‌آمد گویی</td><td>18:00 الی 18:15</td></tr><tr><td>فرصت شبکه سازی با متخصصان و علاقه مندان وردپرس</td><td>18:15 الی 18:45</td></tr><tr><td>بحث و گفتگو در مورد سرعت و بهینه سازی وردپرس</td><td>18:45 الی 19:45</td></tr><tr><td>جشن تولد وردپرس همراه با کیک و عکاسی</td><td>19:45 الی 20:15</td></tr></tbody></table></figure>\n\n\n\n<h2 class=\"wp-block-heading\">برگزارکنندگان این رویداد</h2>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2023/05/sponser-bnd.jpg\" alt=\"\" class=\"wp-image-818\"></figure>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:244:\"https://fa.wordpress.org/team/2023/05/24/%d8%a8%d8%b1%da%af%d8%b2%d8%a7%d8%b1%db%8c-%d8%aa%d9%88%d9%84%d8%af-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%af%d8%b1-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%a8%d9%86%d8%af%d8%b1%d8%b9%d8%a8%d8%a7%d8%b3/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"102\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"میتاپ تولد ۲۰ سالگی وردپرس در تهران برگزار می‌شود\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:241:\"https://fa.wordpress.org/team/2023/05/16/%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%aa%d9%88%d9%84%d8%af-%db%b2%db%b0-%d8%b3%d8%a7%d9%84%da%af%db%8c-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%af%d8%b1-%d8%aa%d9%87%d8%b1%d8%a7%d9%86-%d8%a8%d8%b1%da%af/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:249:\"https://fa.wordpress.org/team/2023/05/16/%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%aa%d9%88%d9%84%d8%af-%db%b2%db%b0-%d8%b3%d8%a7%d9%84%da%af%db%8c-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%af%d8%b1-%d8%aa%d9%87%d8%b1%d8%a7%d9%86-%d8%a8%d8%b1%da%af/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 May 2023 06:22:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=104\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:512:\"در تاریخ ۶ خرداد امسال وردپرس ۲۰ ساله می‌شود. به همین مناسبت در تمامی دنیا رویدادهایی با هدف گرفتن جشن برای این روز برگزار می‌شود. لوکال منیجرها، توسعه‌دهنده‌ها و سایر دوستدارن دنیای متن باز و وردپرس با دورهم جمع شدن این روز رو در کل دنیا با هم جشن می‌گیرند. به همین جهت ما نیز [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4439:\"<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2023/05/2.png\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2023/05/2-1024x768.png\" alt=\"\" class=\"wp-image-790\"></a></figure>\n\n\n\n<p>در تاریخ ۶ خرداد امسال وردپرس ۲۰ ساله می‌شود. به همین مناسبت در تمامی دنیا رویدادهایی با هدف گرفتن جشن برای این روز برگزار می‌شود. لوکال منیجرها، توسعه‌دهنده‌ها و سایر دوستدارن دنیای متن باز و وردپرس با دورهم جمع شدن این روز رو در کل دنیا با هم جشن می‌گیرند.</p>\n\n\n\n<p>به همین جهت ما نیز در جامعه وردپرس ایران در این روز دور هم جمع شده و در رویداد تولد ۲۰ سالگی وردپرس دیدار تازه می‌کنیم.</p>\n\n\n\n<p>از شما علاقمندان به دنیای وردپرس و متن باز دعوت میکنیم که این روز رو در کنار ما باشید.</p>\n\n\n\n<p>تاریخ برگزاری رویداد: <strong>جمعه 5 خرداد، ساعت 9:30 الی 14:00</strong></p>\n\n\n\n<p>محل برگزاری: <strong>تهران، کیلومتر 15 بزرگراه فتح (پل ایرانخودرو)، خیابان تولایی،نبش کوچه لاله،کارخانه نوآوری و صنایع خلاق آمپر</strong></p>\n\n\n\n<p>ظرفیت: <strong>45 نفر</strong></p>\n\n\n\n<p>شرکت در این رویداد رایگان است اما حتما برای حضور باید در آن ثبت نام کنید.<br>برای ثبت نام ابتدا در میتاپ وردپرس تهران به این لینک Attend کرده</p>\n\n\n\n<p><a href=\"https://www.meetup.com/tehran-wordpress-meetup/events/293556812/\">https://www.meetup.com/tehran-wordpress-meetup/events/293556812</a></p>\n\n\n\n<p>و سپس اطلاعاتتون رو در این فرم ثبت کنید.</p>\n\n\n\n<p><a href=\"https://wpmeetup.ir/wp20/\">https://wpmeetup.ir/wp20</a><br></p>\n\n\n\n<p><strong>توجه نمایید که ثبت اطلاعات در فرم ذکر شده به منزله نهایی کردن ثبت نام است.</strong></p>\n\n\n\n<p>به دلیل محدودیت ظرفیت در این رویداد در صورت ثبت نام و کنسل شدن حضورتون حتما به برگزار کنندگان رویداد اطلاع‌رسانی کنید.</p>\n\n\n\n<p>جهت اطلاع‌رسانی در مورد رویداد در شبکه‌های اجتماعی میتاپ وردپرس عضو شوید.</p>\n\n\n\n<p><a rel=\"noreferrer noopener\" href=\"https://t.me/irwpmeetup\" target=\"_blank\">https://t.me/irwpmeetup</a><br><a rel=\"noreferrer noopener\" href=\"https://instagram.com/irwpmeetup\" target=\"_blank\">https://instagram.com/irwpmeetup</a><br><a rel=\"noreferrer noopener\" href=\"https://wpmeetup.ir/\" target=\"_blank\">https://wpmeetup.ir/</a></p>\n\n\n\n<span id=\"more-104\"></span>\n\n\n\n<h2 class=\"wp-block-heading\">برنامه رویداد</h2>\n\n\n\n<figure class=\"wp-block-table is-style-stripes\"><table><tbody><tr><td><strong>برنامه</strong></td><td><strong>ساعت</strong></td></tr><tr><td>معرفی و خوش‌آمد گویی (سعید فرد)</td><td>9:45 الی 10</td></tr><tr><td>سخنرانی اول – رسول وحدتی (امنیت وردپرس)</td><td>10 الی 10:45</td></tr><tr><td>وقت استراحت و پذیرایی اول</td><td>10:45 الی 11:15</td></tr><tr><td>سخنرانی دوم – مخاطرات استفاده محصولات وردپرسی نال و غیراصل (صحبت به صورت آزاد)</td><td>11:15 الی 12</td></tr><tr><td>تولد وردپرس، عکاسی و پذیرایی و شبکه‌سازی</td><td>12 الی 13:30</td></tr></tbody></table></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2023/05/2.5.png\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2023/05/2.5-1024x768.png\" alt=\"\" class=\"wp-image-802\"></a></figure>\n\n\n\n<h2 class=\"wp-block-heading\">اسپانسر برگزاری این رویداد</h2>\n\n\n\n<figure class=\"wp-block-image aligncenter size-medium is-resized\"><a href=\"https://limoo.host/\" target=\"_blank\" rel=\"noreferrer noopener\"><img decoding=\"async\" src=\"https://wpmeetup.ir/wp-content/uploads/2023/05/IMG_7339-300x300.png\" alt=\"\" class=\"wp-image-531\" style=\"width:146px;height:146px\"></a></figure>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:246:\"https://fa.wordpress.org/team/2023/05/16/%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%aa%d9%88%d9%84%d8%af-%db%b2%db%b0-%d8%b3%d8%a7%d9%84%da%af%db%8c-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%af%d8%b1-%d8%aa%d9%87%d8%b1%d8%a7%d9%86-%d8%a8%d8%b1%da%af/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"104\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"میتاپ روز ترجمه وردپرس به فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:203:\"https://fa.wordpress.org/team/2020/09/01/%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%b1%d9%88%d8%b2-%d8%aa%d8%b1%d8%ac%d9%85%d9%87-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d9%87-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:211:\"https://fa.wordpress.org/team/2020/09/01/%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%b1%d9%88%d8%b2-%d8%aa%d8%b1%d8%ac%d9%85%d9%87-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d9%87-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 01 Sep 2020 06:51:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=115\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:564:\"رویداد چند روزه ترجمه وردپرس همزمان با روز جهانی ترجمه شروع شد. در این رویداد طبق روال چند سال اخیر، همزمان با سایر مترجمان وردپرس به زبان‌های مختلف، بخش‌های هسته، سایت اصلی، پوسته‌ها، افزونه‌ها و اپ‌های موبایل را در کنار هم به زبان فارسی ترجمه می‌کنیم. رویداد روز ترجمه فارسی، بصورت یک میتاپ آنلاین در [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1895:\"<p>رویداد چند روزه ترجمه وردپرس همزمان با روز جهانی ترجمه شروع شد. در این رویداد طبق روال چند سال اخیر، همزمان با سایر مترجمان وردپرس به زبان‌های مختلف، بخش‌های هسته، سایت اصلی، پوسته‌ها، افزونه‌ها و اپ‌های موبایل را در کنار هم به زبان فارسی ترجمه می‌کنیم.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/09/highres_492664489-1024x576.png\" alt=\"\" class=\"wp-image-648\"></figure>\n\n\n\n<p>رویداد روز ترجمه فارسی، بصورت یک میتاپ آنلاین در روز <strong>جمعه ۱۱ مهرماه ۱۳۹۹</strong> انجام می شود. اگر علاقمند به حضور در این رویداد هستید می‌توانید از طریق آدرس زیر اطلاعات بیشتری در مورد آن کسب کنید:<br></p>\n\n\n\n<figure class=\"wp-block-embed-meetup-com wp-block-embed is-type-rich is-provider-meetup\"><div class=\"wp-block-embed__wrapper\">\r\nhttps://www.meetup.com/tehran-wordpress-meetup/events/273541393/\r\n</div></figure>\n\n\n\n<p class=\"has-text-align-right\">و یا می‌توانید در ساعت مشخص شده، بصورت مستقیم به پیوند رویداد وارد و به جمع دیگر دوستان بپیوندید:</p>\n\n\n\n<p class=\"has-text-align-left\" style=\"font-size:18px\"><br><strong><a href=\"https://www.meetup.com/tehran-wordpress-meetup/events/273541393\">https://www.meetup.com/tehran-wordpress-meetup/events/273541393</a></strong></p>\n\n\n\n<p>توجه داشته باشید که برای شرکت در پیوند بالا، نیازی به ثبت نام نیست و رویداد راس ساعت اعلام شده آغاز می‌شود.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:208:\"https://fa.wordpress.org/team/2020/09/01/%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%b1%d9%88%d8%b2-%d8%aa%d8%b1%d8%ac%d9%85%d9%87-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d9%87-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"115\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"برگزاری روز ترجمه وردپرس به فارسی در تهران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:241:\"https://fa.wordpress.org/team/2019/05/11/%d8%a8%d8%b1%da%af%d8%b2%d8%a7%d8%b1%db%8c-%d8%b1%d9%88%d8%b2-%d8%aa%d8%b1%d8%ac%d9%85%d9%87-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d9%87-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d8%af%d8%b1-%d8%aa%d9%87/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:249:\"https://fa.wordpress.org/team/2019/05/11/%d8%a8%d8%b1%da%af%d8%b2%d8%a7%d8%b1%db%8c-%d8%b1%d9%88%d8%b2-%d8%aa%d8%b1%d8%ac%d9%85%d9%87-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d9%87-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d8%af%d8%b1-%d8%aa%d9%87/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 May 2019 07:54:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=122\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:509:\"امروز (۲۱ اردیبهشت ۱۳۹۸) روز جهانی ترجمه وردپرس بود، یک رویداد که افراد زیادی در سراسر جهان جهت مشارکت برای ترجمه وردپرس، همکاری می‌کنند. ما نیز از این موضوع به دور نبودیم و به صورت گروهی وردپرس را به فارسی ترجمه کردیم و از کنار هم بودن لذت بردیم. روز ترجمه وردپرس باز نیز تکرار [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Farhad Sakhaei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2346:\"<p>امروز (۲۱ اردیبهشت ۱۳۹۸) روز جهانی ترجمه وردپرس بود، یک رویداد که افراد زیادی در سراسر جهان جهت مشارکت برای ترجمه وردپرس، همکاری می‌کنند. ما نیز از این موضوع به دور نبودیم و به صورت گروهی وردپرس را به فارسی ترجمه کردیم و از کنار هم بودن لذت بردیم. روز ترجمه وردپرس باز نیز تکرار خواهد شد. </p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/1.jpg\"><img decoding=\"async\" data-id=\"495\" src=\"https://fa.wordpress.org/files/2019/05/1-1024x772.jpg\" alt=\"\" class=\"wp-image-495\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/2.jpg\"><img decoding=\"async\" data-id=\"496\" src=\"https://fa.wordpress.org/files/2019/05/2-1024x767.jpg\" alt=\"\" class=\"wp-image-496\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/3.jpg\"><img decoding=\"async\" data-id=\"497\" src=\"https://fa.wordpress.org/files/2019/05/3-1024x767.jpg\" alt=\"\" class=\"wp-image-497\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/4.jpg\"><img decoding=\"async\" data-id=\"498\" src=\"https://fa.wordpress.org/files/2019/05/4-1024x767.jpg\" alt=\"\" class=\"wp-image-498\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/5.jpg\"><img decoding=\"async\" data-id=\"499\" src=\"https://fa.wordpress.org/files/2019/05/5-1024x767.jpg\" alt=\"\" class=\"wp-image-499\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/6.jpg\"><img decoding=\"async\" data-id=\"500\" src=\"https://fa.wordpress.org/files/2019/05/6-1024x767.jpg\" alt=\"\" class=\"wp-image-500\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/7.jpg\"><img decoding=\"async\" data-id=\"501\" src=\"https://fa.wordpress.org/files/2019/05/7-1024x533.jpg\" alt=\"\" class=\"wp-image-501\"></a></figure>\n</figure>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:246:\"https://fa.wordpress.org/team/2019/05/11/%d8%a8%d8%b1%da%af%d8%b2%d8%a7%d8%b1%db%8c-%d8%b1%d9%88%d8%b2-%d8%aa%d8%b1%d8%ac%d9%85%d9%87-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d9%87-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d8%af%d8%b1-%d8%aa%d9%87/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"122\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"پنجمین میتاپ وردپرس تهران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:177:\"https://fa.wordpress.org/team/2019/01/03/%d9%be%d9%86%d8%ac%d9%85%db%8c%d9%86-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%aa%d9%87%d8%b1%d8%a7%d9%86/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:185:\"https://fa.wordpress.org/team/2019/01/03/%d9%be%d9%86%d8%ac%d9%85%db%8c%d9%86-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%aa%d9%87%d8%b1%d8%a7%d9%86/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Jan 2019 07:59:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=127\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:554:\"پنجمین میتاپ وردپرس تهران در تاریخ 7 دی‌ماه 1397 برگزار شد. میتاپ در این دوره هم با استقبال بی‌نظیر علاقمندان به وردپرس مواجه بود . انتظار می‌رود که شاهدحضور بیشتر شما عزیزان در میتاپ‌های بعد باشیم. آقای سعید فرد با صحبت درباره اهداف میتاپ (برگزاری wordcamp در سال آینده، توسعه وردپرس فارسی) آغاز کننده این [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4863:\"<p>پنجمین میتاپ وردپرس تهران در تاریخ 7 دی‌ماه 1397 برگزار شد. میتاپ در این دوره هم با استقبال بی‌نظیر علاقمندان به وردپرس مواجه بود . انتظار می‌رود که شاهدحضور بیشتر شما عزیزان در میتاپ‌های بعد باشیم.</p>\n\n\n\n<p>آقای سعید فرد با صحبت درباره اهداف میتاپ (برگزاری wordcamp در سال آینده، توسعه وردپرس فارسی) آغاز کننده این رویداد بود.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/%D8%B3%D8%B9%DB%8C%D8%AF-%D9%81%D8%B1%D8%AF-%D9%85%DB%8C%D8%AA%D8%A7%D9%BE-768x768-1.jpg\" alt=\"\" class=\"wp-image-587\"></figure>\n\n\n\n<p>بعد از اینکه دوستان شرکت کننده خودشان را معرفی کردند نوبت به ارائه آقای مهدی رضایی (طراح وتوسعه دهنده وب) با موضوع: توسعه دهنده بهتری برای وردپرس باشیم رسید .</p>\n\n\n\n<p>آقای رضایی در ابتدا وردپرسفیای را برای دوستان معرفی کرد و مراحل نصب آن را توضیح و انجام داد. به سوالات حضار درباره ودرپرسفیای پاسخ داد .</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/mehdi-rezaeii-768x768-1.jpg\" alt=\"\" class=\"wp-image-588\"></figure>\n\n\n\n<p>در قسمت دوم ارائه خود آقای رضایی، سایپرس (ابزاری برای آزمایش سایت وردپرسی) را معرفی کرده و مراحل کار با سایپرس را به صورت عملی توضیح داد.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/member-meetup-768x768-1.jpg\" alt=\"\" class=\"wp-image-589\"></figure>\n\n\n\n<p>بعد از تمام شدن ارائه آقای رضایی نوبت به پذیرایی و تبادل نظر شرکت کنندگان رسید .</p>\n\n\n\n<p>بعد از پذیرایی آقای سعید فرد برد ترلو میتاپ را معرفی کرد و از کاربران خواست که برای مشارکت در زمینه بهبود وردپرس فارسی به آن بپیوندند. تمامی دوستان و شرکت‌کننده‌های میتاپ وردپرس می‌توانند در این بورد نظرات و پیشنهادات خود را برای این رویداد ارسال کنند و در برگزاری میتاپ همکاری داشته باشند.</p>\n\n\n\n<p>قسمت دوم میتاپ به صورت بحث و گفتگو بین شرکت‌کننده‌ها در میتاپ با موضوع فارسی سازی وردپرس و مشکلات آن شکل گرفت.</p>\n\n\n\n<p>آقای سخایی از کاربران وردپرس خواست تا در زمینه ترجمه وردپرس، گروه وردپرس را همراهی کنند و به بحث و تبادل نظر بپردازند.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/all-member-768x768-1.jpg\" alt=\"\" class=\"wp-image-590\"></figure>\n\n\n\n<p>گفت و گو درباره ترجمه وردپرس فارسی ادامه پیدا کرد و کاربران پیشنهادات و نظرات خود را درباره این موضوع به اشتراک گذاشتند. بعد از جمع‌بندی صحبت‌های کاربران توسط سعید فرد میتاپ پنجم به پایان رسید.</p>\n\n\n\n<p>عکس دسته جمعی در پایان میتاپ</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/5th-meetup-tehran-768x773-1.jpg\" alt=\"\" class=\"wp-image-591\"></figure>\n\n\n\n<p>اگر تمایل به حضور در دوره‌های بعدی میتاپ وردپرس تهران را دارید می‌توانید جهت اطلاع‌رسانی از برگزاری در اکانت‌های شبکه اجتماعی میتاپ در تلگرام و اینستاگرام عضو شوید.</p>\n\n\n\n<p class=\"has-text-align-center\" dir=\"ltr\"><a href=\"https://t.me/irwpmeetup\">https://t.me/irwpmeetup</a></p>\n\n\n\n<p class=\"has-text-align-center\" dir=\"ltr\"><a href=\"https://instagram.com/irwpmeetup\">https://instagram.com/irwpmeetup</a></p>\n\n\n\n<p>این مژده به کسانی که فرصت حضور در میتاپ ها را ندارند داده می‎‌شود که می‌توانند از طریق اکانت ما در اینستاگرام به صورت زنده و یا از طریق بخش <a href=\"https://wpmeetup.ir/category/videos/\">ویدیوهای میتاپ</a>، میتاپ‌های وردپرس قبلی را مشاهده کنند.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:182:\"https://fa.wordpress.org/team/2019/01/03/%d9%be%d9%86%d8%ac%d9%85%db%8c%d9%86-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%aa%d9%87%d8%b1%d8%a7%d9%86/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"127\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"چهارمین میتاپ وردپرس تهران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:183:\"https://fa.wordpress.org/team/2018/12/01/%da%86%d9%87%d8%a7%d8%b1%d9%85%db%8c%d9%86-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%aa%d9%87%d8%b1%d8%a7%d9%86/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:191:\"https://fa.wordpress.org/team/2018/12/01/%da%86%d9%87%d8%a7%d8%b1%d9%85%db%8c%d9%86-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%aa%d9%87%d8%b1%d8%a7%d9%86/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 01 Dec 2018 08:20:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=131\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:567:\"چهارمین میتاپ وردپرس ۹ آذر ۹۷ ساعت ۱۰ صبح برگزار شد. این میتاپ هم مانند سه میتاپ قبل شاهد حضور علاقه‌مندان وردپرس در هر زمینه‌ای (توسعه دهنده‌، طراح، کاربران وردپرس وحتی دانشجویان) بود. میتاپ با صحبت‌های آغازین آقای سعید‌‌ فرد با تأکید بر اهداف میتاپ که تشکیل جامعه‌ی وردپرسی، مطرح کردن مباحث فنی و عمومی [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5455:\"<p>چهارمین میتاپ وردپرس ۹ آذر ۹۷ ساعت ۱۰ صبح برگزار شد. این میتاپ هم مانند سه میتاپ قبل شاهد حضور علاقه‌مندان وردپرس در هر زمینه‌ای (توسعه دهنده‌، طراح، کاربران وردپرس وحتی دانشجویان) بود.</p>\n\n\n\n<p>میتاپ با صحبت‌های آغازین آقای سعید‌‌ فرد با تأکید بر اهداف میتاپ که تشکیل جامعه‌ی وردپرسی، مطرح کردن مباحث فنی و عمومی در رابطه با وردپرس، کمک به توسعه و پیشرفت  وردپرس در ایران و اشاره به این که هدف اصلی برگزاری میتاپ‌ها برگزاری وردکمپ در سال آینده برای اولین بار در آسیا است آغاز شد.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/%D8%B3%D8%B9%DB%8C%D8%AF-%D9%81%D8%B1%D8%AF-768x623-1.jpg\" alt=\"\" class=\"wp-image-579\"></figure>\n\n\n\n<p>بعد از معرفی شرکت کنندگان مثل میتاپ های گذشته نوبت به ارائه دوستان رسید.</p>\n\n\n\n<p>در این میتاپ آقای مهدی سلطانی که به صورت داوطلب و از طریق قراردادن ارائه خود در قسمت ارسال مقاله در  سایت میتاپ وردپرس علاقه خود را برای به اشتراک گذاشتن تجربیات خود با دیگر دوستان اعلام کرده بود  ارائه‌ی خود را در زمینه برنامه نویسی شی‌گرا در وردپرس آغاز کرد.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/soltani-768x493-1.jpg\" alt=\"\" class=\"wp-image-580\"></figure>\n\n\n\n<p>در این ارائه نکات کلیدی در استفاده از برنامه نویسی شی‌گرا توسط آقای سلطانی گفته شد، نمونه کدهای نوشته شده OOP نشان دادن و توضیحاتی بر روی کدها دادن.</p>\n\n\n\n<p>بعد از تبادل نظر و استراحت دوستان شرکت کننده و پذیرایی توسط مجموعه آتی ارتباط کیش نوبت به ارائه دوم با عنوان وردپرس ارزان برای شروع کسب و کار توسط آقای شاهین کلانتر آغاز شد.</p>\n\n\n\n<p>آقای کلانتر راهکارهایی ارائه کرد که بتوان کسب و کار نوپایی را با کمترین هزینه شروع کرد . در ادامه اضافه کرد که میتوانید بسته به نیاز وب سایت و کسب و کارتان پوسته ای نزدیک به اهدافتان بیابید و مخازن رایگان پوسته های وردپرس را معرفی کرد.</p>\n\n\n\n<p>آقای کلانتر :باجستجو در شبکه های اجتماعی میتوان از خلاقیت های طراحان صفحات وب استفاده کرد. با استفاده از هشتگ‌ها در شبکه‌های اجتماعی مانند اینستاگرام و پینترست.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/kalantar-768x512-1.jpg\" alt=\"\" class=\"wp-image-581\"></figure>\n\n\n\n<p>در ادامه به بررسی و معرفی پلاگین‌های رایگان و مهم و پرکاربرد وردپرس پرداخت و در آخر اضافه کرد که ما با رشد و توسعه وب سایت خود رشد می‌کنیم و بزرگ وبزرگتر می‌شویم  و وقتی وب سایت ما به سود دهی رسید برای برنده شدن در فضای رقابتی باید هزینه کنیم، هیچ رقابتی بدون هزینه نیست و از هزینه کردن نترسیم چون در مقابل بازدهی آن هزینه‌ی کمی است.</p>\n\n\n\n<p>بعد از اتمام ارائه آقای کلانتر دوستان به بحث و گفتگو در زمینه بازار کسب و کار وردپرس پرداختن و نظرات جالب و نکات مثبت زیادی در این زمینه گفته شد.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped wp-block-gallery-2 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" data-id=\"582\" src=\"https://fa.wordpress.org/files/2020/01/all1-meetup-768x650-1.jpg\" alt=\"\" class=\"wp-image-582\"></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" data-id=\"583\" src=\"https://fa.wordpress.org/files/2020/01/all2-meetup-768x638-1.jpg\" alt=\"\" class=\"wp-image-583\"></figure>\n</figure>\n\n\n\n<p>گروه وردپرس برای دوستان و علاقه مندانی که موفق به حضور در میتاپ‌ها را نشده‌اند با پخش زنده از طریق اینستاگرام و همچنین قراردادن ویدئوی میتاپ در آپارات امکان استفاده از مطالب گفته شده در میتاپ را فراهم می‌کند.</p>\n\n\n\n<p>عکس دست جمعی در پایان رویداد وردپرس</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/irwpmeetup4-768x830-1.jpg\" alt=\"\" class=\"wp-image-584\"></figure>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:188:\"https://fa.wordpress.org/team/2018/12/01/%da%86%d9%87%d8%a7%d8%b1%d9%85%db%8c%d9%86-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%aa%d9%87%d8%b1%d8%a7%d9%86/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"131\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://fa.wordpress.org/team/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"117865853\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sun, 30 Nov 2025 10:03:25 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Sat, 15 Feb 2025 19:56:46 GMT\";s:4:\"link\";s:66:\"<https://fa.wordpress.org/team/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";i:1764496951;s:21:\"cache_expiration_time\";i:1764540206;s:23:\"__cache_expiration_time\";i:1764540206;}","off");

INSERT IGNORE INTO `ndu6_options` VALUES 
("211","_transient_timeout_feed_mod_813f86eb29c12d6094f1acd1445797e5","1764540206","off"),
("212","_transient_feed_mod_813f86eb29c12d6094f1acd1445797e5","1764497006","off"),
("213","_transient_timeout_dash_v2_ccb55a4e4b351a220e50ef4117d7dc27","1764540206","off"),
("214","_transient_dash_v2_ccb55a4e4b351a220e50ef4117d7dc27","<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://fa.wordpress.org/2025/02/12/%D8%AE%D8%B7%D8%B1%D8%A7%D8%AA-%D8%A7%D8%B3%D8%AA%D9%81%D8%A7%D8%AF%D9%87-%D8%A7%D8%B2-%D9%85%D8%AD%D8%B5%D9%88%D9%84%D8%A7%D8%AA-%D9%86%D8%A7%D9%84-%D9%88-%DA%A9%D8%B1%DA%A9-%D8%B4%D8%AF%D9%87/\'>خطرات استفاده از محصولات نال و کرک شده</a></li><li><a class=\'rsswidget\' href=\'https://fa.wordpress.org/2024/11/17/%D9%88%D8%B1%D8%AF%D9%BE%D8%B1%D8%B3-%D9%81%D8%A7%D8%B1%D8%B3%DB%8C-%D9%86%DA%AF%D8%A7%D8%B1%D8%B4-%DB%B7-%DB%B6/\'>وردپرس فارسی نگارش ۶.۷</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://fa.wordpress.org/team/2025/02/14/how-to-contribute-translation/\'>آموزش مشارکت در ترجمه وردپرس</a></li><li><a class=\'rsswidget\' href=\'https://fa.wordpress.org/team/2024/04/21/%D9%BE%DB%8C%D9%88%D8%B3%D8%AA%D9%86-%D8%A8%D9%87-%DA%AF%D8%B1%D9%88%D9%87-%D9%85%D8%AA%D8%B1%D8%AC%D9%85%DB%8C%D9%86-%D9%88-%D8%AA%D9%88%D8%B3%D8%B9%D9%87-%D8%AF%D9%87%D9%86%D8%AF%DA%AF%D8%A7%D9%86/\'>پیوستن به گروه مترجمین و توسعه دهندگان وردپرس فارسی</a></li><li><a class=\'rsswidget\' href=\'https://fa.wordpress.org/team/2024/02/17/%D9%85%D8%B9%D8%B1%D9%81%DB%8C-%D8%AA%DB%8C%D9%85-%D9%88%D8%B1%D8%AF%D9%BE%D8%B1%D8%B3-%D9%81%D8%A7%D8%B1%D8%B3%DB%8C/\'>معرفی تیم وردپرس فارسی</a></li></ul></div>","off"),
("221","current_theme","Hello Elementor","auto"),
("222","theme_mods_hello-elementor","a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;}","on"),
("223","theme_switched","","auto"),
("224","hello_theme_version","3.4.5","auto"),
("227","elementor_connect_site_key","5b098bd5db11c6fcb31746933aa0c0cb","auto"),
("228","_hello-elementor_notifications","a:2:{s:7:\"timeout\";i:1764615198;s:5:\"value\";s:7987:\"[{\"id\":\"hello-theme-3.4.5\",\"title\":\"3.4.5 - 2025-10-27\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>New: Add theme home to Finder<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Improve banner behavior after clicking on action button<\\/li>\\n\\t\\t\\t\\t<li>Fix: Load styles correctly in Gutenberg pages<\\/li>\\n\\t\\t\\t\\t<li>Fix: Do not change menu name after Elementor activation<\\/li>\\n\\t\\t\\t\\t<li>Fix: Ensure quicklinks works correctly from home page<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.4\",\"title\":\"3.4.4 - 2025-06-08\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Improve Header\\/Footer edit access from theme Home<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.3\",\"title\":\"3.4.3 - 2025-05-26\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Fix: Settings page empty after 3.4.0 in translated sites<\\/li>\\n\\t\\t\\t\\t<li>Fix: PHP 8.4 deprecation notice<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.2\",\"title\":\"3.4.2 - 2025-05-19\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Set Home links font weight to regular<\\/li>\\n  \\t\\t        <li>Tweak: Dart SASS 3.0.0 - resolve scss deprecated warnings<\\/li>\\n    \\t\\t    <li>Fix: Settings page empty after 3.4.0<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.0\",\"title\":\"3.4.0 - 2025-05-05\",\"description\":\"\\n            <ul>\\n                <li>New: Added Theme Home<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update theme settings page style<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update tested up to version 6.8<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.3.0\",\"title\":\"3.3.0 - 2025-01-21\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Added changelog link in theme settings<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Updated minimum required Safari version to 15.5<\\/li>\\n  \\t\\t        <li>Tweak: Update autoprefixer to latest versions<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.1\",\"title\":\"3.2.1 - 2024-12-16\",\"description\":\"\\n            <ul>\\n                <li>\\n                    Fix: Gutenberg editor expanded disproportionately after adding support for <code>theme.json<\\/code>\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/430\\\" target=\\\"_blank\\\">#430<\\/a>)\\n                <\\/li>\\n                <li>Fix: Use CSS logical properties in the theme<\\/li>\\n                <li>Fix: Add ARIA attributes to header nav menu<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.0\",\"title\":\"3.2.0 - 2024-12-15\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Convert classic to hybrid theme with block-editor support<\\/li>\\n                <li>Tweak: Added new design options to header\\/footer<\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.7<\\/code><\\/li>\\n                <li>\\n                    Fix: Minify JS files\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/419\\\" target=\\\"_blank\\\">#419<\\/a>)\\n                <\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.1\",\"title\":\"3.1.1 - 2024-07-30\",\"description\":\"\\n            <ul>\\n                <li>Fix: Use consistent <code>&lt;h2&gt;<\\/code> for comments title and comment form<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.0\",\"title\":\"3.1.0 - 2024-06-19\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Update <code>Requires PHP 7.4<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.5<\\/code><\\/li>\\n                <li>Tweak: Add the ability to style the brand layout<\\/li>\\n                <li>Tweak: Remove deprecated Elementor code<\\/li>\\n                <li>Tweak: Restore default focus styling inside the theme<\\/li>\\n                <li>Tweak: Add <code>aria-label<\\/code> attribute to various <code>&lt;nav&gt;<\\/code> elements<\\/li>\\n                <li>Tweak: Improve mobile menu keyboard accessibility<\\/li>\\n                <li>Tweak: Semantic mobile menu toggle button<\\/li>\\n                <li>Fix: The header renders redundant <code>&lt;p&gt;<\\/code> when tagline is empty<\\/li>\\n                <li>Fix: Single post renders redundant wrapping <code>&lt;div&gt;<\\/code> when it has no tags<\\/li>\\n                <li>Fix: Remove redundant wrapping <code>&lt;div&gt;<\\/code> from <code>wp_nav_menu()<\\/code> output<\\/li>\\n                <li>Fix: Wrap page <code>&lt;h1&gt;<\\/code> with <code>&lt;div&gt;<\\/code>, not <code>&lt;header&gt;<\\/code><\\/li>\\n                <li>Fix: Use consistent <code>&lt;h3&gt;<\\/code> for comments title and comment form<\\/li>\\n                <li>Fix: Remove heading tags from dynamic header\\/footer<\\/li>\\n                <li>\\n                    Fix: Mobile Menu hamburger is not visible for logged-out users in some cases\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/369\\\" target=\\\"_blank\\\">#369<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove duplicate ID attributes in the header mobile menu<\\/li>\\n                <li>\\n                    Fix: Remove redundant table styles\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/311\\\" target=\\\"_blank\\\">#311<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove redundant space below Site Logo in the header\\/footer<\\/li>\\n                <li>Fix: Remove redundant CSS from dynamic header\\/footer layout<\\/li>\\n                <li>\\n                    Fix: Separate post tags in single post\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/304\\\" target=\\\"_blank\\\">#304<\\/a>)\\n                <\\/li>\\n                <li>Fix: Display <code>the_tags()<\\/code> after <code>wp_link_pages()<\\/code><\\/li>\\n                <li>Fix: Remove page break navigation from archives when using <code>&lt;!--nextpage--&gt;<\\/code><\\/li>\\n                <li>Fix: Style posts pagination component layout<\\/li>\\n                <li>Fix: Add RTL support to pagination arrows in archive pages<\\/li>\\n                <li>\\n                    Fix: Update pagination prev\\/next labels and positions\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/404\\\" target=\\\"_blank\\\">#404<\\/a>)\\n                <\\/li>\\n                <li>Fix: Check if Elementor is loaded when using dynamic header & footer<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.2\",\"title\":\"3.0.2 - 2024-05-28\",\"description\":\"\\n            <ul>\\n                <li>Internal: Version bump release to refresh WordPress repository<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.1\",\"title\":\"3.0.1 - 2024-01-24\",\"description\":\"\\n            <ul>\\n                <li>Fix: Harden security for admin notice dismiss button<\\/li>\\n                <li>Fix: Add <code>alt<\\/code> attribute to all the images in the dashboard<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.0\",\"title\":\"3.0.0 - 2023-12-26\",\"description\":\"\\n            <ul>\\n                <li>New: Option to disable cross-site header & footer<\\/li>\\n                <li>Tweak: Update <code>Requires PHP 7.3<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.4<\\/code><\\/li>\\n                <li>Tweak: Move cross-site header & footer styles to a separate CSS file<\\/li>\\n                <li>Tweak: Don\'t load <code>header-footer.min.css<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Don\'t load <code>hello-frontend.min.js<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in the frontend<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in WordPress admin<\\/li>\\n                <li>Tweak: Remove unused JS code from the frontend<\\/li>\\n                <li>Tweak: Remove unused CSS code from the editor<\\/li>\\n                <li>Tweak: Remove unnecessary <code>role<\\/code> attributes from HTML landmark elements<\\/li>\\n                <li>Tweak: Link from Elementor Site Settings to Hello Theme Settings<\\/li>\\n                <li>Fix: Dynamic script version for better caching<\\/li>\\n            <\\/ul>\"}]\";}","off"),
("241","elementor_active_kit","11","auto"),
("242","elementor_font_display","swap","auto"),
("245","elementor_landing_pages_activation","0","auto"),
("246","elementor_checklist","{\"last_opened_timestamp\":null,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header_pro\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":false}","auto"),
("247","elementor_version","3.33.2","auto"),
("248","elementor_install_history","a:1:{s:6:\"3.33.2\";i:1764497216;}","auto"),
("249","elementor_events_db_version","1.0.0","off"),
("251","_elementor_ab_testing_data","a:2:{s:7:\"timeout\";i:1764513417;s:5:\"value\";s:2:\"[]\";}","off"),
("252","elementor_onboarded","1","auto"),
("253","_elementor_installed_time","1764497223","auto"),
("254","elementor_remote_info_feed_data","a:3:{i:0;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}","off"),
("257","_transient_timeout__elementor_2025_black_friday_1","1764547200","off"),
("258","_transient__elementor_2025_black_friday_1","1764497224","off"),
("259","elementor_pro_license_key","*********","auto"),
("260","_elementor_pro_license_v2_data","a:2:{s:7:\"timeout\";i:1764628728;s:5:\"value\";s:71:\"{\"success\":true,\"license\":\"valid\",\"expires\":\"01.01.2030\",\"features\":[]}\";}","auto"),
("261","elementor_pro_version","3.33.1","auto"),
("262","elementor_pro_install_history","a:1:{s:6:\"3.33.1\";i:1764497253;}","auto"),
("263","widget_elementor-library","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("265","_elementor_pro_installed_time","1764497254","auto"),
("266","external_updates-elementor-pro","O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1764571980;s:14:\"checkedVersion\";s:6:\"3.33.1\";s:6:\"update\";O:8:\"stdClass\":10:{s:4:\"slug\";s:13:\"elementor-pro\";s:7:\"version\";s:6:\"3.33.1\";s:12:\"download_url\";s:63:\"https://esdownload.ir/vip-products/elementor-pro-2656456345.zip\";s:12:\"translations\";a:0:{}s:2:\"id\";i:0;s:8:\"homepage\";N;s:6:\"tested\";s:5:\"6.8.3\";s:14:\"upgrade_notice\";N;s:5:\"icons\";a:2:{s:2:\"1x\";s:44:\"https://esdownload.ir/json/el-update-128.png\";s:2:\"2x\";s:44:\"https://esdownload.ir/json/el-update-256.png\";}s:8:\"filename\";s:31:\"elementor-pro/elementor-pro.php\";}s:11:\"updateClass\";s:22:\"Puc_v4p6_Plugin_Update\";s:15:\"updateBaseClass\";s:13:\"Plugin_Update\";}","off"),
("267","elementor_submissions_db_version","5","auto"),
("268","_elementor_pro_api_requests_lock","a:1:{s:11:\"get_version\";i:1764572673;}","auto"),
("271","fs_active_plugins","O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:47:\"code-snippets-pro/vendor/freemius/wordpress-sdk\";O:8:\"stdClass\":4:{s:7:\"version\";s:9:\"999.99.99\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1764497291;s:11:\"plugin_path\";s:35:\"code-snippets-pro/code-snippets.php\";}}s:7:\"abspath\";s:45:\"/home/toplorir/domains/toplor.ir/public_html/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:35:\"code-snippets-pro/code-snippets.php\";s:8:\"sdk_path\";s:47:\"code-snippets-pro/vendor/freemius/wordpress-sdk\";s:7:\"version\";s:9:\"999.99.99\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1764497291;}}","auto"),
("272","fs_debug_mode","","auto"),
("273","RTL-CareUnit-PIL","q1bKSS1LzVGyUnJMLsksSyzJzM9T0lEqLkksKS0GigaXJienFhcDhVJSi5OLMgvACqyUlGoB","off"),
("276","fs_accounts","a:7:{s:21:\"id_slug_type_path_map\";a:1:{i:10565;a:3:{s:4:\"slug\";s:13:\"code-snippets\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:35:\"code-snippets-pro/code-snippets.php\";}}s:11:\"plugin_data\";a:1:{s:13:\"code-snippets\";a:17:{s:19:\"last_load_timestamp\";i:1764497292;s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:35:\"code-snippets-pro/code-snippets.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1764497291;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:1;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:9:\"999.99.99\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:5:\"3.8.2\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:15:\"prev_is_premium\";b:1;s:20:\"activation_timestamp\";i:1764497291;s:17:\"install_sync_cron\";O:8:\"stdClass\":5:{s:7:\"version\";s:5:\"3.8.2\";s:7:\"blog_id\";i:0;s:11:\"sdk_version\";s:9:\"999.99.99\";s:9:\"timestamp\";i:1764497291;s:2:\"on\";b:1;}}}s:13:\"file_slug_map\";a:1:{s:35:\"code-snippets-pro/code-snippets.php\";s:13:\"code-snippets\";}s:7:\"plugins\";a:1:{s:13:\"code-snippets\";O:9:\"FS_Plugin\":24:{s:2:\"id\";i:10565;s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;s:10:\"public_key\";s:32:\"pk_107ff34fc0b2a9700c150c1acf13a\";s:10:\"secret_key\";N;s:16:\"parent_plugin_id\";N;s:5:\"title\";s:27:\"Code Snippets Pro (Premium)\";s:4:\"slug\";s:13:\"code-snippets\";s:12:\"premium_slug\";s:17:\"code-snippets-pro\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";s:8:\"selected\";s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:35:\"code-snippets-pro/code-snippets.php\";s:7:\"version\";s:5:\"3.8.2\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:1;s:14:\"premium_suffix\";s:3:\"Pro\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:17:\"opt_in_moderation\";N;}}s:12:\"gc_timestamp\";a:0:{}s:10:\"theme_data\";a:0:{}s:7:\"updates\";a:1:{i:10565;N;}}","auto"),
("277","fs_api_cache","a:1:{s:99:\"get:/v1/installs/1/updates/latest.json?is_premium=true&newer_than=3.8.2&include_upgrade_notice=true\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":2:{s:7:\"success\";b:1;s:3:\"api\";s:8:\"bypassed\";}s:7:\"created\";i:1764571972;s:9:\"timestamp\";i:1764575572;}}","off"),
("280","rcuPluginHealthyServerIndex","1","off"),
("281","rcuPluginLastHealthyServerIndex","1","off"),
("284","y87K8cmqCvTITXJxTysyK7NMLjJwdLS1BQA","BcHHomtAAADQD7JA9MVbqNHLEIadHu2OICN8_TvHnbaXX8akIgGFlJ1FSoUrP111GCKDkqadQtWhzk_-UbmCEszzPYSBqoi9MjHj7RxlXXVbmo9e_5ouh7Mb8ThQYaN7VZtI-Anh7FUzrlorTwI9SITmEskI72zkMS2BZ37d5_Zb6Lns0I9nDKWXzOetyfTw8hUo6I0o6m5zb_EfBB6V-2tZuu8epdnQWKil2y1fcLddy1uN2Py8Oak9n8q3A1lnbb4rlsjreHI88FUC0a875s9gNfg01ppmF9suXJX8OvOCq4vhiPWvRiCKSK_SiKlpyd2tW2KDAVWdh9uVKig2cxm6reZNnjdGVe6a-fzWIj2pXnoWfYrM6R3Ut05l0JMsOM0iy5EZj_zwDcly23kgZ6G6VW20JuFH0GxbDLkXwV1jtlxPWhWF7yMUtNAJVhWSaIHUHFFdBLV1QPUBzKTCYRL91RYZRrFD6AT1zV4E-ElItx6OHftmQdsWDV81sIGpvgJKu3AiKwSRThO517SsYGgsXpRzp7B8Sf8PL0fn7EmaYSY5SZLtP58nOAz0C0RgDucuyCbNNa6JvSj98HlsWBlE8HciI9sKZoyvdJ17S5cswlLr0bwMpKwT0w7hhn-hLD72X_Fo7TEfcEb3mHrHN32tThJY_h0uqsZGQDNZN106yUPcVFqZzwbGCuZ-pBSgrj4GqUC6i68PrRwCEhUP-cm-x2jsVi0LRmT6Oqzeso7t9FfH2ekYhhccVuxgukw_FjZ71T2C61NSzANO__4D","off"),
("285","d6b78cce5554e6485dc8c0236b16f66909ee0d97","def50200d409fb884f87afd1c4b0f93a4b15ad9ce0e1b856fc2e3f362a93619546fec3e8de87ccb567a28bee251951b94f9c62821a08cb85a2bda84cfa4f0428843bc71c07cc72e7517bf1a7a34be06725a8fe02f0164ed676d64dbe6af78b6bd2ed7fd814f9f95c4bb37290dd16659a59d0acb933a176ed8a8dee72ae424ebea32bfb295a824954e877bab38ca801aba0d3045385c744c16293d9ced09de68fa3de4247c23a1f2c3064356ddf0ef701c490853cd19e801a27a2397db7a30e0ed42100b2de13468f8615cd1695f249689838ade63489599cc96882b1cb6250349c16d9bcf8de4c857ada0216b629825fc4dd7e95836cf98e3b0238cdeeaf6de19d76aaa189ce8efa16c88e6662aa811ea082eb8af3eb33a7f6662a9a4056d59584a2ef0bf0f04fadd592f9835a77abfe56f9cdfeddcb541858dc99ff111ea01451571b6856a63e558b6f3ee809778b2a12dc2f3a8578ddc3a75d13684f0ebfa19d10c0b350863edd7e3987370e01123d11701fcbf63cf18bfe3fcd9e677bf6f340161821625acf8d94996e355334bb679bc490c4c8fdcc1eed5dbfc7403b7e5f1369961aaa614812a5b9e025d195c38023d4f0251b3f4284ca464cf26c9a683a9165a18f4cdad868dc95886fbe3d9da1012e8f524f9441288ad01fc68e08b6e46127fafc15e6d4ce7f8151f2cbc5c75aa789b94863f53c80f35b6148b914f5c30716d4e80152388294acc6fc33875d6c0eaf9d28a196d05fa1b32cb957b190c275735c2393308af6f49c6afa3fe42915ccc7239cdc5d6c370b0a4cecddc9db277aab178ce6847ac2c56182bc0b9ef623529fc4daa65cc38a15eb7e2403684d6d35fc99a37fee8700121ee7607cf5a7d563b1a1c85b94b1b01937777b7442d1dea8b7831f8545814afb5f6ab0bf46d25c72e19eeed406631d018327b059015b46061843db13b643e09000e1f441c89ebe8a9f9b42832cf1760820fb2a694d985f825a95134697c49773233bc7783810c6091f91f39d9585179cac725f17939f91b84edf97b4c9ca1db1dc033aeb134c99aac4e2f5169b83a34c60c088e395258e4d5c50a83169eb43f7834e0f783fec7d18d6d21abd7a0fcbda8e80011469253e6b3389f7704b8bf92a","off"),
("286","RTL-CareUnit-FPA","1","auto"),
("287","code_snippets_version","3.8.2","auto"),
("288","code_snippets_cloud_settings","a:6:{s:11:\"cloud_token\";s:0:\"\";s:11:\"local_token\";s:30:\"muuMDHPnmnMEa4PMRT1cNeIqROpSQR\";s:14:\"token_verified\";b:0;s:13:\"code_verifier\";s:128:\"76wO2IcPpcUOWolvANcUQ9ESUbL8iziKoUPqShcWGEI6N2H2h2FPYwy1jYV5KgnguUqfDZziKjB0kxccmLyEcZjylBT8bSDgOVlf8OsGbJJysl9PCKqh9yS9sI5oRnf1\";s:14:\"code_challenge\";s:43:\"MKiuwhjTo3LBQCjB5m_WwQRcXDc_xHvY4kFoA5azT5M\";s:5:\"state\";s:15:\"88GoTEY0qqXN00p\";}","auto"),
("289","_site_transient_timeout_fs_garbage_collection","1764583693","off"),
("290","_site_transient_fs_garbage_collection","1","off"),
("297","code_snippets_settings","a:4:{s:7:\"general\";a:9:{s:19:\"activate_by_default\";b:1;s:11:\"enable_tags\";b:1;s:18:\"enable_description\";b:1;s:18:\"visual_editor_rows\";i:5;s:10:\"list_order\";s:12:\"priority-asc\";s:13:\"disable_prism\";b:0;s:13:\"minify_output\";a:2:{i:0;s:3:\"css\";i:1;s:2:\"js\";}s:17:\"hide_upgrade_menu\";b:0;s:18:\"complete_uninstall\";b:0;}s:6:\"editor\";a:12:{s:16:\"indent_with_tabs\";b:1;s:8:\"tab_size\";i:4;s:11:\"indent_unit\";i:4;s:9:\"font_size\";i:14;s:10:\"wrap_lines\";b:1;s:12:\"code_folding\";b:1;s:12:\"line_numbers\";b:1;s:19:\"auto_close_brackets\";b:1;s:27:\"highlight_selection_matches\";b:1;s:21:\"highlight_active_line\";b:1;s:6:\"keymap\";s:7:\"default\";s:5:\"theme\";s:7:\"default\";}s:14:\"version-switch\";a:1:{s:16:\"selected_version\";s:0:\"\";}s:5:\"debug\";a:1:{s:21:\"enable_version_change\";b:0;}}","auto"),
("298","auto_update_plugins","a:2:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";i:1;s:29:\"gravityforms/gravityforms.php\";}","off"),
("299","RTL-CareUnit-PCS","iyjV9vHO8jMrzAioSkn0LfUv9St29TIz1_YPzC8zS8nLc0s1CnDJT64MLjf18Ikq9gh1ColIDAzycEqqsogqyQp0LQu3TC91MUz3MI7KcQ1xdTMJiEgKiKpwL9YuCtaPcqmo9Nd3Na-wzEq3BQA","off"),
("300","_transient_timeout_code_snippets_welcome_data","1764670095","off"),
("301","_transient_code_snippets_welcome_data","a:4:{s:6:\"banner\";a:9:{s:3:\"key\";s:6:\"bf2025\";s:14:\"start_datetime\";O:17:\"DateTimeImmutable\":3:{s:4:\"date\";s:26:\"2025-11-18 00:00:00.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:12:\"end_datetime\";O:17:\"DateTimeImmutable\":3:{s:4:\"date\";s:26:\"2025-12-03 00:00:00.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:9:\"text_free\";s:63:\"Save up to 50% on Code Snippets Pro with our Black Friday Sale!\";s:15:\"action_url_free\";s:45:\"https://codesnippets.pro/pricing/?cs_user=new\";s:17:\"action_label_free\";s:8:\"Get Deal\";s:8:\"text_pro\";s:58:\"Save up to 50% on your upgrade with our Black Friday Sale!\";s:14:\"action_url_pro\";s:50:\"https://codesnippets.pro/pricing/?cs_user=existing\";s:16:\"action_label_pro\";s:8:\"Get Deal\";}s:9:\"hero-item\";a:3:{s:4:\"name\";s:24:\"Meet Snippet Conditions!\";s:10:\"follow_url\";s:78:\"https://codesnippets.pro/blog/version-3-7-snippet-conditions-official-release/\";s:9:\"image_url\";s:78:\"https://codesnippets.pro/wp-content/uploads/2025/09/conditions_screenshot.webp\";}s:8:\"features\";a:4:{i:0;a:5:{s:5:\"title\";s:28:\"Pssss... Get Secret Discount\";s:10:\"follow_url\";s:22:\"https://snipco.de/TFIG\";s:9:\"image_url\";s:81:\"https://codesnippets.pro/wp-content/uploads/2024/09/Promotions_Hero_All_Plans.png\";s:8:\"category\";s:5:\"offer\";s:11:\"description\";s:100:\"Get secret discount on all Code Snippets Pro plans. Just use coupon code \'General5\' at the checkout!\";}i:1;a:5:{s:5:\"title\";s:25:\"Add Unsplash to WordPress\";s:10:\"follow_url\";s:22:\"https://snipco.de/Mind\";s:9:\"image_url\";s:53:\"https://i3.ytimg.com/vi/kRSwWDanX0A/maxresdefault.jpg\";s:8:\"category\";s:3:\"tip\";s:11:\"description\";s:70:\"Code Snippet to Add Unsplash to WordPress - Find and Download Images..\";}i:2;a:5:{s:5:\"title\";s:30:\"Code Snippet Cloud Setup Guide\";s:10:\"follow_url\";s:22:\"https://snipco.de/Mine\";s:9:\"image_url\";s:149:\"https://cdn.getgist.com/attachment_images/76ca6cef08ca8e69ac1e7fbc15004bebbd08ad595ee67e0d7b55d1a9555354bfScreenshot%202023-11-23%20at%2000.50.02.png\";s:8:\"category\";s:5:\"guide\";s:11:\"description\";s:143:\"We have done our best to make the cloud set up as smooth and easy as possible. This guide below will walk you through the process step by step.\";}i:3;a:5:{s:5:\"title\";s:14:\"Cloud and AI +\";s:10:\"follow_url\";s:22:\"https://snipco.de/Minf\";s:9:\"image_url\";s:53:\"https://i3.ytimg.com/vi/rEOC2bIwY-w/maxresdefault.jpg\";s:8:\"category\";s:11:\"new feature\";s:11:\"description\";s:68:\"Code Snippets 3.6 Announcement - AI CodeSnippets - Generate AI Code!\";}}s:8:\"partners\";a:4:{i:0;a:3:{s:5:\"title\";s:9:\"Elementor\";s:10:\"follow_url\";s:22:\"https://snipco.de/KK3d\";s:9:\"image_url\";s:76:\"https://codesnippets.pro/wp-content/uploads/2024/05/Elementor-logo-green.png\";}i:1;a:3:{s:5:\"title\";s:7:\"InstaWP\";s:10:\"follow_url\";s:22:\"https://snipco.de/KK3n\";s:9:\"image_url\";s:68:\"https://codesnippets.pro/wp-content/uploads/2024/05/instawp-logo.png\";}i:2;a:3:{s:5:\"title\";s:11:\"Dynamic.ooo\";s:10:\"follow_url\";s:28:\"https://snipco.de/dynamicooo\";s:9:\"image_url\";s:71:\"https://codesnippets.pro/wp-content/uploads/2025/09/Dynamicooo-Logo.png\";}i:3;a:3:{s:5:\"title\";s:10:\"Crocoblock\";s:10:\"follow_url\";s:22:\"https://snipco.de/KK3l\";s:9:\"image_url\";s:71:\"https://codesnippets.pro/wp-content/uploads/2024/05/crocoblock-logo.png\";}}}","off"),
("304","recently_activated_snippets","a:0:{}","auto"),
("307","jet-license-data","a:1:{s:12:\"license-list\";a:0:{}}","auto"),
("311","guardino_last_check_guard_license","a:4:{s:30:\"a29c3e5cbac2247edbc38cdce73d7d\";i:1764497453;s:30:\"f2ee34502454530a70f73c4e1ed78e\";i:1764497525;s:23:\"d813ce35c79f0666b4774ad\";i:1764497613;s:31:\"d535aa5a606474cf73f694947f9e03a\";i:1764497800;}","off"),
("312","ce74ff48aee8d449b8d829b379a22d","YTo1OntzOjIxOiJmZGJmZTY5YTQ5MTgwYzVlMDE5NmYiO3M6MzY6ImZjZGI2MWQ3LTE0Y2YtNGY4NS04YzM4LTU2NmU0OGZhZTM2MCI7czoyNToiYzA2MzkwZjg5OTAyMTg0YjgzY2FlNTQwZSI7czo0OToi2YTYp9uM2LPZhtizINio2Kcg2YXZiNmB2YLbjNiqINmG2LXYqCDar9ix2K/bjNivLiI7czozMToiZGMzYTJmZmQ4ZWVjMTE1ZDZlM2I5ODdlYmJjZGQ4YiI7aToxNzY0NDk3NDUzO3M6MTc6ImJkMzgwYmY0YmY3NTQzYjZhIjtiOjA7czozMDoiZDg4Y2FkOWQ3NDExOTM5ZGMxNmRjNjE0ZGFjM2VlIjtiOjE7fQ==","auto"),
("321","action_scheduler_hybrid_store_demarkation","12","auto"),
("322","schema-ActionScheduler_StoreSchema","8.0.1764497507","auto"),
("323","schema-ActionScheduler_LoggerSchema","3.0.1764497507","auto"),
("324","rank_math_known_post_types","a:5:{s:4:\"post\";s:4:\"post\";s:4:\"page\";s:4:\"page\";s:10:\"attachment\";s:10:\"attachment\";s:18:\"e-floating-buttons\";s:18:\"e-floating-buttons\";s:10:\"jet-engine\";s:10:\"jet-engine\";}","auto"),
("325","rank_math_modules","a:12:{i:0;s:12:\"link-counter\";i:1;s:9:\"analytics\";i:2;s:12:\"seo-analysis\";i:3;s:7:\"sitemap\";i:4;s:12:\"rich-snippet\";i:5;s:11:\"woocommerce\";i:6;s:10:\"buddypress\";i:7;s:7:\"bbpress\";i:8;s:3:\"acf\";i:9;s:11:\"web-stories\";i:10;s:10:\"content-ai\";i:11;s:16:\"instant-indexing\";}","auto"),
("326","rank_math_react_settings_ui","on","off"),
("327","rank-math-options-general","a:51:{s:19:\"strip_category_base\";s:3:\"off\";s:24:\"attachment_redirect_urls\";s:2:\"on\";s:27:\"attachment_redirect_default\";s:21:\"https://www.toplor.ir\";s:23:\"nofollow_external_links\";s:3:\"off\";s:20:\"nofollow_image_links\";s:3:\"off\";s:25:\"new_window_external_links\";s:2:\"on\";s:11:\"add_img_alt\";s:3:\"off\";s:14:\"img_alt_format\";s:11:\" %filename%\";s:13:\"add_img_title\";s:3:\"off\";s:16:\"img_title_format\";s:22:\"%title% %count(title)%\";s:11:\"breadcrumbs\";s:3:\"off\";s:21:\"breadcrumbs_separator\";s:1:\"-\";s:16:\"breadcrumbs_home\";s:2:\"on\";s:22:\"breadcrumbs_home_label\";s:4:\"Home\";s:26:\"breadcrumbs_archive_format\";s:15:\"Archives for %s\";s:25:\"breadcrumbs_search_format\";s:14:\"Results for %s\";s:21:\"breadcrumbs_404_label\";s:25:\"404 Error: page not found\";s:31:\"breadcrumbs_ancestor_categories\";s:3:\"off\";s:21:\"breadcrumbs_blog_page\";s:3:\"off\";s:16:\"404_monitor_mode\";s:6:\"simple\";s:17:\"404_monitor_limit\";i:100;s:35:\"404_monitor_ignore_query_parameters\";s:2:\"on\";s:24:\"redirections_header_code\";s:3:\"301\";s:18:\"redirections_debug\";s:3:\"off\";s:23:\"console_caching_control\";s:2:\"90\";s:21:\"console_email_reports\";s:2:\"on\";s:23:\"console_email_frequency\";s:7:\"monthly\";s:22:\"wc_remove_product_base\";s:3:\"off\";s:23:\"wc_remove_category_base\";s:3:\"off\";s:31:\"wc_remove_category_parent_slugs\";s:3:\"off\";s:18:\"rss_before_content\";s:0:\"\";s:17:\"rss_after_content\";s:0:\"\";s:19:\"wc_remove_generator\";s:2:\"on\";s:24:\"remove_shop_snippet_data\";s:2:\"on\";s:18:\"frontend_seo_score\";s:3:\"off\";s:29:\"frontend_seo_score_post_types\";a:1:{i:0;s:4:\"post\";}s:27:\"frontend_seo_score_position\";s:3:\"top\";s:10:\"setup_mode\";s:8:\"advanced\";s:21:\"content_ai_post_types\";a:4:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:18:\"e-floating-buttons\";i:3;s:10:\"jet-engine\";}s:18:\"content_ai_country\";s:3:\"all\";s:15:\"content_ai_tone\";s:6:\"Formal\";s:19:\"content_ai_audience\";s:16:\"General Audience\";s:19:\"content_ai_language\";s:10:\"US English\";s:15:\"analytics_stats\";s:2:\"on\";s:15:\"toc_block_title\";s:17:\"Table of Contents\";s:20:\"toc_block_list_style\";s:2:\"ul\";s:15:\"llms_post_types\";a:4:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:18:\"e-floating-buttons\";i:3;s:10:\"jet-engine\";}s:14:\"google_updates\";s:2:\"on\";s:13:\"podcast_title\";s:10:\"%sitename%\";s:19:\"podcast_description\";s:10:\"%sitedesc%\";s:29:\"podcast_tipodcast_explicittle\";s:3:\"off\";}","auto"),
("328","rank-math-options-titles","a:133:{s:24:\"noindex_empty_taxonomies\";s:2:\"on\";s:15:\"title_separator\";s:1:\"-\";s:17:\"capitalize_titles\";s:3:\"off\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:19:\"knowledgegraph_type\";s:6:\"person\";s:19:\"knowledgegraph_name\";s:58:\"انجمن بهترین تعمیر کاران لرستان\";s:12:\"website_name\";s:58:\"انجمن بهترین تعمیر کاران لرستان\";s:19:\"local_business_type\";s:12:\"Organization\";s:20:\"local_address_format\";s:43:\"{address} {locality}, {region} {postalcode}\";s:13:\"opening_hours\";a:7:{i:0;a:2:{s:3:\"day\";s:6:\"Monday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:1;a:2:{s:3:\"day\";s:7:\"Tuesday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:2;a:2:{s:3:\"day\";s:9:\"Wednesday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:3;a:2:{s:3:\"day\";s:8:\"Thursday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:4;a:2:{s:3:\"day\";s:6:\"Friday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:5;a:2:{s:3:\"day\";s:8:\"Saturday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:6;a:2:{s:3:\"day\";s:6:\"Sunday\";s:4:\"time\";s:11:\"09:00-17:00\";}}s:20:\"opening_hours_format\";s:3:\"off\";s:14:\"homepage_title\";s:34:\"%sitename% %page% %sep% %sitedesc%\";s:20:\"homepage_description\";s:0:\"\";s:22:\"homepage_custom_robots\";s:3:\"off\";s:23:\"disable_author_archives\";s:3:\"off\";s:15:\"url_author_base\";s:6:\"author\";s:20:\"author_custom_robots\";s:2:\"on\";s:13:\"author_robots\";a:1:{i:0;s:7:\"noindex\";}s:20:\"author_archive_title\";s:30:\"%name% %sep% %sitename% %page%\";s:19:\"author_add_meta_box\";s:2:\"on\";s:21:\"disable_date_archives\";s:2:\"on\";s:18:\"date_archive_title\";s:30:\"%date% %page% %sep% %sitename%\";s:12:\"search_title\";s:38:\"%search_query% %page% %sep% %sitename%\";s:9:\"404_title\";s:31:\"Page Not Found %sep% %sitename%\";s:19:\"date_archive_robots\";a:1:{i:0;s:7:\"noindex\";}s:14:\"noindex_search\";s:2:\"on\";s:24:\"noindex_archive_subpages\";s:3:\"off\";s:26:\"noindex_password_protected\";s:3:\"off\";s:32:\"pt_download_default_rich_snippet\";s:7:\"product\";s:29:\"author_slack_enhanced_sharing\";s:2:\"on\";s:13:\"pt_post_title\";s:24:\"%title% %sep% %sitename%\";s:19:\"pt_post_description\";s:9:\"%excerpt%\";s:14:\"pt_post_robots\";a:1:{i:0;s:5:\"index\";}s:21:\"pt_post_custom_robots\";s:3:\"off\";s:28:\"pt_post_default_rich_snippet\";s:7:\"article\";s:28:\"pt_post_default_article_type\";s:11:\"BlogPosting\";s:28:\"pt_post_default_snippet_name\";s:11:\"%seo_title%\";s:28:\"pt_post_default_snippet_desc\";s:17:\"%seo_description%\";s:30:\"pt_post_slack_enhanced_sharing\";s:2:\"on\";s:17:\"pt_post_ls_use_fk\";s:6:\"titles\";s:20:\"pt_post_add_meta_box\";s:2:\"on\";s:20:\"pt_post_bulk_editing\";s:7:\"editing\";s:24:\"pt_post_link_suggestions\";s:2:\"on\";s:24:\"pt_post_primary_taxonomy\";s:8:\"category\";s:13:\"pt_page_title\";s:24:\"%title% %sep% %sitename%\";s:19:\"pt_page_description\";s:9:\"%excerpt%\";s:14:\"pt_page_robots\";a:1:{i:0;s:5:\"index\";}s:21:\"pt_page_custom_robots\";s:3:\"off\";s:28:\"pt_page_default_rich_snippet\";s:7:\"article\";s:28:\"pt_page_default_article_type\";s:7:\"Article\";s:28:\"pt_page_default_snippet_name\";s:11:\"%seo_title%\";s:28:\"pt_page_default_snippet_desc\";s:17:\"%seo_description%\";s:30:\"pt_page_slack_enhanced_sharing\";s:2:\"on\";s:17:\"pt_page_ls_use_fk\";s:6:\"titles\";s:20:\"pt_page_add_meta_box\";s:2:\"on\";s:20:\"pt_page_bulk_editing\";s:7:\"editing\";s:24:\"pt_page_link_suggestions\";s:2:\"on\";s:19:\"pt_attachment_title\";s:24:\"%title% %sep% %sitename%\";s:25:\"pt_attachment_description\";s:9:\"%excerpt%\";s:20:\"pt_attachment_robots\";a:1:{i:0;s:7:\"noindex\";}s:27:\"pt_attachment_custom_robots\";s:2:\"on\";s:34:\"pt_attachment_default_rich_snippet\";s:3:\"off\";s:34:\"pt_attachment_default_article_type\";s:7:\"Article\";s:34:\"pt_attachment_default_snippet_name\";s:11:\"%seo_title%\";s:34:\"pt_attachment_default_snippet_desc\";s:17:\"%seo_description%\";s:36:\"pt_attachment_slack_enhanced_sharing\";s:3:\"off\";s:26:\"pt_attachment_add_meta_box\";s:3:\"off\";s:27:\"pt_e-floating-buttons_title\";s:24:\"%title% %sep% %sitename%\";s:33:\"pt_e-floating-buttons_description\";s:9:\"%excerpt%\";s:28:\"pt_e-floating-buttons_robots\";a:1:{i:0;s:5:\"index\";}s:35:\"pt_e-floating-buttons_custom_robots\";s:3:\"off\";s:42:\"pt_e-floating-buttons_default_rich_snippet\";s:3:\"off\";s:42:\"pt_e-floating-buttons_default_article_type\";s:7:\"Article\";s:42:\"pt_e-floating-buttons_default_snippet_name\";s:11:\"%seo_title%\";s:42:\"pt_e-floating-buttons_default_snippet_desc\";s:17:\"%seo_description%\";s:44:\"pt_e-floating-buttons_slack_enhanced_sharing\";s:3:\"off\";s:31:\"pt_e-floating-buttons_ls_use_fk\";s:6:\"titles\";s:34:\"pt_e-floating-buttons_add_meta_box\";s:2:\"on\";s:34:\"pt_e-floating-buttons_bulk_editing\";s:7:\"editing\";s:38:\"pt_e-floating-buttons_link_suggestions\";s:2:\"on\";s:19:\"pt_jet-engine_title\";s:24:\"%title% %sep% %sitename%\";s:25:\"pt_jet-engine_description\";s:9:\"%excerpt%\";s:20:\"pt_jet-engine_robots\";a:1:{i:0;s:5:\"index\";}s:27:\"pt_jet-engine_custom_robots\";s:3:\"off\";s:34:\"pt_jet-engine_default_rich_snippet\";s:3:\"off\";s:34:\"pt_jet-engine_default_article_type\";s:7:\"Article\";s:34:\"pt_jet-engine_default_snippet_name\";s:11:\"%seo_title%\";s:34:\"pt_jet-engine_default_snippet_desc\";s:17:\"%seo_description%\";s:36:\"pt_jet-engine_slack_enhanced_sharing\";s:3:\"off\";s:23:\"pt_jet-engine_ls_use_fk\";s:6:\"titles\";s:26:\"pt_jet-engine_add_meta_box\";s:2:\"on\";s:26:\"pt_jet-engine_bulk_editing\";s:7:\"editing\";s:30:\"pt_jet-engine_link_suggestions\";s:2:\"on\";s:16:\"pt_product_title\";s:24:\"%title% %sep% %sitename%\";s:22:\"pt_product_description\";s:9:\"%excerpt%\";s:17:\"pt_product_robots\";a:1:{i:0;s:5:\"index\";}s:24:\"pt_product_custom_robots\";s:3:\"off\";s:31:\"pt_product_default_rich_snippet\";s:7:\"product\";s:31:\"pt_product_default_article_type\";s:7:\"Article\";s:31:\"pt_product_default_snippet_name\";s:11:\"%seo_title%\";s:31:\"pt_product_default_snippet_desc\";s:17:\"%seo_description%\";s:33:\"pt_product_slack_enhanced_sharing\";s:2:\"on\";s:20:\"pt_product_ls_use_fk\";s:6:\"titles\";s:23:\"pt_product_add_meta_box\";s:2:\"on\";s:23:\"pt_product_bulk_editing\";s:7:\"editing\";s:27:\"pt_product_link_suggestions\";s:2:\"on\";s:27:\"pt_product_primary_taxonomy\";s:11:\"product_cat\";s:18:\"pt_web-story_title\";s:24:\"%title% %sep% %sitename%\";s:24:\"pt_web-story_description\";s:9:\"%excerpt%\";s:19:\"pt_web-story_robots\";a:1:{i:0;s:5:\"index\";}s:26:\"pt_web-story_custom_robots\";s:3:\"off\";s:33:\"pt_web-story_default_rich_snippet\";s:7:\"article\";s:33:\"pt_web-story_default_article_type\";s:7:\"Article\";s:33:\"pt_web-story_default_snippet_name\";s:11:\"%seo_title%\";s:33:\"pt_web-story_default_snippet_desc\";s:17:\"%seo_description%\";s:35:\"pt_web-story_slack_enhanced_sharing\";s:3:\"off\";s:25:\"pt_web-story_add_meta_box\";s:3:\"off\";s:18:\"tax_category_title\";s:23:\"%term% %sep% %sitename%\";s:19:\"tax_category_robots\";a:1:{i:0;s:5:\"index\";}s:25:\"tax_category_add_meta_box\";s:2:\"on\";s:26:\"tax_category_custom_robots\";s:3:\"off\";s:24:\"tax_category_description\";s:18:\"%term_description%\";s:35:\"tax_category_slack_enhanced_sharing\";s:2:\"on\";s:25:\"tax_category_bulk_editing\";i:0;s:18:\"tax_post_tag_title\";s:23:\"%term% %sep% %sitename%\";s:19:\"tax_post_tag_robots\";a:1:{i:0;s:7:\"noindex\";}s:25:\"tax_post_tag_add_meta_box\";s:3:\"off\";s:26:\"tax_post_tag_custom_robots\";s:2:\"on\";s:24:\"tax_post_tag_description\";s:18:\"%term_description%\";s:35:\"tax_post_tag_slack_enhanced_sharing\";s:2:\"on\";s:25:\"tax_post_tag_bulk_editing\";i:0;s:31:\"remove_product_cat_snippet_data\";s:2:\"on\";s:31:\"remove_product_tag_snippet_data\";s:2:\"on\";}","auto"),
("329","rank-math-options-sitemap","a:18:{s:14:\"items_per_page\";i:200;s:14:\"include_images\";s:2:\"on\";s:22:\"include_featured_image\";s:3:\"off\";s:13:\"exclude_roles\";a:2:{i:0;s:11:\"contributor\";i:1;s:10:\"subscriber\";}s:12:\"html_sitemap\";s:2:\"on\";s:20:\"html_sitemap_display\";s:9:\"shortcode\";s:17:\"html_sitemap_sort\";s:9:\"published\";s:23:\"html_sitemap_seo_titles\";s:6:\"titles\";s:15:\"authors_sitemap\";s:2:\"on\";s:15:\"pt_post_sitemap\";s:2:\"on\";s:15:\"pt_page_sitemap\";s:2:\"on\";s:21:\"pt_attachment_sitemap\";s:3:\"off\";s:29:\"pt_e-floating-buttons_sitemap\";s:2:\"on\";s:21:\"pt_jet-engine_sitemap\";s:2:\"on\";s:18:\"pt_product_sitemap\";s:2:\"on\";s:20:\"pt_web-story_sitemap\";s:3:\"off\";s:20:\"tax_category_sitemap\";s:2:\"on\";s:20:\"tax_post_tag_sitemap\";s:3:\"off\";}","auto"),
("330","rank-math-options-instant-indexing","a:2:{s:15:\"bing_post_types\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:16:\"indexnow_api_key\";s:32:\"6543ac30243347d78bf68980b5e7ae6e\";}","auto"),
("331","_transient_timeout__rank_math_activation_redirect","1764497537","off"),
("332","_transient__rank_math_activation_redirect","1","off"),
("333","rank_math_version","1.0.258","auto"),
("334","rank_math_db_version","1","auto"),
("335","rank_math_install_date","1764510107","auto"),
("339","action_scheduler_lock_async-request-runner","692d3ee3e39812.25355197|1764572959","no"),
("340","rank_math_review_notice_date","1765719708","off"),
("343","_transient_timeout_as-post-store-dependencies-met","1764583908","off"),
("344","_transient_as-post-store-dependencies-met","yes","off"),
("345","rank_math_review_posts_converted","1","auto"),
("347","rank_math_pro_version","3.0.101","auto"),
("351","rank_math_notifications","a:0:{}","auto"),
("353","_transient_rank_math_first_submenu_id","rank-math","on"),
("363","e891f38c5b083a4846f4c4601ee26d","YTo1OntzOjMxOiJhNjJmMjk4MTNlODZiODZlZjUyZmFmNTE5ZjNiNmFlIjtzOjM2OiJlODhmMmY4MS1hYTQxLTQxZjItYTdmYi1lNTRhZWZiYjQ2MDYiO3M6MzE6ImI5NzZjMmNiMDIzNmRjODdlMjFhYTAyMDU2NWFhYWEiO3M6NDk6ItmE2KfbjNiz2YbYsyDYqNinINmF2YjZgdmC24zYqiDZhti12Kgg2q/Ysdiv24zYry4iO3M6MzA6ImIyMmVjNTEyZjIzMzk1N2JjYmQ0Yjk1YjY2NTUwZCI7aToxNzY0NDk3NTI1O3M6MzA6ImYyMzRjZDljNzliNmU1MWMzYzE5MmJiY2I5NDlkYSI7YjowO3M6Mjk6ImIwNjc1ZWIzMzI4NWIzOTJjMjg0MWZkOTU0MTlkIjtiOjE7fQ==","auto"),
("364","rank_math_connect_data","a:5:{s:8:\"username\";s:7:\"user420\";s:5:\"email\";s:17:\"user420@gmail.com\";s:7:\"api_key\";s:9:\"*********\";s:4:\"plan\";s:8:\"business\";s:9:\"connected\";b:1;}","auto"),
("365","rank_math_registration_skip","1","auto"),
("368","elementor_custom_icon_sets_config","a:0:{}","auto"),
("370","action_scheduler_migration_status","complete","auto"),
("371","as_has_wp_comment_logs","no","on"),
("387","jet_smart_filters_version","3.7.0","off"),
("388","b51bce972b5b73cc434356f8805d","YTo1OntzOjI4OiJjZTNmOTRjMTNhMDhmODZlZWRjMTNlYTA0MjRjIjtzOjM2OiJiNTA1MDQ3ZS1mMjBhLTQxZGUtOThlMC0yMThiNmUxY2YxMTUiO3M6MzE6ImE3M2M0ODI0YWI1Zjk1MDQ4Y2UyYmYwNDkwNTQzMWMiO3M6NDk6ItmE2KfbjNiz2YbYsyDYqNinINmF2YjZgdmC24zYqiDZhti12Kgg2q/Ysdiv24zYry4iO3M6MzA6ImI0YzU3NmU0ZWQ2NWU4NzU0YzE1NzQwYzU2MTMxZSI7aToxNzY0NDk3NjEzO3M6MjM6ImY4YmM0ZWViMzI0MjdjMTM0OGQ0YjNhIjtiOjA7czozMDoiZWNmMDgzMDY0MTk0YWNjZWJjMmJkZmUwYjUyYjZhIjtiOjE7fQ==","auto"),
("400","duplicator_pro_capabilities","a:9:{s:20:\"duplicator_pro_basic\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:21:\"duplicator_pro_create\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:23:\"duplicator_pro_schedule\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:22:\"duplicator_pro_storage\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:29:\"duplicator_pro_backup_restore\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:21:\"duplicator_pro_import\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:21:\"duplicator_pro_export\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:23:\"duplicator_pro_settings\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:22:\"duplicator_pro_license\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}}","auto"),
("401","duplicator_unique_id","F4V,aCEnve+;jj3xSTKK4YWpxkiGz03Ky40F+i94s-cn","on"),
("402","duplicator_pro_plugin_version","4.5.24","on"),
("403","duplicator_pro_install_info","a:3:{s:7:\"version\";s:6:\"4.5.24\";s:4:\"time\";i:1764497783;s:10:\"updateTime\";i:1764497783;}","off"),
("404","edd_sl_d4cddcbfacec1cb84c2108addd3c8f99","a:2:{s:7:\"timeout\";i:1764583477;s:5:\"value\";s:478:\"{\"new_version\":\"\",\"stable_version\":\"\",\"name\":\"Duplicator Pro\",\"slug\":\"duplicator-pro\",\"url\":\"https:\\/\\/duplicator.com\",\"last_updated\":\"2025-12-01T07:04:37.125Z\",\"homepage\":\"https:\\/\\/duplicator.com\",\"package\":\"\",\"download_link\":\"\",\"sections\":{\"description\":\"Professional WordPress Migration Plugin\",\"changelog\":\"\"},\"description\":[\"Professional WordPress Migration Plugin\"],\"changelog\":[\"\"],\"plugin\":\"duplicator-pro\\/duplicator-pro.php\",\"id\":\"duplicator-pro\\/duplicator-pro.php\"}\";}","off"),
("407","duplicator_pro_notifications","a:4:{s:6:\"update\";i:1764571995;s:4:\"feed\";a:1:{i:0;a:7:{s:5:\"title\";s:62:\"Last chance to get 60% off Duplicator Pro + free media cleaner\";s:7:\"content\";s:259:\"Green Monday is here! Get up to 60% off Duplicator Pro while we support The Conservation Fund. Your purchase helps protect nature and fight climate change. Ready to manage your sites while keeping your budget (and the planet) green? Claim your discount today.\";s:4:\"type\";s:3:\"any\";s:2:\"id\";i:24;s:3:\"btn\";a:4:{s:8:\"main_url\";s:102:\"https://duplicator.com/pricing/?utm_source=dup-notification&utm_medium=in-plugin-cta&utm_campaign=BF25\";s:9:\"main_text\";s:10:\"Learn More\";s:7:\"alt_url\";N;s:8:\"alt_text\";N;}s:5:\"start\";s:19:\"2025-12-08 00:00:00\";s:3:\"end\";s:19:\"2025-12-09 00:00:00\";}}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}","auto"),
("408","duplicator_expire_tmp_cleanup_check","{\"expire\":1764584185,\"value\":true}","on"),
("409","duplicator_expire_daily_bootstrap_actions","{\"expire\":1764584185,\"value\":true}","on"),
("410","duplicator_expire_rename_delay","{\"expire\":1764615172,\"value\":true}","on"),
("412","duplicator_expire_license_check","{\"expire\":1764572961,\"value\":true}","on"),
("413","duplicator_expire_duplicator_pro_frotend_delay","{\"expire\":1764572960,\"value\":true}","on"),
("420","bc2cd51d04055364ec4ee40700b","YTo1OntzOjI4OiJjYWFmZmUxZjMzYjAxYmYyYmY5ZmEyMDM1MTRjIjtzOjM2OiIzYWM5YmEyYS1hMDlmLTQ3MGQtOWU2YS04NWMxOTk1ODFiYzQiO3M6MjQ6ImI2MjQ3ZGYyYTk2ZWM2ZWQyNzAxNzY0ZCI7czo0OToi2YTYp9uM2LPZhtizINio2Kcg2YXZiNmB2YLbjNiqINmG2LXYqCDar9ix2K/bjNivLiI7czozMDoiZTFjMjc2NTdlM2UwODk5YTEzOTQxYjI2NmJjMDdiIjtpOjE3NjQ0OTc4MDE7czozMDoiZDMzNGY1MDQwODVkZjg5MWM4ZjQxNDU5YWNjMDBhIjtiOjA7czozMDoiZjg2Y2I5OTYwZTNmZThlZTE5ZTRmM2QxODk2OGJiIjtiOjE7fQ==","auto"),
("422","_elementor_notifications_data","a:2:{s:7:\"timeout\";i:1764588908;s:5:\"value\";s:2:\"[]\";}","off"),
("437","lef_options","a:7:{s:4:\"avif\";s:1:\"1\";s:4:\"webp\";s:1:\"1\";s:3:\"svg\";s:1:\"1\";s:4:\"woff\";s:1:\"1\";s:5:\"woff2\";s:1:\"1\";s:3:\"ttf\";s:1:\"1\";s:3:\"eot\";s:1:\"1\";}","auto"),
("438","_transient_timeout_settings_errors","1764498006","off"),
("439","_transient_settings_errors","a:1:{i:0;a:4:{s:7:\"setting\";s:7:\"general\";s:4:\"code\";s:16:\"settings_updated\";s:7:\"message\";s:31:\"تنظیمات ذخیره شد.\";s:4:\"type\";s:7:\"success\";}}","off"),
("446","elementor_pro_theme_builder_conditions","a:0:{}","auto"),
("447","rank_math_sitemap_cache_files","a:0:{}","auto"),
("449","plugin_family_dismiss_promote_imagify","1","auto"),
("454","elementor_log","a:1:{s:32:\"3deddd4b2bb8352e28072bf48586f7af\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-11-30 14:00:39\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:78:\"explode(): Passing null to parameter #2 ($string) of type string is deprecated\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2025-11-30 14:00:39\";i:1;s:19:\"2025-11-30 14:00:41\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:78:\"explode(): Passing null to parameter #2 ($string) of type string is deprecated\";s:4:\"file\";s:103:\"/home/toplorir/domains/toplor.ir/public_html/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:4:\"line\";i:165;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:103:\"/home/toplorir/domains/toplor.ir/public_html/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:7:\"\0*\0line\";i:165;}}","off"),
("465","elementor_fonts_manager_font_types","a:3:{s:9:\"iranyekan\";s:6:\"custom\";s:8:\"iransans\";s:6:\"custom\";s:5:\"peyda\";s:6:\"custom\";}","auto"),
("466","elementor_fonts_manager_fonts","a:3:{s:9:\"iranyekan\";a:2:{s:9:\"font_face\";s:1199:\"@font-face {\n	font-family: \'iranyekan\';\n	font-style: normal;\n	font-weight: normal;\n	font-display: auto;\n	src: url(\'https://www.toplor.ir/wp-content/uploads/2025/11/iranyekanweb.eot\');\n	src: url(\'https://www.toplor.ir/wp-content/uploads/2025/11/iranyekanweb.eot?#iefix\') format(\'embedded-opentype\'),\n		url(\'https://www.toplor.ir/wp-content/uploads/2025/11/iranyekanweb.woff\') format(\'woff\'),\n		url(\'https://www.toplor.ir/wp-content/uploads/2025/11/iranyekanweb.ttf\') format(\'truetype\'),\n		url(\'https://www.toplor.ir/wp-content/uploads/2025/11/iranyekanweb.svg#iranyekan\') format(\'svg\');\n}\n@font-face {\n	font-family: \'iranyekan\';\n	font-style: normal;\n	font-weight: bold;\n	font-display: auto;\n	src: url(\'https://www.toplor.ir/wp-content/uploads/2025/11/iranyekanweb-Bold.eot\');\n	src: url(\'https://www.toplor.ir/wp-content/uploads/2025/11/iranyekanweb-Bold.eot?#iefix\') format(\'embedded-opentype\'),\n		url(\'https://www.toplor.ir/wp-content/uploads/2025/11/iranyekanweb-Bold.woff\') format(\'woff\'),\n		url(\'https://www.toplor.ir/wp-content/uploads/2025/11/iranyekanweb-Bold.ttf\') format(\'truetype\'),\n		url(\'https://www.toplor.ir/wp-content/uploads/2025/11/iranyekanweb-Bold.svg#iranyekan\') format(\'svg\');\n}\n\";s:7:\"post_id\";i:46;}s:8:\"iransans\";a:2:{s:9:\"font_face\";s:1175:\"@font-face {\n	font-family: \'iransans\';\n	font-style: normal;\n	font-weight: normal;\n	font-display: auto;\n	src: url(\'https://www.toplor.ir/wp-content/uploads/2025/11/IRANSansWeb.eot\');\n	src: url(\'https://www.toplor.ir/wp-content/uploads/2025/11/IRANSansWeb.eot?#iefix\') format(\'embedded-opentype\'),\n		url(\'https://www.toplor.ir/wp-content/uploads/2025/11/IRANSansWeb.woff2\') format(\'woff2\'),\n		url(\'https://www.toplor.ir/wp-content/uploads/2025/11/IRANSansWeb.woff\') format(\'woff\'),\n		url(\'https://www.toplor.ir/wp-content/uploads/2025/11/IRANSansWeb.ttf\') format(\'truetype\');\n}\n@font-face {\n	font-family: \'iransans\';\n	font-style: normal;\n	font-weight: bold;\n	font-display: auto;\n	src: url(\'https://www.toplor.ir/wp-content/uploads/2025/11/IRANSansWeb_Bold.eot\');\n	src: url(\'https://www.toplor.ir/wp-content/uploads/2025/11/IRANSansWeb_Bold.eot?#iefix\') format(\'embedded-opentype\'),\n		url(\'https://www.toplor.ir/wp-content/uploads/2025/11/IRANSansWeb_Bold.woff2\') format(\'woff2\'),\n		url(\'https://www.toplor.ir/wp-content/uploads/2025/11/IRANSansWeb_Bold.woff\') format(\'woff\'),\n		url(\'https://www.toplor.ir/wp-content/uploads/2025/11/IRANSansWeb_Bold.ttf\') format(\'truetype\');\n}\n\";s:7:\"post_id\";i:45;}s:5:\"peyda\";a:2:{s:9:\"font_face\";s:811:\"@font-face {\n	font-family: \'peyda\';\n	font-style: normal;\n	font-weight: normal;\n	font-display: auto;\n	src: url(\'https://www.toplor.ir/wp-content/uploads/2025/11/PeydaWebFaNum-Regular.woff2\') format(\'woff2\'),\n		url(\'https://www.toplor.ir/wp-content/uploads/2025/11/PeydaWebFaNum-Regular.woff\') format(\'woff\'),\n		url(\'https://www.toplor.ir/wp-content/uploads/2025/11/PeydaFaNum-Regular.ttf\') format(\'truetype\');\n}\n@font-face {\n	font-family: \'peyda\';\n	font-style: normal;\n	font-weight: bold;\n	font-display: auto;\n	src: url(\'https://www.toplor.ir/wp-content/uploads/2025/11/PeydaWebFaNum-Bold.woff2\') format(\'woff2\'),\n		url(\'https://www.toplor.ir/wp-content/uploads/2025/11/PeydaWebFaNum-Bold.woff\') format(\'woff\'),\n		url(\'https://www.toplor.ir/wp-content/uploads/2025/11/PeydaFaNum-Bold.ttf\') format(\'truetype\');\n}\n\";s:7:\"post_id\";i:44;}}","auto"),
("493","gf_db_version","2.9.23","off"),
("494","rg_form_version","2.9.23","off"),
("495","gform_enable_background_updates","1","auto"),
("496","rg_gforms_default_theme","orbital","off"),
("497","rg_form_original_version","2.9.23","off"),
("498","_site_transient_t15s-registry-gforms","O:8:\"stdClass\":2:{s:8:\"projects\";a:59:{s:26:\"gravityformsactivecampaign\";a:1:{s:12:\"translations\";a:26:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T14:15:16+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:17+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:27+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T07:57:07+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T11:15:47+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2024-11-09T11:31:32+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2022-06-27T08:31:49+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-05T14:57:41+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-05T14:57:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:05+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-10-09T08:22:02+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T09:20:30+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-05T14:57:45+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-24T15:09:35+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-05T14:57:46+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T14:59:21+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-04-02T06:44:05+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:11+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T15:58:58+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T18:39:07+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-04-02T13:27:41+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-29T17:58:14+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-20T19:24:04+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T12:47:21+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-30T21:18:28+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-30T22:29:04+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformsaweber\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-19T14:35:08+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-19T08:03:28+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-19T11:19:40+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2023-08-16T11:26:53+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2023-08-16T11:26:50+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2023-08-16T11:26:50+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-19T07:37:20+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-19T15:24:00+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2023-08-16T11:26:54+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-24T15:14:51+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-18T15:09:53+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-04-01T06:34:42+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-18T15:56:34+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-18T18:10:35+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-04-02T13:44:34+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-29T17:52:10+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-20T19:27:52+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-19T12:51:04+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-27T15:08:02+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-30T22:22:32+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformsagilecrm\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-19T14:37:01+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:27+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-19T08:01:05+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-19T11:18:14+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2024-11-09T11:31:32+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-27T08:36:09+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-27T08:36:11+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-27T08:36:16+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-11-06T08:44:20+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-19T09:20:53+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-01-06T16:56:35+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-24T15:13:08+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-18T15:05:10+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-04-01T06:35:45+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-18T15:45:37+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-18T18:39:20+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-04-02T13:43:17+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-29T17:54:16+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-20T19:26:30+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-19T12:49:31+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-30T21:23:25+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-30T22:24:10+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:24:\"gravityformsauthorizenet\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2024-03-20T12:51:36+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-12-28T11:16:35+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2022-06-23T19:13:22+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2024-09-12T11:38:58+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2022-06-29T15:48:18+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-10-19T11:05:17+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-10-19T11:04:01+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2022-06-23T19:13:41+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-03-02T20:29:58+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-10-21T11:50:09+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T16:57:21+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T16:57:37+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T16:57:39+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T16:57:45+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-03-14T17:38:30+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2021-09-13T20:54:56+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-12-17T15:01:32+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-12-17T15:53:58+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T08:01:49+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T16:57:28+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T08:01:53+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-11-05T09:28:49+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-11-09T01:30:51+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformsbatchbook\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2024-03-20T12:53:19+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2022-06-27T09:51:40+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-11-03T10:14:25+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T16:58:20+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:29:58+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:29:36+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:29:39+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:29:46+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2025-11-06T08:44:47+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T16:58:24+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T16:58:41+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2020-01-22T16:00:21+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T16:58:48+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-03-14T17:40:37+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T08:02:41+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T08:02:47+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T08:02:49+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:30:05+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:30:11+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T16:58:32+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2020-10-21T18:08:50+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T08:02:59+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-11-09T01:26:27+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformsbreeze\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T14:38:33+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T08:03:58+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T11:20:05+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2022-06-23T19:13:42+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T07:33:49+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T09:21:40+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-01-06T16:59:43+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-24T15:15:41+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-18T15:11:29+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-04-01T06:33:30+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-18T16:04:19+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-18T18:39:39+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-04-02T13:45:16+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-29T17:49:19+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-20T19:28:07+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T12:53:20+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-27T15:05:01+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-30T22:19:44+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:27:\"gravityformscampaignmonitor\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-19T14:38:54+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2024-11-09T11:58:24+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-19T08:04:30+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-19T11:20:27+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2023-01-06T17:00:49+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-19T07:37:42+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-19T09:21:49+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2020-10-27T15:32:58+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-24T15:16:23+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-18T15:12:16+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-04-01T06:33:17+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-18T16:04:53+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-18T18:40:04+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-04-02T13:45:29+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-29T18:51:09+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-20T16:43:56+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-19T13:16:17+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-27T15:04:34+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-30T22:52:50+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformscampfire\";a:1:{s:12:\"translations\";a:24:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2024-03-20T12:55:41+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:21+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:02:39+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:01:41+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:51+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:30+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:34+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2022-06-27T09:53:41+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-03-02T20:33:52+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:43+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:01:45+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2020-02-18T11:26:09+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2020-01-22T16:22:19+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:47+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-03-14T17:44:01+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-03-02T20:33:59+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:02:22+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:55+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:58+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:44:01+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:36+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:02:33+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2020-02-13T09:15:04+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-11-09T01:41:12+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:22:\"gravityformscapsulecrm\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T14:41:03+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:26+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T08:05:52+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T11:21:13+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2024-11-09T11:31:33+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2022-06-27T08:52:42+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2022-06-27T08:52:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-01-06T17:03:07+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-11-06T08:43:59+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T09:22:00+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-01-06T17:03:14+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-24T15:18:53+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T15:20:01+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-04-01T06:33:04+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T16:07:43+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T18:40:30+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-04-02T13:46:44+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-29T18:53:38+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-20T19:29:19+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T13:18:09+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-30T21:28:54+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-30T22:52:20+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:26:\"gravityformschainedselects\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2024-03-26T11:38:44+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2023-04-14T18:06:58+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2023-11-20T07:22:44+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2023-01-06T17:04:41+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2022-06-23T19:13:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-10-27T15:57:33+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-11-04T16:39:59+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-11-04T16:39:05+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-10-27T15:56:33+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-11-04T16:40:25+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-12-17T14:50:04+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2021-09-13T21:00:54+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-12-17T15:03:03+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-12-17T15:55:04+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-11-04T16:40:51+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2023-01-06T17:04:14+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-10-21T17:43:40+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-10-27T15:55:51+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2023-11-10T01:29:52+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:23:\"gravityformscleverreach\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T14:41:52+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T08:06:48+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T11:21:40+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2022-06-27T08:54:38+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2022-06-27T08:54:39+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2023-01-06T17:05:28+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T07:38:06+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T09:22:17+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2023-01-06T17:05:34+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-24T15:20:44+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-18T15:25:49+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-04-02T06:43:20+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-18T16:06:22+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-18T18:40:33+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-04-02T13:47:12+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-29T18:54:26+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-20T19:29:40+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T13:19:11+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-30T21:26:25+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-30T22:50:24+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformscoupons\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-19T14:42:29+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2022-06-23T19:14:14+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-19T08:07:30+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-19T11:27:01+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2022-06-23T19:13:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2023-03-02T20:27:34+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-19T07:38:40+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-19T09:23:19+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2023-01-06T17:06:49+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-26T15:44:36+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-18T15:26:41+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-04-02T06:34:19+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2023-11-03T10:13:14+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-18T16:05:15+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-18T18:40:36+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2024-09-08T00:13:14+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-29T19:00:30+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-20T16:43:37+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-22T07:24:43+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-27T15:06:38+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-30T22:45:00+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformsdropbox\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-19T16:09:14+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2024-09-02T08:18:20+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-19T14:46:04+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-19T11:28:31+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2022-06-27T08:56:15+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-01-06T17:07:52+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-19T10:35:31+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-19T09:23:32+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2022-06-27T08:56:26+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-26T15:45:53+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-18T15:34:40+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-04-02T06:33:50+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-11-03T10:13:15+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-18T16:02:05+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-18T18:40:58+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-04-02T15:53:32+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-29T19:16:51+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-20T20:05:17+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-22T07:26:02+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-30T21:31:44+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-30T22:44:36+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:16:\"gravityformsemma\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T16:12:50+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T15:01:29+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T11:29:52+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T14:10:50+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T14:10:51+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T14:10:54+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T14:10:56+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T09:23:59+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T14:10:58+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-26T15:49:47+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T15:49:44+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-04-02T06:32:04+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:14+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T15:50:44+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T18:41:05+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-04-02T15:29:12+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-29T19:14:52+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-20T20:16:33+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-22T07:29:16+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-30T06:27:41+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-30T22:41:32+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:22:\"gravityformsfreshbooks\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2024-03-20T13:24:54+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:09:49+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:29+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-02-20T14:36:42+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2020-10-21T11:51:43+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:09:52+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:11+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:13+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:19+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-03-14T17:49:01+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2021-09-14T09:32:44+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:33+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2020-12-17T15:53:03+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:39+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:09:59+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2021-02-08T11:26:17+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:44+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-11-29T02:21:29+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:23:\"gravityformsgetresponse\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T16:13:42+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T15:03:09+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T11:30:45+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2022-06-27T08:58:09+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2022-06-27T08:58:11+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2023-01-06T17:11:13+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T07:40:50+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T09:24:14+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2023-01-06T17:11:18+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-26T15:50:57+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-18T16:08:44+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-04-02T07:37:54+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-18T16:02:48+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-18T18:45:04+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-04-02T15:55:20+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-29T19:12:36+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-20T20:06:28+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-22T07:29:56+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-30T21:24:10+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-30T22:39:14+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformshelpscout\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2024-03-20T13:26:34+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-02-20T14:31:15+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-11-24T07:42:04+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2021-10-11T17:38:30+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2022-06-27T09:58:40+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2022-06-27T09:58:42+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:19+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2021-10-25T16:20:17+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:08+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2020-11-05T09:45:35+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:27+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:32+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-03-14T17:50:31+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-11-28T21:10:33+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:48+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2021-10-25T23:03:06+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2021-10-20T06:44:18+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:15+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2021-11-04T18:39:39+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:13:00+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-11-29T02:37:34+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformshighrise\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2024-03-20T13:28:49+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2022-06-27T09:59:10+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-11-03T10:14:26+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:12+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:45+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-11-03T10:13:20+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:21+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:25+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:27+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2025-11-06T08:43:37+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:18+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:33+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:35+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:40+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-03-14T17:51:12+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:52+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:54+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:52+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:56+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:23+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2021-08-02T17:30:03+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:14:05+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-11-19T23:28:15+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformshipchat\";a:1:{s:12:\"translations\";a:25:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2024-03-20T13:29:15+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:58:44+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2022-06-27T10:00:12+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:58:50+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:25+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:00+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:04+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:11+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2023-03-02T20:33:52+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2020-10-21T13:28:02+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:58:57+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:9:\"de/formal\";a:7:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:58:55+00:00\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-de_DE_formal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2020-02-21T12:24:57+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2020-01-25T07:46:44+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:18+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2023-03-14T17:51:30+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:23+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2023-01-06T17:14:57+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2023-01-06T17:14:59+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:32+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:35+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:06+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2021-08-02T17:31:33+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2020-02-13T09:22:17+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2023-11-19T23:25:08+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformsmadmimi\";a:1:{s:12:\"translations\";a:34:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-20T13:31:30+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:11:17+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:15+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:27+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:5:\"zh-hk\";a:7:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:32+00:00\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-zh_HK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:22+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:16:07+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:20+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:06+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2020-10-21T11:52:31+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:26+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:14:\"de-ch/informal\";a:7:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-09-25T12:09:30+00:00\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:110:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-de_CH_informal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:11:27+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:49+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:52+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:13+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"id\";a:7:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:30+00:00\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-id_ID.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"id\";i:1;s:3:\"ind\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:57+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-03-14T17:52:56+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:15+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2021-10-02T10:46:06+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:16:11+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2020-12-17T15:55:55+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ro\";a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:47+00:00\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-ro_RO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ro\";i:1;s:3:\"ron\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:16:17+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"sr\";a:7:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:16+00:00\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-sr_RS.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sr\";i:1;s:3:\"srp\";}}s:5:\"es-mx\";a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:11:53+00:00\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-es_MX.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:36+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2021-08-02T17:35:32+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:16:24+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-09T01:39:35+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformsmailchimp\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2024-03-20T13:32:12+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-11-24T12:41:33+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:15+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2022-06-27T08:43:13+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:16:52+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-03-02T20:28:02+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2021-10-25T16:35:54+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:16:39+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:16:57+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2021-10-17T13:48:34+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:05+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-02-04T16:58:16+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-11-03T10:13:13+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-11-28T21:13:27+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:19+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2021-10-25T23:02:38+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:25+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:16:47+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:29+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:31+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-11-25T20:33:22+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:26:\"gravityformspartialentries\";a:1:{s:12:\"translations\";a:27:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-11-23T11:07:56+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-04-14T17:10:56+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-02-20T14:31:15+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2024-11-09T11:58:41+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-11-26T19:03:02+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:18:21+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2024-11-09T11:31:43+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2022-06-23T19:13:42+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2020-10-21T13:19:25+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:17:46+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:14:\"de-ch/informal\";a:7:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-09-25T12:09:31+00:00\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:124:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-de_CH_informal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-10-17T13:38:00+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:18:03+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:18:05+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2024-11-08T17:21:07+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:18:12+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2020-12-17T14:50:15+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2021-09-14T09:48:18+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:18:24+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2020-12-17T15:55:24+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:18:31+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:17:54+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2021-08-02T17:40:09+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2020-11-05T09:27:36+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-11-25T20:27:12+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:29:\"gravityformspaypalpaymentspro\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2024-03-20T13:33:43+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:118:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-12-28T11:16:35+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-11-26T19:04:21+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:08:48+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2022-06-23T19:13:42+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:118:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-03-02T20:27:35+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2021-03-24T14:22:06+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:07:45+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:09:54+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-01-06T17:19:10+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:08:26+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-03-14T17:54:30+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:118:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2021-09-14T09:52:47+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-01-06T17:19:29+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-12-17T14:13:06+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:10:17+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:09:09+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2021-09-29T18:02:03+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-01-06T17:19:40+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-11-25T20:24:57+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:118:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformspaypal\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2024-03-20T15:01:34+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:51+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2022-06-23T19:13:23+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:31+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2022-06-27T10:05:05+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2022-06-23T19:13:41+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-03-02T20:27:35+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2020-10-21T11:52:44+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:19:55+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:13+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:15+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:21+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-03-14T17:54:51+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2021-09-14T09:52:14+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:35+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2020-12-17T15:54:54+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:40+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:03+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2021-09-29T18:06:04+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:46+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-12-01T23:37:46+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformspaypalpro\";a:1:{s:12:\"translations\";a:30:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2025-11-06T14:08:36+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-04-15T14:48:04+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-12-28T11:11:03+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-12-28T11:16:36+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:5:\"zh-hk\";a:7:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-03-02T20:50:54+00:00\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-zh_HK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:59:29+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:55:46+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:55:30+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:55:02+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:55:18+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:54:52+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2025-10-23T13:44:10+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:56:58+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:9:\"de/formal\";a:7:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-03-30T13:48:05+00:00\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-de_DE_formal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:14:\"de-ch/informal\";a:7:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-09-25T12:58:34+00:00\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-de_CH_informal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-10-17T13:40:59+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-04-29T16:41:43+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-01-27T16:56:20+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-03-02T20:50:29+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:54:26+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-03-14T17:55:20+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2019-12-10T13:19:22+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2021-09-14T09:53:44+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:53:59+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:54:40+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:57:32+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:56:26+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2021-11-04T18:47:08+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-04-29T16:42:28+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-12-01T23:55:20+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:17:\"gravityformspolls\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-03-20T15:15:58+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-11-27T04:51:47+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-11-05T15:15:31+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2022-06-27T09:09:10+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2022-06-27T09:09:12+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2022-06-27T09:09:20+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-03-02T20:51:24+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-10-21T13:43:25+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-11-05T15:13:17+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-01-06T17:22:24+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-11-05T15:17:13+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-01-06T17:22:32+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-03-14T17:55:58+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2021-09-14T09:55:19+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-12-17T14:20:05+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-12-17T14:19:33+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-11-05T15:18:45+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-01-06T17:22:14+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2021-11-04T18:52:05+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-06-29T08:29:29+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-12-02T00:08:37+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformspostmark\";a:1:{s:12:\"translations\";a:18:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-11-24T12:00:03+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-11-27T04:54:05+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-24T11:44:53+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2022-06-27T09:11:37+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-25T21:03:26+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-31T19:40:40+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-03-29T18:54:45+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-22T09:30:48+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-26T12:48:57+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-06-04T08:26:03+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-09-14T09:55:49+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-31T04:01:04+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-04-11T21:20:33+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-20T16:53:54+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-06-01T17:59:01+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-06-05T06:35:48+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-26T23:45:38+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-11-25T20:16:29+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:16:\"gravityformsquiz\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-07T08:40:34+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-17T12:15:00+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-06T18:20:38+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-07-10T08:01:14+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-07-10T08:01:15+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-07-10T08:01:15+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-07-10T08:01:12+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-17T15:15:27+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-19T07:49:40+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-07-10T08:01:13+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-26T10:46:55+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-17T20:51:56+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-10-02T06:51:05+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-10T10:06:05+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-06T19:10:38+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-11T23:20:43+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-15T19:21:44+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-24T12:53:46+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-22T19:36:46+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-17T09:14:40+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-15T19:21:20+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformssignature\";a:1:{s:12:\"translations\";a:25:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-19T16:17:23+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2023-02-20T14:32:41+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2022-06-27T10:11:12+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-24T08:43:38+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-19T11:44:44+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2024-11-09T11:33:00+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2021-08-12T08:00:46+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2023-03-02T20:55:38+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-19T07:42:56+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-19T09:28:09+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2023-03-02T20:55:40+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-26T16:52:40+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"id\";a:7:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2024-09-02T08:48:32+00:00\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-id_ID.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"id\";i:1;s:3:\"ind\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-18T16:56:26+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-04-02T07:03:50+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-18T16:06:03+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-18T19:08:56+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-04-02T16:07:30+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-29T18:33:52+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-20T16:45:25+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-22T07:55:39+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-30T12:11:45+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-30T23:01:49+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:17:\"gravityformsslack\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T16:18:46+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-04-14T18:11:09+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-24T08:44:34+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T11:45:41+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-01-06T17:26:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T07:48:34+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T09:27:59+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-01-06T17:26:48+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-26T16:52:08+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T16:57:49+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-04-02T07:03:12+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T16:08:17+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T22:09:43+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-04-02T15:58:47+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-29T18:35:17+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-20T16:49:20+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-22T07:56:35+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-30T21:31:04+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-31T00:49:49+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformsstripe\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:57+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:02+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:00+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:02+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:02+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:01+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:01+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:02+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:00+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:00+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:00+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:57+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:59+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:59+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:59+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:59+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-11-03T17:55:20+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:59+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:58+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:58+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformssurvey\";a:1:{s:12:\"translations\";a:27:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-20T15:11:13+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2023-04-14T18:14:00+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-09-02T08:43:26+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2022-06-23T19:14:15+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-20T05:58:48+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-15T15:32:19+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2022-06-27T08:34:13+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2022-06-23T19:13:41+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2023-03-02T20:57:55+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2025-11-06T08:40:43+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-28T10:17:54+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:14:\"de-ch/informal\";a:7:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2023-09-25T12:51:08+00:00\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-de_CH_informal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2023-10-17T13:14:03+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2020-11-06T13:17:26+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-04-01T11:10:01+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-11-08T17:20:20+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-19T16:32:17+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-04-01T05:03:07+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-18T10:41:56+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-21T23:00:49+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-31T22:09:46+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-20T22:24:23+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-25T10:52:40+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-04-02T20:12:15+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-20T18:41:25+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-20T22:24:57+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformstrello\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T16:47:20+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2024-09-02T08:18:24+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T13:28:46+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T11:53:16+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:13+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-01-06T17:29:56+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T15:26:43+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T09:27:15+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-01-06T17:30:03+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-26T16:54:51+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T17:00:57+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-04-02T06:56:40+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T16:04:33+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T22:10:14+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-04-02T16:08:09+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-29T18:29:32+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-20T20:39:11+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-22T08:10:53+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-27T15:04:50+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-30T23:00:57+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformstwilio\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-19T16:46:45+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-18T13:28:16+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-19T11:53:28+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2023-01-05T16:46:39+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2022-06-27T09:02:55+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2023-01-06T17:31:07+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-18T15:26:24+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-19T09:27:02+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2023-01-06T17:31:12+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-27T09:14:41+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-18T17:01:55+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-04-02T06:56:24+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-18T16:03:43+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-18T22:10:21+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-04-02T16:07:47+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-29T18:29:10+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-20T20:39:39+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-22T08:11:15+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-27T15:05:31+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-30T23:00:32+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:28:\"gravityformsuserregistration\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-19T16:46:08+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:116:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2024-09-02T08:18:21+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:116:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2023-01-06T17:32:56+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-24T08:49:32+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-19T11:54:15+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2022-06-27T10:16:33+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2022-06-27T10:16:36+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2023-01-06T17:32:11+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:116:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2023-03-02T20:28:46+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-10-07T07:40:48+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2024-03-29T13:44:16+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2021-03-29T19:18:41+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-27T09:23:57+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-19T19:34:41+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-04-02T06:56:06+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:116:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-18T15:47:00+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-18T22:32:36+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-04-02T16:03:40+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-29T18:28:28+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-20T21:04:43+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-22T08:12:58+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-30T21:30:15+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-30T23:00:05+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:116:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformszapier\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-19T16:50:44+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-18T13:22:40+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-19T11:55:18+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2022-06-27T09:18:29+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2022-06-27T09:18:32+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2022-06-27T09:18:39+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-18T15:19:39+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-19T09:26:32+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:33:24+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-27T09:12:38+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-19T19:38:52+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-04-02T06:53:00+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-18T15:27:45+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-18T22:10:46+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-04-02T15:19:59+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-29T18:24:13+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-20T20:59:29+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-22T08:15:36+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-30T21:16:01+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-30T22:56:56+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformszohocrm\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-19T16:54:27+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-18T13:18:24+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-19T11:56:01+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2022-06-27T09:02:53+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2022-06-27T08:55:23+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2023-01-06T17:34:25+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-18T15:16:09+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-19T09:26:21+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2023-01-06T17:34:31+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-27T09:09:58+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-19T19:41:21+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-04-02T06:52:06+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-18T15:23:21+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-18T22:10:50+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-04-02T16:06:20+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-29T18:20:53+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-20T19:57:28+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-22T20:46:20+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-30T21:27:36+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-30T22:55:02+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformsicontact\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T18:08:34+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T13:49:03+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T15:10:50+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T11:33:12+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T13:49:08+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T13:49:09+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T13:49:14+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T08:17:20+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T15:27:13+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T13:49:17+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-26T15:57:01+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T16:22:16+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-04-02T07:37:34+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T15:35:16+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T18:37:35+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-04-02T13:55:43+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-29T19:22:07+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-20T20:31:53+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-22T07:43:57+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-30T06:22:23+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-31T01:10:39+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:24:\"gravityformsemailoctopus\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-19T18:11:07+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-19T14:47:14+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-19T11:29:03+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:13+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2022-06-27T08:55:23+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-01-06T17:36:53+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-19T07:40:08+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-19T09:23:47+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2020-06-23T13:15:54+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-26T15:46:55+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-18T15:37:40+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-04-02T06:32:30+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:17+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-18T15:49:45+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-18T18:41:01+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-04-02T15:22:11+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-29T19:01:57+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-20T20:06:00+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-22T07:27:27+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-30T21:16:40+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-30T22:42:48+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformsmailgun\";a:1:{s:12:\"translations\";a:24:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-07T08:52:25+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-12-28T11:11:02+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2022-06-27T10:02:12+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-13T09:22:58+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-04T08:15:20+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-12-28T11:14:06+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:13+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2022-06-27T10:01:47+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-12-28T11:13:16+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-03-02T20:46:07+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-06T12:42:42+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-04T11:37:35+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-01-06T17:38:07+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-04T17:13:38+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-15T07:35:12+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-24T06:29:14+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-06T09:42:12+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-23T16:10:35+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-19T21:36:35+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-09T14:20:35+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-15T21:52:07+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-22T17:42:52+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-17T22:15:18+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-09T14:20:57+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformssendgrid\";a:1:{s:12:\"translations\";a:27:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-24T14:25:24+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:16+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-23T19:14:16+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-26T19:07:24+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-11-06T09:05:56+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-29T15:47:02+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-27T09:11:37+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-23T19:13:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-03-02T20:27:36+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-10-21T13:18:39+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-11-06T09:06:48+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:9:\"de/formal\";a:7:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-01-26T16:08:21+00:00\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:110:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-de_DE_formal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-07-04T20:05:08+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-06-28T10:45:00+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:16+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-05-23T18:18:20+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-11-06T09:07:21+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:12+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2021-09-14T09:57:06+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-12-17T14:33:12+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-12-17T14:32:57+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-11-06T09:06:16+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-11-04T22:55:46+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-11-06T09:05:23+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-05-15T07:53:36+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-09T01:37:59+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformssquare\";a:1:{s:12:\"translations\";a:19:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-19T18:16:30+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-18T13:35:08+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-19T11:46:46+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\"