<?php
/**
 * Plugin Name: افزونه فایل‌های مجاز سبک (Lightweight Extra Files)
 * Description: افزونه‌ای سبک برای فعال‌سازی آپلود تصاویر مدرن (AVIF, WebP)، فونت‌ها و SVG در وردپرس.
 * Version: 1.2
 * Author: joodaki
 * Author URI: https://toplor.ir
 */

// جلوگیری از دسترسی مستقیم به فایل
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// 1. ساخت منوی اصلی و زیرمنو
add_action('admin_menu', 'lef_create_custom_menu_structure');

function lef_create_custom_menu_structure() {
    // الف) ایجاد منوی اصلی "افزونه‌های من" (اگر قبلاً وجود نداشته باشد)
    // ما از یک تابع global استفاده می‌کنیم تا اگر افزونه‌های دیگری هم خواستند زیر این منو باشند، تداخل ایجاد نشود.
    global $menu;
    
    // بررسی می‌کنیم آیا منویی با اسلاگ 'my-custom-plugins' وجود دارد یا خیر.
    // اما راه استانداردتر استفاده از add_menu_page است. اگر تکراری باشد، وردپرس مدیریت می‌کند اما بهتر است تابع مشترک داشته باشیم.
    // برای سادگی و اطمینان از اجرا، ما منو را می‌سازیم.
    
    add_menu_page(
        'افزونه‌های من',          // عنوان صفحه (وقتی روی منوی اصلی کلیک میشه)
        'افزونه‌های من',          // نام منو در سایدبار
        'manage_options',         // سطح دسترسی
        'my-custom-plugins',      // اسلاگ (شناسه) منوی اصلی
        'lef_main_menu_page',     // تابعی که محتوای صفحه اصلی منو را نمایش می‌دهد
        'dashicons-admin-plugins', // آیکون منو
        99                        // اولویت نمایش (ته لیست)
    );

    // ب) ایجاد زیرمنوی "فرمت های قابل آپلود"
    add_submenu_page(
        'my-custom-plugins',      // اسلاگ منوی والد (باید با اسلاگ بالا یکی باشد)
        'تنظیمات فرمت‌های آپلود', // عنوان صفحه
        'فرمت‌های قابل آپلود',    // نام در زیرمنو
        'manage_options',         // سطح دسترسی
        'lef-settings',           // اسلاگ این صفحه
        'lef_options_page'        // تابع نمایش دهنده تنظیمات (همان تابع قبلی)
    );
}

// محتوای صفحه اصلی "افزونه‌های من" (اختیاری - فقط یک خوش‌آمدگویی ساده)
function lef_main_menu_page() {
    echo '<div class="wrap"><h1>افزونه‌های اختصاصی من</h1><p>از زیرمنو برای تنظیمات استفاده کنید.</p></div>';
}

// 2. ثبت تنظیمات و گزینه‌ها (بدون تغییر)
add_action('admin_init', 'lef_settings_init');
function lef_settings_init() {
    register_setting('lefPlugin', 'lef_options');
    
    add_settings_section(
        'lef_plugin_page_section', 
        'مدیریت فرمت‌های فایل', 
        'lef_settings_section_callback', 
        'lefPlugin'
    );

    $formats = [
        'avif'  => 'تصاویر مدرن (AVIF)',
        'webp'  => 'تصاویر وب (WebP)',
        'svg'   => 'تصاویر وکتور (SVG)',
        'woff'  => 'فونت (WOFF)',
        'woff2' => 'فونت (WOFF2)',
        'ttf'   => 'فونت (TTF)',
        'eot'   => 'فونت (EOT)',
        'json'  => 'داده‌ها (JSON)',
        'xml'   => 'داده‌ها (XML)'
    ];

    foreach ($formats as $key => $label) {
        add_settings_field(
            'lef_field_' . $key, 
            $label, 
            'lef_checkbox_markup', 
            'lefPlugin', 
            'lef_plugin_page_section',
            ['key' => $key]
        );
    }
}

function lef_settings_section_callback() {
    echo '<p>فرمت‌های مورد نظر خود را تیک بزنید تا اجازه آپلود داشته باشند.</p>';
}

function lef_checkbox_markup($args) {
    $options = get_option('lef_options');
    $key = $args['key'];
    $checked = isset($options[$key]) ? 'checked' : '';
    echo "<input type='checkbox' name='lef_options[$key]' value='1' $checked /> <span style='font-family:monospace; color:#666;'>.$key</span>";
}

// 3. ساختار ظاهری صفحه تنظیمات (لینک شده به زیرمنو)
function lef_options_page() {
    ?>
    <div class="wrap">
        <h1>فرمت‌های قابل آپلود</h1>
        <form action='options.php' method='post'>
            <?php
            settings_fields('lefPlugin');
            do_settings_sections('lefPlugin');
            submit_button('ذخیره تغییرات');
            ?>
        </form>
    </div>
    <?php
}

// 4. فیلتر اصلی برای اضافه کردن فرمت‌ها
add_filter('upload_mimes', 'lef_enable_selected_mimes');
function lef_enable_selected_mimes($mimes) {
    $options = get_option('lef_options');
    
    $all_mimes = [
        'avif'  => 'image/avif',
        'webp'  => 'image/webp',
        'svg'   => 'image/svg+xml',
        'woff'  => 'font/woff',
        'woff2' => 'font/woff2',
        'ttf'   => 'font/ttf',
        'eot'   => 'application/vnd.ms-fontobject',
        'json'  => 'application/json',
        'xml'   => 'application/xml'
    ];

    if ($options) {
        foreach ($all_mimes as $ext => $type) {
            if (isset($options[$ext])) {
                $mimes[$ext] = $type;
            }
        }
    }
    return $mimes;
}

// 5. رفع مشکل عدم شناسایی فایل‌ها
add_filter( 'wp_check_filetype_and_ext', 'lef_fix_mime_check', 10, 4 );
function lef_fix_mime_check( $data, $file, $filename, $mimes ) {
    $options = get_option('lef_options');
    $filetype = wp_check_filetype( $filename, $mimes );
    $ext = $filetype['ext'];
    
    if ( !$ext && !empty($options) ) {
        $path_info = pathinfo( $filename );
        $extension = isset($path_info['extension']) ? $path_info['extension'] : '';

        if ( isset($options[$extension]) ) {
            $custom_mimes = [
                'avif' => 'image/avif',
                'webp' => 'image/webp',
                'svg'  => 'image/svg+xml',
                'woff' => 'font/woff',
                'woff2'=> 'font/woff2',
                'ttf'  => 'font/ttf',
                'json' => 'application/json'
            ];
            
            if ( isset($custom_mimes[$extension]) ) {
                $data['ext']  = $extension;
                $data['type'] = $custom_mimes[$extension];
            }
        }
    }
    return $data;
}
