<div class="wrap">
	<div class="naga-box-help">
		<div class="naga-box">
			<div class="nga_vid_row">
				<div>
					<ul>
						<?php
						// Video List
						$videos = [
							'h1n3z',
							'48HiY',
							'NoLP1',
							'oYJTi',
							'tdO9X',
							'MxBRZ',
						];

						foreach ( $videos as $index => $video_id ) {
							echo '<li><a href="https://www.aparat.com/video/video/embed/videohash/' . esc_attr( $video_id ) . '/vt/frame" target="rm_iframe">';
							/* translators: %d video number */
							printf( esc_html__( 'Video Tutorial %d', 'naga-rank-math' ), $index + 1 );
							echo '</a></li>';
						}
						?>
					</ul>
				</div>

				<div>
					<iframe src="https://www.aparat.com/video/video/embed/videohash/h1n3z/vt/frame"
						name="rm_iframe"
						height="720"
						width="100%"
						title="<?php esc_attr_e( 'Rank Math Iframe', 'naga-rank-math' ); ?>">
					</iframe>
				</div>
			</div>
		</div>
	</div>

	<?php
	$naga_links = [];
	
	$naga_links[] = [
		'url'    => 'https://vrgl.ir/m20UQ',
		'title'    => esc_html__( 'Rank Math Titles and Meta Settings', 'naga-rank-math' ),
		'desc'     => esc_html__( 'In this knowledge base tutorial, we are going to cover the Tiles and Meta settings in Rank Math.', 'naga-rank-math' ),
		'icon'     => 'dashicons dashicons-editor-paste-text',
	];
	
	$naga_links[] = [
		'url'    => 'https://vrgl.ir/m20UQ',
		'title'    => esc_html__( 'Rank Math Local SEO Settings', 'naga-rank-math' ),
		'desc'     => esc_html__( 'The Local SEO section contains all the settings related to Local Businesses.', 'naga-rank-math' ),
		'icon'     => 'dashicons dashicons-location',
	];
	
	$naga_links[] = [
		'url'    => 'https://vrgl.ir/ABWCg',
		'title'    => esc_html__( 'Configuring Schema Markup in Rank Math (Part 1)', 'naga-rank-math' ),
		'desc'     => esc_html__( 'This is the first part of Schema Markup. we will explain the Schema options in Rank Math and how you can use them to add schema to your website.', 'naga-rank-math' ),
		'icon'     => 'dashicons dashicons-awards',
	];
	
	$naga_links[] = [
		'url'    => 'https://vrgl.ir/RS4qe',
		'title'    => esc_html__( 'Configuring Schema Markup in Rank Math (Part 2)', 'naga-rank-math' ),
		'desc'     => esc_html__( 'This is the second part of Schema Markup. we will explain the Schema options in Rank Math and how you can use them to add schema to your website.', 'naga-rank-math' ),
		'icon'     => 'dashicons dashicons-editor-code',
	];
	
	$naga_links[] = [
		'url'    => 'https://vrgl.ir/HqJj0',
		'title'    => esc_html__( 'How to Set Up Redirections?', 'naga-rank-math' ),
		'desc'     => esc_html__( 'HTTP redirects are incredibly important in SEO & UX. When you visit a URL with a redirection, your browser automatically jumps to a new address.', 'naga-rank-math' ),
		'icon'     => 'dashicons dashicons-share-alt2',
	];
	
	$naga_links[] = [
		'url'    => 'https://vrgl.ir/f1Dvd',
		'title'    => esc_html__( 'Product Schema For WooCommerce', 'naga-rank-math' ),
		'desc'     => esc_html__( 'In this tutorial, we’ll walk you through how to use the Product Schema type on products you create using the WooCommerce.', 'naga-rank-math' ),
		'icon'     => 'dashicons dashicons-store',
	];
	
	$naga_links[] = [
		'url'    => 'https://vrgl.ir/wJbSl',
		'title'    => esc_html__( 'Google Search Console and Analytics', 'naga-rank-math' ),
		'desc'     => esc_html__( 'It is the time to take a deep look at the search console and google analytics and use them with rank math pro correctly.', 'naga-rank-math' ),
		'icon'     => 'dashicons dashicons-google',
	];
	
	$naga_links[] = [
		'url'    => 'https://vrgl.ir/K0dP5',
		'title'    => esc_html__( 'RankMath Analytics Panel', 'naga-rank-math' ),
		'desc'     => esc_html__( 'Now we are going to learn how to use the rank math analytics panel with a complete tutorial.', 'naga-rank-math' ),
		'icon'     => 'dashicons dashicons-analytics',
	];
	
	$naga_links[] = [
		'url'    => 'https://vrgl.ir/2xrF6',
		'title'    => esc_html__( 'How to connect Rank Math to Google Analytics?', 'naga-rank-math' ),
		'desc'     => esc_html__( 'Rank Math’s goal is to make on-page SEO easy. With that said, Rank Math’s built-in Analytics module makes it easier than ever to install Google Analytics on your website.', 'naga-rank-math' ),
		'icon'     => 'dashicons dashicons-chart-bar',
	];
	
	$naga_links[] = [
		'url'    => 'https://vrgl.ir/MJGkK',
		'title'    => esc_html__( 'Pros and Cons Content', 'naga-rank-math' ),
		'desc'     => esc_html__( 'In this tutorial, we’ll walk you through how to use Rank Math Pro to add a Pros and Cons Content.', 'naga-rank-math' ),
		'icon'     => 'dashicons dashicons-format-chat',
	];
	
	$naga_links[] = [
		'url'    => 'https://vrgl.ir/Fo79C',
		'title'    => esc_html__( 'FAQ Schema Behavior in SERPs', 'naga-rank-math' ),
		'desc'     => esc_html__( 'According to questions from many users we published a new complete article to describe FAQ schema behavior in SERPs.', 'naga-rank-math' ),
		'icon'     => 'dashicons dashicons-clipboard',
	];
	
	$naga_links[] = [
		'url'    => 'https://vrgl.ir/khIwq',
		'title'    => esc_html__( 'Speakable Schema with Rank Math', 'naga-rank-math' ),
		'desc'     => esc_html__( 'In this tutorial, we’ll walk you through how to use Rank Math Pro to optimize an article for voice searchs for SERPs.', 'naga-rank-math' ),
		'icon'     => 'dashicons dashicons-microphone',
	];
	
	$naga_links[] = [
		'url'    => 'https://vrgl.ir/r5KCV',
		'title'    => esc_html__( 'PodcastEpisode Schema with Rank Math', 'naga-rank-math' ),
		'desc'     => esc_html__( 'In this tutorial, we’ll walk you through how to use Rank Math Pro to optimize a PodcastEpisodein in an article for SERPs.', 'naga-rank-math' ),
		'icon'     => 'dashicons dashicons-embed-audio',
	];
	
	$naga_links[] = [
		'url'    => 'https://vrgl.ir/OQY7s',
		'title'    => esc_html__( 'Self-serving reviews', 'naga-rank-math' ),
		'desc'     => esc_html__( 'In this tutorial, we’ll walk you through what is self-serving reviews and how to avoid from it.', 'naga-rank-math' ),
		'icon'     => 'dashicons dashicons-format-chat',
	];
	
	$naga_links[] = [
		'url'    => 'https://vrgl.ir/F3m3B',
		'title'    => esc_html__( 'Date/time not in ISO 8601', 'naga-rank-math' ),
		'desc'     => esc_html__( 'In this tutorial, We want to describe how to solve Date/time not in ISO 8601 format in field uploadDate in google search console.', 'naga-rank-math' ),
		'icon'     => 'dashicons dashicons-clock',
	];
	
	$naga_links[] = [
		'url'    => 'https://vrgl.ir/zHsSQ',
		'title'    => esc_html__( 'Product Schema Warnings and Errors', 'naga-rank-math' ),
		'desc'     => esc_html__( 'In this tutorial, We are going to explain how to fix Product Schema Warnings and Errors in google search console.', 'naga-rank-math' ),
		'icon'     => 'dashicons dashicons-products',
	];
	
	$naga_links[] = [
		'url'    => 'https://vrgl.ir/uX06P',
		'title'    => esc_html__( 'Fix Sitemap Post and Product tags', 'naga-rank-math' ),
		'desc'     => esc_html__( 'In this tutorial, we’ll walk you through solving issues about sitemap post and product tags.', 'naga-rank-math' ),
		'icon'     => 'dashicons dashicons-location-alt',
	];
	
	$naga_links[] = [
		'url'    => 'https://vrgl.ir/Cau1q',
		'title'    => esc_html__( 'Either “offers”, “review”, or “aggregateRating” should be specified', 'naga-rank-math' ),
		'desc'     => esc_html__( 'If you have come across an error: Either “offers”, “review”, or “aggregateRating” should be specified in the Google Search Console, you’ve come to the right place.', 'naga-rank-math' ),
		'icon'     => 'dashicons dashicons-star-half',
	];
	
	$naga_links[] = [
		'url'    => 'https://vrgl.ir/TQSvX',
		'title'    => esc_html__( 'Fix $title variable required Issue', 'naga-rank-math' ),
		'desc'     => esc_html__( 'In this tutorial, we’ll walk you through how to solve $title variable required issue.', 'naga-rank-math' ),
		'icon'     => 'dashicons dashicons-lock',
	];
	
	$naga_links[] = [
		'url'    => 'https://vrgl.ir/tnVvn',
		'title'    => esc_html__( 'Fix Rank Math Issue with Solar Date', 'naga-rank-math' ),
		'desc'     => esc_html__( 'In this tutorial, we’ll walk you through how to solve solar date issues occurred with Rank Math.', 'naga-rank-math' ),
		'icon'     => 'dashicons dashicons-calendar-alt',
	];

	?>
	<div class="naga-box-help">

		<div class="naga-box">

			<header>
				<h3><?php esc_html_e( 'NagaTheme Persian Knowledge Base', 'naga-rank-math' ); ?></h3>
				<p><?php esc_html_e( 'Here you can find the most popular documentations about Rank Math. Read them and make your knowledge be upgrated.', 'naga-rank-math' ); ?></p>
				<br>
			</header>

			<div class="naga-box-content">

				<ul class="naga-list-icon">

					<?php foreach( $naga_links as $naga_link ) { ?>
					
						<li>
							<i class="<?php echo $naga_link['icon']; ?>"></i>
							<div>
								<strong><a href="<?php echo $naga_link['url']; ?>" target="_blank"><?php echo $naga_link['title']; ?></a></strong>
								<p><?php echo $naga_link['desc']; ?></p>
							</div>

						</li>
					
					<?php } ?>

				</ul>

			</div>

		</div>
		
	</div>


	<?php
	// Items of The Translation Table
	$naga_trans_items = array(
		'Title'		=>	'عنوان',
		'Alt'		=>	'متن جایگزین',
		'Schema'	=>	'اسکیما - طرحواره',
		'Sitemap'	=>	'نقشه سایت',
		'Post Type'	=>	'پست تایپ',
		'Warning'	=>	'هشدار',
		'Error'		=>	'خطا',
		'Taxonomy'	=>	'طبقه بندی',
		'Category'	=>	'دسته بندی',
		// Copy Above Line and Add Here
		'Breadcrumbs'	=>	'مسیر راهنما'
	);
	// Let's sort the srings alphabetically
	ksort($naga_trans_items);
	?>
	
	<div class="naga-box-help">
	
		<div class="naga-box">
		
			<header>
				<h3>راهنمای ترجمه‌های ناگاتم در رنک مث ژاکت</h3>
				<p>در این قسمت شما می‌توانید لیست مهمترین اصطلاحات ترجمه شده در رنک مث ژاکت را مشاهده کنید.  ترتیب جدول بر اساس حروف الفبای انگلیسی می‌باشد.</p>
				<br>
			</header>
			
			<table id="nagatb">
				<tr>
					<th>لیست کلمات</th>
					<th>ترجمه ها</th>
				</tr>
				<?php foreach( $naga_trans_items as $key => $value ) { ?>
					<tr>
						<td><?php echo "{$key}"; ?></td>
						<td><?php echo "{$value}"; ?></td>
					</tr>
				<?php } ?>
			</table>
			
			<br><p>لازم به ذکر است که هنوز برخی از ترجمه‌های این افزونه از سمت مخزن وردپرس فراخوانی می‌شوند و نیاز به اصلاح و ترجمه مجدد دارند که در حال اصلاح و بهبود آن‌ها هستیم. از حمایت شما قدردانیم.</p>
			
		</div>
		
	</div>
	
	<div class="naga-box-help" style="width:50%; margin: 25px auto; display: block;">
		<a href="https://www.zhaket.com/web/rank-math-pro" target="_blank">
			<img src="<?php echo NAGATHEME_RANK_MATH_PRO_URL . 'assets/images/zhk-naga-review.png'; ?>" alt="Review" style="width:100%; margin: 25px auto; display: block;">
		</a>
	</div>
</div>